/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.fieldaccess;

import chemaxon.formats.MFileFormatUtil;
import chemaxon.marvin.io.MFieldAccessor;
import chemaxon.marvin.io.MolExportException;
import chemaxon.struc.MProp;
import chemaxon.struc.Molecule;
import chemaxon.struc.prop.MStringProp;

public class MFieldAccessorWrapper
extends MFieldAccessor {
    private static final int MAX_EXTRA_FIELDS = 3;
    private static final int F_MOL_NAME = 1;
    private static final int F_IUPAC_NAME = 2;
    private static final int F_SMILES = 4;
    private static final String[] EXTRA_FIELD_NAMES = new String[]{"$MolName", "$GenName", "$SMILES"};
    private int flags = 0;
    private MFieldAccessor fieldAccessor;

    public MFieldAccessorWrapper(MFieldAccessor fa) {
        this.fieldAccessor = fa;
        this.flags = 0;
    }

    public boolean isMolNameEnabled() {
        return (this.flags & 1) != 0;
    }

    public void setMolNameEnabled(boolean v) {
        this.flags = v ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
    }

    public boolean isGenNameEnabled() {
        return (this.flags & 2) != 0;
    }

    public void setGenNameEnabled(boolean v) {
        this.flags = v ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
    }

    public boolean isSMILESEnabled() {
        return (this.flags & 4) != 0;
    }

    public void setSMILESEnabled(boolean v) {
        this.flags = v ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
    }

    @Override
    public Molecule getMainMolecule(int irec, Molecule mol) {
        return this.fieldAccessor.getMainMolecule(irec, mol);
    }

    @Override
    public String[] getKeys(int irec, Molecule mol) {
        String[] keys = this.fieldAccessor.getKeys(irec, mol);
        if (this.flags == 0) {
            return keys;
        }
        int nx = this.countExtraFields();
        String[] newkeys = new String[keys.length + nx];
        System.arraycopy(keys, 0, newkeys, nx, keys.length);
        int k = 0;
        for (int i = 0; i < 3; ++i) {
            if ((this.flags & 1 << i) == 0) continue;
            newkeys[k++] = EXTRA_FIELD_NAMES[i];
        }
        return newkeys;
    }

    @Override
    public void getFields(int irec, Molecule mol, String[] keys, MProp[] values) {
        this.fieldAccessor.getFields(irec, mol, keys, values);
        if (this.flags == 0) {
            return;
        }
        for (int i = 0; i < keys.length; ++i) {
            String k = keys[i];
            if (k == null) continue;
            for (int j = 0; j < 3; ++j) {
                Throwable t;
                Molecule m;
                int f = 1 << j;
                if ((this.flags & f) == 0 || !k.equals(EXTRA_FIELD_NAMES[j])) continue;
                String s = null;
                if (f == 1) {
                    m = this.fieldAccessor.getMainMolecule(irec, mol);
                    if (m != null) {
                        s = m.getName();
                    }
                } else if (f == 2) {
                    m = this.fieldAccessor.getMainMolecule(irec, mol);
                    if (m != null) {
                        try {
                            s = m.exportToFormat("name");
                        }
                        catch (MolExportException ex) {
                            for (t = ex; t != null; t = t.getCause()) {
                                s = t.getMessage();
                            }
                        }
                    }
                } else if (f == 4 && (m = this.fieldAccessor.getMainMolecule(irec, mol)) != null) {
                    try {
                        String[] r = MFileFormatUtil.convertToSmilingFormat(m);
                        s = r[0];
                    }
                    catch (MolExportException ex) {
                        for (t = ex; t != null; t = t.getCause()) {
                            s = t.getMessage();
                        }
                    }
                }
                values[i] = s != null ? new MStringProp(s) : null;
            }
        }
    }

    @Override
    public void setFields(int irec, Molecule mol, String[] keys, MProp[] values) {
        String[] newkeys = keys;
        if (this.flags != 0) {
            newkeys = new String[keys.length];
            for (int i = 0; i < newkeys.length; ++i) {
                String k = keys[i];
                if (k == null) continue;
                boolean extrafield = false;
                for (int j = 0; j < 3; ++j) {
                    Molecule m;
                    int f = 1 << j;
                    if ((this.flags & f) == 0 || !k.equals(EXTRA_FIELD_NAMES[j])) continue;
                    if (f == 1 && (m = this.fieldAccessor.getMainMolecule(irec, mol)) != null) {
                        MStringProp p = (MStringProp)values[i];
                        m.setName(p.stringValue());
                    }
                    newkeys[i] = null;
                    extrafield = true;
                }
                if (extrafield) continue;
                newkeys[i] = keys[i];
            }
        }
        this.fieldAccessor.setFields(irec, mol, newkeys, values);
    }

    @Override
    public boolean isEditable(int irec, Molecule mol, String key) {
        if (key == null || key.equals("$SMILES") || key.equals("$GenName")) {
            return false;
        }
        if (key.equals("$MolName")) {
            Molecule m = this.fieldAccessor.getMainMolecule(irec, mol);
            return m != null;
        }
        return this.fieldAccessor.isEditable(irec, mol, key);
    }

    private int countExtraFields() {
        int n = 0;
        for (int i = 0; i < 3; ++i) {
            if ((this.flags & 1 << i) == 0) continue;
            ++n;
        }
        return n;
    }
}

