/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats;

import chemaxon.common.util.IntVector;
import chemaxon.common.util.LongVector;
import chemaxon.common.util.MProgressMonitor;
import chemaxon.formats.MFileFormatUtil;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolInputStream;
import chemaxon.marvin.io.MRecord;
import chemaxon.marvin.io.MRecordParseException;
import chemaxon.marvin.io.MRecordReader;
import java.io.IOException;
import java.io.InputStream;

public abstract class AbstractMRecordReader
implements MRecordReader {
    private int recordCount;
    private String importOptions;
    private MolInputStream molInputStream;
    private IntVector lineNumberMap;

    public AbstractMRecordReader(InputStream istr, String opts) throws IOException {
        String[] fmtopts = MFileFormatUtil.splitFormatAndOptions(opts);
        MolInputStream mis = istr instanceof MolInputStream ? (MolInputStream)istr : new MolInputStream(istr, fmtopts[0]);
        this.importOptions = fmtopts[1];
        this.recordCount = 0;
        this.molInputStream = mis;
        this.lineNumberMap = new IntVector();
    }

    @Override
    public void setProgressMonitor(MProgressMonitor pmon) {
    }

    @Override
    public String getRecognizedFormat() {
        return this.molInputStream.getFormat();
    }

    @Override
    public String getHeaderAsString() {
        return "";
    }

    @Override
    public String getFooterAsString() {
        return "";
    }

    @Override
    public String getOptions() {
        return this.importOptions;
    }

    protected String readLine() throws IOException {
        MolInputStream mis = this.molInputStream;
        if (mis != null) {
            return mis.readLine();
        }
        return null;
    }

    protected boolean skipLine() throws IOException {
        MolInputStream mis = this.molInputStream;
        if (mis != null) {
            return mis.skipLine();
        }
        return false;
    }

    protected void putBackLine() throws IOException {
        MolInputStream mis = this.molInputStream;
        if (mis == null) {
            throw new IOException("cannot put line back into closed input stream");
        }
        mis.putBackLine();
    }

    protected int[] endRecord(boolean skip) {
        int[] map;
        if (skip) {
            map = null;
        } else {
            int n = this.lineNumberMap.size();
            map = new int[n + 1];
            map[0] = 0;
            for (int i = 0; i < n; ++i) {
                map[i + 1] = this.lineNumberMap.get(i);
            }
            this.lineNumberMap.clear();
        }
        ++this.recordCount;
        return map;
    }

    @Override
    public void close() {
        MolInputStream mis = this.molInputStream;
        if (mis != null) {
            try {
                mis.close();
            }
            catch (IOException ex) {
                this.molInputStream = null;
            }
        }
    }

    @Override
    public MRecordReader getEncapsulatedReader() {
        return null;
    }

    @Override
    public MolInputStream getMolInputStream() {
        return this.molInputStream;
    }

    @Override
    public long getFilePointer() {
        return this.getMolInputStream().getFilePointer();
    }

    @Override
    public int getLineCount() {
        return this.getMolInputStream().getLineCount();
    }

    @Override
    public boolean isSeekable() {
        MolInputStream mis = this.molInputStream;
        return mis == this.getMolInputStream() && mis.isSeekable();
    }

    @Override
    public void seek(long p, int lcount, int k) throws IOException {
        this.molInputStream.seek(p, lcount);
        this.recordCount = k;
    }

    protected MRecordReader.Position getPosition() {
        return new MRecordReader.Position(this.recordCount + 1, this.molInputStream.getLineCount());
    }

    protected void appendLines(StringBuffer sb, String l) {
        MolInputStream mis = this.molInputStream;
        int lc = mis != null ? mis.getLineCount() : 0;
        int i = 0;
        if (sb != null) {
            int j;
            while ((j = l.indexOf(10, i)) >= i) {
                this.lineNumberMap.add(lc);
                i = j + 1;
            }
            sb.append(l);
            if (!l.endsWith("\n")) {
                this.lineNumberMap.add(lc);
                sb.append('\n');
            }
        }
    }

    protected void appendLine(StringBuffer sb, String line) {
        if (sb != null) {
            MolInputStream mis = this.molInputStream;
            int lc = mis != null ? mis.getLineCount() : 0;
            this.lineNumberMap.add(lc);
            sb.append(line);
            sb.append('\n');
        }
    }

    @Override
    public boolean isPropertyRecord() {
        return false;
    }

    @Override
    public LongVector detectRecordPositions(IntVector linenums) throws MolFormatException {
        LongVector positions = new LongVector();
        try {
            MRecord rec;
            while ((rec = this.skipRecord()) != null) {
                positions.add(rec.getStartPosition());
                positions.add(rec.getEndPosition());
                if (linenums == null) continue;
                linenums.add(rec.getStartLineCount());
            }
        }
        catch (MRecordParseException ex) {
            throw new MolFormatException(ex);
        }
        catch (IOException ioex) {
            throw new MolFormatException(ioex);
        }
        return positions;
    }
}

