/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats;

import chemaxon.formats.MFileFormatUtil;
import chemaxon.formats.MolInputStream;
import chemaxon.marvin.io.MRecord;
import chemaxon.marvin.io.MRecordParseException;
import chemaxon.marvin.io.MRecordReader;
import chemaxon.marvin.io.formats.AbstractMRecordReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;

public class GzipRecordReader
extends AbstractMRecordReader {
    private MRecordReader reader;

    public GzipRecordReader(InputStream istr, String opts) throws IOException {
        super(new GZIPInputStream(istr), GzipRecordReader.getStoredFormatOptions(opts));
        MolInputStream mis = super.getMolInputStream();
        String[] fmtopts = MFileFormatUtil.splitFormatAndOptions(opts);
        opts = fmtopts[1];
        this.reader = MFileFormatUtil.createRecordReader(mis, opts);
    }

    @Override
    public MRecordReader getEncapsulatedReader() {
        return this.reader;
    }

    @Override
    public String getRecognizedFormat() {
        return "gzip";
    }

    @Override
    public MolInputStream getMolInputStream() {
        return this.reader.getMolInputStream();
    }

    @Override
    public String getOptions() {
        return this.reader.getOptions();
    }

    @Override
    public boolean isSeekable() {
        return false;
    }

    private static String getStoredFormatOptions(String opts) {
        String[] fmtopts;
        if (opts == null) {
            return null;
        }
        if (opts.indexOf(58) == -1) {
            opts = opts + ":";
        }
        if ((fmtopts = MFileFormatUtil.splitFormatAndOptions(opts))[0] != null && fmtopts[0].equals("gzip")) {
            opts = fmtopts[1];
        }
        return opts;
    }

    @Override
    public String getHeaderAsString() {
        return this.reader.getHeaderAsString();
    }

    @Override
    public String getFooterAsString() {
        return this.reader.getFooterAsString();
    }

    @Override
    public MRecord nextRecord() throws MRecordParseException, IOException {
        return this.reader.nextRecord();
    }

    @Override
    public MRecord skipRecord() throws MRecordParseException, IOException {
        return this.reader.skipRecord();
    }
}

