/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats;

import chemaxon.formats.MFileFormatUtil;
import chemaxon.formats.MolImporter;
import chemaxon.formats.MolInputStream;
import chemaxon.marvin.io.formats.MoleculeImporterIface;
import chemaxon.marvin.io.formats.cml.CmlImportStax;
import chemaxon.marvin.io.formats.cml.MrvImportStax;
import chemaxon.struc.Molecule;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class MoleculeImporter
implements MoleculeImporterIface {
    protected final MoleculeImporterIface importer;

    public MoleculeImporter(String fileName) throws IOException {
        this(fileName, null);
    }

    public MoleculeImporter(String fileName, String opts) throws IOException {
        this(new FileInputStream(new File(fileName)), opts, null, fileName);
    }

    public MoleculeImporter(File f) throws IOException {
        this(f, null);
    }

    public MoleculeImporter(File f, String opts) throws IOException {
        this(new FileInputStream(f), opts, null, f.getName());
    }

    public MoleculeImporter(InputStream inputStream) throws IOException {
        this(inputStream, null);
    }

    public MoleculeImporter(InputStream inputStream, String opts) throws IOException {
        this(inputStream, opts, null);
    }

    public MoleculeImporter(InputStream inputStream, String opts, String enc) throws IOException {
        this(inputStream, opts, enc, null);
    }

    private MoleculeImporter(InputStream inputStream, String opts, String enc, String fileName) throws IOException {
        MolInputStream mis;
        String[] fmtopts = MFileFormatUtil.splitFormatAndOptions(opts);
        MolInputStream molInputStream = mis = inputStream instanceof MolInputStream ? (MolInputStream)inputStream : new MolInputStream(inputStream, fmtopts[0], enc, fileName);
        this.importer = mis.getFormat().startsWith("mrv") ? new MrvImportStax(mis, mis.getEncoding() == null ? null : mis.getEncoding().name()) : (mis.getFormat().startsWith("cml") ? new CmlImportStax(mis, mis.getEncoding() == null ? null : mis.getEncoding().name()) : new MolImporter(mis, opts, enc, fileName));
        if (this.importer == null) {
            throw new IllegalArgumentException("Can not import molecules from this stream.");
        }
    }

    @Override
    public Molecule read() throws IOException {
        return this.importer.read();
    }

    public Iterator<Molecule> getIterator() {
        if (this.importer instanceof MolImporter) {
            return ((MolImporter)this.importer).getMoleculeIterator();
        }
        return new Iterator<Molecule>(){
            private Molecule next = this.read();
            private Exception readException = null;

            private Molecule read() {
                try {
                    this.next = MoleculeImporter.this.importer.read();
                }
                catch (Exception e) {
                    this.readException = e;
                    this.next = null;
                }
                return this.next;
            }

            @Override
            public boolean hasNext() {
                if (this.readException != null) {
                    throw new IllegalStateException(this.readException);
                }
                return this.next != null;
            }

            @Override
            public Molecule next() {
                if (this.hasNext()) {
                    Molecule result = this.next;
                    this.read();
                    return result;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void close() throws IOException {
        this.importer.close();
    }
}

