/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats;

import chemaxon.common.util.BasicEnvironment;
import chemaxon.marvin.util.Environment;
import chemaxon.util.DotfileUtil;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Array;
import java.security.AccessControlException;
import java.util.StringTokenizer;
import java.util.Vector;

public class NucleicAcidSource {
    private static NucleicAcidSource instance;
    protected static String customDictionaryPath;
    protected static String defaultDictPath;
    protected static boolean alreadyInitialized;
    protected static String[] IMPORT_ABBREV;
    protected static String[] IMPORT_SMILES;
    protected static int[] IMPORT_1ST_ATTACH_POINT;
    protected static int[] IMPORT_2ND_ATTACH_POINT;
    protected static Vector EXPORT_SHORT_NAMES;
    protected static Vector EXPORT_LONG_NAMES;
    protected static Vector EXPORT_MOLS;

    public static synchronized NucleicAcidSource getInstance() {
        if (!alreadyInitialized) {
            alreadyInitialized = NucleicAcidSource.initDictionary();
        }
        if (!alreadyInitialized) {
            NucleicAcidSource.clearDataFields();
        }
        return instance;
    }

    private static void clearDataFields() {
        IMPORT_ABBREV = null;
        IMPORT_SMILES = null;
        IMPORT_1ST_ATTACH_POINT = null;
        IMPORT_2ND_ATTACH_POINT = null;
        EXPORT_LONG_NAMES = new Vector();
        EXPORT_SHORT_NAMES = new Vector();
        EXPORT_MOLS = new Vector();
    }

    private NucleicAcidSource() {
    }

    protected static boolean initDictionary() {
        boolean readSuccessful;
        NucleicAcidSource.clearDataFields();
        InputStream dictFile = BasicEnvironment.getResourceAsStream(NucleicAcidSource.class, defaultDictPath);
        if (dictFile == null) {
            System.err.println("Cannot find " + defaultDictPath);
            readSuccessful = false;
        } else {
            readSuccessful = NucleicAcidSource.readDictionary(dictFile);
            try {
                dictFile.close();
            }
            catch (IOException ioex) {
                readSuccessful = false;
                ioex.printStackTrace();
            }
            if (readSuccessful && customDictionaryPath != null) {
                try {
                    dictFile = new FileInputStream(customDictionaryPath);
                    readSuccessful = NucleicAcidSource.readDictionary(dictFile);
                }
                catch (IOException e) {
                }
                catch (AccessControlException accessControlException) {
                    // empty catch block
                }
            }
        }
        return readSuccessful;
    }

    private static boolean readDictionary(InputStream dictFile) {
        boolean readSuccessful = true;
        DataInputStream in = new DataInputStream(dictFile);
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        Vector<String> naAbbrev = new Vector<String>();
        Vector<String> naSMILES = new Vector<String>();
        Vector<String> firstAttach = new Vector<String>();
        Vector<String> secondAttach = new Vector<String>();
        try {
            String strLine;
            while ((strLine = br.readLine()) != null) {
                StringTokenizer st;
                int tc;
                if (strLine.startsWith("#") || (tc = (st = new StringTokenizer(strLine, " \t")).countTokens()) != 4) continue;
                naAbbrev.add(st.nextToken());
                naSMILES.add(st.nextToken());
                firstAttach.add(st.nextToken());
                secondAttach.add(st.nextToken());
            }
            int tableSize = naAbbrev.size();
            IMPORT_ABBREV = (String[])NucleicAcidSource.makeArray(IMPORT_ABBREV, tableSize, String.class, naAbbrev);
            IMPORT_SMILES = (String[])NucleicAcidSource.makeArray(IMPORT_SMILES, tableSize, String.class, naSMILES);
            IMPORT_1ST_ATTACH_POINT = (int[])NucleicAcidSource.makeArray(IMPORT_1ST_ATTACH_POINT, tableSize, Integer.TYPE, firstAttach);
            IMPORT_2ND_ATTACH_POINT = (int[])NucleicAcidSource.makeArray(IMPORT_2ND_ATTACH_POINT, tableSize, Integer.TYPE, secondAttach);
            for (int i = 0; i < IMPORT_ABBREV.length; ++i) {
                String abbrev = IMPORT_ABBREV[i];
                EXPORT_SHORT_NAMES.add(abbrev);
                EXPORT_MOLS.add(IMPORT_SMILES[i]);
            }
        }
        catch (IOException ioex) {
            ioex.printStackTrace();
            readSuccessful = false;
        }
        return readSuccessful;
    }

    protected static Object makeArray(Object oldArray, int increment, Class elementType, Vector items) {
        Object newArray;
        if (oldArray == null && increment >= 0) {
            newArray = Array.newInstance(elementType, increment);
            if (elementType == Integer.TYPE) {
                for (int i = 0; i < increment; ++i) {
                    ((int[])newArray)[i] = Integer.parseInt((String)items.elementAt(i));
                }
            } else {
                items.copyInto((Object[])newArray);
            }
        } else {
            int oldSize = Array.getLength(oldArray);
            int newSize = increment + oldSize;
            newArray = Array.newInstance(elementType, newSize);
            System.arraycopy(oldArray, 0, newArray, 0, oldSize);
            if (elementType == Integer.TYPE) {
                int i = oldSize;
                int j = 0;
                while (i < newSize) {
                    ((int[])newArray)[i] = Integer.parseInt((String)items.elementAt(j));
                    ++i;
                    ++j;
                }
            } else {
                int i = oldSize;
                int j = 0;
                while (i < newSize) {
                    ((Object[])newArray)[i] = items.elementAt(j);
                    ++i;
                    ++j;
                }
            }
        }
        return newArray;
    }

    public String[] getImportNames() {
        return IMPORT_ABBREV;
    }

    public Vector getSMILESVector() {
        Vector<String> aaSMILES = new Vector<String>();
        for (int i = 0; i < IMPORT_SMILES.length; ++i) {
            aaSMILES.add(IMPORT_SMILES[i]);
        }
        return aaSMILES;
    }

    public int[] getImportFirtsAttachPoints() {
        return IMPORT_1ST_ATTACH_POINT;
    }

    public int[] getImportSecondAttachPoints() {
        return IMPORT_2ND_ATTACH_POINT;
    }

    static {
        customDictionaryPath = null;
        defaultDictPath = "/chemaxon/nucleicacids.dict";
        alreadyInitialized = false;
        EXPORT_SHORT_NAMES = new Vector();
        EXPORT_LONG_NAMES = new Vector();
        EXPORT_MOLS = new Vector();
        if (!Environment.UNTRUSTED) {
            customDictionaryPath = DotfileUtil.getDotDir().toString() + File.separator + "custom_nucleicacids.dict";
        }
        instance = new NucleicAcidSource();
    }
}

