/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats;

import chemaxon.marvin.io.MolExportModule;
import chemaxon.marvin.paint.internal.ColorCollection;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import java.awt.Color;
import java.util.List;
import java.util.StringTokenizer;

public class PovExport
extends MolExportModule {
    private static final double[] atsizes = new double[37];

    protected void getOptionDescriptors(String fmtname, String optnames, List l) {
        super.getOptionDescriptors(fmtname, "H -H", l);
    }

    @Override
    public Object convert(Molecule mol) {
        double bl = mol.bondlength();
        StringBuffer s = this.stringBuffer;
        s.setLength(0);
        s.append("camera { location <0,0,10> look_at <0,0,0> angle 90 }\n");
        s.append("light_source { <500,500,2000> rgb <1,1,1> }\n");
        s.append("light_source { <-1000,-1000,0> rgb <1,1,1> }\n");
        s.append("blob {\n");
        s.append("\tthreshold 0.4\n");
        int na = mol.getAtomCount();
        DPoint3 center = mol.calcCenter();
        for (int i = 0; i < na; ++i) {
            MolAtom a = mol.getAtom(i);
            int atno = a.getAtno();
            String e = a.getSymbol();
            s.append("\tsphere { <");
            this.appendRight(a.getX() - center.x);
            s.append(",");
            this.appendRight(a.getY() - center.y);
            s.append(",");
            this.appendRight(a.getZ() - center.z);
            s.append(">, ");
            double atsize = 1.0;
            if (atno < atsizes.length) {
                atsize = atsizes[atno];
            }
            this.appendRight(atsize *= 12.5 * bl);
            Color color = ColorCollection.getColor(atno, true);
            s.append(", 1 pigment { rgb <");
            this.appendRight((double)color.getRed() / 255.0);
            s.append(",");
            this.appendRight((double)color.getGreen() / 255.0);
            s.append(",");
            this.appendRight((double)color.getBlue() / 255.0);
            s.append("> } }\n");
        }
        s.append("\tfinish { phong 1 }\n");
        s.append("}\n");
        return s.toString();
    }

    private void appendRight(double t) {
        double y = Math.abs(t);
        int iy = (int)y;
        int b = (int)(10000.0 * (y - Math.floor(y)) + 0.5);
        if (b == 10000) {
            ++iy;
        }
        String sb = String.valueOf(b);
        sb = "0000".concat(sb);
        sb = sb.substring(sb.length() - 4);
        if (t < 0.0) {
            this.stringBuffer.append("-");
        }
        this.stringBuffer.append(iy);
        this.stringBuffer.append(".");
        this.stringBuffer.append(sb);
    }

    static {
        StringTokenizer st = new StringTokenizer("0.03 0.1 0.152 0.112 0.088 0.077 0.070 0.066 0.064 0.1 0.186 0.160 0.143 0.117 0.110 0.104 0.099 0.1 0.231 0.197 0.162 0.1 0.1 0.1 0.1 0.1 0.1 0.1 0.128 0.133 0.122 0.122 0.121 0.117 0.114 0.1 ");
        int atno = 1;
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            PovExport.atsizes[atno] = Double.valueOf(s);
            ++atno;
        }
    }
}

