/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.abbrevgroup;

import chemaxon.marvin.io.MolExportException;
import chemaxon.marvin.io.MolExportModule;
import chemaxon.marvin.io.formats.smiles.SmilesExport;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.SelectionMolecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.sgroup.SgroupAtom;
import chemaxon.struc.sgroup.SuperatomSgroup;
import java.util.List;

public class AbbrevGroupExport
extends MolExportModule {
    private SmilesExport smilesExport = new SmilesExport();

    protected void getOptionDescriptors(String fmtname, String optnames, List l) {
    }

    @Override
    public Object open(String fmtopts) throws MolExportException {
        super.open(fmtopts);
        this.smilesExport.open(null);
        return null;
    }

    @Override
    public Object convert(Molecule mol) throws MolExportException {
        this.stringBuffer.setLength(0);
        if (mol.getSgroupCount() == 0) {
            String s = mol.getProperty("abbreviation");
            if (s == null) {
                s = "Noname";
            }
            this.export(mol, s, null, null, 0);
        } else {
            for (int i = 0; i < mol.getSgroupCount(); ++i) {
                Sgroup sg = mol.getSgroup(i);
                SelectionMolecule m = sg.cloneStructure();
                if (sg instanceof SuperatomSgroup) {
                    SgroupAtom sa = ((SuperatomSgroup)sg).getSuperAtom();
                    String ln = sa.getLeftName();
                    String rn = sa.getRightName();
                    int lc = sa.getLabelCenter();
                    String sym = sg.getSubscript();
                    this.export(m, sym, ln, rn, lc);
                    continue;
                }
                this.export(m, sg.getSubscript(), null, null, 0);
            }
        }
        return this.stringBuffer.toString();
    }

    private void export(MoleculeGraph m, String symbol, String leftName, String rightName, int labelCenter) throws MolExportException {
        this.stringBuffer.append(symbol);
        this.stringBuffer.append("\t");
        this.addSMILESAndAttachmentPoints(m);
        if (leftName != null) {
            this.stringBuffer.append("\tleftName=");
            this.stringBuffer.append(leftName);
        }
        if (rightName != null) {
            this.stringBuffer.append("\trightName=");
            this.stringBuffer.append(rightName);
        }
        if (labelCenter != 0) {
            this.stringBuffer.append("\tcenter=");
            if (labelCenter == -1) {
                this.stringBuffer.append("AUTO");
            } else {
                this.stringBuffer.append(String.valueOf(labelCenter));
            }
        }
        this.stringBuffer.append('\n');
    }

    @Override
    public boolean isCleanable() {
        return false;
    }

    private void addSMILESAndAttachmentPoints(MoleculeGraph mol) throws MolExportException {
        String s = this.smilesExport.toSMILES((Molecule)mol);
        int[] smilesAtoms = this.smilesExport.getSmilesAtomOrder();
        if (s.endsWith("\n")) {
            s = s.substring(0, s.length() - 1);
        }
        this.stringBuffer.append(s);
        int[] attach = new int[4];
        block0: for (int i = 0; i < mol.getAtomCount(); ++i) {
            MolAtom a = mol.getAtom(i);
            int k = a.getAttach();
            if (k <= 0) continue;
            for (int j = 0; j < smilesAtoms.length; ++j) {
                if (smilesAtoms[j] != i) continue;
                attach[k] = j + 1;
                continue block0;
            }
        }
        for (int k = 1; k < attach.length; ++k) {
            int i = attach[k];
            if (i <= 0) continue;
            this.stringBuffer.append('\t');
            this.stringBuffer.append(String.valueOf(i));
            if (k != 3) continue;
            this.stringBuffer.append('\t');
            this.stringBuffer.append(String.valueOf(i));
        }
    }
}

