/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.abbrevgroup;

import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolInputStream;
import chemaxon.marvin.io.MolImportModule;
import chemaxon.marvin.io.formats.smiles.SmilesImport;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.sgroup.SgroupAtom;
import chemaxon.struc.sgroup.SuperatomSgroup;
import java.io.IOException;
import java.util.StringTokenizer;

public class AbbrevGroupImport
extends MolImportModule {
    private MolInputStream istream;
    private SmilesImport smilesImport = new SmilesImport();

    @Override
    public void initMolImport(MolInputStream mis) throws IOException {
        this.istream = mis;
        this.smilesImport.initMolImport(mis);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean readMol(Molecule mol) throws IOException {
        MolAtom a;
        mol.clearForImport("abbrevgroup");
        String line = this.istream.readLine();
        if (line == null) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(line, "\t");
        String abbrev = st.nextToken();
        String smiles = st.nextToken();
        String rightName = null;
        String leftName = null;
        int labelCenter = 0;
        if (!this.smilesImport.readMol(smiles, mol)) {
            return false;
        }
        mol.setInputFormat("abbrevgroup");
        mol.setName(abbrev);
        mol.setProperty("abbreviation", abbrev);
        SuperatomSgroup sg = new SuperatomSgroup(mol);
        sg.setSubscript(abbrev);
        boolean attached1 = false;
        boolean attached2 = false;
        int count = 1;
        while (st.hasMoreTokens()) {
            block17: {
                String s = st.nextToken();
                if (count <= 3) {
                    try {
                        int j = Integer.parseInt(s);
                        if (j < 1 || j > mol.getAtomCount()) {
                            throw new MolFormatException("Invalid attachment point number " + j);
                        }
                        a = mol.getAtom(j - 1);
                        a.setImplicitHcount(0);
                        int p = a.getAttach() == 0 ? count : 3;
                        a.setAttach(p);
                        attached1 &= (p & 1) != 0;
                        attached2 &= (p & 2) != 0;
                    }
                    catch (NumberFormatException nfe) {
                        int eq;
                        if (s.startsWith("rightName=")) {
                            eq = s.indexOf("=");
                            rightName = s.substring(eq + 1);
                        }
                        if (s.startsWith("leftName=")) {
                            eq = s.indexOf("=");
                            leftName = s.substring(eq + 1);
                        }
                        if (!s.startsWith("center=")) break block17;
                        labelCenter = (s = s.substring(7)).equals("AUTO") ? -1 : Integer.parseInt(s);
                    }
                }
            }
            ++count;
        }
        SgroupAtom supat = sg.getSuperAtom();
        supat.setLeftName(leftName);
        supat.setRightName(rightName);
        supat.setLabelCenter(labelCenter);
        if (st.hasMoreTokens()) {
            throw new MolFormatException("Incorrect abbreviated file format (delimiter is TAB and there can be max two attachemnt points:\n <abbrev> <SMILES> <attach1> [attach2] [leftName=name][rightName=name]");
        }
        for (int i = 0; i < mol.getAtomCount(); ++i) {
            int rad;
            a = mol.getAtom(i);
            if (a.getAttach() == 0 && (rad = a.getRadical()) != 0) {
                if (rad == 1) {
                    if (!attached1) {
                        a.setAttach(1);
                    } else {
                        if (attached2) throw new MolFormatException("Cannot associate attachment point to radical.");
                        a.setAttach(2);
                    }
                } else {
                    if (rad != 2 && rad != 6 && rad != 10 || attached1 || attached2) throw new MolFormatException("Cannot associate attachment point to radical.");
                    a.setAttach(3);
                }
            }
            if (a.getAttach() != 0) {
                a.setRadical(0);
                a.setValenceProp(-1);
            }
            mol.setSgroupParent(a, sg, true);
        }
        return true;
    }

    @Override
    public Molecule createMol() {
        return new Molecule();
    }
}

