/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.base64;

import chemaxon.common.util.Base64OutputStream;
import chemaxon.formats.MFileFormatUtil;
import chemaxon.marvin.io.MolExportException;
import chemaxon.marvin.io.MolExportModule;
import chemaxon.struc.MPropertyContainer;
import chemaxon.struc.Molecule;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;

public class Base64Export
extends MolExportModule {
    private MolExportModule exporter2;
    private ByteArrayOutputStream byteArrayOutputStream;
    private Base64OutputStream base64OutputStream;

    protected void getOptionDescriptors(String fmtname, String optnames, List l) {
    }

    @Override
    public Object open(String fmtopts, MPropertyContainer props) throws MolExportException {
        Object o;
        String fmt2 = "Mol";
        int i = fmtopts != null ? fmtopts.indexOf(58) : -1;
        String fmtopts2 = i >= 0 ? fmtopts.substring(i + 1) : "";
        this.byteArrayOutputStream = new ByteArrayOutputStream();
        this.base64OutputStream = new Base64OutputStream(this.byteArrayOutputStream);
        this.exporter2 = MFileFormatUtil.createExportModule(fmtopts2);
        if (this.exporter2 != null && (o = this.exporter2.open(fmtopts2, props)) != null) {
            byte[] data = o instanceof String ? ((String)o).getBytes() : (byte[])o;
            try {
                this.base64OutputStream.write(data);
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public Object convert(Molecule mol) throws MolExportException {
        if (this.exporter2 == null) {
            return null;
        }
        Object o = this.exporter2.convert(mol);
        byte[] data = o instanceof String ? ((String)o).getBytes() : (byte[])o;
        try {
            this.base64OutputStream.write(data);
        }
        catch (IOException ex) {
            // empty catch block
        }
        data = this.byteArrayOutputStream.toByteArray();
        this.byteArrayOutputStream.reset();
        return new String(data);
    }

    @Override
    public Object close() throws MolExportException {
        byte[] data;
        Object o = this.exporter2.close();
        try {
            if (o != null) {
                data = o instanceof String ? ((String)o).getBytes() : (byte[])o;
                this.base64OutputStream.write(data);
            }
            this.base64OutputStream.close();
        }
        catch (IOException ex) {
            throw new MolExportException(ex.getMessage());
        }
        data = null;
        if (this.byteArrayOutputStream.size() != 0) {
            data = this.byteArrayOutputStream.toByteArray();
            this.byteArrayOutputStream.reset();
            return new String(data);
        }
        return null;
    }
}

