/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.cdx;

import java.util.HashMap;
import java.util.Set;

public class CDXObject {
    private CDXObject prev;
    private CDXObject next;
    private CDXObject firstChild;
    private boolean hasChild;
    private CDXObject parent;
    private int type;
    private HashMap prop;
    private int id;

    public CDXObject() {
        this.prev = null;
        this.next = null;
        this.firstChild = null;
        this.hasChild = false;
        this.parent = null;
        this.type = 0;
        this.prop = new HashMap();
        this.id = -1;
    }

    public CDXObject(int type) {
        this.prev = null;
        this.next = null;
        this.firstChild = null;
        this.hasChild = false;
        this.parent = null;
        this.type = type;
        this.prop = new HashMap();
        this.id = -1;
    }

    public CDXObject(int type, CDXObject prev) {
        this.prev = prev;
        this.next = null;
        this.firstChild = null;
        this.hasChild = false;
        this.parent = null;
        this.type = type;
        this.prop = new HashMap();
        this.id = -1;
    }

    public String ID() {
        return Integer.toString(this.id);
    }

    public void ID(int id) {
        this.id = id;
    }

    public int getID() {
        return this.id;
    }

    public void setID(int id) {
        this.ID(id);
    }

    public CDXObject Next() {
        return this.next;
    }

    public CDXObject Prev() {
        return this.prev;
    }

    public void setNext(CDXObject next) {
        this.next = next;
    }

    public void setPrev(CDXObject prev) {
        this.prev = prev;
    }

    public void setFirstChild(CDXObject child) {
        this.hasChild = true;
        this.firstChild = child;
    }

    public CDXObject firstChild() {
        return this.firstChild;
    }

    public boolean hasChild() {
        return this.hasChild;
    }

    public CDXObject Parent() {
        return this.parent;
    }

    public void setParent(CDXObject p) {
        this.parent = p;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int Type() {
        return this.type;
    }

    public Object Prop(Object p) {
        return this.Property(p);
    }

    public Object getProperty(Object p) {
        if (this.hasProp(p)) {
            return this.Property(p);
        }
        return null;
    }

    public Object Property(Object p) {
        if (p instanceof String) {
            String s = (String)p;
            if (this.prop.containsKey(s.trim().toLowerCase())) {
                return this.prop.get(s.trim().toLowerCase());
            }
            return null;
        }
        if (this.prop.containsKey(p)) {
            return this.prop.get(p);
        }
        return null;
    }

    public boolean hasProp(Object p) {
        if (p instanceof String) {
            String s = (String)p;
            return this.prop.containsKey(s.trim().toLowerCase());
        }
        return this.prop.containsKey(p);
    }

    public void setProperty(Object prop, Object value) {
        if (prop instanceof String) {
            String s = (String)prop;
            this.prop.put(s.trim().toLowerCase(), value);
        } else {
            this.prop.put(prop, value);
        }
    }

    public void appendProperty(Object prop, String value) {
        if (this.hasProp(prop)) {
            String p = (String)this.getProperty(prop);
            this.setProperty(prop, p + value);
        } else {
            this.setProperty(prop, value);
        }
    }

    public String toString() {
        String s = "";
        s = this.parent != null ? s + "Type: " + Integer.toHexString(this.type) + " Id: " + this.id + " Parent: " + Integer.toHexString(this.parent.type) + "\n" : s + "Type: " + this.type + " Parent: null\n";
        Set k = this.prop.keySet();
        Object[] keys = k.toArray();
        for (int i = 0; i < this.prop.size(); ++i) {
            s = s + keys[i] + ": " + this.prop.get(keys[i]) + " ";
        }
        s = s + "\n";
        return s;
    }
}

