/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.cdxml;

import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolInputStream;
import chemaxon.marvin.io.MolImportModule;
import chemaxon.marvin.io.formats.cdx.CDXConstants;
import chemaxon.marvin.io.formats.cdx.CDXObject;
import chemaxon.marvin.io.formats.cdx.CDXObjectReader;
import chemaxon.struc.MDocument;
import chemaxon.struc.Molecule;
import chemaxon.struc.RgMolecule;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CDXMLImport
extends MolImportModule
implements CDXConstants {
    MolInputStream mis;
    CDXObject CDXMLRoot;
    private DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();

    private void buildStruct(Node element, CDXObject o) {
        NamedNodeMap attr = element.getAttributes();
        for (int attri = 0; attri < attr.getLength(); ++attri) {
            Node a = attr.item(attri);
            if (a.getNodeValue().equalsIgnoreCase("yes")) {
                o.setProperty(a.getNodeName(), "true");
            } else if (a.getNodeValue().equalsIgnoreCase("no")) {
                o.setProperty(a.getNodeName(), "false");
            } else {
                o.setProperty(a.getNodeName(), a.getNodeValue());
            }
            if (!a.getNodeName().toLowerCase().equals("id")) continue;
            o.ID(Integer.parseInt(a.getNodeValue()));
        }
        NodeList nodes = element.getChildNodes();
        CDXObject curr = new CDXObject();
        for (int nodei = 0; nodei < nodes.getLength(); ++nodei) {
            Node e = nodes.item(nodei);
            String name = e.getNodeName();
            curr.setParent(o);
            CDXObject obj = new CDXObject();
            curr.setNext(obj);
            obj.setPrev(curr);
            if (!o.hasChild()) {
                o.setFirstChild(curr);
            }
            if (name.equalsIgnoreCase("b")) {
                curr.setType(32773);
                this.buildStruct(e, curr);
                curr = obj;
                continue;
            }
            if (name.equalsIgnoreCase("altgroup")) {
                curr.setType(32778);
                this.buildStruct(e, curr);
                curr = obj;
                continue;
            }
            if (name.equalsIgnoreCase("border")) {
                curr.setType(32800);
                this.buildStruct(e, curr);
                curr = obj;
                continue;
            }
            if (name.equalsIgnoreCase("bracketedgroup")) {
                curr.setType(32791);
                this.buildStruct(e, curr);
                curr = obj;
                continue;
            }
            if (name.equalsIgnoreCase("bracketattachment")) {
                curr.setType(32792);
                this.buildStruct(e, curr);
                curr = obj;
                continue;
            }
            if (name.equalsIgnoreCase("chemicalproperty")) {
                curr.setType(32806);
                this.buildStruct(e, curr);
                curr = obj;
                continue;
            }
            if (name.equalsIgnoreCase("constraint")) {
                curr.setType(32802);
                this.buildStruct(e, curr);
                curr = obj;
                continue;
            }
            if (name.equalsIgnoreCase("color")) {
                curr.setType(769);
                this.buildStruct(e, curr);
                curr = obj;
                continue;
            }
            if (name.equalsIgnoreCase("colortable")) {
                curr.setType(768);
                this.buildStruct(e, curr);
                curr = obj;
                continue;
            }
            if (name.equalsIgnoreCase("curve")) {
                curr.setType(32776);
                this.buildStruct(e, curr);
                curr = obj;
                continue;
            }
            if (name.equalsIgnoreCase("crossreference")) {
                curr.setType(32788);
                this.buildStruct(e, curr);
                curr = obj;
                continue;
            }
            if (name.equalsIgnoreCase("fragment")) {
                curr.setType(32771);
                this.buildStruct(e, curr);
                curr = obj;
                continue;
            }
            if (name.equalsIgnoreCase("fonttable")) {
                curr.setType(256);
                this.buildStruct(e, curr);
                curr = obj;
                continue;
            }
            if (name.equalsIgnoreCase("font")) {
                curr.setType(257);
                this.buildStruct(e, curr);
                curr = obj;
                continue;
            }
            if (name.equalsIgnoreCase("geometry")) {
                curr.setType(32801);
                this.buildStruct(e, curr);
                curr = obj;
                continue;
            }
            if (name.equalsIgnoreCase("graphic")) {
                curr.setType(32775);
                this.buildStruct(e, curr);
                curr = obj;
                continue;
            }
            if (name.equalsIgnoreCase("group")) {
                curr.setType(32770);
                this.buildStruct(e, curr);
                curr = obj;
                continue;
            }
            if (name.equalsIgnoreCase("n")) {
                curr.setType(32772);
                this.buildStruct(e, curr);
                curr = obj;
                continue;
            }
            if (name.equalsIgnoreCase("objecttag")) {
                curr.setType(32785);
                this.buildStruct(e, curr);
                curr = obj;
                continue;
            }
            if (name.equalsIgnoreCase("page")) {
                curr.setType(32769);
                this.buildStruct(e, curr);
                curr = obj;
                continue;
            }
            if (name.equalsIgnoreCase("s")) {
                curr.setType(258);
                curr.setProperty("Text", e.getTextContent());
                this.buildStruct(e, curr);
                curr = obj;
                continue;
            }
            if (name.equalsIgnoreCase("scheme")) {
                curr.setType(32781);
                this.buildStruct(e, curr);
                curr = obj;
                continue;
            }
            if (name.equalsIgnoreCase("sequence")) {
                curr.setType(32787);
                this.buildStruct(e, curr);
                curr = obj;
                continue;
            }
            if (name.equalsIgnoreCase("spectrum")) {
                curr.setType(32784);
                this.buildStruct(e, curr);
                curr = obj;
                continue;
            }
            if (name.equalsIgnoreCase("splitter")) {
                curr.setType(32789);
                this.buildStruct(e, curr);
                curr = obj;
                continue;
            }
            if (name.equalsIgnoreCase("step")) {
                curr.setType(32782);
                this.buildStruct(e, curr);
                curr = obj;
                continue;
            }
            if (name.equalsIgnoreCase("t")) {
                curr.setType(32774);
                curr.appendProperty("Text", e.getTextContent());
                this.buildStruct(e, curr);
                curr = obj;
                continue;
            }
            if (name.equalsIgnoreCase("table")) {
                curr.setType(32790);
                this.buildStruct(e, curr);
                curr = obj;
                continue;
            }
            if (name.equalsIgnoreCase("tlcplate")) {
                curr.setType(32797);
                this.buildStruct(e, curr);
                curr = obj;
                continue;
            }
            if (name.equalsIgnoreCase("tlclane")) {
                curr.setType(32798);
                this.buildStruct(e, curr);
                curr = obj;
                continue;
            }
            if (name.equalsIgnoreCase("tlcspot")) {
                curr.setType(32799);
                this.buildStruct(e, curr);
                curr = obj;
                continue;
            }
            if (name.equalsIgnoreCase("templategrid")) {
                curr.setType(32779);
                this.buildStruct(e, curr);
                curr = obj;
                continue;
            }
            if (name.equalsIgnoreCase("rlogic")) {
                curr.setType(32809);
                this.buildStruct(e, curr);
                curr = obj;
                continue;
            }
            if (!name.equalsIgnoreCase("rlogicitem")) continue;
            curr.setType(32810);
            this.buildStruct(e, curr);
            curr = obj;
        }
    }

    public void processFile() throws MolFormatException, IOException {
        Document document;
        try {
            DocumentBuilder builder = this.docBuilderFactory.newDocumentBuilder();
            document = builder.parse(this.mis);
        }
        catch (ParserConfigurationException ex) {
            throw new MolFormatException(ex);
        }
        catch (SAXException ex) {
            throw new MolFormatException(ex);
        }
        Element root = document.getDocumentElement();
        this.CDXMLRoot = new CDXObject(32768);
        this.buildStruct(root, this.CDXMLRoot);
    }

    @Override
    public void initMolImport(MolInputStream arg0) throws MolFormatException, IOException {
        this.mis = arg0;
    }

    public void initMolImport(MolInputStream is, String opts) {
        this.mis = is;
    }

    @Override
    public boolean readMol(Molecule mol) throws MolFormatException, IOException {
        mol.clearForImport("cdx");
        mol.setStartPosition(this.mis.getFilePointer());
        this.processFile();
        CDXObjectReader r = new CDXObjectReader();
        boolean notEmpty = r.readMol(this.CDXMLRoot, mol);
        mol.setEndPosition(this.mis.getFilePointer());
        return notEmpty;
    }

    @Override
    public Molecule createMol() {
        return new RgMolecule();
    }

    public boolean isDocumentReader() {
        return true;
    }

    @Override
    public MDocument readDocument(MDocument md) throws IOException {
        this.processFile();
        CDXObjectReader reader = new CDXObjectReader();
        md = reader.readDocument(this.CDXMLRoot, md);
        return md;
    }
}

