/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.cml;

import chemaxon.common.util.IntVector;
import chemaxon.formats.MolFormatException;
import chemaxon.marvin.io.formats.cml.ParsedData;
import chemaxon.marvin.io.formats.cml.ReaderUtil;
import chemaxon.marvin.io.formats.smiles.SmartsAtomQuerifier;
import chemaxon.marvin.modules.ResidueInfo;
import chemaxon.marvin.util.text.EncodingUtil;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.Sgroup;
import chemaxon.struc.sgroup.SgroupAtom;
import chemaxon.struc.sgroup.SuperatomSgroup;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class AtomReader {
    static void setSelection(MolAtom a, String isSelected) {
        if (isSelected != null) {
            if (isSelected.equals("true")) {
                a.setSelected(true);
            }
        } else {
            a.setSelected(false);
        }
    }

    static boolean readAtomRefs2(String array, List<String> bondAtomRefs2Array) {
        if (array != null) {
            StringTokenizer st = new StringTokenizer(array);
            List<String> h = bondAtomRefs2Array;
            while (st.hasMoreTokens()) {
                String ref2 = st.nextToken();
                h.add(ref2);
            }
            return true;
        }
        return false;
    }

    static void readAtomParity(String[] ligands, String s, MolAtom a, Map<MolAtom, String[]> atomParityHash) throws MolFormatException {
        if (s == null) {
            throw new MolFormatException("empty <atomParity> element");
        }
        ligands[ligands.length - 1] = s;
        Map<MolAtom, String[]> phash = atomParityHash;
        phash.put(a, ligands);
    }

    static String[] getRefsArray(String refs) throws MolFormatException {
        if (refs == null) {
            throw new MolFormatException("Missing atom reference list attribute");
        }
        StringTokenizer st = new StringTokenizer(refs);
        String[] refsArray = new String[st.countTokens() + 1];
        for (int i = 0; i < refsArray.length - 1; ++i) {
            refsArray[i] = st.nextToken();
        }
        return refsArray;
    }

    public static MolAtom createAtom(Molecule mol, ParsedData parsedData, String sid) {
        MolAtom a = parsedData.idAtomHash.get(sid);
        if (a == null) {
            int i = parsedData.idAtomHash.size();
            a = mol.reuseAtom(6, i);
            parsedData.idAtomHash.put(sid, a);
            parsedData.atomIdHash.put(a, sid);
        }
        return a;
    }

    static boolean storeLinkNodeOuters(MolAtom atom, String value, boolean needsUpdating) {
        boolean linkNodeRefNeedsUpdating = needsUpdating;
        int k = value.indexOf(44);
        int out1 = -1;
        int out2 = -1;
        if (k > 0) {
            String value1 = value.substring(0, k);
            if (value1.charAt(0) == 'a') {
                atom.setQProp("LINKNODE_OUTER0", value1);
                linkNodeRefNeedsUpdating = true;
            } else {
                out1 = Integer.parseInt(value1);
            }
            String value2 = value.substring(k + 1);
            if (value2.charAt(0) == 'a') {
                atom.setQProp("LINKNODE_OUTER1", value2);
                linkNodeRefNeedsUpdating = true;
            } else {
                out2 = Integer.parseInt(value2);
            }
        } else if (!value.equals("-")) {
            out1 = Integer.parseInt(value);
        }
        atom.setLinkNodeOuterAtom(0, out1);
        atom.setLinkNodeOuterAtom(1, out2);
        return linkNodeRefNeedsUpdating;
    }

    static void setElementType(MolAtom a, String sym) {
        if (sym.equals("X")) {
            a.setAtno(137);
        } else if (sym.equals("R")) {
            a.setAtno(134);
        } else {
            int atno = MolAtom.numOf(sym);
            if (atno == 0 && sym.length() > 0 && Character.isDigit(sym.charAt(0))) {
                try {
                    int value = Integer.parseInt(sym);
                    atno = 138;
                    a.setRgroupAttachmentPointOrder(value);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            a.setAtno(atno);
        }
    }

    static void setAtomAttach(MolAtom a, String s, MoleculeGraph mol) throws MolFormatException {
        if (s.equals("both")) {
            a.setAttach(3, ReaderUtil.getSgroup(a, mol));
        } else {
            int r = 0;
            try {
                r = Integer.parseInt(s);
            }
            catch (NumberFormatException ex) {
                throw new MolFormatException("invalid attachmentPoint value");
            }
            if (r >= 0 && r <= 3) {
                a.setAttach(r, r > 0 ? ReaderUtil.getSgroup(a, mol) : null);
            } else {
                throw new MolFormatException("invalid attachmentPoint value " + r);
            }
        }
    }

    static MolAtom setAtomSgroupRef(MoleculeGraph mol, int i, String s, Sgroup psg, boolean isRgroup, ParsedData parsedData) {
        Molecule pmol;
        if (s.equals("0")) {
            return mol.getAtom(i);
        }
        MolAtom a = mol.getAtom(i);
        boolean contracted = !isRgroup && a.getAtno() == 134;
        Map<String, Sgroup> h = parsedData.atomSgroupRefHash;
        Sgroup sg = h.get(s);
        Molecule molecule = psg != null ? psg.getParentMolecule() : (pmol = mol instanceof Molecule ? (Molecule)mol : null);
        if (sg == null) {
            if (a.getAtno() == 134) {
                sg = new SuperatomSgroup(pmol, !contracted);
                h.put(s, sg);
            } else {
                sg = new Sgroup(pmol, 12);
                h.put(s, sg);
            }
        }
        if (contracted && sg.getType() == 0) {
            SgroupAtom sa = ((SuperatomSgroup)sg).getSuperAtom();
            MolAtom old = mol.getAtom(i);
            String sid = parsedData.atomIdHash.get(old);
            parsedData.atomIdHash.remove(old);
            mol.setAtom(i, sa);
            parsedData.atomIdHash.put(sa, sid);
            parsedData.idAtomHash.put(sid, sa);
            return sa;
        }
        if (pmol.indexOf(a) > -1) {
            pmol.setSgroupParent(a, sg, true);
        }
        return a;
    }

    static boolean setAtomRgroupRef(MolAtom a, String s) throws MolFormatException {
        int r = 0;
        try {
            r = Integer.parseInt(s);
        }
        catch (NumberFormatException ex) {
            throw new MolFormatException("invalid rgroupRef");
        }
        if (r > 0) {
            a.setRgroup(r);
            return true;
        }
        if (r < 0) {
            throw new MolFormatException("negative rgroupRef values are not allowed");
        }
        return false;
    }

    static void setAtomStereoGroup(MolAtom a, String s) {
        if (s.equals("abs")) {
            a.setStereoGroupType(1);
        } else if (s.startsWith("and")) {
            a.setStereoGroupType(3);
            try {
                int k = Integer.parseInt(s.substring(3));
                a.setStereoGroupNumber(k);
            }
            catch (NumberFormatException ex) {}
        } else if (s.startsWith("or")) {
            a.setStereoGroupType(2);
            try {
                int k = Integer.parseInt(s.substring(2));
                a.setStereoGroupNumber(k);
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            a.setStereoGroupType(0);
        }
    }

    static void setAtomRxnStereo(MolAtom a, String s) {
        int k = 0;
        if (s.equals("Inv")) {
            k = 1;
        } else if (s.equals("Ret")) {
            k = 2;
        }
        a.setReactionStereo(k);
    }

    static void setResidueAtomId(MolAtom a, String s) {
        int r = a.getResidueType();
        int id = ResidueInfo.getAtomId(r, s);
        if (id == 0) {
            try {
                id = Integer.parseInt(s);
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        a.setResidueAtomId(id);
    }

    static void setResidueSeq(MolAtom a, String s, Map<String, Integer> hash) {
        if (s.equals("0")) {
            a.setResidueSeq(0);
        } else {
            Integer k = hash.get(s);
            if (k == null) {
                k = hash.size() + 1;
                hash.put(s, k);
            }
            a.setResidueSeq(k);
        }
    }

    static void setResidueType(MolAtom a, String s) {
        int r = Molecule.residueTypeOf(s);
        if (r == 0 && s.startsWith("UNK") && s.length() != 3) {
            try {
                String sr = s.substring(3);
                r = Integer.parseInt(sr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        a.setResidueType(r);
    }

    public static void setSpecIsotopeSymbolPreferred(MolAtom a, String s) {
        a.setSpecIsotopeSymbolPreferred(s.equals("1"));
    }

    static void setAtomRadical(MolAtom a, String s) {
        if (s.equals("monovalent")) {
            a.setRadical(1);
        } else if (s.equals("divalent")) {
            a.setRadical(2);
        } else if (s.equals("divalent1")) {
            a.setRadical(6);
        } else if (s.equals("divalent3")) {
            a.setRadical(10);
        } else if (s.equals("triplet")) {
            a.setRadical(10);
        } else if (s.equals("trivalent")) {
            a.setRadical(3);
        } else if (s.equals("trivalent2")) {
            a.setRadical(7);
        } else if (s.equals("trivalent4")) {
            a.setRadical(11);
        } else {
            int r = 0;
            try {
                r = Integer.parseInt(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            a.setRadical(r);
        }
    }

    static void readAtomList(MolAtom a, char sep, String v) throws MolFormatException {
        StringTokenizer st = new StringTokenizer(v, String.valueOf(sep));
        a.setAtno(sep == ',' ? 128 : 129);
        IntVector olist = new IntVector();
        while (st.hasMoreElements()) {
            String s = st.nextToken();
            int atno = MolAtom.numOf(s);
            if (atno < 1 || atno > 109) {
                throw new MolFormatException("unknown element in atom list: " + s);
            }
            olist.add(atno);
        }
        int[] list = olist.toArray();
        a.setList(list);
    }

    static void setAtomQueryProps(MolAtom a, String str) throws MolFormatException {
        String v = str;
        if (!v.equals("0")) {
            int listEndIndex = 0;
            if (v.startsWith("L!") || v.startsWith("L,")) {
                listEndIndex = v.indexOf(58);
                if (listEndIndex < 0) {
                    listEndIndex = v.length();
                }
                AtomReader.readAtomList(a, v.charAt(1), v.substring(2, listEndIndex));
            } else if (v.startsWith("A:")) {
                listEndIndex = 1;
                a.setAtno(131);
            } else if (v.startsWith("Q:")) {
                listEndIndex = 1;
                a.setAtno(132);
            }
            int strIndex = v.indexOf("str:");
            if (strIndex >= 0) {
                SmartsAtomQuerifier.setQuerystr(a, v.substring(strIndex + 4));
                v = v.substring(0, strIndex);
            }
            if (listEndIndex == v.length()) {
                return;
            }
            if (listEndIndex > 0) {
                v = v.substring(listEndIndex + 1);
            }
            StringTokenizer st = new StringTokenizer(v, ";");
            while (st.hasMoreTokens()) {
                int i;
                char c;
                int digiti;
                String s = st.nextToken();
                for (digiti = 0; digiti < s.length() && (c = s.charAt(digiti)) != '*' && c != '-' && c != '+' && (c < '0' || c > '9'); ++digiti) {
                }
                String prop = s.substring(0, digiti);
                if (s.equals("s-1") || s.equals("rb-1")) {
                    i = 0;
                } else if (s.equals("s*") || s.equals("rb*")) {
                    i = -2;
                } else {
                    try {
                        i = Integer.parseInt(s.substring(digiti));
                    }
                    catch (NumberFormatException ex) {
                        throw new MolFormatException("SMARTS or MDL property does not have an integer argument");
                    }
                }
                if (prop.equals("v")) {
                    a.setValenceProp(i);
                    continue;
                }
                a.setQProp(prop, i);
            }
        }
    }

    static String getUnescapedProperty(MolAtom a, String prop) {
        String v = prop;
        if (!v.equals("0")) {
            v = a.getAtno() == 131 && v.length() > 2 && v.charAt(0) == '\'' && v.endsWith("'") ? EncodingUtil.unescape(v.substring(1, v.length() - 1)) : (v.equals(".") ? "" : EncodingUtil.unescape(v));
            return v;
        }
        return null;
    }

    public static void setAtomExtraLabel(MolAtom a, String label) {
        String v = AtomReader.getUnescapedProperty(a, label);
        if (v != null) {
            a.setExtraLabel(v);
        }
    }

    public static void setAtomAlias(MolAtom a, String prop) {
        String v = AtomReader.getUnescapedProperty(a, prop);
        if (v != null) {
            a.setAliasstr(v);
        }
    }

    public static void setPseudoAtomName(MolAtom a, String name) {
        String v = name;
        if (!v.equals("0")) {
            a.setAtno(136);
            v = v.equals(".") ? "" : EncodingUtil.unescape(v);
            a.setAliasstr(v);
        }
    }

    public static void setLinkNodeRep(MolAtom a, String s) {
        int k = s.indexOf(45);
        int min = 1;
        int max = 1;
        if (k > 0) {
            min = Integer.parseInt(s.substring(0, k));
            max = Integer.parseInt(s.substring(k + 1));
        } else {
            max = Integer.parseInt(s);
        }
        a.setMinRepetitions(min);
        a.setMaxRepetitions(max);
    }

    public static int readAtomIdentifiers(Molecule mol, ParsedData parsedData, String array) throws MolFormatException {
        StringTokenizer st = new StringTokenizer(array);
        int i = 0;
        Map<String, MolAtom> h = parsedData.idAtomHash;
        Map<MolAtom, String> h2 = parsedData.atomIdHash;
        while (st.hasMoreTokens()) {
            String id = st.nextToken();
            MolAtom a = mol.reuseAtom(6, i);
            h.put(id, a);
            h2.put(a, id);
            ++i;
        }
        int na = i;
        return na;
    }

    public static void readIsSelected(Molecule mol, String array) throws MolFormatException {
        StringTokenizer st = new StringTokenizer(array);
        int i = 0;
        try {
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                if (s.equals("true")) {
                    mol.getAtom(i).setSelected(true);
                } else {
                    mol.getAtom(i).setSelected(false);
                }
                ++i;
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new MolFormatException("Reference to non-existing atom index in input in attribute isSelected", e);
        }
    }

    public static void readElementTypes(Molecule mol, String array) throws MolFormatException {
        StringTokenizer st = new StringTokenizer(array);
        int i = 0;
        try {
            while (st.hasMoreTokens()) {
                String sym = st.nextToken();
                AtomReader.setElementType(mol.getAtom(i), sym);
                ++i;
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new MolFormatException("Reference to non-existing atom index in input in attribute elementType", e);
        }
    }

    public static boolean[] readRgroupReferences(Molecule mol, String array) throws MolFormatException {
        boolean[] isRgroup = new boolean[mol.getAtomCount()];
        StringTokenizer st = new StringTokenizer(array);
        int i = 0;
        try {
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                isRgroup[i] = AtomReader.setAtomRgroupRef(mol.getAtom(i), s);
                ++i;
            }
            return isRgroup;
        }
        catch (IndexOutOfBoundsException e) {
            throw new MolFormatException("Reference to non-existing atom index in input in attribute rgroupRef", e);
        }
    }

    public static void readAttachmentPoints(Molecule mol, String array) throws MolFormatException {
        StringTokenizer st = new StringTokenizer(array);
        int i = 0;
        try {
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                AtomReader.setAtomAttach(mol.getAtom(i), s, mol);
                ++i;
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new MolFormatException("Reference to non-existing atom index in input in attribute attachmentPoint or sgroupAttachmentPoint", e);
        }
    }

    public static void readAttachmentOrders(Molecule mol, String array) throws MolFormatException {
        StringTokenizer st = new StringTokenizer(array);
        int i = 0;
        try {
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                int order = Integer.valueOf(s);
                mol.getAtom(i).setRgroupAttachmentPointOrder(order);
                ++i;
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new MolFormatException("Reference to non-existing atom index in input in attribute attachmentOrder", e);
        }
    }

    public static void readIsotopes(Molecule mol, String array) throws MolFormatException {
        StringTokenizer st = new StringTokenizer(array);
        int i = 0;
        try {
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                int iso = Integer.parseInt(s);
                mol.getAtom(i).setMassno(iso);
                ++i;
            }
        }
        catch (NumberFormatException ex) {
        }
        catch (IndexOutOfBoundsException e) {
            throw new MolFormatException("Reference to non-existing atom index in input in attribute isotope", e);
        }
    }

    public static void readFormalCharges(Molecule mol, String array) throws MolFormatException {
        StringTokenizer st = new StringTokenizer(array);
        int i = 0;
        try {
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                if (s.charAt(0) == '+') {
                    s = s.substring(1);
                }
                int chg = Integer.parseInt(s);
                mol.getAtom(i).setCharge(chg);
                ++i;
            }
        }
        catch (NumberFormatException ex) {
        }
        catch (IndexOutOfBoundsException e) {
            throw new MolFormatException("Reference to non-existing atom index in input in attribute formalCharge", e);
        }
    }

    public static void initCharges(Molecule mol) {
        for (int i = 0; i < mol.getAtomCount(); ++i) {
            mol.getAtom(i).setCharge(0);
        }
    }

    public static void readHydrogenCounts(Molecule mol, Set<MolAtom> atomsWithHcount, String array) throws MolFormatException {
        StringTokenizer st = new StringTokenizer(array);
        int i = 0;
        try {
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                int h = Integer.parseInt(s);
                MolAtom a = mol.getAtom(i);
                int hx = a.getExplicitHcount();
                a.setImplicitHcount(h - hx);
                atomsWithHcount.add(a);
                ++i;
            }
        }
        catch (NumberFormatException ex) {
        }
        catch (IndexOutOfBoundsException e) {
            throw new MolFormatException("Reference to non-existing atom index in input in attribute hydrogenCount", e);
        }
    }

    public static void readMrvValences(Molecule mol, String array) throws MolFormatException {
        StringTokenizer st = new StringTokenizer(array);
        int i = 0;
        try {
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                if (!s.equals("-")) {
                    int v = Integer.parseInt(s);
                    MolAtom a = mol.getAtom(i);
                    a.setValenceProp(v);
                }
                ++i;
            }
        }
        catch (NumberFormatException ex) {
        }
        catch (IndexOutOfBoundsException e) {
            throw new MolFormatException("Reference to non-existing atom index in input in attribute mrvValence", e);
        }
    }

    public static void readResidueTypes(Molecule mol, String array) throws MolFormatException {
        StringTokenizer st = new StringTokenizer(array);
        int i = 0;
        try {
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                AtomReader.setResidueType(mol.getAtom(i), s);
                ++i;
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new MolFormatException("Reference to non-existing atom index in input in attribute residueType", e);
        }
    }

    public static void readResidueIdentifiers(Molecule mol, Map<String, Integer> atomResidueIdHash, String array) throws MolFormatException {
        StringTokenizer st = new StringTokenizer(array);
        int i = 0;
        Map<String, Integer> h = atomResidueIdHash;
        try {
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                AtomReader.setResidueSeq(mol.getAtom(i), s, h);
                ++i;
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new MolFormatException("Reference to non-existing atom index in input in attribute residueId", e);
        }
    }

    public static void readResidueAtomNames(Molecule mol, String array) throws MolFormatException {
        StringTokenizer st = new StringTokenizer(array);
        int i = 0;
        try {
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                MolAtom a = mol.getAtom(i);
                AtomReader.setResidueAtomId(a, s);
                ++i;
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new MolFormatException("Reference to non-existing atom index in input in attribute residueAtomName", e);
        }
    }

    public static void readMrvMappings(Molecule mol, String array) throws MolFormatException {
        StringTokenizer st = new StringTokenizer(array);
        int i = 0;
        try {
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                int map = Integer.parseInt(s);
                mol.getAtom(i).setAtomMap(map);
                ++i;
            }
        }
        catch (NumberFormatException ex) {
        }
        catch (IndexOutOfBoundsException e) {
            throw new MolFormatException("Reference to non-existing atom index in input in attribute mrvMap", e);
        }
    }

    public static void readReactionStereos(Molecule mol, String array) throws MolFormatException {
        StringTokenizer st = new StringTokenizer(array);
        int i = 0;
        try {
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                AtomReader.setAtomRxnStereo(mol.getAtom(i), s);
                ++i;
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new MolFormatException("Reference to non-existing atom index in input in attribute reactionStereo", e);
        }
    }

    public static void readMrvStereoGroups(Molecule mol, String array) throws MolFormatException {
        StringTokenizer st = new StringTokenizer(array);
        int i = 0;
        try {
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                AtomReader.setAtomStereoGroup(mol.getAtom(i), s);
                ++i;
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new MolFormatException("Reference to non-existing atom index in input in attribute mrvStereoGroup", e);
        }
    }

    public static void readMrvSpecIsotopes(Molecule mol, String array) throws MolFormatException {
        StringTokenizer st = new StringTokenizer(array);
        int i = 0;
        try {
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                AtomReader.setSpecIsotopeSymbolPreferred(mol.getAtom(i), s);
                ++i;
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new MolFormatException("Reference to non-existing atom index in input in attribute mrvSpecIsotopeSymbolPreferred", e);
        }
    }

    public static void readRadicals(Molecule mol, String array) throws MolFormatException {
        StringTokenizer st = new StringTokenizer(array);
        int i = 0;
        try {
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                AtomReader.setAtomRadical(mol.getAtom(i), s);
                ++i;
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new MolFormatException("Reference to non-existing atom index in input in attribute radical", e);
        }
    }

    public static void readLonePairs(Molecule mol, String array) throws MolFormatException {
        StringTokenizer st = new StringTokenizer(array);
        int i = 0;
        try {
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                mol.getAtom(i).setElectronProp(Integer.valueOf(s));
                ++i;
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new MolFormatException("Reference to non-existing atom index in input in attribute lonePair", e);
        }
    }

    public static void readMrvQueryProps(Molecule mol, String array) throws MolFormatException {
        StringTokenizer st = new StringTokenizer(array);
        int i = 0;
        try {
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                AtomReader.setAtomQueryProps(mol.getAtom(i), s);
                ++i;
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new MolFormatException("Reference to non-existing atom index in input in attribute mrvQueryProps", e);
        }
    }

    public static void readMrvAliasValues(Molecule mol, String array) throws MolFormatException {
        StringTokenizer st = new StringTokenizer(array);
        int i = 0;
        try {
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                AtomReader.setAtomAlias(mol.getAtom(i), s);
                ++i;
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new MolFormatException("Reference to non-existing atom index in input in attribute mrvAlias", e);
        }
    }

    public static void readMrvExtraLabels(Molecule mol, String array) throws MolFormatException {
        StringTokenizer st = new StringTokenizer(array);
        int i = 0;
        try {
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                AtomReader.setAtomExtraLabel(mol.getAtom(i), s);
                ++i;
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new MolFormatException("Reference to non-existing atom index in input in attribute mrvExtraLabel", e);
        }
    }

    public static void readMrvPseudos(Molecule mol, String array) throws MolFormatException {
        StringTokenizer st = new StringTokenizer(array);
        int i = 0;
        try {
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                AtomReader.setPseudoAtomName(mol.getAtom(i), s);
                ++i;
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new MolFormatException("Reference to non-existing atom index in input in attribute mrvPseudo", e);
        }
    }

    public static void readMrvSetSeq(Molecule mol, String array) throws MolFormatException {
        StringTokenizer st = new StringTokenizer(array);
        int i = 0;
        try {
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                int k = Integer.parseInt(s);
                mol.getAtom(i).setSetSeq(k);
                ++i;
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new MolFormatException("Reference to non-existing atom index in input in attribute mrvSetSeq", e);
        }
    }

    public static void readMrvSetExtraLabelSeq(Molecule mol, String array) throws MolFormatException {
        StringTokenizer st = new StringTokenizer(array);
        int i = 0;
        try {
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                int k = Integer.parseInt(s);
                mol.getAtom(i).setExtraLabelSetSeq(k);
                ++i;
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new MolFormatException("Reference to non-existing atom index in input in attribute mrvSetExtraLabelSeq", e);
        }
    }

    public static void readMrvLinkNodeRepetitions(Molecule mol, String array) throws MolFormatException {
        StringTokenizer st = new StringTokenizer(array);
        int i = 0;
        try {
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                AtomReader.setLinkNodeRep(mol.getAtom(i), s);
                ++i;
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new MolFormatException("Reference to non-existing atom index in input in attribute mrvLinkNodeRep", e);
        }
    }

    public static boolean readMrvLinkNodeOutValues(Molecule mol, String array, boolean needsUpdating) throws MolFormatException {
        boolean linkNodeRefNeedsUpdating = needsUpdating;
        StringTokenizer st = new StringTokenizer(array);
        int i = 0;
        try {
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                linkNodeRefNeedsUpdating = AtomReader.storeLinkNodeOuters(mol.getAtom(i), s, linkNodeRefNeedsUpdating);
                ++i;
            }
            return linkNodeRefNeedsUpdating;
        }
        catch (IndexOutOfBoundsException e) {
            throw new MolFormatException("Reference to non-existing atom index in input in attribute mrvLinkNodeOut", e);
        }
    }

    public static int readCoordinates(Molecule mol, int dimension, int i, int j, String array) throws MolFormatException {
        int newDimension = dimension;
        if (i == 2 && dimension < 2) {
            newDimension = 2;
        } else if (i == 3) {
            newDimension = 3;
        }
        StringTokenizer st = new StringTokenizer(array);
        int k = 0;
        try {
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                MolAtom a = mol.getAtom(k);
                try {
                    double v = Double.valueOf(s);
                    if (j == 0) {
                        a.setX(v);
                    } else if (j == 1) {
                        a.setY(v);
                    } else {
                        a.setZ(v);
                    }
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
                ++k;
            }
            return newDimension;
        }
        catch (IndexOutOfBoundsException e) {
            throw new MolFormatException("Reference to non-existing atom index in input in atom coordinate attributes", e);
        }
    }

    public static void setLinkNodeOuters(Molecule mol, ParsedData parsedData, boolean linkNodeRefNeedsUpdating) throws MolFormatException {
        try {
            if (linkNodeRefNeedsUpdating) {
                int ac = mol.getAtomCount();
                for (int i = 0; i < ac; ++i) {
                    MolAtom atom = mol.getAtom(i);
                    Object aRef = atom.getQProp("LINKNODE_OUTER0");
                    if (aRef == null) continue;
                    MolAtom aa = parsedData.idAtomHash.get(aRef);
                    int outer0 = atom.getLigandIndex(aa);
                    atom.setLinkNodeOuterAtom(0, outer0);
                    atom.setQProp("LINKNODE_OUTER0", null);
                    aRef = atom.getQProp("LINKNODE_OUTER1");
                    if (aRef == null) continue;
                    aa = parsedData.idAtomHash.get(aRef);
                    int outer1 = atom.getLigandIndex(aa);
                    atom.setLinkNodeOuterAtom(1, outer1);
                    atom.setQProp("LINKNODE_OUTER1", null);
                }
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new MolFormatException("Reference to non-existing atom index in input in link node outer information", e);
        }
    }

    public static void processLigandOrderHash(Molecule mol, ParsedData parsedData) throws MolFormatException {
        try {
            for (int i = 0; i < mol.getAtomCount(); ++i) {
                String refs;
                MolAtom atom = mol.getAtom(i);
                if (atom.getAtno() != 134 || (refs = parsedData.ligandOrderHash.get(atom)) == null || refs.length() <= 0) continue;
                StringTokenizer st = new StringTokenizer(refs);
                int j = 1;
                while (st.hasMoreTokens()) {
                    String atomId = st.nextToken();
                    MolAtom ligand = parsedData.idAtomHash.get(atomId);
                    atom.setLigandOrder(j, ligand);
                    ++j;
                }
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new MolFormatException("Reference to non-existing atom index in input in ligand order information", e);
        }
    }

    public static void setAtomParities(MoleculeGraph molg, ParsedData parsedData) throws MolFormatException {
        Map<MolAtom, String[]> phash = parsedData.atomParityHash;
        Map<String, MolAtom> ahash = parsedData.idAtomHash;
        Iterator<MolAtom> keys = phash.keySet().iterator();
        try {
            while (keys.hasNext()) {
                MolAtom a = keys.next();
                String[] refs = phash.get(a);
                int[] order = new int[refs.length - 1];
                for (int i = 0; i < order.length; ++i) {
                    MolAtom aa = ahash.get(refs[i]);
                    order[i] = a.getLigandIndex(aa);
                }
                String sparity = refs[order.length];
                int parity = 0;
                if (sparity.equals("1")) {
                    parity = 1;
                } else if (sparity.equals("-1")) {
                    parity = -1;
                }
                int sign = 0;
                if (order.length == 3) {
                    sign = MolAtom.paritySign(order[0], order[1], order[2], Integer.MAX_VALUE);
                } else if (order.length == 4) {
                    sign = MolAtom.paritySign(order[0], order[1], order[2], order[3]);
                }
                int i = molg.indexOf(a);
                molg.setParity(i, (parity *= sign) == -1 ? 2 : (parity == 1 ? 1 : 0));
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new MolFormatException("Reference to non-existing atom index in input in atom parity information", e);
        }
    }
}

