/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.cml;

import chemaxon.calculations.clean.Cleaner;
import chemaxon.marvin.io.MPropHandler;
import chemaxon.marvin.io.MolExportException;
import chemaxon.marvin.io.MolExportModule;
import chemaxon.marvin.io.formats.cml.MrvPrettyPrinter;
import chemaxon.marvin.util.OptionDescriptor;
import chemaxon.marvin.util.text.EncodingUtil;
import chemaxon.marvin.util.text.LocaleUtil;
import chemaxon.marvin.version.VersionInfo;
import chemaxon.struc.MProp;
import chemaxon.struc.MPropertyContainer;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.RgMolecule;
import chemaxon.struc.RxnMolecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.StereoConstants;
import chemaxon.struc.prop.MMoleculeProp;
import chemaxon.struc.prop.MStringProp;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.TransformerException;

public class CMLExport
extends MolExportModule
implements StereoConstants {
    private static final String CML_FILE_FORMAT_VERSION = "5.9.0";
    private static final String FILE_FORMAT_PREFIX = "ChemAxon file format v";
    private static final String GENERATION_PREFIX = ", generated by v";
    protected String fileFormatVersion = "5.9.0";
    protected int coordinateLength = 0;
    protected boolean coordinateConversion = true;
    protected static XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
    protected XMLStreamWriter xmlStreamWriter = null;
    protected OutputStream outputStream = null;
    protected boolean prettyPrinting = false;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final int ALIGNMENT = 3;
    public static final int SIGNED = 4;
    protected static final String[] REACTION_LIST_STRINGS = new String[]{"reactantList", "agentList", "productList"};
    private static final boolean[] NEEDS_CDATA;
    protected static final int[] REACTION_LIST_IDS;
    private static final int MIN_FRACTION_DIGITS_FOR_NUMBER_FORMAT = 15;
    private boolean writeSelfRefProps = true;
    protected boolean useAtomArray = false;
    protected int currentMoleculeCount = 0;
    protected String theFormat = "cml";

    public CMLExport() throws MolExportException {
        this(new ByteArrayOutputStream());
    }

    private CMLExport(OutputStream stream) throws MolExportException {
        this.outputStream = stream;
        try {
            this.xmlStreamWriter = xmlOutputFactory.createXMLStreamWriter(this.outputStream);
        }
        catch (XMLStreamException e) {
            throw new MolExportException(e);
        }
    }

    public static String getFileFormatVersion() {
        return CML_FILE_FORMAT_VERSION;
    }

    public boolean isPrettyPrinting() {
        return this.prettyPrinting;
    }

    public void setPrettyPrinting(boolean prettyPrinting) {
        this.prettyPrinting = prettyPrinting;
    }

    public boolean areCoordinatesConverted() {
        return this.coordinateConversion;
    }

    public void setCoordinatesConverted(boolean convert) {
        this.coordinateConversion = convert;
    }

    @Override
    protected void getOptionDescriptors(String fmtname, String optnames, List<OptionDescriptor> l) {
        super.getOptionDescriptors(null, optnames, l);
        ResourceBundle rc = LocaleUtil.getResourceBundle(CMLExport.class.getName(), null);
        CMLExport.getOptionDescriptors(rc, fmtname, optnames, l);
    }

    static String getFileFormatVersion(String versionInfo) {
        int startIndex = versionInfo.indexOf(FILE_FORMAT_PREFIX) + FILE_FORMAT_PREFIX.length();
        return versionInfo.substring(startIndex, startIndex + CML_FILE_FORMAT_VERSION.length());
    }

    static String getGenerationVersion(String versionInfo) {
        int startIndex = versionInfo.indexOf(GENERATION_PREFIX) + GENERATION_PREFIX.length();
        int versionEnd = startIndex + VersionInfo.MARVIN_VERSION.length();
        int endIndex = versionEnd > versionInfo.length() ? versionInfo.length() : versionEnd;
        return versionInfo.substring(startIndex, endIndex);
    }

    @Override
    public Object open(String fmtopts, MPropertyContainer props) throws MolExportException {
        this.useAtomArray = false;
        super.open(fmtopts, props);
        this.currentMoleculeCount = 0;
        String encoding = this.getEncoding();
        try {
            if (encoding != null) {
                this.xmlStreamWriter.writeStartDocument(encoding, "1.0");
            } else {
                this.xmlStreamWriter.writeStartDocument("1.0");
            }
            if (this.prettyPrinting) {
                this.writeNewLineToStream();
            }
            this.appendCMLHeader();
        }
        catch (XMLStreamException e) {
            throw new MolExportException(e);
        }
        this.writeNewLineToStream();
        try {
            this.xmlStreamWriter.flush();
        }
        catch (XMLStreamException e) {
            throw new MolExportException(e);
        }
        String result = this.outputStream.toString();
        ((ByteArrayOutputStream)this.outputStream).reset();
        return result;
    }

    private void appendCMLHeader() throws XMLStreamException {
        this.xmlStreamWriter.writeStartElement("cml");
        this.writeFormatSpecificAttributes();
        this.xmlStreamWriter.writeAttribute("version", FILE_FORMAT_PREFIX + this.fileFormatVersion + GENERATION_PREFIX + VersionInfo.MARVIN_VERSION);
    }

    protected void writeFormatSpecificAttributes() throws XMLStreamException {
        this.xmlStreamWriter.writeAttribute("xmlns", "http://www.xml-cml.org/schema");
        this.xmlStreamWriter.writeAttribute("xmlns:convention", "http://www.xml-cml.org/convention");
        this.xmlStreamWriter.writeAttribute("convention", "convention:molecular");
        this.xmlStreamWriter.writeAttribute("xmlns:marvin", "http://www.chemaxon.com/marvin/marvinDictRef");
    }

    @Override
    public Object close() throws MolExportException {
        try {
            this.xmlStreamWriter.writeEndElement();
            this.xmlStreamWriter.writeEndDocument();
            this.writeNewLineToStream();
            this.xmlStreamWriter.close();
        }
        catch (XMLStreamException e) {
            throw new MolExportException(e);
        }
        String result = this.outputStream.toString();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object convert(Molecule mol) throws MolExportException {
        MPropertyContainer props = mol.properties();
        boolean hierarchic = props.isHierarchic();
        if (hierarchic) {
            props.flatten();
        }
        try {
            Object object = this.convert0(mol);
            return object;
        }
        finally {
            if (hierarchic) {
                props.hierarchize();
            }
        }
    }

    protected String printToString() throws MolExportException {
        try {
            this.xmlStreamWriter.flush();
        }
        catch (XMLStreamException e) {
            throw new MolExportException(e);
        }
        String result = this.outputStream.toString();
        ((ByteArrayOutputStream)this.outputStream).reset();
        if (!result.isEmpty() && this.prettyPrinting) {
            try {
                result = MrvPrettyPrinter.prettyPrintWithoutXmlTag(result);
            }
            catch (TransformerException e) {
                throw new MolExportException(e);
            }
        }
        if (this.getEncoding() == null || this.getEncoding().isEmpty()) {
            result = CMLExport.escapeString(result);
        }
        return result;
    }

    protected void writeNewLineToStream() throws MolExportException {
        try {
            this.xmlStreamWriter.writeCharacters("\n");
        }
        catch (XMLStreamException e) {
            throw new MolExportException(e);
        }
    }

    private Object convert0(Molecule mol) throws MolExportException {
        mol = this.expandBeforeWrite(mol);
        this.appendMolecule(mol);
        this.writeNewLineToStream();
        return this.printToString();
    }

    protected void appendMolecule(Molecule mol) throws MolExportException {
        if (mol instanceof RxnMolecule) {
            this.appendReaction((RxnMolecule)mol);
        } else if (mol instanceof RgMolecule) {
            this.appendRgMolecule((RgMolecule)mol);
        } else {
            this.appendMolecule0(mol, mol.properties());
        }
    }

    private void appendRgMolecule(RgMolecule rgmol) throws MolExportException {
        Molecule root = rgmol.getRoot();
        if (root instanceof RxnMolecule) {
            this.appendMolecule((RxnMolecule)root);
        } else {
            this.appendMolecule0(root, root.properties());
        }
    }

    protected Molecule expandBeforeWrite(Molecule mol) {
        Molecule newM = (Molecule)mol.clone();
        newM.expandSgroups();
        return newM;
    }

    private void appendReaction(RxnMolecule rxn) throws MolExportException {
        Hashtable<Molecule, String> writtenRxns = new Hashtable<Molecule, String>();
        if (rxn.isSingleStepReaction()) {
            this.appendReactionStep(rxn, writtenRxns);
        }
    }

    private void appendReactionStep(RxnMolecule step, Hashtable<Molecule, String> writtenRxns) throws MolExportException {
        try {
            this.xmlStreamWriter.writeStartElement("reaction");
            String title = step.getName();
            if (!title.isEmpty()) {
                this.xmlStreamWriter.writeAttribute("title", title);
            }
            this.extendReactionTag(step);
            this.appendArrow(step);
            boolean rxnwritten = false;
            if (this.writeSelfRefProps || !step.hasSelfReferringProperty()) {
                this.appendPropertyList(step.properties());
                rxnwritten = step.hasSelfReferringProperty();
            }
            if (!rxnwritten) {
                for (int i = 0; i < REACTION_LIST_IDS.length; ++i) {
                    int f = REACTION_LIST_IDS[i];
                    int n = step.getComponentCount(f);
                    if (n == 0 && f != 0 && f != 1) continue;
                    if (f == 2) {
                        this.reactionListExtension(step, n);
                        continue;
                    }
                    this.xmlStreamWriter.writeStartElement(REACTION_LIST_STRINGS[i]);
                    for (int j = 0; j < n; ++j) {
                        Molecule m = step.getComponent(f, j);
                        if (writtenRxns.containsKey(m)) {
                            String ref = writtenRxns.get(m);
                            this.appendMoleculePlaceHolder(ref);
                            continue;
                        }
                        this.appendMolecule0(m, m.properties());
                    }
                    this.xmlStreamWriter.writeEndElement();
                }
            }
            this.xmlStreamWriter.writeEndElement();
        }
        catch (Exception e) {
            throw new MolExportException(e);
        }
    }

    protected void appendMolecule0(Molecule mol, MPropertyContainer props) throws MolExportException {
        this.appendMolecule0(mol, props, null);
    }

    private void appendMolecule0(Molecule molecule, MPropertyContainer props, Hashtable<Molecule, String> writtenRxnFragments) throws MolExportException {
        try {
            Molecule mol = this.prepareForImport(molecule);
            this.xmlStreamWriter.writeStartElement("molecule");
            String title = mol.getName();
            if (!title.isEmpty()) {
                this.xmlStreamWriter.writeAttribute("title", title);
            }
            ++this.currentMoleculeCount;
            String molCount = "m" + this.currentMoleculeCount;
            this.xmlStreamWriter.writeAttribute(this.getMolIDString(), molCount);
            if (writtenRxnFragments != null) {
                writtenRxnFragments.put(mol, molCount);
            }
            this.extendMoleculeTag(mol);
            boolean molwritten = false;
            if (this.writeSelfRefProps || !mol.hasSelfReferringProperty()) {
                this.appendPropertyList(props);
                molwritten = mol.hasSelfReferringProperty();
            }
            HashMap<MolAtom, String> atomHash = new HashMap<MolAtom, String>();
            if (!molwritten) {
                this.appendMoleculeGraph(mol, null, atomHash);
                this.sgroupExtension(mol, atomHash);
            }
            this.xmlStreamWriter.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new MolExportException(e);
        }
    }

    private boolean hasParityInfo(MoleculeGraph molg) {
        for (int i = 0; i < molg.getAtomCount(); ++i) {
            if (molg.getParity(i) == 0 || molg.getParity(i) == 3) continue;
            return true;
        }
        return false;
    }

    protected void appendMoleculeGraph(MoleculeGraph molg, Sgroup psg, HashMap<MolAtom, String> atomHash) throws XMLStreamException {
        this.xmlStreamWriter.writeStartElement("atomArray");
        if (this.coordinateConversion && molg.getDim() == 0 && this.hasParityInfo(molg)) {
            Cleaner.clean(molg, 2, "");
        }
        if (this.useAtomArray && !this.useAtomicAttributes(molg)) {
            this.writeAtomArrayAttributes(molg, psg, atomHash);
            this.xmlStreamWriter.writeEndElement();
        } else {
            int na = molg.getAtomCount();
            for (int i = 0; i < na; ++i) {
                this.writeAtom(molg, psg, i, atomHash);
            }
            this.xmlStreamWriter.writeEndElement();
        }
        this.xmlStreamWriter.writeStartElement("bondArray");
        molg.getBondCount();
        for (int i = 0; i < molg.getBondCount(); ++i) {
            this.writeBond(molg, i, atomHash);
        }
        this.xmlStreamWriter.writeEndElement();
    }

    private void writeBond(MoleculeGraph molg, int i, HashMap<MolAtom, String> atomHash) throws XMLStreamException {
        boolean extrastuff;
        MolBond b = molg.getBond(i);
        String ref1 = CMLExport.getAtomId(b.getAtom1(), atomHash);
        String ref2 = CMLExport.getAtomId(b.getAtom2(), atomHash);
        this.xmlStreamWriter.writeStartElement("bond");
        this.xmlStreamWriter.writeAttribute("atomRefs2", ref1 + " " + ref2);
        int flags = b.getFlags();
        int type = b.getType();
        if (type >= 1 && type <= 3 || type == 4) {
            String s = type == 4 ? "A" : String.valueOf(type);
            this.xmlStreamWriter.writeAttribute("order", s);
        } else if (type == 9) {
            this.xmlStreamWriter.writeAttribute("convention", "cxn:coord");
        } else {
            String sq;
            String so;
            switch (type) {
                case 5: {
                    so = "1";
                    sq = "SD";
                    break;
                }
                case 6: {
                    so = "1";
                    sq = "SA";
                    break;
                }
                case 7: {
                    so = "2";
                    sq = "DA";
                    break;
                }
                default: {
                    so = "1";
                    sq = "Any";
                }
            }
            this.xmlStreamWriter.writeAttribute("order", so);
            this.writeBondExtension0(b, sq);
        }
        this.writeBondExtension1(b);
        int stereo1 = flags & 0x30;
        int stereo2 = flags & 0x3C0;
        boolean bl = extrastuff = stereo1 != 0 || stereo2 != 0;
        if (!extrastuff) {
            this.xmlStreamWriter.writeEndElement();
        }
        if (stereo1 != 0) {
            if (stereo1 == 16) {
                this.xmlStreamWriter.writeStartElement("bondStereo");
                this.xmlStreamWriter.writeCharacters("W");
                this.xmlStreamWriter.writeEndElement();
            } else if (stereo1 == 32) {
                this.xmlStreamWriter.writeStartElement("bondStereo");
                this.xmlStreamWriter.writeCharacters("H");
                this.xmlStreamWriter.writeEndElement();
            } else if (stereo1 == 48) {
                this.xmlStreamWriter.writeStartElement("bondStereo");
                this.xmlStreamWriter.writeAttribute("convention", "MDL");
                this.xmlStreamWriter.writeAttribute("conventionValue", "4");
                this.xmlStreamWriter.writeEndElement();
            }
        }
        if (stereo2 != 0) {
            if ((stereo2 & 0x300) != 0) {
                this.xmlStreamWriter.writeStartElement("bondStereo");
                this.xmlStreamWriter.writeAttribute("convention", "ChemAxon");
                String s = this.getStereo2InChemaxonConvention(stereo2);
                this.xmlStreamWriter.writeAttribute("conventionValue", s);
                this.xmlStreamWriter.writeEndElement();
            } else if ((stereo2 & 0xC0) == 128) {
                this.xmlStreamWriter.writeStartElement("bondStereo");
                this.xmlStreamWriter.writeCharacters("C");
                this.xmlStreamWriter.writeEndElement();
            } else if ((stereo2 & 0xC0) == 64) {
                this.xmlStreamWriter.writeStartElement("bondStereo");
                this.xmlStreamWriter.writeCharacters("T");
                this.xmlStreamWriter.writeEndElement();
            } else if (stereo2 == 192) {
                this.xmlStreamWriter.writeStartElement("bondStereo");
                this.xmlStreamWriter.writeAttribute("convention", "MDL");
                this.xmlStreamWriter.writeAttribute("conventionValue", "3");
                this.xmlStreamWriter.writeEndElement();
            }
        }
        if (extrastuff) {
            this.xmlStreamWriter.writeEndElement();
        }
    }

    private String getStereo2InChemaxonConvention(int stereo2) {
        StringBuilder sb = new StringBuilder();
        if ((stereo2 & 0xC0) == 128) {
            sb.append('C');
        } else if ((stereo2 & 0xC0) == 64) {
            sb.append('T');
        } else if ((stereo2 & 0xC0) == 192 && (stereo2 & 0x100) == 0) {
            sb.append("C,T");
        }
        if ((stereo2 & 0x100) != 0) {
            if (sb.length() != 0) {
                sb.append(',');
            }
            sb.append("CTUnspec");
        }
        if ((stereo2 & 0x200) != 0) {
            if (sb.length() != 0) {
                sb.append(',');
            }
            sb.append("CARE");
        }
        return sb.toString();
    }

    protected void writeBondExtension1(MolBond b) throws XMLStreamException {
    }

    protected void writeBondExtension0(MolBond b, String sq) throws XMLStreamException {
    }

    private void writeAtom(MoleculeGraph molg, Sgroup psg, int i, HashMap<MolAtom, String> atomHash) throws XMLStreamException {
        boolean hasParityInfo;
        MolAtom a = molg.getAtom(i);
        int dim = molg.getDim();
        String elemtyp = this.getElementType(a);
        int formalCharge = a.getCharge();
        int isotope = a.getMassno();
        double x = a.getX();
        double y = a.getY();
        double z = a.getZ();
        this.xmlStreamWriter.writeStartElement("atom");
        this.xmlStreamWriter.writeAttribute("id", CMLExport.getAtomId(a, atomHash));
        this.xmlStreamWriter.writeAttribute("elementType", elemtyp);
        if (isotope != 0) {
            this.xmlStreamWriter.writeAttribute("isotope", String.valueOf(isotope));
        }
        if (formalCharge != 0) {
            String sc = String.valueOf(formalCharge);
            this.xmlStreamWriter.writeAttribute("formalCharge", sc);
        }
        this.writeAtomExtensions(molg, psg, i, atomHash);
        if (dim == 2 || dim == 3) {
            if (dim == 2) {
                this.xmlStreamWriter.writeAttribute("x2", this.formatNumber(x));
                this.xmlStreamWriter.writeAttribute("y2", this.formatNumber(y));
            } else {
                this.xmlStreamWriter.writeAttribute("x3", this.formatNumber(x));
                this.xmlStreamWriter.writeAttribute("y3", this.formatNumber(y));
                this.xmlStreamWriter.writeAttribute("z3", this.formatNumber(z));
            }
        }
        this.writeRGroupAttachmentPointInformation(a, molg, atomHash);
        this.writeSelectionInformation(a);
        int nb = a.getBondCount();
        int parity = (nb == 3 || nb == 4) && molg.getDim() == 0 ? molg.getParity(i) : 0;
        parity = parity == 3 ? 0 : parity;
        boolean hasProperty = a.propertyCount() != 0;
        boolean is0D = molg.getDim() == 0;
        boolean bl = hasParityInfo = is0D && parity != 0;
        if (hasParityInfo) {
            this.writeAtomParity(molg, i, atomHash, parity);
        }
        if (hasProperty) {
            this.writePropertyList(a, atomHash);
        }
        if (this.hasBicycloStereoInformation(is0D, a, molg)) {
            this.writeBicycloStereoInformation(a, atomHash, molg);
        }
        this.xmlStreamWriter.writeEndElement();
    }

    protected void writeSelectionInformation(MolAtom a) throws XMLStreamException {
    }

    @Override
    protected int parseOption(String opts, int i) throws IllegalArgumentException {
        if ((i = this.parseCharIfOptionSign(opts, i)) >= opts.length()) {
            return i;
        }
        int ii = super.parseOption(opts, i);
        if (ii != i) {
            return ii;
        }
        char c = opts.charAt(i);
        if (c == 'A') {
            this.useAtomArray = true;
            ++i;
        }
        if (c == 'P') {
            this.prettyPrinting = true;
            ++i;
        }
        if (c == 'C') {
            this.coordinateLength = Integer.parseInt(opts.substring(++i, i + 1));
            ++i;
        }
        if (c == 'D') {
            this.coordinateConversion = false;
            ++i;
        }
        return i;
    }

    protected void writeBicycloStereoInformation(MolAtom a, HashMap<MolAtom, String> atomHash, MoleculeGraph molg) throws XMLStreamException {
    }

    private void writePropertyList(MolAtom atom, HashMap<MolAtom, String> atomHash) throws XMLStreamException {
        Object[] keys = atom.propertyKeySet().toArray(new String[atom.propertyCount()]);
        Arrays.sort(keys);
        for (int i = 0; i < keys.length; ++i) {
            Object key = keys[i];
            Object value = atom.getProperty((String)key);
            String type = this.getTypeOf(value);
            if (type == null) continue;
            this.xmlStreamWriter.writeStartElement("scalar");
            this.xmlStreamWriter.writeAttribute("id", atomHash.get(atom) + ":prop" + (i + 1));
            this.xmlStreamWriter.writeAttribute("title", (String)key);
            this.xmlStreamWriter.writeAttribute("convention", "marvin:atomprop");
            this.xmlStreamWriter.writeAttribute("dataType", "xsd:" + type);
            if (value == null) {
                this.xmlStreamWriter.writeAttribute("value", "null");
            } else {
                this.xmlStreamWriter.writeAttribute("value", value.toString());
            }
            this.xmlStreamWriter.writeEndElement();
        }
    }

    private String getTypeOf(Object value) {
        if (value == null) {
            return "unknown";
        }
        if (value instanceof String) {
            return "string";
        }
        if (value instanceof Integer) {
            return "integer";
        }
        if (value instanceof Boolean) {
            return "boolean";
        }
        if (value instanceof Double) {
            return "double";
        }
        if (value instanceof Float) {
            return "float";
        }
        return null;
    }

    private void writeAtomParity(MoleculeGraph molg, int i, HashMap<MolAtom, String> atomHash, int parity) throws XMLStreamException {
        MolAtom a = molg.getAtom(i);
        this.xmlStreamWriter.writeStartElement("atomParity");
        this.xmlStreamWriter.writeAttribute("atomRefs4", this.getAtomParityAtomRefs(a, atomHash));
        this.xmlStreamWriter.writeCharacters(parity == 1 ? "1" : "-1");
        this.xmlStreamWriter.writeEndElement();
    }

    private String getAtomParityAtomRefs(MolAtom a, HashMap<MolAtom, String> atomHash) {
        StringBuilder sb = new StringBuilder();
        int nb = a.getBondCount();
        if (nb == 3) {
            sb.append(CMLExport.getAtomId(a, atomHash));
            sb.append(' ');
        }
        for (int i = 0; i < nb; ++i) {
            if (i != 0) {
                sb.append(' ');
            }
            sb.append(CMLExport.getAtomId(a.getLigand(i), atomHash));
        }
        return sb.toString();
    }

    protected void writeRGroupAttachmentPointInformation(MolAtom a, MoleculeGraph molg, HashMap<MolAtom, String> atomHash) throws XMLStreamException {
    }

    protected String truncateNumber(double number) {
        String result;
        if (this.coordinateLength > 0) {
            StringBuilder sb = new StringBuilder("0.");
            for (int i = 0; i < this.coordinateLength; ++i) {
                sb.append('0');
            }
            DecimalFormat df = new DecimalFormat(sb.toString());
            result = df.format(number).replace(",", ".");
        } else {
            result = String.valueOf(number);
        }
        return result;
    }

    protected String formatNumber(double number) {
        String numString = this.truncateNumber(number);
        if (this.coordinateLength > 0) {
            return numString;
        }
        String str = String.valueOf(numString).trim();
        int fractiondigits = 0;
        if (str.contains(".")) {
            fractiondigits = str.substring(str.indexOf(".") + 1).length();
        }
        StringBuilder builder = new StringBuilder(str);
        if (fractiondigits < 15) {
            for (int i = fractiondigits; i < 15; ++i) {
                builder.append('0');
            }
        }
        return builder.toString();
    }

    protected void writeAtomExtensions(MoleculeGraph molg, Sgroup psg, int i, HashMap<MolAtom, String> atomHash) throws XMLStreamException {
    }

    private void writeAtomArrayAttributes(MoleculeGraph molg, Sgroup psg, HashMap<MolAtom, String> atomHash) throws XMLStreamException {
        int j;
        int i;
        int i2;
        int na = molg.getAtomCount();
        int dim = molg.getDim();
        StringBuilder sb = new StringBuilder();
        for (i2 = 0; i2 < na; ++i2) {
            MolAtom a = molg.getAtom(i2);
            if (i2 > 0) {
                sb.append(' ');
            }
            sb.append(CMLExport.getAtomId(a, atomHash));
        }
        this.xmlStreamWriter.writeAttribute("atomID", sb.toString());
        sb.setLength(0);
        for (i2 = 0; i2 < na; ++i2) {
            String sym = this.getElementType(molg.getAtom(i2));
            if (i2 > 0) {
                sb.append(' ');
            }
            sb.append(sym);
        }
        this.xmlStreamWriter.writeAttribute("elementType", sb.toString());
        boolean hasIsotope = false;
        boolean hasFormalCharge = false;
        boolean hasHydrogenCount = false;
        boolean hasRgroupAPO = false;
        boolean hasSelection = false;
        for (i = 0; i < na; ++i) {
            MolAtom a = molg.getAtom(i);
            hasIsotope |= a.getMassno() != 0;
            hasFormalCharge |= a.getCharge() != 0;
            hasHydrogenCount |= CMLExport.isImplicitHcountImportant(a);
            hasRgroupAPO |= a.getAtno() == 138;
            hasSelection |= a.isSelected();
        }
        if (hasRgroupAPO) {
            sb.setLength(0);
            for (j = 0; j < na; ++j) {
                int apo = 0;
                if (molg.getAtom(j).getAtno() == 138) {
                    apo = molg.getAtom(j).getRgroupAttachmentPointOrder();
                }
                if (j > 0) {
                    sb.append(' ');
                }
                sb.append(apo);
            }
            this.xmlStreamWriter.writeAttribute("attachmentOrder", sb.toString());
        }
        if (hasSelection) {
            this.writeSelectionInformation(molg, na);
        }
        if (hasIsotope) {
            sb.setLength(0);
            for (j = 0; j < na; ++j) {
                int iso = molg.getAtom(j).getMassno();
                if (j > 0) {
                    sb.append(' ');
                }
                sb.append(iso);
            }
            this.xmlStreamWriter.writeAttribute("isotope", sb.toString());
        }
        if (hasFormalCharge) {
            sb.setLength(0);
            for (j = 0; j < na; ++j) {
                int chg = molg.getAtom(j).getCharge();
                if (j > 0) {
                    sb.append(' ');
                }
                sb.append(chg);
            }
            this.xmlStreamWriter.writeAttribute("formalCharge", sb.toString());
        }
        this.extendAtomArrayAttributes(molg, psg, atomHash);
        if (dim == 2 || dim == 3) {
            for (i = 0; i < dim; ++i) {
                sb.setLength(0);
                for (int j2 = 0; j2 < na; ++j2) {
                    double coord;
                    MolAtom a = molg.getAtom(j2);
                    double d = i == 0 ? a.getX() : (coord = i == 1 ? a.getY() : a.getZ());
                    if (j2 > 0) {
                        sb.append(' ');
                    }
                    sb.append(this.truncateNumber(coord));
                }
                this.xmlStreamWriter.writeAttribute((char)(120 + i) + String.valueOf(dim), sb.toString());
            }
        }
    }

    protected void writeSelectionInformation(MoleculeGraph molg, int na) throws XMLStreamException {
    }

    protected void extendAtomArrayAttributes(MoleculeGraph molg, Sgroup psg, HashMap<MolAtom, String> atomHash) throws XMLStreamException {
    }

    private String getElementType(MolAtom a) {
        int atno = a.getAtno();
        if (atno == 137) {
            return "X";
        }
        if (atno == 138) {
            return "*";
        }
        if (atno == 134 || atno == 135) {
            return "R";
        }
        if (atno == 131 || atno == 132 || atno == 129 || atno == 136) {
            return "C";
        }
        if (atno == 128) {
            int[] list = a.getList();
            return list != null && list.length != 0 ? MolAtom.symbolOf(list[0]) : "C";
        }
        return MolAtom.symbolOf(atno);
    }

    protected static String getAtomId(MolAtom a, HashMap<MolAtom, String> atomHash) {
        String id = atomHash.get(a);
        if (id == null) {
            id = "a" + (atomHash.size() + 1);
            atomHash.put(a, id);
        }
        return id;
    }

    private boolean useAtomicAttributes(MoleculeGraph molg) {
        boolean is0D = molg.getDim() == 0;
        for (int i = 0; i < molg.getAtomCount(); ++i) {
            if (!this.hasExtendedAttributes(is0D, i, molg)) continue;
            return true;
        }
        return false;
    }

    private boolean hasParityInfo(boolean is0D, int p) {
        return is0D && p != 0 && p != 3;
    }

    private boolean hasExtendedAttributes(boolean is0D, int i, MoleculeGraph molg) {
        int parity = is0D ? molg.getParity(i) : 0;
        return molg.getAtom(i).propertyCount() != 0 || molg.getAtom(i).getAtno() == 134 || this.hasBicycloStereoInformation(is0D, molg.getAtom(i), molg) || this.hasParityInfo(is0D, parity) || CMLExport.isImplicitHcountImportant(molg.getAtom(i));
    }

    protected boolean hasBicycloStereoInformation(boolean is0D, MolAtom atom, MoleculeGraph molg) {
        return false;
    }

    protected void sgroupExtension(Molecule mol, HashMap<MolAtom, String> atomHash) throws XMLStreamException, MolExportException {
    }

    protected void extendMoleculeTag(Molecule mol) throws XMLStreamException {
    }

    protected String getMolIDString() {
        return "id";
    }

    protected Molecule prepareForImport(Molecule mol) {
        Molecule pmol = this.preconvert(mol, false);
        if (mol.getSgroupCount() != 0) {
            if (pmol == mol) {
                pmol = (Molecule)mol.clone();
            }
            pmol.setGUIContracted(true);
        }
        return pmol;
    }

    protected void appendMoleculePlaceHolder(String ref) throws XMLStreamException {
        this.xmlStreamWriter.writeStartElement("molecule");
        this.xmlStreamWriter.writeAttribute(this.getMolIDString(), ref);
    }

    protected void reactionListExtension(RxnMolecule step, int sCount) throws XMLStreamException, MolExportException {
    }

    protected void appendPropertyList(MPropertyContainer props) throws MolExportException {
        this.appendPropertyList(null, props);
    }

    protected void appendPropertyList(MPropertyContainer tagProps, MPropertyContainer props) throws MolExportException {
        int nprop = props.size();
        if (nprop != 0) {
            try {
                this.xmlStreamWriter.writeStartElement("propertyList");
                if (tagProps != null && tagProps.size() > 0) {
                    int nTagProps = tagProps.size();
                    for (int i = 0; i < nTagProps; ++i) {
                        String xsdtype;
                        String key = tagProps.getKey(i);
                        MProp val = tagProps.get(key);
                        if (!tagProps.isValid(val) || !(xsdtype = val.getPropXSDType()).equalsIgnoreCase("string")) continue;
                        this.xmlStreamWriter.writeAttribute(key, ((MStringProp)val).stringValue());
                    }
                }
                for (int i = 0; i < nprop; ++i) {
                    String key = props.getKey(i);
                    MProp val = props.get(key);
                    if (!props.isValid(val)) continue;
                    this.xmlStreamWriter.writeStartElement("property");
                    this.xmlStreamWriter.writeAttribute("dictRef", this.modifyPropertyKeyCallback(key));
                    this.xmlStreamWriter.writeAttribute("title", key);
                    String xsdtype = val.getPropXSDType();
                    int arrsize = val.getPropArraySize();
                    if (arrsize >= 0) {
                        this.xmlStreamWriter.writeStartElement("array");
                        this.xmlStreamWriter.writeAttribute("size", String.valueOf(arrsize));
                        this.xmlStreamWriter.writeAttribute("dataType", "xsd:" + val.getPropXSDType());
                        this.writeArrayData(this.propertyToString(val, props), ' ');
                        this.xmlStreamWriter.writeEndElement();
                    } else {
                        this.xmlStreamWriter.writeStartElement("scalar");
                        if (!xsdtype.equals("string")) {
                            this.xmlStreamWriter.writeAttribute("dataType", "xsd:" + val.getPropXSDType());
                        }
                        this.writeData(this.propertyToString(val, props));
                        this.xmlStreamWriter.writeEndElement();
                    }
                    this.xmlStreamWriter.writeEndElement();
                }
                this.xmlStreamWriter.writeEndElement();
            }
            catch (XMLStreamException e) {
                throw new MolExportException(e);
            }
        }
    }

    protected void writeArrayData(String v, char delim) throws XMLStreamException {
        StringTokenizer st = new StringTokenizer(v, String.valueOf(delim));
        int i = 0;
        while (st.hasMoreTokens()) {
            if (i != 0) {
                this.xmlStreamWriter.writeCharacters(String.valueOf(delim));
            }
            this.writeData(st.nextToken());
            ++i;
        }
    }

    protected void writeData(String v) throws XMLStreamException {
        boolean needscdata = false;
        if ((v = EncodingUtil.escape(v, 0)).length() < 64) {
            for (int i = 0; i < v.length() && !needscdata; ++i) {
                char c = v.charAt(i);
                needscdata = c < '\u0000' || c >= NEEDS_CDATA.length || NEEDS_CDATA[c];
            }
        } else {
            needscdata = true;
        }
        if (needscdata) {
            this.xmlStreamWriter.writeCData(this.createCDataFromString(v));
        } else {
            this.xmlStreamWriter.writeCharacters(v);
        }
    }

    private String createCDataFromString(String originalString) {
        return originalString.replaceAll("]]>", "]]>]]&gt;<![CDATA[");
    }

    protected String propertyToString(MProp p, MPropertyContainer props) throws MolExportException, XMLStreamException {
        String xsdtype = p.getPropXSDType();
        String s = null;
        try {
            if (xsdtype.equals("ENTITY")) {
                String propertyString = p instanceof MMoleculeProp ? this.moleculePropertyToString((MMoleculeProp)p, props) : MPropHandler.convertToString(p, this.theFormat);
                return "MProp:" + p.getPropType() + ":" + propertyString;
            }
            s = MPropHandler.convertToString(p, this.theFormat);
        }
        catch (IllegalArgumentException e) {
            throw new MolExportException(e);
        }
        if (s != null) {
            return s;
        }
        throw new NullPointerException("" + p + " contains null");
    }

    private String moleculePropertyToString(MMoleculeProp p, MPropertyContainer props) throws MolExportException, XMLStreamException {
        CMLExport me = this.initExporterWithSameOptions();
        me.writeSelfRefProps = !props.isSelfReference(p);
        String toReturn = (String)me.open("");
        toReturn = toReturn + me.convert(p.getMolecule());
        toReturn = toReturn + me.close();
        int i = toReturn.indexOf("?>");
        return toReturn.substring(i + 2).trim();
    }

    protected CMLExport initExporterWithSameOptions() throws MolExportException {
        CMLExport toReturn = new CMLExport();
        toReturn.useAtomArray = this.useAtomArray;
        toReturn.prettyPrinting = this.prettyPrinting;
        toReturn.coordinateConversion = this.coordinateConversion;
        return toReturn;
    }

    protected String modifyPropertyKeyCallback(String key) {
        if (!key.startsWith("marvin:")) {
            return "marvin:" + key;
        }
        return key;
    }

    protected void appendArrow(RxnMolecule step) throws MolExportException, XMLStreamException {
        MPropertyContainer props;
        if (step.properties() != null && (props = step.properties()).get("marvin:arrowType") != null) {
            return;
        }
        MPropertyContainer tagProps = new MPropertyContainer();
        tagProps.set("dictRef", new MStringProp("marvin:arrow"));
        this.appendPropertyList(tagProps, step.getArrowAsProperty());
    }

    protected String getAtomIndexRefs(MolAtom a, MoleculeGraph mol, HashMap<MolAtom, String> atomHash) {
        StringBuilder sb = new StringBuilder();
        int nb = a.getBondCount();
        for (int i = 0; i < nb; ++i) {
            if (i != 0) {
                sb.append(' ');
            }
            sb.append(CMLExport.getAtomId(a.getLigand(i), atomHash));
        }
        return sb.toString();
    }

    protected String getAtomIndexRefs(MolAtom[] atoms, MoleculeGraph mol, HashMap<MolAtom, String> atomHash) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < atoms.length; ++i) {
            if (i != 0) {
                sb.append(' ');
            }
            sb.append(CMLExport.getAtomId(atoms[i], atomHash));
        }
        return sb.toString();
    }

    protected void extendReactionTag(RxnMolecule step) throws XMLStreamException {
    }

    protected void extendReactionSchemeTag(RxnMolecule rxn) throws XMLStreamException {
    }

    protected static String escapeString(String str) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            CMLExport.appendEscapedChar(sb, c);
        }
        return sb.toString();
    }

    private static void appendEscapedChar(StringBuilder sb, char c) {
        if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || "!@#$%()[]{}.,:/\\?|-+*^_~=;'<>\"&".indexOf(c) >= 0 || Character.isWhitespace(c)) {
            sb.append(c);
        } else {
            sb.append("&#");
            sb.append(Integer.toString(c));
            sb.append(';');
        }
    }

    static {
        REACTION_LIST_IDS = new int[]{0, 2, 1};
        NEEDS_CDATA = new boolean[256];
        for (int c = 0; c < 256; ++c) {
            if (c >= 97 && c <= 122 || c >= 65 && c <= 90 || c >= 48 && c <= 57 || "*\\/!?+-%$^=.,_#()[]{}:~|".indexOf(c) >= 0) continue;
            CMLExport.NEEDS_CDATA[c] = true;
        }
    }
}

