/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.cml;

import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolInputStream;
import chemaxon.marvin.io.MolImportModule;
import chemaxon.marvin.io.formats.cml.AtomReader;
import chemaxon.marvin.io.formats.cml.BicycloStereoIndexDescriptor;
import chemaxon.marvin.io.formats.cml.BondReader;
import chemaxon.marvin.io.formats.cml.CMLExport;
import chemaxon.marvin.io.formats.cml.MObjectReader;
import chemaxon.marvin.io.formats.cml.MoleculeReader;
import chemaxon.marvin.io.formats.cml.ParsedData;
import chemaxon.marvin.io.formats.cml.PropertyReader;
import chemaxon.marvin.io.formats.cml.ReaderUtil;
import chemaxon.marvin.io.formats.cml.SgroupReader;
import chemaxon.marvin.modelling.TextUtils;
import chemaxon.marvin.util.MolImportUtil;
import chemaxon.marvin.util.text.EncodingUtil;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MObject;
import chemaxon.struc.MPoint;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.RgMolecule;
import chemaxon.struc.RxnMolecule;
import chemaxon.struc.SelectionMolecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.StereoConstants;
import chemaxon.struc.graphics.MBracket;
import chemaxon.struc.graphics.MRArrow;
import chemaxon.struc.sgroup.DataSgroup;
import chemaxon.struc.sgroup.MultipleSgroup;
import chemaxon.struc.sgroup.RepeatingUnitSgroup;
import chemaxon.struc.sgroup.SgroupAtom;
import chemaxon.struc.sgroup.SuperatomSgroup;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CMLImport
extends MolImportModule
implements StereoConstants {
    protected String fileFormatVersion = null;
    protected String generationVersion = null;
    protected static final String[] REACTION_LIST_STRINGS = new String[]{"reactantList", "agentList", "productList"};
    protected static final int[] REACTION_LIST_IDS = new int[]{0, 2, 1};
    private DocumentBuilderFactory docBuilderFactory;
    private MolInputStream molInputStream;
    private int dimension = 2;
    protected Map<String, Molecule> molMap;
    private boolean useMolIDMap = false;
    protected boolean useSgroupAPO = false;
    private boolean linkNodeRefNeedsUpdating = false;
    protected List<Object> atomSetPointVector;
    protected List<Object> eflowBasePointVector;
    protected Map<String, String> attrHash = new HashMap<String, String>();

    public CMLImport() {
        this.docBuilderFactory = DocumentBuilderFactory.newInstance();
    }

    @Override
    public void initMolImport(MolInputStream is) throws MolFormatException, IOException {
        this.molInputStream = is;
    }

    public MolInputStream getMolInputStream() {
        return this.molInputStream;
    }

    @Override
    public Molecule createMol() {
        return new RgMolecule();
    }

    @Override
    public boolean readMol(Molecule mol) throws MolFormatException, IOException {
        boolean ret;
        Document xmldoc;
        this.useSgroupAPO = false;
        try {
            DocumentBuilder builder = this.docBuilderFactory.newDocumentBuilder();
            xmldoc = builder.parse(this.molInputStream);
        }
        catch (ParserConfigurationException ex) {
            throw new MolFormatException(ex);
        }
        catch (SAXException ex) {
            throw new MolFormatException(ex);
        }
        mol.clearForImport("cml");
        this.readCML(xmldoc.getDocumentElement(), mol);
        if (!this.useSgroupAPO) {
            MolImportUtil.convertRgroupAttachments(mol);
        }
        MolImportUtil.convertAttachments(mol.getGraphUnion());
        MolImportUtil.fixBeilsteinRDF(mol);
        boolean bl = ret = !mol.isEmpty();
        if (ret) {
            mol.setGUIContracted(false);
            mol.revalidateCoordDependentProps();
        }
        return ret;
    }

    private void readCML(Element e, Molecule mol) throws MolFormatException {
        if (!e.getTagName().equals("cml")) {
            throw new MolFormatException("CML root element is not <cml>");
        }
        this.readHeader(e);
        NodeList nodes = e.getChildNodes();
        if (nodes.getLength() != 0) {
            Node item;
            for (item = nodes.item(0); !(item == null || item.getNodeName().equals("MDocument") || item.getNodeName().equals("molecule") || item.getNodeName().startsWith("reaction")); item = item.getNextSibling()) {
            }
            if (item == null) {
                return;
            }
            if (item.getNodeName().equals("MDocument")) {
                throw new MolFormatException("CMLImport cannot parse MRV, use MrvImport");
            }
            if (item.getNodeName().equals("molecule")) {
                this.readMolecule(item, mol);
                return;
            }
            if (item.getNodeName().equals("reactionScheme")) {
                this.readReactionScheme(item, mol);
                return;
            }
            if (item.getNodeName().equals("reaction")) {
                this.readReaction(item, mol);
                return;
            }
        }
    }

    protected void readHeader(Element e) {
        String versionInfo = CMLImport.getTagProperty(e, "version");
        if (versionInfo != null) {
            this.fileFormatVersion = CMLExport.getFileFormatVersion(versionInfo);
            this.generationVersion = CMLExport.getGenerationVersion(versionInfo);
        }
    }

    protected void readReactionScheme(Node elem, Molecule mol) throws MolFormatException {
        RxnMolecule rxn = MoleculeReader.initRxnMolecule(mol);
        String name = CMLImport.getTagProperty(elem, "title");
        if (name != null) {
            rxn.setName(name);
        }
        NodeList nodes = elem.getChildNodes();
        ArrayList<RxnMolecule> rxns = new ArrayList<RxnMolecule>();
        this.setUseMolIDMap(true);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node item = nodes.item(i);
            String s = item.getNodeName();
            if (s.equals("reaction")) {
                RxnMolecule newRxn = new RxnMolecule();
                this.readReaction(item, newRxn);
                rxns.add(newRxn);
                continue;
            }
            if (!s.equals("reactionScheme")) continue;
            throw new MolFormatException("Reading nested reaction schemas is not supported yet.");
        }
        this.setUseMolIDMap(false);
        HashMap<MRArrow, RxnMolecule> rxnMap = new HashMap<MRArrow, RxnMolecule>();
        for (int i = 0; i < rxns.size(); ++i) {
            try {
                this.addToRxnScheme(rxn, rxns.iterator(), rxnMap);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new MolFormatException("Could not read reaction schema.");
            }
        }
        rxn.setMSLogic(rxnMap);
    }

    private void addToRxnScheme(RxnMolecule rxnMol, Iterator<RxnMolecule> it, Map<MRArrow, RxnMolecule> rxnMap) {
        while (it.hasNext()) {
            RxnMolecule r = it.next();
            MRArrow arrow = r.getItsArrow();
            rxnMap.put(arrow, r);
            for (int type = 0; type < 3; ++type) {
                for (int j = 0; j < r.getComponentCount(type); ++j) {
                    Molecule m = r.getComponent(type, j);
                    long cID = rxnMol.getComponentID(m);
                    if (cID < 0L) {
                        rxnMol.addComponent(m, type);
                        continue;
                    }
                    int oldType = rxnMol.getComponentType(cID);
                    if (oldType == type) continue;
                    int cIdx = rxnMol.getComponentIndex(cID);
                    rxnMol.removeComponent(oldType, cIdx);
                    rxnMol.addComponent(m, 2);
                }
            }
        }
    }

    protected void setUseMolIDMap(boolean flag) {
        this.useMolIDMap = flag;
        if (this.molMap != null) {
            this.molMap.clear();
        }
    }

    protected Molecule readMolecule(Node elem, Molecule mol) throws MolFormatException {
        if (this.useMolIDMap && this.molMap == null) {
            this.molMap = new HashMap<String, Molecule>();
        }
        this.linkNodeRefNeedsUpdating = false;
        NamedNodeMap attr = elem.getAttributes();
        if (attr != null) {
            Node molID;
            Node title = attr.getNamedItem("title");
            if (title != null) {
                mol.setName(title.getNodeValue());
            }
            if ((molID = attr.getNamedItem("molID")) != null) {
                String key = molID.getNodeValue();
                if (this.useMolIDMap) {
                    if (!this.molMap.containsKey(key)) {
                        this.molMap.put(key, mol);
                    } else {
                        return this.molMap.get(key);
                    }
                }
            }
            this.readAbsStereo(attr, mol);
        }
        this.dimension = 0;
        mol.setDim(0);
        NodeList nodes = elem.getChildNodes();
        this.readMol00(nodes, mol, null);
        if (mol.isEmpty()) {
            this.dimension = 2;
        }
        mol.setDim(this.dimension);
        MolImportUtil.reparentEmptySgroups(mol);
        MolImportUtil.generateBrackets(mol);
        return mol;
    }

    private void readMol00(NodeList nodes, Molecule mol, Sgroup psg) throws MolFormatException {
        this.readMol0(nodes, mol, psg, null, null);
    }

    private void readMol0(NodeList nodes, Molecule mol, Sgroup psg, Map<String, MolAtom> idAtomHash0, Map<String, Sgroup> atomSgroupRefHash0) throws MolFormatException {
        boolean bondsProcessed = false;
        ParsedData parsedData = new ParsedData();
        int na = 0;
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node item = nodes.item(i);
            if (item.getNodeType() != 1) continue;
            String name = item.getNodeName();
            if (name.equals("atomArray")) {
                na += this.readAtomArray(item, mol, psg, parsedData);
                continue;
            }
            if (name.equals("bondArray")) {
                if (bondsProcessed) {
                    throw new MolFormatException("bonds already specified");
                }
                this.readBondArray(item, parsedData);
                continue;
            }
            if (name.equals("molecule")) {
                bondsProcessed = BondReader.processBondArrays(mol, parsedData);
                this.readSubMolecule(item, name, mol, psg, parsedData, idAtomHash0, atomSgroupRefHash0);
                continue;
            }
            if (!name.equals("name")) continue;
            mol.setName(item.getTextContent());
        }
        BondReader.processBondArrays(mol, parsedData);
        BondReader.processBondCorrespondence(mol, parsedData);
        mol.endReuse(na);
        AtomReader.setAtomParities(mol, parsedData);
        MoleculeReader.setBicycloStereoDescriptors(mol, parsedData);
        AtomReader.setLinkNodeOuters(mol, parsedData, this.linkNodeRefNeedsUpdating);
        AtomReader.processLigandOrderHash(mol, parsedData);
        ReaderUtil.valenceCheck(mol, parsedData.atomsWithHcount);
    }

    protected void readReaction(Node elem, Molecule mol) throws MolFormatException {
        RxnMolecule rxn = MoleculeReader.initRxnMolecule(mol);
        String name = CMLImport.getTagProperty(elem, "title");
        if (name != null) {
            rxn.setName(name);
        }
        this.readAbsStereo(elem.getAttributes(), rxn);
        this.readArrowFromAttributes(elem, rxn);
        NodeList nodes = elem.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node item = nodes.item(i);
            String s = item.getNodeName();
            if (s.equals(this.modifyPropertyKeyCallback("arrow"))) {
                this.readReactionArrow(item, rxn);
            }
            for (int j = 0; j < REACTION_LIST_IDS.length; ++j) {
                String rxlstr = REACTION_LIST_STRINGS[j];
                if (!s.equals(rxlstr)) continue;
                int f = REACTION_LIST_IDS[j];
                NodeList subnodes = item.getChildNodes();
                for (int k = 0; k < subnodes.getLength(); ++k) {
                    Node subnode = subnodes.item(k);
                    s = subnode.getNodeName();
                    if (!s.equals("molecule")) continue;
                    Molecule m = new Molecule();
                    m.setInputFormat("cml");
                    m = this.readMolecule(subnode, m);
                    rxn.addComponent(m, f);
                }
            }
        }
        MoleculeReader.setRxnAttributes(rxn, this.dimension);
    }

    private void readArrowFromAttributes(Node reactionTag, RxnMolecule rxn) {
        Node arrowdata;
        if (reactionTag != null && reactionTag.getAttributes() != null && (arrowdata = reactionTag.getAttributes().getNamedItem(this.modifyPropertyKeyCallback("arrowType"))) != null) {
            this.readReactionArrow(reactionTag, rxn);
        }
    }

    private void readReactionArrow(Node elem, RxnMolecule rxn) {
        Double coord;
        boolean hasAllCoords;
        DPoint3[] aPoints = new DPoint3[]{new DPoint3(), new DPoint3()};
        String tagAttr = CMLImport.getTagProperty(elem, this.modifyPropertyKeyCallback("x1"));
        boolean bl = hasAllCoords = tagAttr != null;
        if (hasAllCoords) {
            coord = new Double(tagAttr);
            aPoints[0].x = coord;
        }
        if ((tagAttr = CMLImport.getTagProperty(elem, this.modifyPropertyKeyCallback("y1"))) != null && hasAllCoords) {
            coord = new Double(tagAttr);
            aPoints[0].y = coord;
        } else {
            hasAllCoords = false;
        }
        tagAttr = CMLImport.getTagProperty(elem, this.modifyPropertyKeyCallback("z1"));
        if (tagAttr != null && hasAllCoords) {
            coord = new Double(tagAttr);
            aPoints[0].z = coord;
        }
        if ((tagAttr = CMLImport.getTagProperty(elem, this.modifyPropertyKeyCallback("x2"))) != null && hasAllCoords) {
            coord = new Double(tagAttr);
            aPoints[1].x = coord;
        } else {
            hasAllCoords = false;
        }
        tagAttr = CMLImport.getTagProperty(elem, this.modifyPropertyKeyCallback("y2"));
        if (tagAttr != null && hasAllCoords) {
            coord = new Double(tagAttr);
            aPoints[1].y = coord;
        } else {
            hasAllCoords = false;
        }
        tagAttr = CMLImport.getTagProperty(elem, this.modifyPropertyKeyCallback("z2"));
        if (tagAttr != null && hasAllCoords) {
            coord = new Double(tagAttr);
            aPoints[1].z = coord;
        }
        if (hasAllCoords) {
            rxn.setReactionArrow(aPoints);
        }
        if ((tagAttr = CMLImport.getTagProperty(elem, this.modifyPropertyKeyCallback("type"))) != null) {
            rxn.setReactionArrowType(tagAttr);
        } else {
            tagAttr = CMLImport.getTagProperty(elem, this.modifyPropertyKeyCallback("arrowType"));
            if (tagAttr != null) {
                rxn.setReactionArrowType(tagAttr);
            }
        }
    }

    private int readAtomArray(Node elem, Molecule mol, Sgroup psg, ParsedData parsedData) throws MolFormatException {
        NamedNodeMap attr = elem.getAttributes();
        HashMap<String, Integer> atomResidueIdHash = new HashMap<String, Integer>();
        int na = this.initUsingAtomArrayAttributes(attr, mol, psg, parsedData, atomResidueIdHash);
        NodeList nodes = elem.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node item = nodes.item(i);
            String name = item.getNodeName();
            if (!name.equals("atom")) continue;
            this.readAtom(item, mol, psg, parsedData, atomResidueIdHash);
            ++na;
        }
        return na;
    }

    private void readAtom(Node elem, Molecule mol, Sgroup psg, ParsedData parsedData, Map<String, Integer> atomResidueIdHash) throws MolFormatException {
        int k;
        MolAtom a = AtomReader.createAtom(mol, parsedData, CMLImport.getTagProperty(elem, "id"));
        String elementType = CMLImport.getTagProperty(elem, "elementType");
        Integer formalCharge = ReaderUtil.getTagPropertyAsInteger(CMLImport.getTagProperty(elem, "formalCharge"));
        Integer hydrogenCount = ReaderUtil.getTagPropertyAsInteger(CMLImport.getTagProperty(elem, "hydrogenCount"));
        Integer valenceProp = ReaderUtil.getTagPropertyAsInteger(CMLImport.getTagProperty(elem, "mrvValence"));
        Integer isotope = ReaderUtil.getTagPropertyAsInteger(CMLImport.getTagProperty(elem, "isotope"));
        String residueType = CMLImport.getTagProperty(elem, "residueType");
        String residueId = CMLImport.getTagProperty(elem, "residueId");
        String residueAtomName = CMLImport.getTagProperty(elem, "residueAtomName");
        String sX2 = CMLImport.getTagProperty(elem, "x2");
        String sY2 = CMLImport.getTagProperty(elem, "y2");
        String sX3 = CMLImport.getTagProperty(elem, "x3");
        String sY3 = CMLImport.getTagProperty(elem, "y3");
        String sZ3 = CMLImport.getTagProperty(elem, "z3");
        double x = a.getX();
        double y = a.getY();
        double z = a.getZ();
        Integer mrvAtomMap = ReaderUtil.getTagPropertyAsInteger(CMLImport.getTagProperty(elem, "mrvMap"));
        String reactionStereo = CMLImport.getTagProperty(elem, "reactionStereo");
        String mrvStereoGroup = CMLImport.getTagProperty(elem, "mrvStereoGroup");
        String mrvSpecIsoSym = CMLImport.getTagProperty(elem, "mrvSpecIsotopeSymbolPreferred");
        String radical = CMLImport.getTagProperty(elem, "radical");
        String lonePair = CMLImport.getTagProperty(elem, "lonePair");
        String rgroupRef = CMLImport.getTagProperty(elem, "rgroupRef");
        String sgroupRef = CMLImport.getTagProperty(elem, "sgroupRef");
        String attachmentPoint = CMLImport.getTagProperty(elem, "attachmentPoint");
        String sgroupAttachmentPoint = CMLImport.getTagProperty(elem, "sgroupAttachmentPoint");
        String mrvQueryProps = CMLImport.getTagProperty(elem, "mrvQueryProps");
        String mrvAlias = CMLImport.getTagProperty(elem, "mrvAlias");
        String mrvExtraLabel = CMLImport.getTagProperty(elem, "mrvExtraLabel");
        String mrvPseudo = CMLImport.getTagProperty(elem, "mrvPseudo");
        String mrvSetSeq = CMLImport.getTagProperty(elem, "mrvSetSeq");
        String mrvExtraLabelSeq = CMLImport.getTagProperty(elem, "mrvSetExtraLabelSeq");
        String mrvLinkNodeRep = CMLImport.getTagProperty(elem, "mrvLinkNodeRep");
        String mrvLinkNodeOut = CMLImport.getTagProperty(elem, "mrvLinkNodeOut");
        String ligandOrder = CMLImport.getTagProperty(elem, "ligandOrder");
        String attachmentOrder = CMLImport.getTagProperty(elem, "attachmentOrder");
        String isSelected = CMLImport.getTagProperty(elem, "isSelected");
        try {
            if (sX2 != null) {
                x = Double.valueOf(sX2);
            }
            if (sY2 != null) {
                y = Double.valueOf(sY2);
            }
            if (sX3 != null) {
                x = Double.valueOf(sX3);
            }
            if (sY3 != null) {
                y = Double.valueOf(sY3);
            }
            if (sZ3 != null) {
                z = Double.valueOf(sZ3);
            }
        }
        catch (NumberFormatException ex) {
            throw new MolFormatException("invalid property value");
        }
        if (elem.hasChildNodes()) {
            this.readAtomInternalTags(elem, a, parsedData);
        }
        if (elementType != null) {
            AtomReader.setElementType(a, elementType);
        }
        boolean isRgroup = false;
        if (rgroupRef != null) {
            isRgroup = AtomReader.setAtomRgroupRef(a, rgroupRef);
        }
        if (sgroupRef != null) {
            int i = mol.indexOf(a);
            a = AtomReader.setAtomSgroupRef(mol, i, sgroupRef, psg, isRgroup, parsedData);
        }
        if (attachmentPoint != null) {
            AtomReader.setAtomAttach(a, attachmentPoint, mol);
        }
        if (sgroupAttachmentPoint != null) {
            AtomReader.setAtomAttach(a, sgroupAttachmentPoint, mol);
            this.useSgroupAPO = true;
        }
        if (formalCharge != null) {
            a.setCharge(formalCharge);
        } else {
            a.setFlags(65536, 65536);
        }
        if (hydrogenCount != null) {
            int hx = a.getExplicitHcount();
            a.setImplicitHcount(hydrogenCount - hx);
            parsedData.atomsWithHcount.add(a);
        }
        if (valenceProp != null) {
            a.setValenceProp(valenceProp);
        }
        if (isotope != null) {
            a.setMassno(isotope);
        }
        if (residueType != null) {
            AtomReader.setResidueType(a, residueType);
        }
        if (residueId != null) {
            AtomReader.setResidueSeq(a, residueId, atomResidueIdHash);
        }
        if (residueAtomName != null) {
            AtomReader.setResidueAtomId(a, residueAtomName);
        }
        if (mrvAtomMap != null) {
            a.setAtomMap(mrvAtomMap);
        }
        if (reactionStereo != null) {
            AtomReader.setAtomRxnStereo(a, reactionStereo);
        }
        if (mrvStereoGroup != null) {
            AtomReader.setAtomStereoGroup(a, mrvStereoGroup);
        }
        if (mrvSpecIsoSym != null) {
            AtomReader.setSpecIsotopeSymbolPreferred(a, mrvSpecIsoSym);
        }
        if (radical != null) {
            AtomReader.setAtomRadical(a, radical);
        }
        if (lonePair != null) {
            a.setElectronProp(Integer.valueOf(lonePair));
        }
        if (mrvQueryProps != null) {
            AtomReader.setAtomQueryProps(a, mrvQueryProps);
        }
        if (mrvAlias != null) {
            AtomReader.setAtomAlias(a, mrvAlias);
        }
        if (mrvExtraLabel != null) {
            AtomReader.setAtomExtraLabel(a, mrvExtraLabel);
        }
        if (mrvPseudo != null) {
            AtomReader.setPseudoAtomName(a, mrvPseudo);
        }
        if (mrvSetSeq != null) {
            k = Integer.parseInt(mrvSetSeq);
            a.setSetSeq(k);
        }
        if (mrvExtraLabelSeq != null) {
            k = Integer.parseInt(mrvExtraLabelSeq);
            a.setExtraLabelSetSeq(k);
        }
        if (mrvLinkNodeRep != null) {
            AtomReader.setLinkNodeRep(a, mrvLinkNodeRep);
        }
        if (mrvLinkNodeOut != null) {
            this.linkNodeRefNeedsUpdating = AtomReader.storeLinkNodeOuters(a, mrvLinkNodeOut, this.linkNodeRefNeedsUpdating);
        }
        if (ligandOrder != null) {
            parsedData.ligandOrderHash.put(a, ligandOrder);
        }
        if (attachmentOrder != null) {
            int order = Integer.parseInt(attachmentOrder);
            a.setRgroupAttachmentPointOrder(order);
        }
        if ((x != 0.0 || y != 0.0) && this.dimension < 2) {
            this.dimension = 2;
        }
        if (z != 0.0) {
            this.dimension = 3;
        }
        AtomReader.setSelection(a, isSelected);
        mol.setDim(this.dimension);
        a.setXYZ(x, y, z);
    }

    private void readBondArray(Node node, ParsedData parsedData) throws MolFormatException {
        boolean containsAtomRefs1 = BondReader.readAtomRefs1(CMLImport.getTagProperty(node, "atomRefs1"), parsedData.bondAtomRefs1Array);
        boolean containsAtomRefs2 = AtomReader.readAtomRefs2(CMLImport.getTagProperty(node, "atomRefs2"), parsedData.bondAtomRefs2Array);
        boolean containsOrder = BondReader.readOrder(CMLImport.getTagProperty(node, "order"), parsedData);
        if (!(!containsAtomRefs1 && !containsAtomRefs2 && !containsOrder || containsAtomRefs1 && containsAtomRefs2 && containsOrder)) {
            throw new MolFormatException("<bondArray> with incomplete atomRef*/order specification");
        }
        NodeList nodes = node.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node item = nodes.item(i);
            String name = item.getNodeName();
            if (!name.equals("bond")) continue;
            this.readBond(item, parsedData);
        }
    }

    private void readBond(Node elem, ParsedData parsedData) throws MolFormatException {
        boolean bold;
        String atomRef1 = null;
        String atomRef2 = null;
        String sOrder = CMLImport.getTagProperty(elem, "order");
        String sConvention = CMLImport.getTagProperty(elem, "convention");
        String sQueryType = CMLImport.getTagProperty(elem, "queryType");
        String mrvQueryProps = CMLImport.getTagProperty(elem, "mrvQueryProps");
        String[] dbBondStereoProps = null;
        int flags = 0;
        String atomRefs2 = CMLImport.getTagProperty(elem, "atomRefs2");
        String sTopology = CMLImport.getTagProperty(elem, "topology");
        String mrvSetSeq = CMLImport.getTagProperty(elem, "mrvSetSeq");
        String mrvReactingCenter = CMLImport.getTagProperty(elem, "mrvReactingCenter");
        String mrvBold = CMLImport.getTagProperty(elem, "mrvBold");
        String mrvHashed = CMLImport.getTagProperty(elem, "mrvHashed");
        if (atomRefs2 != null) {
            StringTokenizer st = new StringTokenizer(atomRefs2);
            atomRef1 = st.nextToken();
            atomRef2 = st.nextToken();
        }
        if (sOrder != null) {
            flags = BondReader.readBondOrder(sOrder, flags);
        }
        if (sConvention != null) {
            flags = BondReader.readBondConvention(sConvention, flags);
        }
        if (sTopology != null) {
            flags = BondReader.readBondTopology(sTopology, flags);
        }
        if (sQueryType != null) {
            flags = BondReader.readBondQueryType(sQueryType, flags);
        }
        if (mrvSetSeq != null) {
            int k = Integer.parseInt(mrvSetSeq);
            flags = flags & 0xC0FFFFFF | k << 24;
        }
        if (mrvReactingCenter != null) {
            flags = BondReader.readReactingCenterProperty(mrvReactingCenter, flags);
        }
        if (mrvBold != null && (bold = Boolean.parseBoolean(mrvBold))) {
            flags = flags & 0xBFFFFFFF | 0x40000000;
        }
        if (mrvHashed != null && Boolean.parseBoolean(mrvHashed)) {
            flags = flags & Integer.MAX_VALUE | Integer.MIN_VALUE;
        }
        if (elem.hasChildNodes()) {
            NodeList nodes = elem.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node item = nodes.item(i);
                String s = item.getNodeName();
                if (!s.equals("bondStereo")) continue;
                String conv = CMLImport.getTagProperty(item, "convention");
                String val = CMLImport.getTagProperty(item, "conventionValue");
                if (conv != null && val != null) {
                    flags = BondReader.readStereoValue(flags, conv, val);
                    continue;
                }
                if (item.hasChildNodes()) {
                    String atomRefs4;
                    NodeList subnodes = item.getChildNodes();
                    for (int j = 0; j < subnodes.getLength(); ++j) {
                        Node subitem = subnodes.item(j);
                        if (subitem.getNodeType() != 3) continue;
                        s = subitem.getNodeValue().trim();
                        break;
                    }
                    if ((atomRefs4 = CMLImport.getTagProperty(item, "atomRefs4")) != null) {
                        String[] refs = AtomReader.getRefsArray(atomRefs4);
                        dbBondStereoProps = BondReader.readDbBondStereo(refs, s);
                        continue;
                    }
                    flags = BondReader.setStereoValue(flags, s);
                    continue;
                }
                throw new MolFormatException("empty <bondStereo> element");
            }
        }
        if (atomRef1 == null || atomRef2 == null) {
            throw new MolFormatException("Less than two atomRefs defined");
        }
        parsedData.bondAtomRefs1Array.add(atomRef1);
        parsedData.bondAtomRefs2Array.add(atomRef2);
        parsedData.bondFlagsArray.add(flags);
        Object[] xprops = new Object[dbBondStereoProps == null ? 1 : 2];
        xprops[0] = mrvQueryProps;
        if (xprops.length > 1) {
            xprops[1] = dbBondStereoProps;
        }
        parsedData.bondXPropsArray.add(xprops);
    }

    private void readSubMolecule(Node elem, String s, Molecule mol, Sgroup psg, ParsedData parsedData, Map<String, MolAtom> idAtomHash0, Map<String, Sgroup> atomSgroupRefHash0) throws MolFormatException {
        boolean isParentSgroup = !s.equals("molecule") || elem.hasChildNodes();
        Map<String, Sgroup> sghash = parsedData.atomSgroupRefHash.isEmpty() && atomSgroupRefHash0 != null ? atomSgroupRefHash0 : parsedData.atomSgroupRefHash;
        String role = CMLImport.getTagProperty(elem, "role");
        String id = MoleculeReader.getMolID(CMLImport.getTagProperty(elem, "id"), CMLImport.getTagProperty(elem, "molID"));
        Molecule parentMol = mol;
        if (mol instanceof RgMolecule) {
            parentMol = ((RgMolecule)mol).getRoot();
        }
        if (SgroupReader.isAcceptableRole(id, role)) {
            Sgroup sg = SgroupReader.createSgroup(psg, sghash, role, id, parentMol);
            String title = SgroupReader.readGeneralSgroupAttributes(CMLImport.getTagProperty(elem, "title"), CMLImport.getTagProperty(elem, "charge"), sg);
            if (sg instanceof SuperatomSgroup) {
                this.readSuperatomSgroup(sg, elem);
            }
            if (role.equals("MultipleSgroup")) {
                this.readMultipleSgroup(elem, parsedData, idAtomHash0, sghash, sg, title, parentMol, id, psg);
            } else if (role.equals("SuperatomSgroup")) {
                this.readSuperatomSgroup(psg, sg, elem, sghash, parsedData.idAtomHash, parentMol);
            } else if (role.equals("DataSgroup")) {
                this.readDataSgroup(parentMol, elem, idAtomHash0, parsedData, sg, sghash, id, psg);
            } else if (role.equals("ComponentSgroup") || role.equals("MixtureSgroup") || role.equals("FormulationSgroup") || role.equals("GenericSgroup") || role.equals("MerSgroup") || role.equals("MonomerSgroup")) {
                this.readSimpleSgroups(idAtomHash0, parsedData, elem, role, sg, parentMol, id, psg, sghash);
            } else if (SgroupReader.getPolymerFromName(role) > -1) {
                this.readPolymerSgroup(idAtomHash0, parsedData, elem, parentMol, role, sg, id, sghash, psg);
            } else if (role.equals("MulticenterSgroup")) {
                SgroupReader.readMulticenterSgroup(CMLImport.getTagProperty(elem, "atomRefs"), CMLImport.getTagProperty(elem, "center"), sg, id, psg, sghash, parsedData, idAtomHash0, parentMol);
            }
        }
        if (role.equals("SuperatomSgroup")) {
            return;
        }
        if (!isParentSgroup) {
            return;
        }
        NodeList nodes = elem.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 || !(s = node.getNodeName()).equals("molecule")) continue;
            this.readSubMolecule(node, s, parentMol, sghash.get(id), parsedData, idAtomHash0, atomSgroupRefHash0);
        }
    }

    private void readPolymerSgroup(Map<String, MolAtom> idAtomHash0, ParsedData parsedData, Node elem, Molecule parentMol, String role, Sgroup sg, String id, Map<String, Sgroup> sghash, Sgroup psg) throws MolFormatException {
        SelectionMolecule smol = new SelectionMolecule();
        SgroupReader.readSelectionMol(CMLImport.getTagProperty(elem, "atomRefs"), smol, parsedData, idAtomHash0);
        RepeatingUnitSgroup csg = SgroupReader.createRUSgroup(parentMol, role, sg, smol);
        parsedData.correspondenceIdHash.put(id, BondReader.readBondList(CMLImport.getTagProperty(elem, "correspondence")));
        parsedData.bondListIdHash.put(id, BondReader.readBondList(CMLImport.getTagProperty(elem, "bondList")));
        SgroupReader.readConnectivity(CMLImport.getTagProperty(elem, "connect"), csg);
        this.readBracketInfo(elem, csg);
        sghash.put(id, csg);
        if (psg != null) {
            psg.addChildSgroup(csg);
        }
    }

    private void readSimpleSgroups(Map<String, MolAtom> idAtomHash0, ParsedData parsedData, Node elem, String role, Sgroup sg, Molecule parentMol, String id, Sgroup psg, Map<String, Sgroup> sghash) throws MolFormatException {
        Sgroup csg = SgroupReader.createSimpleSgroup(idAtomHash0, parsedData, CMLImport.getTagProperty(elem, "atomRefs"), role, sg, parentMol, id, psg, sghash);
        this.readBracketInfo(elem, csg);
    }

    private void readDataSgroup(Molecule parentMolecule, Node elem, Map<String, MolAtom> idAtomHash0, ParsedData parsedData, Sgroup sg, Map<String, Sgroup> sghash, String id, Sgroup psg) throws MolFormatException {
        String context;
        Integer pos;
        String tag;
        Integer dispLines;
        DataSgroup dsg = SgroupReader.createDataSgroup(parentMolecule, CMLImport.getTagProperty(elem, "atomRefs"), idAtomHash0, parsedData, sg);
        dsg.setFieldName(CMLImport.getTagProperty(elem, "fieldName"));
        dsg.setFieldType(CMLImport.getTagProperty(elem, "fieldType"));
        dsg.setUnits(CMLImport.getTagProperty(elem, "units"));
        dsg.setX(Double.parseDouble(CMLImport.getTagProperty(elem, "x")));
        dsg.setY(Double.parseDouble(CMLImport.getTagProperty(elem, "y")));
        dsg.setDataDetached(!"false".equals(CMLImport.getTagProperty(elem, "dataDetached")));
        dsg.setAbsolutePlacement(!"Relative".equals(CMLImport.getTagProperty(elem, "placement")));
        dsg.setUnitDisplayed("Unit displayed".equals(CMLImport.getTagProperty(elem, "unitsDisplayed")));
        Integer dispChars = ReaderUtil.getTagPropertyAsInteger(CMLImport.getTagProperty(elem, "displayedChars"));
        if (dispChars != null) {
            dsg.setDisplayedChars(dispChars);
        }
        if ((dispLines = ReaderUtil.getTagPropertyAsInteger(CMLImport.getTagProperty(elem, "displayedLines"))) != null) {
            dsg.setDisplayedLines(dispLines);
        }
        if ((tag = CMLImport.getTagProperty(elem, "tag")) != null) {
            dsg.setTag(tag.charAt(0));
        }
        if ((pos = ReaderUtil.getTagPropertyAsInteger(CMLImport.getTagProperty(elem, "pos"))) != null) {
            dsg.setPos(pos);
        }
        if ((context = CMLImport.getTagProperty(elem, "context")) != null) {
            dsg.setContext(context);
        }
        dsg.setQueryCode(CMLImport.getTagProperty(elem, "queryType"));
        dsg.setQueryOp(CMLImport.getTagProperty(elem, "queryOp"));
        dsg.setChargeLocation(sg.getChargeLocation());
        int lineNo = 0;
        String lNoS = lineNo == 0 ? "" : Integer.toString(lineNo);
        String nextLine = CMLImport.getTagProperty(elem, "fieldData" + lNoS);
        while (nextLine != null) {
            dsg.addDataLine(nextLine);
            lNoS = ++lineNo == 0 ? "" : Integer.toString(lineNo);
            nextLine = CMLImport.getTagProperty(elem, "fieldData" + lNoS);
        }
        if (CMLImport.getTagProperty(elem, "fieldType") == null && TextUtils.isURL(dsg.getData())) {
            dsg.setFieldType(4);
        }
        sghash.put(id, dsg);
        if (psg != null) {
            psg.addChildSgroup(dsg);
        }
    }

    private void readMultipleSgroup(Node elem, ParsedData parsedData, Map<String, MolAtom> idAtomHash0, Map<String, Sgroup> sghash, Sgroup sg, String title, Molecule parentMol, String id, Sgroup psg) throws MolFormatException {
        SelectionMolecule smol = new SelectionMolecule();
        SgroupReader.readSelectionMol(CMLImport.getTagProperty(elem, "atomRefs"), smol, parsedData, idAtomHash0);
        MultipleSgroup mulsg = SgroupReader.readMultipleSgroup(sghash, sg, title, parentMol, id, psg, smol);
        this.readBracketInfo(elem, mulsg);
    }

    private void readSuperatomSgroup(Sgroup sg, Node elem) {
        SgroupAtom supat = ((SuperatomSgroup)sg).getSuperAtom();
        supat.setLeftName(CMLImport.getTagProperty(elem, "leftName"));
        supat.setRightName(CMLImport.getTagProperty(elem, "rightName"));
        String center = CMLImport.getTagProperty(elem, "labelCenter");
        if (center != null) {
            if (center.equals("AUTO")) {
                supat.setLabelCenter(-1);
            } else {
                int k = Integer.parseInt(center);
                supat.setLabelCenter(k);
            }
        }
    }

    private void readSuperatomSgroup(Sgroup psg, Sgroup sg, Node elem, Map<String, Sgroup> atomSgroupRefHash, Map<String, MolAtom> idAtomHash, Molecule parentMol) throws MolFormatException {
        if (psg != null) {
            psg.addChildSgroup(sg);
        }
        if (elem.hasChildNodes()) {
            Molecule smol0 = new Molecule();
            this.readMol0(elem.getChildNodes(), smol0, sg, idAtomHash, atomSgroupRefHash);
            SgroupReader.readSuperatomSgroup(sg, parentMol, smol0);
        }
    }

    private void readBracketInfo(Node elem, Sgroup csg) throws MolFormatException {
        NodeList nodes = elem.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node child = nodes.item(i);
            if (child.getNodeType() != 1) continue;
            this.readDisplayInfo(child, csg);
        }
    }

    private void readAbsStereo(NamedNodeMap attr, Molecule mol) {
        Node absc;
        if (attr != null && (absc = attr.getNamedItem("absStereo")) != null) {
            mol.setAbsStereo(absc.getNodeValue().equals("true"));
        }
    }

    private int initUsingAtomArrayAttributes(NamedNodeMap attr, Molecule mol, Sgroup psg, ParsedData parsedData, Map<String, Integer> atomResidueIdHash) throws MolFormatException {
        int na = 0;
        Node item = attr.getNamedItem("atomID");
        if (item == null) {
            return 0;
        }
        na = AtomReader.readAtomIdentifiers(mol, parsedData, item.getNodeValue());
        item = attr.getNamedItem("elementType");
        if (item != null) {
            AtomReader.readElementTypes(mol, item.getNodeValue());
        }
        boolean[] isRgroup = null;
        item = attr.getNamedItem("rgroupRef");
        if (item != null) {
            isRgroup = AtomReader.readRgroupReferences(mol, item.getNodeValue());
        }
        if ((item = attr.getNamedItem("sgroupRef")) != null) {
            SgroupReader.readSgroupReferences(mol, psg, parsedData, isRgroup, item.getNodeValue());
        }
        if ((item = attr.getNamedItem("attachmentPoint")) != null) {
            AtomReader.readAttachmentPoints(mol, item.getNodeValue());
        }
        if ((item = attr.getNamedItem("sgroupAttachmentPoint")) != null) {
            this.useSgroupAPO = true;
            AtomReader.readAttachmentPoints(mol, item.getNodeValue());
        }
        if ((item = attr.getNamedItem("attachmentOrder")) != null) {
            AtomReader.readAttachmentOrders(mol, item.getNodeValue());
        }
        if ((item = attr.getNamedItem("isotope")) != null) {
            AtomReader.readIsotopes(mol, item.getNodeValue());
        }
        if ((item = attr.getNamedItem("formalCharge")) != null) {
            AtomReader.readFormalCharges(mol, item.getNodeValue());
        } else {
            AtomReader.initCharges(mol);
        }
        item = attr.getNamedItem("hydrogenCount");
        if (item != null) {
            AtomReader.readHydrogenCounts(mol, parsedData.atomsWithHcount, item.getNodeValue());
        }
        if ((item = attr.getNamedItem("mrvValence")) != null) {
            AtomReader.readMrvValences(mol, item.getNodeValue());
        }
        if ((item = attr.getNamedItem("residueType")) != null) {
            AtomReader.readResidueTypes(mol, item.getNodeValue());
        }
        if ((item = attr.getNamedItem("residueId")) != null) {
            AtomReader.readResidueIdentifiers(mol, atomResidueIdHash, item.getNodeValue());
        }
        if ((item = attr.getNamedItem("residueAtomName")) != null) {
            AtomReader.readResidueAtomNames(mol, item.getNodeValue());
        }
        if ((item = attr.getNamedItem("mrvMap")) != null) {
            AtomReader.readMrvMappings(mol, item.getNodeValue());
        }
        if ((item = attr.getNamedItem("reactionStereo")) != null) {
            AtomReader.readReactionStereos(mol, item.getNodeValue());
        }
        if ((item = attr.getNamedItem("mrvStereoGroup")) != null) {
            AtomReader.readMrvStereoGroups(mol, item.getNodeValue());
        }
        if ((item = attr.getNamedItem("mrvSpecIsotopeSymbolPreferred")) != null) {
            AtomReader.readMrvSpecIsotopes(mol, item.getNodeValue());
        }
        if ((item = attr.getNamedItem("radical")) != null) {
            AtomReader.readRadicals(mol, item.getNodeValue());
        }
        if ((item = attr.getNamedItem("lonePair")) != null) {
            AtomReader.readLonePairs(mol, item.getNodeValue());
        }
        if ((item = attr.getNamedItem("mrvQueryProps")) != null) {
            AtomReader.readMrvQueryProps(mol, item.getNodeValue());
        }
        if ((item = attr.getNamedItem("mrvAlias")) != null) {
            AtomReader.readMrvAliasValues(mol, item.getNodeValue());
        }
        if ((item = attr.getNamedItem("mrvExtraLabel")) != null) {
            AtomReader.readMrvExtraLabels(mol, item.getNodeValue());
        }
        if ((item = attr.getNamedItem("mrvPseudo")) != null) {
            AtomReader.readMrvPseudos(mol, item.getNodeValue());
        }
        if ((item = attr.getNamedItem("mrvSetSeq")) != null) {
            AtomReader.readMrvSetSeq(mol, item.getNodeValue());
        }
        if ((item = attr.getNamedItem("mrvSetExtraLabelSeq")) != null) {
            AtomReader.readMrvSetExtraLabelSeq(mol, item.getNodeValue());
        }
        if ((item = attr.getNamedItem("mrvLinkNodeRep")) != null) {
            AtomReader.readMrvLinkNodeRepetitions(mol, item.getNodeValue());
        }
        if ((item = attr.getNamedItem("mrvLinkNodeOut")) != null) {
            this.linkNodeRefNeedsUpdating = AtomReader.readMrvLinkNodeOutValues(mol, item.getNodeValue(), this.linkNodeRefNeedsUpdating);
        }
        if ((item = attr.getNamedItem("isSelected")) != null) {
            AtomReader.readIsSelected(mol, item.getNodeValue());
        }
        this.readCoordinates(attr, mol);
        return na;
    }

    private void readCoordinates(NamedNodeMap attr, Molecule mol) throws MolFormatException {
        for (int i = 2; i <= 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                char c = (char)(120 + j);
                Node item = attr.getNamedItem(String.valueOf(c) + i);
                if (item == null) continue;
                String array = item.getNodeValue();
                this.dimension = AtomReader.readCoordinates(mol, this.dimension, i, j, array);
            }
        }
    }

    private void readAtomInternalTags(Node elem, MolAtom a, ParsedData parsedData) throws MolFormatException {
        NodeList nodes = elem.getChildNodes();
        ArrayList<BicycloStereoIndexDescriptor> list = new ArrayList<BicycloStereoIndexDescriptor>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node item = nodes.item(i);
            String s = item.getNodeName();
            if (s.equals("atomParity")) {
                String parityValue = this.getParityValue(this.readNodeValue(item));
                AtomReader.readAtomParity(AtomReader.getRefsArray(CMLImport.getTagProperty(item, "atomRefs4")), parityValue, a, parsedData.atomParityHash);
            }
            if (s.equals("scalar")) {
                PropertyReader.readAtomProperties(CMLImport.getTagProperty(item, "title"), CMLImport.getTagProperty(item, "value"), CMLImport.getTagProperty(item, "dataType"), a);
            }
            if (!s.equals("atomBicycloStereo")) continue;
            list.add(MoleculeReader.readAtomBicycloStereo(CMLImport.getTagProperty(item, "connectionAtom"), AtomReader.getRefsArray(CMLImport.getTagProperty(item, "lowBridge")), AtomReader.getRefsArray(CMLImport.getTagProperty(item, "highBridge")), this.readNodeValue(item)));
        }
        parsedData.bicycloStereoHash.put(a, list.size() > 0 ? list : null);
    }

    protected String getParityValue(String readParityValue) {
        return readParityValue;
    }

    private String readNodeValue(Node elem) {
        String s = null;
        if (elem.hasChildNodes()) {
            NodeList nodes = elem.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node item = nodes.item(i);
                if (item.getNodeType() != 3) continue;
                s = item.getNodeValue().trim();
                break;
            }
        }
        return s;
    }

    private void readDisplayInfo(Node elem, Sgroup csg) throws MolFormatException {
        String coordinates = CMLImport.getTagProperty(elem, "coordinates");
        if (coordinates != null) {
            StringTokenizer st = new StringTokenizer(coordinates);
            DPoint3 p1 = new DPoint3();
            p1.x = Double.parseDouble(st.nextToken());
            p1.y = Double.parseDouble(st.nextToken());
            p1.z = Double.parseDouble(st.nextToken());
            DPoint3 p2 = new DPoint3();
            p2.x = Double.parseDouble(st.nextToken());
            p2.y = Double.parseDouble(st.nextToken());
            p2.z = Double.parseDouble(st.nextToken());
        } else if (elem.getNodeName().equals("MBracket") && elem.getNodeName().equals("MBracket")) {
            MBracket mo = new MBracket();
            this.initGraphicsObject(elem, mo, null);
            csg.addBracket(mo);
        }
    }

    protected void initGraphicsObject(Node elem, MObject o, Map<String, MObject> objHash) throws MolFormatException {
        this.attrHash.clear();
        MPoint[] points = this.readGraphicsObject(elem, true);
        this.addTagProperties(elem, this.attrHash);
        MObjectReader.initGraphicsObject(this.attrHash, o, objHash, points);
    }

    private MPoint[] readGraphicsObject(Node elem, boolean add) throws MolFormatException {
        ArrayList<MPoint> points = new ArrayList<MPoint>();
        NodeList nodes = elem.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String s = node.getNodeName();
            if (s.equals("MAtomSetPoint")) {
                this.atomSetPointVector = MObjectReader.readMAtomSetPoint(this.atomSetPointVector, add, points, CMLImport.getTagProperty(node, "atomRefs"), PropertyReader.getTagPropertyAsDoubleArray(CMLImport.getTagProperty(node, "weights")));
                continue;
            }
            if (s.equals("MEFlowBasePoint")) {
                this.eflowBasePointVector = MObjectReader.readMEFlowBasePoint(this.eflowBasePointVector, add, points, CMLImport.getTagProperty(node, "atomRef"));
                continue;
            }
            if (s.equals("MMidPoint")) {
                MObjectReader.readMMidPoint(add, points, CMLImport.getTagProperty(node, "pos"), CMLImport.getTagProperty(node, "lineRef"));
                continue;
            }
            if (s.equals("MRectanglePoint")) {
                MObjectReader.readMRectanglePoint(add, points, CMLImport.getTagProperty(node, "pos"), CMLImport.getTagProperty(node, "rectRef"));
                continue;
            }
            if (s.equals("MPoint")) {
                MObjectReader.readMPoint(add, points, CMLImport.getTagProperty(node, "x"), CMLImport.getTagProperty(node, "y"), CMLImport.getTagProperty(node, "z"));
                continue;
            }
            if (!s.equals("Field")) continue;
            this.readField(node);
        }
        return MObjectReader.toArray(points);
    }

    private void readField(Node node) {
        String name = CMLImport.getTagProperty(node, "name");
        NodeList datanodes = node.getChildNodes();
        StringBuffer sb = new StringBuffer();
        for (int j = 0; j < datanodes.getLength(); ++j) {
            Node datanode = datanodes.item(j);
            String v = datanode.getNodeValue();
            sb.append(v);
        }
        String v = EncodingUtil.unescape(sb.toString());
        this.attrHash.put(name, v);
    }

    protected static String getTagProperty(Node elem, String key) {
        Node node;
        NamedNodeMap attr = elem.getAttributes();
        if (attr != null && (node = attr.getNamedItem(key)) != null) {
            return node.getNodeValue();
        }
        return null;
    }

    protected void addTagProperties(Node node, Map<String, String> hash) {
        NamedNodeMap attrs = node.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attr = attrs.item(i);
            String key = attr.getNodeName();
            String val = attr.getNodeValue();
            hash.put(key, val);
        }
    }

    protected String modifyPropertyKeyCallback(String key) {
        return "marvin:" + key;
    }
}

