/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.cml;

import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolInputStream;
import chemaxon.marvin.io.MPropHandler;
import chemaxon.marvin.io.formats.MoleculeImporterIface;
import chemaxon.marvin.io.formats.cml.AtomReader;
import chemaxon.marvin.io.formats.cml.BicycloStereoIndexDescriptor;
import chemaxon.marvin.io.formats.cml.BondReader;
import chemaxon.marvin.io.formats.cml.CMLExport;
import chemaxon.marvin.io.formats.cml.MObjectReader;
import chemaxon.marvin.io.formats.cml.MoleculeReader;
import chemaxon.marvin.io.formats.cml.ParsedData;
import chemaxon.marvin.io.formats.cml.PropertyReader;
import chemaxon.marvin.io.formats.cml.ReaderUtil;
import chemaxon.marvin.io.formats.cml.SgroupReader;
import chemaxon.marvin.modelling.TextUtils;
import chemaxon.marvin.util.MolImportUtil;
import chemaxon.marvin.util.text.EncodingUtil;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MObject;
import chemaxon.struc.MPoint;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.RxnMolecule;
import chemaxon.struc.SelectionMolecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.StereoConstants;
import chemaxon.struc.graphics.MBracket;
import chemaxon.struc.sgroup.DataSgroup;
import chemaxon.struc.sgroup.MultipleSgroup;
import chemaxon.struc.sgroup.RepeatingUnitSgroup;
import chemaxon.struc.sgroup.SgroupAtom;
import chemaxon.struc.sgroup.SuperatomSgroup;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class CmlImportStax
implements StereoConstants,
MoleculeImporterIface {
    private int dimension = 2;
    protected boolean useSgroupAPO = false;
    private boolean linkNodeRefNeedsUpdating = false;
    protected List<Object> atomSetPointVector;
    protected List<Object> eflowBasePointVector;
    protected Map<String, String> attrHash = new HashMap<String, String>();
    protected InputStream inputStream;
    protected XMLStreamReader reader;
    protected String fileFormatVersion = null;
    protected String generationVersion = null;
    protected boolean readHeader = true;
    protected static final String[] MAIN_MOLECULE_TAGS = new String[]{"atomArray", "bondArray", "molecule", "name", "propertyList"};
    protected static final String[] ATOM_ARRAY_TAGS = new String[]{"atom"};
    protected static final String[] ATOM_ARRAY_SUBTAGS = new String[]{"atomParity", "scalar", "atomBicycloStereo"};
    protected static final String[] BOND_ARRAY_TAGS = new String[]{"bond"};
    protected static final String[] BOND_ARRAY_SUBTAGS = new String[]{"bondStereo"};
    protected static final String[] CML_START_TAGS = new String[]{"molecule", "reaction", "MDocument"};
    protected static final String[] VALID_ROOT_TAGS = new String[]{"molecule", "MDocument", "reaction", "reactionScheme"};
    protected static final String[] CML_TAG = new String[]{"cml"};
    protected static final String[] MAIN_REACTION_TAGS = new String[]{"propertyList", "reactantList", "agentList", "productList", "arrow"};
    protected static final String[] PROPERTYLIST_SUB_SUBTAGS = new String[]{"property"};
    protected static final String[] PROPERTY_SUBTAGS = new String[]{"scalar", "array"};
    protected static final String[] SCALAR_TAG = new String[]{"scalar"};
    protected static final String[] REACTION_PART_TAGS = new String[]{"molecule"};
    protected static final String[] SGROUP_MAIN_TAGS = new String[]{"molecule"};
    protected static final String[] MBRACKET_TAG = new String[]{"MBracket"};
    protected static final String[] GRAPHICS_OBJECT_TAGS = new String[]{"MBracket", "MPolyline", "MEFlow", "MRectangle", "MTextBox", "MNameTextBox", "MRoundedRectangle", "MEllipse"};
    protected static final String[] GRAPHICS_OBJECT_SUBTAGS = new String[]{"MAtomSetPoint", "MEFlowBasePoint", "MMidPoint", "MRectanglePoint", "MPoint", "Field"};
    protected String recordStartingTag = null;

    public CmlImportStax(InputStream inputStream) throws IOException {
        MolInputStream mis = this.openInputStream(inputStream);
        XMLInputFactory xmlStreamReaderFactory = XMLInputFactory.newInstance();
        this.inputStream = inputStream;
        try {
            this.reader = mis.getEncoding() != null ? xmlStreamReaderFactory.createXMLStreamReader(mis, mis.getEncoding().name()) : xmlStreamReaderFactory.createXMLStreamReader(mis);
        }
        catch (XMLStreamException e) {
            throw new IOException("Error in initializing XML reader.", e);
        }
    }

    protected MolInputStream openInputStream(InputStream inputStream) throws IOException {
        MolInputStream mis = inputStream instanceof MolInputStream ? (MolInputStream)inputStream : new MolInputStream(inputStream, "cml");
        return mis;
    }

    public CmlImportStax(InputStream inputStream, String encoding) throws IOException {
        XMLInputFactory xmlStreamReaderFactory = XMLInputFactory.newInstance();
        this.inputStream = inputStream;
        try {
            this.reader = xmlStreamReaderFactory.createXMLStreamReader(inputStream, encoding);
        }
        catch (XMLStreamException e) {
            throw new IOException("Error in initializing XML reader.", e);
        }
    }

    @Override
    public Molecule read() throws IOException {
        try {
            if (this.readHeader) {
                this.readHeader();
                this.readHeader = false;
            }
            return this.readMol();
        }
        catch (XMLStreamException e) {
            throw new IOException("Xml format error in CML input.", e);
        }
        catch (NullPointerException e) {
            try {
                this.readUntilEndTagOf(this.recordStartingTag);
            }
            catch (XMLStreamException eXml) {
                throw new IOException("Xml format error in CML input.", eXml);
            }
            throw new MolFormatException("Error in CML import: essential information not found in input.", e);
        }
        catch (IndexOutOfBoundsException e) {
            try {
                this.readUntilEndTagOf(this.recordStartingTag);
            }
            catch (XMLStreamException eXml) {
                throw new IOException("Xml format error in CML input.", eXml);
            }
            throw new MolFormatException("Error in CML import: non-consistent arrays or indexing.", e);
        }
        catch (MolFormatException e) {
            try {
                this.readUntilEndTagOf(this.recordStartingTag);
            }
            catch (XMLStreamException eXml) {
                throw new IOException("Xml format error in CML input.", eXml);
            }
            throw e;
        }
    }

    protected void readHeader() throws IOException, XMLStreamException {
        this.reader.next();
        if (this.isStartingTagOfArray(CML_TAG)) {
            String versionInfo = this.reader.getAttributeValue(null, "version");
            if (versionInfo != null) {
                this.fileFormatVersion = CMLExport.getFileFormatVersion(versionInfo);
                this.generationVersion = CMLExport.getGenerationVersion(versionInfo);
            }
            this.nextTag();
        }
    }

    private Molecule readMol() throws IOException, XMLStreamException {
        this.useSgroupAPO = false;
        Molecule mol = this.readCML();
        if (mol != null) {
            if (!this.useSgroupAPO) {
                MolImportUtil.convertRgroupAttachments(mol);
            }
            MolImportUtil.convertAttachments(mol.getGraphUnion());
            MolImportUtil.fixBeilsteinRDF(mol);
            mol.setGUIContracted(false);
            mol.revalidateCoordDependentProps();
            mol.setInputFormat("cml");
            return mol;
        }
        return null;
    }

    protected Molecule readCML() throws IOException, XMLStreamException {
        try {
            if (this.readUntilTag(CML_START_TAGS)) {
                this.recordStartingTag = this.reader.getLocalName();
                if (this.reader.getLocalName().equals("MDocument")) {
                    throw new IOException("CMLImport cannot parse MRV, use MrvImport");
                }
                if (this.reader.getLocalName().equals("molecule")) {
                    return this.readMolecule();
                }
                return this.readReaction();
            }
            return null;
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    protected Molecule readMolecule() throws XMLStreamException, IOException {
        Molecule mol = new Molecule();
        this.linkNodeRefNeedsUpdating = false;
        this.readMoleculeAttributes(mol);
        this.dimension = 0;
        mol.setDim(0);
        this.readMol00(mol, null);
        if (mol.isEmpty()) {
            this.dimension = 2;
        }
        mol.setDim(this.dimension);
        MolImportUtil.reparentEmptySgroups(mol);
        MolImportUtil.generateBrackets(mol);
        return mol;
    }

    private Molecule readMoleculeAttributes(Molecule mol) {
        for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
            if (this.reader.getAttributeLocalName(i).equals("title")) {
                mol.setName(this.reader.getAttributeValue(i));
            }
            if (!this.reader.getAttributeLocalName(i).equals("absStereo")) continue;
            mol.setAbsStereo(this.reader.getAttributeValue(i).equals("true"));
        }
        return mol;
    }

    private void readMol00(Molecule mol, Sgroup psg) throws IOException, XMLStreamException {
        this.readMol0(mol, psg, null, null);
    }

    private void readMol0(Molecule mol, Sgroup psg, Map<String, MolAtom> idAtomHash0, Map<String, Sgroup> atomSgroupRefHash0) throws IOException, XMLStreamException {
        boolean bondsProcessed = false;
        ParsedData parsedData = new ParsedData();
        int na = 0;
        int eventCode = this.nextInArray(MAIN_MOLECULE_TAGS);
        while (eventCode == 1) {
            if (this.reader.getLocalName().equals("atomArray")) {
                na += this.readAtomArray(mol, psg, parsedData);
            } else if (this.reader.getLocalName().equals("bondArray")) {
                if (bondsProcessed) {
                    throw new MolFormatException("bonds already specified");
                }
                this.readBondArray(parsedData);
            } else if (this.reader.getLocalName().equals("molecule")) {
                bondsProcessed = BondReader.processBondArrays(mol, parsedData);
                this.readSubMolecule(mol, psg, parsedData, idAtomHash0, atomSgroupRefHash0);
            } else if (this.reader.getLocalName().equals("name")) {
                this.readName(mol);
            } else {
                this.readMoleculePropertyList(mol);
            }
            eventCode = this.nextInArray(MAIN_MOLECULE_TAGS);
        }
        BondReader.processBondArrays(mol, parsedData);
        BondReader.processBondCorrespondence(mol, parsedData);
        mol.endReuse(na);
        AtomReader.setAtomParities(mol, parsedData);
        MoleculeReader.setBicycloStereoDescriptors(mol, parsedData);
        AtomReader.setLinkNodeOuters(mol, parsedData, this.linkNodeRefNeedsUpdating);
        AtomReader.processLigandOrderHash(mol, parsedData);
        ReaderUtil.valenceCheck(mol, parsedData.atomsWithHcount);
    }

    private void readMoleculePropertyList(Molecule mol) throws XMLStreamException, IOException {
        int eventCode = this.nextInArray(PROPERTYLIST_SUB_SUBTAGS);
        while (eventCode == 1) {
            this.readMoleculeProperty(mol);
            eventCode = this.nextInArray(PROPERTYLIST_SUB_SUBTAGS);
        }
    }

    private void readMoleculeProperty(Molecule mol) throws XMLStreamException, IOException {
        String key = this.reader.getAttributeValue(null, "dictRef");
        if (key == null) {
            key = this.reader.getAttributeValue(null, "title");
        }
        if (this.nextInArray(PROPERTY_SUBTAGS) == 1) {
            if (this.reader.getLocalName().equals("scalar")) {
                String xsdtype = this.reader.getAttributeValue(null, "dataType");
                String v = this.readData();
                if (key != null) {
                    mol.properties().set(key, MPropHandler.stringToScalar(xsdtype, v));
                }
            } else if (this.reader.getLocalName().equals("array")) {
                int size;
                String xsdtype = this.reader.getAttributeValue(null, "dataType");
                String delim = this.reader.getAttributeValue(null, "delimiter");
                String sizeo = this.reader.getAttributeValue(null, "size");
                try {
                    size = Integer.parseInt(sizeo);
                }
                catch (NumberFormatException e) {
                    size = -1;
                }
                StringBuffer sb = new StringBuffer();
                String v = this.readData();
                sb.append(v);
                if (key != null) {
                    mol.properties().set(key, MPropHandler.stringToArray(xsdtype, sb.toString(), size, delim != null ? (int)delim.charAt(0) : -1));
                }
            }
            this.readUntilEndTagOf(PROPERTYLIST_SUB_SUBTAGS[0]);
        }
    }

    private void readName(Molecule mol) throws XMLStreamException {
        this.reader.next();
        mol.setName(this.readElementValue());
        this.reader.next();
    }

    protected boolean isStartingTagOfArray(String[] tagArray) {
        if (this.reader.getEventType() != 1) {
            return false;
        }
        String tag = this.reader.getLocalName();
        for (int i = 0; i < tagArray.length; ++i) {
            if (!tag.equals(tagArray[i])) continue;
            return true;
        }
        return false;
    }

    protected boolean isStartingTagOfArrayIgnoreCase(String[] tagArray) {
        if (this.reader.getEventType() != 1) {
            return false;
        }
        String tag = this.reader.getLocalName();
        for (int i = 0; i < tagArray.length; ++i) {
            if (!tag.equals(tagArray[i])) continue;
            return true;
        }
        return false;
    }

    protected boolean isEndingTagOfArrayIgnoreCase(String[] tagArray) {
        if (this.reader.getEventType() != 2) {
            return false;
        }
        String tag = this.reader.getLocalName();
        for (int i = 0; i < tagArray.length; ++i) {
            if (!tag.equals(tagArray[i])) continue;
            return true;
        }
        return false;
    }

    protected int nextTag() throws XMLStreamException {
        int eventCode = this.reader.next();
        while (eventCode != 1 && eventCode != 2) {
            eventCode = this.reader.next();
        }
        return eventCode;
    }

    protected boolean readUntilTag(String[] tagArray) throws XMLStreamException {
        while (!this.reader.isStartElement() && !this.isEndDocument()) {
            this.reader.next();
        }
        while (this.reader.isStartElement()) {
            String tag = this.reader.getLocalName();
            for (int i = 0; i < tagArray.length; ++i) {
                if (!tag.equals(tagArray[i])) continue;
                return true;
            }
            this.readUntilEndTagOf(tag);
            while (!this.reader.isStartElement() && !this.isEndDocument()) {
                this.reader.next();
            }
        }
        return false;
    }

    private boolean isEndDocument() {
        return this.reader.getEventType() == 8;
    }

    protected int readUntilEndTagOf(String tag) throws XMLStreamException {
        int depth = 1;
        int eventCode = -1;
        while (depth > 0) {
            eventCode = this.nextTag();
            if (eventCode == 1 && this.reader.getLocalName().equals(tag)) {
                ++depth;
                continue;
            }
            if (eventCode != 2 || !this.reader.getLocalName().equals(tag)) continue;
            --depth;
        }
        return eventCode;
    }

    protected int nextInArray(String[] tagArray) throws XMLStreamException {
        int eventCode = this.nextTag();
        while (eventCode == 1) {
            String tag = this.reader.getLocalName();
            for (int i = 0; i < tagArray.length; ++i) {
                if (!tag.equals(tagArray[i])) continue;
                return eventCode;
            }
            eventCode = this.readUntilEndTagOf(tag);
            eventCode = this.nextTag();
        }
        return eventCode;
    }

    protected int readUntilEndTagOfIgnoreCase(String tag) throws XMLStreamException {
        int depth = 1;
        int eventCode = -1;
        while (depth > 0) {
            eventCode = this.nextTag();
            if (eventCode == 1 && this.reader.getLocalName().equals(tag)) {
                ++depth;
                continue;
            }
            if (eventCode != 2 || !this.reader.getLocalName().equals(tag)) continue;
            --depth;
        }
        return eventCode;
    }

    private int readAtomArray(Molecule mol, Sgroup psg, ParsedData parsedData) throws MolFormatException, XMLStreamException {
        HashMap<String, Integer> atomResidueIdHash = new HashMap<String, Integer>();
        int na = this.initUsingAtomArrayAttributes(mol, psg, parsedData, atomResidueIdHash);
        int eventCode = this.nextInArray(ATOM_ARRAY_TAGS);
        while (eventCode == 1) {
            this.readAtom(mol, psg, atomResidueIdHash, parsedData);
            ++na;
            eventCode = this.nextInArray(ATOM_ARRAY_TAGS);
        }
        return na;
    }

    private int initUsingAtomArrayAttributes(Molecule mol, Sgroup psg, ParsedData parsedData, Map<String, Integer> atomResidueIdHash) throws MolFormatException {
        int na = 0;
        if (this.reader.getAttributeValue(null, "atomID") != null) {
            na = AtomReader.readAtomIdentifiers(mol, parsedData, this.reader.getAttributeValue(null, "atomID"));
        }
        if (this.reader.getAttributeValue(null, "elementType") != null) {
            AtomReader.readElementTypes(mol, this.reader.getAttributeValue(null, "elementType"));
        }
        boolean[] isRgroup = null;
        if (this.reader.getAttributeValue(null, "rgroupRef") != null) {
            isRgroup = AtomReader.readRgroupReferences(mol, this.reader.getAttributeValue(null, "rgroupRef"));
        }
        if (this.reader.getAttributeValue(null, "sgroupRef") != null) {
            SgroupReader.readSgroupReferences(mol, psg, parsedData, isRgroup, this.reader.getAttributeValue(null, "sgroupRef"));
        }
        if (this.reader.getAttributeValue(null, "attachmentPoint") != null) {
            AtomReader.readAttachmentPoints(mol, this.reader.getAttributeValue(null, "attachmentPoint"));
        }
        if (this.reader.getAttributeValue(null, "sgroupAttachmentPoint") != null) {
            this.useSgroupAPO = true;
            AtomReader.readAttachmentPoints(mol, this.reader.getAttributeValue(null, "sgroupAttachmentPoint"));
        }
        if (this.reader.getAttributeValue(null, "attachmentOrder") != null) {
            AtomReader.readAttachmentOrders(mol, this.reader.getAttributeValue(null, "attachmentOrder"));
        }
        if (this.reader.getAttributeValue(null, "isotope") != null) {
            AtomReader.readIsotopes(mol, this.reader.getAttributeValue(null, "isotope"));
        }
        if (this.reader.getAttributeValue(null, "formalCharge") != null) {
            AtomReader.readFormalCharges(mol, this.reader.getAttributeValue(null, "formalCharge"));
        } else {
            AtomReader.initCharges(mol);
        }
        if (this.reader.getAttributeValue(null, "hydrogenCount") != null) {
            AtomReader.readHydrogenCounts(mol, parsedData.atomsWithHcount, this.reader.getAttributeValue(null, "hydrogenCount"));
        }
        if (this.reader.getAttributeValue(null, "mrvValence") != null) {
            AtomReader.readMrvValences(mol, this.reader.getAttributeValue(null, "mrvValence"));
        }
        if (this.reader.getAttributeValue(null, "residueType") != null) {
            AtomReader.readResidueTypes(mol, this.reader.getAttributeValue(null, "residueType"));
        }
        if (this.reader.getAttributeValue(null, "residueId") != null) {
            AtomReader.readResidueIdentifiers(mol, atomResidueIdHash, this.reader.getAttributeValue(null, "residueId"));
        }
        if (this.reader.getAttributeValue(null, "residueAtomName") != null) {
            AtomReader.readResidueAtomNames(mol, this.reader.getAttributeValue(null, "residueAtomName"));
        }
        if (this.reader.getAttributeValue(null, "mrvMap") != null) {
            AtomReader.readMrvMappings(mol, this.reader.getAttributeValue(null, "mrvMap"));
        }
        if (this.reader.getAttributeValue(null, "reactionStereo") != null) {
            AtomReader.readReactionStereos(mol, this.reader.getAttributeValue(null, "reactionStereo"));
        }
        if (this.reader.getAttributeValue(null, "mrvStereoGroup") != null) {
            AtomReader.readMrvStereoGroups(mol, this.reader.getAttributeValue(null, "mrvStereoGroup"));
        }
        if (this.reader.getAttributeValue(null, "mrvSpecIsotopeSymbolPreferred") != null) {
            AtomReader.readMrvSpecIsotopes(mol, this.reader.getAttributeValue(null, "mrvSpecIsotopeSymbolPreferred"));
        }
        if (this.reader.getAttributeValue(null, "radical") != null) {
            AtomReader.readRadicals(mol, this.reader.getAttributeValue(null, "radical"));
        }
        if (this.reader.getAttributeValue(null, "lonePair") != null) {
            AtomReader.readLonePairs(mol, this.reader.getAttributeValue(null, "lonePair"));
        }
        if (this.reader.getAttributeValue(null, "mrvQueryProps") != null) {
            AtomReader.readMrvQueryProps(mol, this.reader.getAttributeValue(null, "mrvQueryProps"));
        }
        if (this.reader.getAttributeValue(null, "mrvAlias") != null) {
            AtomReader.readMrvAliasValues(mol, this.reader.getAttributeValue(null, "mrvAlias"));
        }
        if (this.reader.getAttributeValue(null, "mrvExtraLabel") != null) {
            AtomReader.readMrvExtraLabels(mol, this.reader.getAttributeValue(null, "mrvExtraLabel"));
        }
        if (this.reader.getAttributeValue(null, "mrvPseudo") != null) {
            AtomReader.readMrvPseudos(mol, this.reader.getAttributeValue(null, "mrvPseudo"));
        }
        if (this.reader.getAttributeValue(null, "mrvSetSeq") != null) {
            AtomReader.readMrvSetSeq(mol, this.reader.getAttributeValue(null, "mrvSetSeq"));
        }
        if (this.reader.getAttributeValue(null, "mrvSetExtraLabelSeq") != null) {
            AtomReader.readMrvSetExtraLabelSeq(mol, this.reader.getAttributeValue(null, "mrvSetExtraLabelSeq"));
        }
        if (this.reader.getAttributeValue(null, "mrvLinkNodeRep") != null) {
            AtomReader.readMrvLinkNodeRepetitions(mol, this.reader.getAttributeValue(null, "mrvLinkNodeRep"));
        }
        if (this.reader.getAttributeValue(null, "mrvLinkNodeOut") != null) {
            this.linkNodeRefNeedsUpdating = AtomReader.readMrvLinkNodeOutValues(mol, this.reader.getAttributeValue(null, "mrvLinkNodeOut"), this.linkNodeRefNeedsUpdating);
        }
        if (this.reader.getAttributeValue(null, "isSelected") != null) {
            AtomReader.readIsSelected(mol, this.reader.getAttributeValue(null, "isSelected"));
        }
        this.readCoordinates(mol);
        return na;
    }

    private void readAtom(Molecule mol, Sgroup psg, Map<String, Integer> atomResidueIdHash, ParsedData parsedData) throws MolFormatException, XMLStreamException {
        int k;
        MolAtom a = AtomReader.createAtom(mol, parsedData, this.reader.getAttributeValue(null, "id"));
        String elementType = this.reader.getAttributeValue(null, "elementType");
        Integer formalCharge = ReaderUtil.getTagPropertyAsInteger(this.reader.getAttributeValue(null, "formalCharge"));
        Integer hydrogenCount = ReaderUtil.getTagPropertyAsInteger(this.reader.getAttributeValue(null, "hydrogenCount"));
        Integer valenceProp = ReaderUtil.getTagPropertyAsInteger(this.reader.getAttributeValue(null, "mrvValence"));
        Integer isotope = ReaderUtil.getTagPropertyAsInteger(this.reader.getAttributeValue(null, "isotope"));
        String residueType = this.reader.getAttributeValue(null, "residueType");
        String residueId = this.reader.getAttributeValue(null, "residueId");
        String residueAtomName = this.reader.getAttributeValue(null, "residueAtomName");
        String sX2 = this.reader.getAttributeValue(null, "x2");
        String sY2 = this.reader.getAttributeValue(null, "y2");
        String sX3 = this.reader.getAttributeValue(null, "x3");
        String sY3 = this.reader.getAttributeValue(null, "y3");
        String sZ3 = this.reader.getAttributeValue(null, "z3");
        Integer mrvAtomMap = ReaderUtil.getTagPropertyAsInteger(this.reader.getAttributeValue(null, "mrvMap"));
        String reactionStereo = this.reader.getAttributeValue(null, "reactionStereo");
        String mrvStereoGroup = this.reader.getAttributeValue(null, "mrvStereoGroup");
        String mrvSpecIsoSym = this.reader.getAttributeValue(null, "mrvSpecIsotopeSymbolPreferred");
        String radical = this.reader.getAttributeValue(null, "radical");
        String lonePair = this.reader.getAttributeValue(null, "lonePair");
        String rgroupRef = this.reader.getAttributeValue(null, "rgroupRef");
        String sgroupRef = this.reader.getAttributeValue(null, "sgroupRef");
        String attachmentPoint = this.reader.getAttributeValue(null, "attachmentPoint");
        String sgroupAttachmentPoint = this.reader.getAttributeValue(null, "sgroupAttachmentPoint");
        String mrvQueryProps = this.reader.getAttributeValue(null, "mrvQueryProps");
        String mrvAlias = this.reader.getAttributeValue(null, "mrvAlias");
        String mrvExtraLabel = this.reader.getAttributeValue(null, "mrvExtraLabel");
        String mrvPseudo = this.reader.getAttributeValue(null, "mrvPseudo");
        String mrvSetSeq = this.reader.getAttributeValue(null, "mrvSetSeq");
        String mrvExtraLabelSeq = this.reader.getAttributeValue(null, "mrvSetExtraLabelSeq");
        String mrvLinkNodeRep = this.reader.getAttributeValue(null, "mrvLinkNodeRep");
        String mrvLinkNodeOut = this.reader.getAttributeValue(null, "mrvLinkNodeOut");
        String ligandOrder = this.reader.getAttributeValue(null, "ligandOrder");
        String attachmentOrder = this.reader.getAttributeValue(null, "attachmentOrder");
        String isSelected = this.reader.getAttributeValue(null, "isSelected");
        double x = a.getX();
        double y = a.getY();
        double z = a.getZ();
        try {
            if (sX2 != null) {
                x = Double.valueOf(sX2);
            }
            if (sY2 != null) {
                y = Double.valueOf(sY2);
            }
            if (sX3 != null) {
                x = Double.valueOf(sX3);
            }
            if (sY3 != null) {
                y = Double.valueOf(sY3);
            }
            if (sZ3 != null) {
                z = Double.valueOf(sZ3);
            }
        }
        catch (NumberFormatException ex) {
            throw new MolFormatException("invalid property value");
        }
        this.readAtomInternalTags(a, parsedData);
        if (elementType != null) {
            AtomReader.setElementType(a, elementType);
        }
        boolean isRgroup = false;
        if (rgroupRef != null) {
            isRgroup = AtomReader.setAtomRgroupRef(a, rgroupRef);
        }
        if (sgroupRef != null) {
            int i = mol.indexOf(a);
            a = AtomReader.setAtomSgroupRef(mol, i, sgroupRef, psg, isRgroup, parsedData);
        }
        if (attachmentPoint != null) {
            AtomReader.setAtomAttach(a, attachmentPoint, mol);
        }
        if (sgroupAttachmentPoint != null) {
            AtomReader.setAtomAttach(a, sgroupAttachmentPoint, mol);
            this.useSgroupAPO = true;
        }
        if (formalCharge != null) {
            a.setCharge(formalCharge);
        } else {
            a.setFlags(65536, 65536);
        }
        if (hydrogenCount != null) {
            int hx = a.getExplicitHcount();
            a.setImplicitHcount(hydrogenCount - hx);
            parsedData.atomsWithHcount.add(a);
        }
        if (valenceProp != null) {
            a.setValenceProp(valenceProp);
        }
        if (isotope != null) {
            a.setMassno(isotope);
        }
        if (residueType != null) {
            AtomReader.setResidueType(a, residueType);
        }
        if (residueId != null) {
            AtomReader.setResidueSeq(a, residueId, atomResidueIdHash);
        }
        if (residueAtomName != null) {
            AtomReader.setResidueAtomId(a, residueAtomName);
        }
        if (mrvAtomMap != null) {
            a.setAtomMap(mrvAtomMap);
        }
        if (reactionStereo != null) {
            AtomReader.setAtomRxnStereo(a, reactionStereo);
        }
        if (mrvStereoGroup != null) {
            AtomReader.setAtomStereoGroup(a, mrvStereoGroup);
        }
        if (mrvSpecIsoSym != null) {
            AtomReader.setSpecIsotopeSymbolPreferred(a, mrvSpecIsoSym);
        }
        if (radical != null) {
            AtomReader.setAtomRadical(a, radical);
        }
        if (lonePair != null) {
            a.setElectronProp(Integer.valueOf(lonePair));
        }
        if (mrvQueryProps != null) {
            AtomReader.setAtomQueryProps(a, mrvQueryProps);
        }
        if (mrvAlias != null) {
            AtomReader.setAtomAlias(a, mrvAlias);
        }
        if (mrvExtraLabel != null) {
            AtomReader.setAtomExtraLabel(a, mrvExtraLabel);
        }
        if (mrvPseudo != null) {
            AtomReader.setPseudoAtomName(a, mrvPseudo);
        }
        if (mrvSetSeq != null) {
            k = Integer.parseInt(mrvSetSeq);
            a.setSetSeq(k);
        }
        if (mrvExtraLabelSeq != null) {
            k = Integer.parseInt(mrvExtraLabelSeq);
            a.setExtraLabelSetSeq(k);
        }
        if (mrvLinkNodeRep != null) {
            AtomReader.setLinkNodeRep(a, mrvLinkNodeRep);
        }
        if (mrvLinkNodeOut != null) {
            this.linkNodeRefNeedsUpdating = AtomReader.storeLinkNodeOuters(a, mrvLinkNodeOut, this.linkNodeRefNeedsUpdating);
        }
        if (ligandOrder != null) {
            parsedData.ligandOrderHash.put(a, ligandOrder);
        }
        if (attachmentOrder != null) {
            int order = Integer.parseInt(attachmentOrder);
            a.setRgroupAttachmentPointOrder(order);
        }
        if ((x != 0.0 || y != 0.0) && this.dimension < 2) {
            this.dimension = 2;
        }
        if (z != 0.0) {
            this.dimension = 3;
        }
        AtomReader.setSelection(a, isSelected);
        mol.setDim(this.dimension);
        a.setXYZ(x, y, z);
    }

    private void readCoordinates(Molecule mol) throws MolFormatException {
        for (int i = 2; i <= 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                String key = String.valueOf((char)(120 + j)) + i;
                if (this.reader.getAttributeValue(null, key) == null) continue;
                this.dimension = AtomReader.readCoordinates(mol, this.dimension, i, j, this.reader.getAttributeValue(null, key));
            }
        }
    }

    private void readAtomInternalTags(MolAtom a, ParsedData parsedData) throws MolFormatException, XMLStreamException {
        ArrayList<BicycloStereoIndexDescriptor> list = new ArrayList<BicycloStereoIndexDescriptor>();
        int eventCode = this.nextInArray(ATOM_ARRAY_SUBTAGS);
        while (eventCode == 1) {
            if (this.reader.getLocalName().equals("atomParity")) {
                String[] atoms = AtomReader.getRefsArray(this.reader.getAttributeValue(null, "atomRefs4"));
                eventCode = this.reader.next();
                String parityValue = this.getParityValue(this.readElementValue());
                AtomReader.readAtomParity(atoms, parityValue, a, parsedData.atomParityHash);
                this.readUntilEndTagOf("atomParity");
            } else if (this.reader.getLocalName().equals("scalar")) {
                PropertyReader.readAtomProperties(this.reader.getAttributeValue(null, "title"), this.reader.getAttributeValue(null, "value"), this.reader.getAttributeValue(null, "dataType"), a);
                this.readUntilEndTagOf("scalar");
            } else {
                String connectionAtom = this.reader.getAttributeValue(null, "connectionAtom");
                String lowBridge = this.reader.getAttributeValue(null, "lowBridge");
                String highBridge = this.reader.getAttributeValue(null, "highBridge");
                eventCode = this.reader.next();
                list.add(MoleculeReader.readAtomBicycloStereo(connectionAtom, AtomReader.getRefsArray(lowBridge), AtomReader.getRefsArray(highBridge), this.readElementValue()));
                this.readUntilEndTagOf("atomBicycloStereo");
            }
            eventCode = this.nextInArray(ATOM_ARRAY_SUBTAGS);
        }
        parsedData.bicycloStereoHash.put(a, list.size() > 0 ? list : null);
    }

    protected String getParityValue(String readParityValue) {
        return readParityValue;
    }

    private void readBondArray(ParsedData parsedData) throws MolFormatException, XMLStreamException {
        int eventCode = this.nextInArray(BOND_ARRAY_TAGS);
        while (eventCode == 1) {
            this.readBond(parsedData);
            eventCode = this.nextInArray(BOND_ARRAY_TAGS);
        }
    }

    private void readBond(ParsedData parsedData) throws MolFormatException, XMLStreamException {
        boolean bold;
        String atomRef1 = null;
        String atomRef2 = null;
        String sOrder = this.reader.getAttributeValue(null, "order");
        String sConvention = this.reader.getAttributeValue(null, "convention");
        String sQueryType = this.reader.getAttributeValue(null, "queryType");
        String mrvQueryProps = this.reader.getAttributeValue(null, "mrvQueryProps");
        String[] dbBondStereoProps = null;
        int flags = 0;
        String atomRefs2 = this.reader.getAttributeValue(null, "atomRefs2");
        String sTopology = this.reader.getAttributeValue(null, "topology");
        String mrvSetSeq = this.reader.getAttributeValue(null, "mrvSetSeq");
        String mrvReactingCenter = this.reader.getAttributeValue(null, "mrvReactingCenter");
        String mrvBold = this.reader.getAttributeValue(null, "mrvBold");
        String mrvHashed = this.reader.getAttributeValue(null, "mrvHashed");
        if (atomRefs2 != null) {
            StringTokenizer st = new StringTokenizer(atomRefs2);
            atomRef1 = st.nextToken();
            atomRef2 = st.nextToken();
        }
        if (sOrder != null) {
            flags = BondReader.readBondOrder(sOrder, flags);
        }
        if (sConvention != null) {
            flags = BondReader.readBondConvention(sConvention, flags);
        }
        if (sTopology != null) {
            flags = BondReader.readBondTopology(sTopology, flags);
        }
        if (sQueryType != null) {
            flags = BondReader.readBondQueryType(sQueryType, flags);
        }
        if (mrvSetSeq != null) {
            int k = Integer.parseInt(mrvSetSeq);
            flags = flags & 0xC0FFFFFF | k << 24;
        }
        if (mrvReactingCenter != null) {
            flags = BondReader.readReactingCenterProperty(mrvReactingCenter, flags);
        }
        if (mrvBold != null && (bold = Boolean.parseBoolean(mrvBold))) {
            flags = flags & 0xBFFFFFFF | 0x40000000;
        }
        if (mrvHashed != null && Boolean.parseBoolean(mrvHashed)) {
            flags = flags & Integer.MAX_VALUE | Integer.MIN_VALUE;
        }
        int eventCode = this.nextInArray(BOND_ARRAY_SUBTAGS);
        while (eventCode == 1) {
            String conv = this.reader.getAttributeValue(null, "convention");
            String val = this.reader.getAttributeValue(null, "conventionValue");
            if (conv != null && val != null) {
                flags = BondReader.readStereoValue(flags, conv, val);
            } else {
                String atomRefs4 = this.reader.getAttributeValue(null, "atomRefs4");
                eventCode = this.reader.next();
                String s = this.readElementValue();
                if (s == null) {
                    throw new MolFormatException("Missing stereo value in atom stereo description");
                }
                s = s.trim();
                if (atomRefs4 != null) {
                    String[] refs = AtomReader.getRefsArray(atomRefs4);
                    dbBondStereoProps = BondReader.readDbBondStereo(refs, s);
                } else {
                    flags = BondReader.setStereoValue(flags, s);
                }
            }
            this.readUntilEndTagOf("bondStereo");
            eventCode = this.nextInArray(BOND_ARRAY_SUBTAGS);
        }
        if (atomRef1 == null || atomRef2 == null) {
            throw new MolFormatException("Less than two atomRefs defined");
        }
        parsedData.bondAtomRefs1Array.add(atomRef1);
        parsedData.bondAtomRefs2Array.add(atomRef2);
        parsedData.bondFlagsArray.add(flags);
        Object[] xprops = new Object[dbBondStereoProps == null ? 1 : 2];
        xprops[0] = mrvQueryProps;
        if (xprops.length > 1) {
            xprops[1] = dbBondStereoProps;
        }
        parsedData.bondXPropsArray.add(xprops);
    }

    private void readSubMolecule(Molecule mol, Sgroup psg, ParsedData parsedData, Map<String, MolAtom> idAtomHash0, Map<String, Sgroup> atomSgroupRefHash0) throws XMLStreamException, IOException {
        Map<String, Sgroup> sghash = parsedData.atomSgroupRefHash.isEmpty() && atomSgroupRefHash0 != null ? atomSgroupRefHash0 : parsedData.atomSgroupRefHash;
        String role = this.reader.getAttributeValue(null, "role");
        String id = MoleculeReader.getMolID(this.reader.getAttributeValue(null, "id"), this.reader.getAttributeValue(null, "molID"));
        if (SgroupReader.isAcceptableRole(id, role)) {
            Sgroup sg = SgroupReader.createSgroup(psg, sghash, role, id, mol);
            String title = SgroupReader.readGeneralSgroupAttributes(this.reader.getAttributeValue(null, "title"), this.reader.getAttributeValue(null, "charge"), sg);
            if (sg instanceof SuperatomSgroup) {
                this.readSuperatomSgroup(sg);
            }
            if (role.equals("MultipleSgroup")) {
                this.readMultipleSgroup(parsedData, idAtomHash0, sghash, sg, title, mol, id, psg);
            } else if (role.equals("SuperatomSgroup")) {
                this.readSuperatomSgroup(psg, sg, sghash, parsedData, mol);
            } else if (role.equals("DataSgroup")) {
                this.readDataSgroup(mol, idAtomHash0, parsedData, sg, sghash, id, psg);
                this.reader.next();
            } else if (role.equals("ComponentSgroup") || role.equals("MixtureSgroup") || role.equals("FormulationSgroup") || role.equals("GenericSgroup") || role.equals("MerSgroup") || role.equals("MonomerSgroup")) {
                this.readSimpleSgroups(idAtomHash0, parsedData, role, sg, mol, id, psg, sghash);
            } else if (SgroupReader.getPolymerFromName(role) > -1) {
                this.readPolymerSgroup(idAtomHash0, parsedData, mol, role, sg, id, sghash, psg);
            } else {
                SgroupReader.readMulticenterSgroup(this.reader.getAttributeValue(null, "atomRefs"), this.reader.getAttributeValue(null, "center"), sg, id, psg, sghash, parsedData, idAtomHash0, mol);
                this.reader.next();
            }
        } else {
            throw new MolFormatException("Wrong definition of S-group with id = " + id + " and role = " + role);
        }
        if (this.reader.isEndElement() && this.reader.getLocalName().equals("molecule")) {
            return;
        }
        while (this.goToNext("molecule") == 1) {
            this.readSubMolecule(mol, sghash.get(id), parsedData, idAtomHash0, atomSgroupRefHash0);
            this.reader.next();
        }
    }

    protected int goToNext(String term) throws XMLStreamException {
        int eventCode = this.reader.getEventType();
        while (eventCode != 1 && eventCode != 2 || !this.reader.getLocalName().equals(term)) {
            eventCode = this.reader.next();
        }
        return eventCode;
    }

    private void readSuperatomSgroup(Sgroup sg) {
        SgroupAtom supat = ((SuperatomSgroup)sg).getSuperAtom();
        supat.setLeftName(this.reader.getAttributeValue(null, "leftName"));
        supat.setRightName(this.reader.getAttributeValue(null, "rightName"));
        String center = this.reader.getAttributeValue(null, "labelCenter");
        if (center != null) {
            if (center.equals("AUTO")) {
                supat.setLabelCenter(-1);
            } else {
                int k = Integer.parseInt(center);
                supat.setLabelCenter(k);
            }
        }
    }

    private void readMultipleSgroup(ParsedData parsedData, Map<String, MolAtom> idAtomHash0, Map<String, Sgroup> sghash, Sgroup sg, String title, Molecule parentMol, String id, Sgroup psg) throws MolFormatException, XMLStreamException {
        SelectionMolecule smol = new SelectionMolecule();
        SgroupReader.readSelectionMol(this.reader.getAttributeValue(null, "atomRefs"), smol, parsedData, idAtomHash0);
        MultipleSgroup mulsg = SgroupReader.readMultipleSgroup(sghash, sg, title, parentMol, id, psg, smol);
        this.readBracketInfo(mulsg);
    }

    private void readDisplayInfo(Sgroup csg) throws MolFormatException, XMLStreamException {
        MBracket mo = new MBracket();
        this.initGraphicsObject(mo, null);
        csg.addBracket(mo);
    }

    private void readBracketInfo(Sgroup csg) throws MolFormatException, XMLStreamException {
        this.nextTag();
        while (this.reader.isStartElement()) {
            if (this.isStartingTagOfArray(MBRACKET_TAG)) {
                this.readDisplayInfo(csg);
            } else {
                if (this.isStartingTagOfArray(SGROUP_MAIN_TAGS)) break;
                this.readUntilEndTagOf(this.reader.getLocalName());
            }
            this.nextTag();
        }
    }

    protected void initGraphicsObject(MObject o, Map<String, MObject> objHash) throws MolFormatException, XMLStreamException {
        this.attrHash.clear();
        this.addTagProperties();
        MPoint[] points = this.readGraphicsObject(true);
        MObjectReader.initGraphicsObject(this.attrHash, o, objHash, points);
    }

    protected void addTagProperties() {
        for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
            this.attrHash.put(this.reader.getAttributeLocalName(i), this.reader.getAttributeValue(i));
        }
    }

    private MPoint[] readGraphicsObject(boolean add) throws MolFormatException, XMLStreamException {
        ArrayList<MPoint> points = new ArrayList<MPoint>();
        int eventCode = this.nextInArray(GRAPHICS_OBJECT_SUBTAGS);
        while (eventCode == 1) {
            if (this.reader.getLocalName().equals("MAtomSetPoint")) {
                this.atomSetPointVector = MObjectReader.readMAtomSetPoint(this.atomSetPointVector, add, points, this.reader.getAttributeValue(null, "atomRefs"), PropertyReader.getTagPropertyAsDoubleArray(this.reader.getAttributeValue(null, "weights")));
                this.readUntilEndTagOf("MAtomSetPoint");
            } else if (this.reader.getLocalName().equals("MEFlowBasePoint")) {
                this.eflowBasePointVector = MObjectReader.readMEFlowBasePoint(this.eflowBasePointVector, add, points, this.reader.getAttributeValue(null, "atomRef"));
                this.readUntilEndTagOf("MEFlowBasePoint");
            } else if (this.reader.getLocalName().equals("MMidPoint")) {
                MObjectReader.readMMidPoint(add, points, this.reader.getAttributeValue(null, "pos"), this.reader.getAttributeValue(null, "lineRef"));
                this.readUntilEndTagOf("MMidPoint");
            } else if (this.reader.getLocalName().equals("MRectanglePoint")) {
                MObjectReader.readMRectanglePoint(add, points, this.reader.getAttributeValue(null, "pos"), this.reader.getAttributeValue(null, "rectRef"));
                this.readUntilEndTagOf("MRectanglePoint");
            } else if (this.reader.getLocalName().equals("MPoint")) {
                MObjectReader.readMPoint(add, points, this.reader.getAttributeValue(null, "x"), this.reader.getAttributeValue(null, "y"), this.reader.getAttributeValue(null, "z"));
                this.readUntilEndTagOf("MPoint");
            } else {
                String key = this.reader.getAttributeValue(null, "name");
                this.reader.next();
                if (this.reader.isCharacters()) {
                    this.attrHash.put(key, EncodingUtil.unescape(this.readElementValue()));
                    this.readUntilEndTagOf("Field");
                } else if (!this.reader.isEndElement()) {
                    this.readUntilEndTagOf("Field");
                }
            }
            eventCode = this.nextInArray(GRAPHICS_OBJECT_SUBTAGS);
        }
        return MObjectReader.toArray(points);
    }

    private void readSuperatomSgroup(Sgroup psg, Sgroup sg, Map<String, Sgroup> atomSgroupRefHash, ParsedData parsedData, Molecule parentMol) throws XMLStreamException, IOException {
        if (psg != null) {
            psg.addChildSgroup(sg);
        }
        Molecule smol0 = new Molecule();
        this.readMol0(smol0, sg, parsedData.idAtomHash, atomSgroupRefHash);
        SgroupReader.readSuperatomSgroup(sg, parentMol, smol0);
    }

    private void readDataSgroup(Molecule parentMolecule, Map<String, MolAtom> idAtomHash0, ParsedData parsedData, Sgroup sg, Map<String, Sgroup> sghash, String id, Sgroup psg) throws IOException {
        String context;
        Integer pos;
        String tag;
        Integer dispLines;
        DataSgroup dsg = SgroupReader.createDataSgroup(parentMolecule, this.reader.getAttributeValue(null, "atomRefs"), idAtomHash0, parsedData, sg);
        dsg.setFieldName(this.reader.getAttributeValue(null, "fieldName"));
        dsg.setFieldType(this.reader.getAttributeValue(null, "fieldType"));
        dsg.setUnits(this.reader.getAttributeValue(null, "units"));
        dsg.setX(ReaderUtil.readDoubleValue(this.reader.getAttributeValue(null, "x"), "Invalid data S-group coordinate(x): "));
        dsg.setY(ReaderUtil.readDoubleValue(this.reader.getAttributeValue(null, "y"), "Invalid data S-group coordinate(y): "));
        dsg.setDataDetached(!"false".equals(this.reader.getAttributeValue(null, "dataDetached")));
        dsg.setAbsolutePlacement(!"Relative".equals(this.reader.getAttributeValue(null, "placement")));
        dsg.setUnitDisplayed("Unit displayed".equals(this.reader.getAttributeValue(null, "unitsDisplayed")));
        Integer dispChars = ReaderUtil.getTagPropertyAsInteger(this.reader.getAttributeValue(null, "displayedChars"));
        if (dispChars != null) {
            dsg.setDisplayedChars(dispChars);
        }
        if ((dispLines = ReaderUtil.getTagPropertyAsInteger(this.reader.getAttributeValue(null, "displayedLines"))) != null) {
            dsg.setDisplayedLines(dispLines);
        }
        if ((tag = this.reader.getAttributeValue(null, "tag")) != null) {
            dsg.setTag(tag.charAt(0));
        }
        if ((pos = ReaderUtil.getTagPropertyAsInteger(this.reader.getAttributeValue(null, "pos"))) != null) {
            dsg.setPos(pos);
        }
        if ((context = this.reader.getAttributeValue(null, "context")) != null) {
            dsg.setContext(context);
        }
        dsg.setQueryCode(this.reader.getAttributeValue(null, "queryType"));
        dsg.setQueryOp(this.reader.getAttributeValue(null, "queryOp"));
        dsg.setChargeLocation(sg.getChargeLocation());
        int lineNo = 0;
        String lNoS = "";
        String nextLine = this.reader.getAttributeValue(null, "fieldData" + lNoS);
        while (nextLine != null) {
            dsg.addDataLine(nextLine);
            lNoS = Integer.toString(++lineNo);
            nextLine = this.reader.getAttributeValue(null, "fieldData" + lNoS);
        }
        if (this.reader.getAttributeValue(null, "fieldType") == null && TextUtils.isURL(dsg.getData())) {
            dsg.setFieldType(4);
        }
        sghash.put(id, dsg);
        if (psg != null) {
            psg.addChildSgroup(dsg);
        }
    }

    private Sgroup readSimpleSgroups(Map<String, MolAtom> idAtomHash0, ParsedData parsedData, String role, Sgroup sg, Molecule parentMol, String id, Sgroup psg, Map<String, Sgroup> sghash) throws MolFormatException, XMLStreamException {
        Sgroup csg = SgroupReader.createSimpleSgroup(idAtomHash0, parsedData, this.reader.getAttributeValue(null, "atomRefs"), role, sg, parentMol, id, psg, sghash);
        this.readBracketInfo(csg);
        return csg;
    }

    private Sgroup readPolymerSgroup(Map<String, MolAtom> idAtomHash0, ParsedData parsedData, Molecule parentMol, String role, Sgroup sg, String id, Map<String, Sgroup> sghash, Sgroup psg) throws MolFormatException, XMLStreamException {
        SelectionMolecule smol = new SelectionMolecule();
        SgroupReader.readSelectionMol(this.reader.getAttributeValue(null, "atomRefs"), smol, parsedData, idAtomHash0);
        RepeatingUnitSgroup csg = SgroupReader.createRUSgroup(parentMol, role, sg, smol);
        parsedData.correspondenceIdHash.put(id, BondReader.readBondList(this.reader.getAttributeValue(null, "correspondence")));
        parsedData.bondListIdHash.put(id, BondReader.readBondList(this.reader.getAttributeValue(null, "bondList")));
        SgroupReader.readConnectivity(this.reader.getAttributeValue(null, "connect"), csg);
        this.readBracketInfo(csg);
        sghash.put(id, csg);
        if (psg != null) {
            psg.addChildSgroup(csg);
        }
        return csg;
    }

    private String readData() throws XMLStreamException {
        if (this.reader.isStartElement()) {
            return EncodingUtil.unescape(this.reader.getElementText());
        }
        return "";
    }

    protected RxnMolecule readReaction() throws XMLStreamException, IOException {
        RxnMolecule rxn = new RxnMolecule();
        String name = this.reader.getAttributeValue(null, "title");
        if (name != null) {
            rxn.setName(name);
        }
        if (this.reader.getAttributeValue(null, "absStereo") != null) {
            rxn.setAbsStereo(this.reader.getAttributeValue(null, "absStereo").equals("true"));
        }
        int eventCode = this.nextInArray(MAIN_REACTION_TAGS);
        while (eventCode == 1) {
            if (this.reader.getLocalName().equals("arrow")) {
                this.readMRVReactionProperties(rxn);
            } else if (this.reader.getLocalName().equals("reactantList")) {
                this.readReactionPart(0, rxn);
            } else if (this.reader.getLocalName().equals("agentList")) {
                this.readReactionPart(2, rxn);
            } else if (this.reader.getLocalName().equals("productList")) {
                this.readReactionPart(1, rxn);
            } else {
                this.readCMLReactionProperties(rxn);
            }
            eventCode = this.nextInArray(MAIN_REACTION_TAGS);
        }
        MoleculeReader.setRxnAttributes(rxn, this.dimension);
        return rxn;
    }

    private void readReactionPart(int componentType, RxnMolecule rxn) throws XMLStreamException, IOException {
        int eventCode = this.nextInArray(REACTION_PART_TAGS);
        while (eventCode == 1) {
            Molecule m = this.readMolecule();
            m.setInputFormat("cml");
            rxn.addComponent(m, componentType);
            eventCode = this.nextInArray(REACTION_PART_TAGS);
        }
    }

    private void readMRVReactionProperties(RxnMolecule mol) throws XMLStreamException, IOException {
        boolean isX1Set = false;
        boolean isX2Set = false;
        boolean isY1Set = false;
        boolean isY2Set = false;
        DPoint3[] arrowPoints = new DPoint3[]{new DPoint3(), new DPoint3()};
        if (this.reader.getAttributeValue(null, "type") != null) {
            mol.setReactionArrowType(this.reader.getAttributeValue(null, "type"));
        }
        if (this.reader.getAttributeValue(null, "x1") != null) {
            arrowPoints[0].x = ReaderUtil.readDoubleValue(this.reader.getAttributeValue(null, "x1"), "Invalid reaction arrow coordinate(x1): ");
            isX1Set = true;
        }
        if (this.reader.getAttributeValue(null, "x2") != null) {
            arrowPoints[1].x = ReaderUtil.readDoubleValue(this.reader.getAttributeValue(null, "x2"), "Invalid reaction arrow coordinate(x2): ");
            isX2Set = true;
        }
        if (this.reader.getAttributeValue(null, "y1") != null) {
            arrowPoints[0].y = ReaderUtil.readDoubleValue(this.reader.getAttributeValue(null, "y1"), "Invalid reaction arrow coordinate(y1): ");
            isY1Set = true;
        }
        if (this.reader.getAttributeValue(null, "y2") != null) {
            arrowPoints[1].y = ReaderUtil.readDoubleValue(this.reader.getAttributeValue(null, "y2"), "Invalid reaction arrow coordinate(y2): ");
            isY2Set = true;
        }
        if (this.reader.getAttributeValue(null, "z1") != null) {
            arrowPoints[0].z = ReaderUtil.readDoubleValue(this.reader.getAttributeValue(null, "z1"), "Invalid reaction arrow coordinate(z1): ");
        }
        if (this.reader.getAttributeValue(null, "z2") != null) {
            arrowPoints[1].z = ReaderUtil.readDoubleValue(this.reader.getAttributeValue(null, "z2"), "Invalid reaction arrow coordinate(z2): ");
        }
        if (isX1Set && isX2Set && isY1Set && isY2Set) {
            mol.setReactionArrow(arrowPoints);
        }
        this.readUntilEndTagOf("arrow");
    }

    private void readCMLReactionProperties(RxnMolecule mol) throws XMLStreamException, IOException {
        boolean isX1Set = false;
        boolean isX2Set = false;
        boolean isY1Set = false;
        boolean isY2Set = false;
        DPoint3[] arrowPoints = new DPoint3[]{new DPoint3(), new DPoint3()};
        int eventCode = this.nextInArray(PROPERTYLIST_SUB_SUBTAGS);
        while (eventCode == 1) {
            if (this.reader.getAttributeValue(null, "dictRef") == null) {
                this.readUntilEndTagOf("property");
            } else if (this.reader.getAttributeValue(null, "dictRef").equals("marvin:arrowType")) {
                this.readReactionArrowProperty(mol);
                this.readUntilEndTagOf("property");
            } else if (this.reader.getAttributeValue(null, "dictRef").equals("marvin:x1")) {
                arrowPoints[0].x = this.readDoubleProperty();
                isX1Set = true;
                this.readUntilEndTagOf("property");
            } else if (this.reader.getAttributeValue(null, "dictRef").equals("marvin:x2")) {
                arrowPoints[1].x = this.readDoubleProperty();
                isX2Set = true;
                this.readUntilEndTagOf("property");
            } else if (this.reader.getAttributeValue(null, "dictRef").equals("marvin:y1")) {
                arrowPoints[0].y = this.readDoubleProperty();
                isY1Set = true;
                this.readUntilEndTagOf("property");
            } else if (this.reader.getAttributeValue(null, "dictRef").equals("marvin:y2")) {
                arrowPoints[1].y = this.readDoubleProperty();
                isY2Set = true;
                this.readUntilEndTagOf("property");
            } else if (this.reader.getAttributeValue(null, "dictRef").equals("marvin:z1")) {
                arrowPoints[0].z = this.readDoubleProperty();
                this.readUntilEndTagOf("property");
            } else if (this.reader.getAttributeValue(null, "dictRef").equals("marvin:z2")) {
                arrowPoints[1].z = this.readDoubleProperty();
                this.readUntilEndTagOf("property");
            } else {
                this.readMoleculeProperty(mol);
            }
            eventCode = this.nextInArray(PROPERTYLIST_SUB_SUBTAGS);
        }
        if (isX1Set && isX2Set && isY1Set && isY2Set) {
            mol.setReactionArrow(arrowPoints);
        }
    }

    private double readDoubleProperty() throws XMLStreamException, IOException {
        int eventCode = this.nextInArray(SCALAR_TAG);
        if (eventCode == 1) {
            this.reader.next();
            double result = ReaderUtil.readDoubleValue(this.readElementValue(), "Invalid reaction arrow coordinate: ");
            this.readUntilEndTagOf("scalar");
            return result;
        }
        throw new IOException("Invalid reaction arrow coordinate.");
    }

    private void readReactionArrowProperty(RxnMolecule rxn) throws XMLStreamException, IOException {
        this.nextInArray(SCALAR_TAG);
        if (this.reader.isStartElement()) {
            int type;
            this.reader.next();
            try {
                type = Integer.parseInt(this.readElementValue());
            }
            catch (NumberFormatException e) {
                throw new IOException("Invalid reaction arrow type: " + this.readElementValue());
            }
            if (!this.isLegalRxnArrowType(type)) {
                throw new IOException("Invalid reaction arrow type: " + type);
            }
            rxn.setReactionArrowType(type);
            this.readUntilEndTagOf("scalar");
            return;
        }
        throw new IOException("Invalid reaction arrow type");
    }

    private boolean isLegalRxnArrowType(int type) {
        return type == 0 || type == 2 || type == 1 || type == 3 || type == 1 || type == 3 || type == 2;
    }

    private String readElementValue() {
        if (this.reader.hasText()) {
            return this.reader.getText();
        }
        return null;
    }

    protected String modifyPropertyKeyCallback(String key) {
        return "marvin:" + key;
    }

    @Override
    public void close() throws IOException {
        try {
            this.reader.close();
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
        finally {
            this.inputStream.close();
        }
    }
}

