/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.cml;

import chemaxon.formats.MolFormatException;
import chemaxon.marvin.io.formats.cml.MTempMidPoint;
import chemaxon.marvin.io.formats.cml.MTempRectanglePoint;
import chemaxon.marvin.io.formats.cml.MoleculeReader;
import chemaxon.marvin.util.MolImportUtil;
import chemaxon.struc.MDocument;
import chemaxon.struc.MObject;
import chemaxon.struc.MPoint;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.PageSettings;
import chemaxon.struc.RgMolecule;
import chemaxon.struc.RxnMolecule;
import chemaxon.struc.graphics.MAtomSetPoint;
import chemaxon.struc.graphics.MChemicalStruct;
import chemaxon.struc.graphics.MEFlow;
import chemaxon.struc.graphics.MEFlowBasePoint;
import chemaxon.struc.graphics.MFont;
import chemaxon.struc.graphics.MMidPoint;
import chemaxon.struc.graphics.MPolyline;
import chemaxon.struc.graphics.MRectangle;
import chemaxon.struc.graphics.MRectanglePoint;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class DocumentReader {
    static void setPageEnabled(PageSettings pageSettings, String val) throws MolFormatException {
        if (val == null) {
            pageSettings.setEnabled(false);
        } else if (val.toLowerCase().equalsIgnoreCase("true")) {
            pageSettings.setEnabled(true);
        } else if (val.toLowerCase().equalsIgnoreCase("false")) {
            pageSettings.setEnabled(false);
        } else {
            throw new MolFormatException("MDocument property \" multipageEnabled\" is in bad format, boolean expected.");
        }
    }

    static void setSelectedPage(PageSettings pageSettings, String val) throws MolFormatException {
        if (val != null) {
            int pageNumber = 0;
            try {
                pageNumber = Integer.parseInt(val);
            }
            catch (NumberFormatException ex) {
                throw new MolFormatException("MDocument property \" multipageSelectedPage\" is in bad format, integer expected.");
            }
            if (pageNumber > 0) {
                pageSettings.setSelectedPage(pageNumber - 1);
            } else {
                throw new MolFormatException("MDocument property \" multipageSelectedPage\" is in bad format, positive integer expected.");
            }
        }
    }

    static void setColumnCount(PageSettings pageSettings, String val) throws MolFormatException {
        if (val != null) {
            int count = 0;
            try {
                count = Integer.parseInt(val);
            }
            catch (NumberFormatException ex) {
                throw new MolFormatException("MDocument property \" multipageColumnCount\" is in bad format, integer expected.");
            }
            if (count >= 0) {
                pageSettings.setColumnCount(count);
            } else {
                throw new MolFormatException("MDocument property \" multipageColumnCount\" is in bad format, non-negative integer expected.");
            }
        }
    }

    static void setRowCount(PageSettings pageSettings, String val) throws MolFormatException {
        if (val != null) {
            int count = 0;
            try {
                count = Integer.parseInt(val);
            }
            catch (NumberFormatException ex) {
                throw new MolFormatException("MDocument property \" multipageRowCount\" is in bad format, integer expected.");
            }
            if (count >= 0) {
                pageSettings.setRowCount(count);
            } else {
                throw new MolFormatException("MDocument property \" multipageRowCount\" is in bad format, non-negative integer expected.");
            }
        }
    }

    static void setAtomSetRGB(MDocument doc, int[][] atomSetRGB) {
        if (atomSetRGB != null) {
            for (int i = 0; i < atomSetRGB[0].length; ++i) {
                int seq = atomSetRGB[0][i];
                int cmode = atomSetRGB[1][i];
                if (cmode == 1) {
                    doc.setAtomSetRGB(seq, atomSetRGB[2][i]);
                    continue;
                }
                doc.setAtomSetColorMode(seq, cmode);
            }
        }
    }

    static void setAtomSetFont(MDocument doc, Map<Integer, MFont> atomSetFont) {
        if (atomSetFont != null) {
            for (Integer key : atomSetFont.keySet()) {
                if (key == null) continue;
                MFont mf = atomSetFont.get(key);
                doc.setAtomSetFont(key, mf);
            }
        }
    }

    static void setBondSetRGB(MDocument doc, int[][] bondSetRGB) {
        if (bondSetRGB != null) {
            for (int i = 0; i < bondSetRGB[0].length; ++i) {
                int seq = bondSetRGB[0][i];
                int cmode = bondSetRGB[1][i];
                if (cmode == 1) {
                    doc.setBondSetRGB(seq, bondSetRGB[2][i]);
                    continue;
                }
                doc.setBondSetColorMode(seq, cmode);
            }
        }
    }

    static void setExtraLabelSetRGB(MDocument doc, int[][] extraLabelSetRGB) {
        if (extraLabelSetRGB != null) {
            for (int i = 0; i < extraLabelSetRGB[0].length; ++i) {
                int seq = extraLabelSetRGB[0][i];
                int cmode = extraLabelSetRGB[1][i];
                if (cmode == 1) {
                    doc.setExtraLabelSetRGBs(seq, extraLabelSetRGB[2][i], extraLabelSetRGB[3][i]);
                    doc.setExtraLabelSetColorMode(seq, cmode);
                    continue;
                }
                doc.setExtraLabelSetColorMode(seq, cmode);
            }
        }
    }

    static void setBondSetThickness(MDocument doc, Map<Integer, Double> bondSetLT) {
        if (bondSetLT != null) {
            for (Integer key : bondSetLT.keySet()) {
                if (key == null) continue;
                doc.setBondSetThickness(key, bondSetLT.get(key));
            }
        }
    }

    static int[][] readSetRGB(String val, String propname, int nRGBs) throws MolFormatException {
        if (val == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(val, ", \t\n\r");
        int n = st.countTokens();
        int[][] rgb = new int[2 + nRGBs][n];
        for (int i = 0; i < n; ++i) {
            String s = st.nextToken();
            int k = s.indexOf(58);
            if (k < 0) {
                throw new MolFormatException("MDocument property \"" + propname + "\" is in bad format");
            }
            rgb[0][i] = Integer.parseInt(s.substring(0, k));
            if ((s = s.substring(k + 1)).charAt(0) == '#') {
                rgb[1][i] = 1;
                String cstr = s.substring(1);
                if (nRGBs == 1) {
                    rgb[2][i] = Integer.parseInt(cstr, 16);
                    continue;
                }
                int k1 = 0;
                int len = cstr.length();
                for (int j = 0; j < nRGBs && k1 < len; ++j) {
                    int k2 = cstr.indexOf("|#", k1);
                    if (k2 == -1) {
                        k2 = len;
                    }
                    rgb[2 + j][i] = Integer.parseInt(cstr.substring(k1, k2), 16);
                    k1 = k2 + 2;
                }
                continue;
            }
            if (s.equals("D")) {
                rgb[1][i] = 0;
                continue;
            }
            if (s.equals("N")) {
                rgb[1][i] = 2;
                continue;
            }
            throw new MolFormatException("MDocument property \"" + propname + "\" is in bad format," + " hexadecimal number expected");
        }
        return rgb;
    }

    static void initRectanglePoints(MDocument doc, Map<String, MObject> objHash) {
        for (int i = 0; i < doc.getObjectCount(); ++i) {
            MObject o = doc.getObject(i);
            if (!(o instanceof MPolyline)) continue;
            MPolyline pl = (MPolyline)o;
            MPoint[] points = pl.getPoints();
            boolean changed = false;
            for (int j = 0; j < points.length; ++j) {
                int pos;
                String ref;
                MPoint p;
                if (points[j] instanceof MTempMidPoint) {
                    p = (MTempMidPoint)points[j];
                    ref = ((MTempMidPoint)p).lineRef;
                    MPolyline l = (MPolyline)objHash.get(ref);
                    pos = ((MMidPoint)p).getPositionInPolyline();
                    points[j] = new MMidPoint.Sticky(l, pos);
                    changed = true;
                    continue;
                }
                if (!(points[j] instanceof MTempRectanglePoint)) continue;
                p = (MTempRectanglePoint)points[j];
                ref = ((MTempRectanglePoint)p).rectRef;
                MRectangle r = (MRectangle)objHash.get(ref);
                pos = ((MRectanglePoint)p).getPositionInRect();
                points[j] = new MRectanglePoint.Sticky(r, pos);
                changed = true;
            }
            if (!changed) continue;
            pl.setPoints(points);
        }
    }

    static MoleculeGraph findMol(MDocument doc, int im) {
        int count = 0;
        for (int i = 0; i < doc.getObjectCount(); ++i) {
            MObject mo = doc.getObject(i);
            if (!(mo instanceof MChemicalStruct)) continue;
            MChemicalStruct mcs = (MChemicalStruct)mo;
            MoleculeGraph m = mcs.getMoleculeGraph();
            if (m instanceof RxnMolecule) {
                RxnMolecule rxn = (RxnMolecule)m;
                Molecule mm = MoleculeReader.findInRxn(count, rxn, im);
                if (mm != null) {
                    return mm;
                }
                count += MoleculeReader.countSubMolecules(rxn);
                continue;
            }
            if (m instanceof RgMolecule) {
                RgMolecule rgmol = (RgMolecule)m;
                Molecule root = rgmol.getRoot();
                if (root instanceof RxnMolecule) {
                    RxnMolecule rxn = (RxnMolecule)root;
                    Molecule mm = MoleculeReader.findInRxn(count, rxn, im);
                    if (mm != null) {
                        return mm;
                    }
                    count += MoleculeReader.countSubMolecules(rxn);
                } else {
                    if (count == im) {
                        return root;
                    }
                    ++count;
                }
                for (int j = 0; j < rgmol.getRgroupCount(); ++j) {
                    for (int k = 0; k < rgmol.getRgroupMemberCount(j); ++k) {
                        if (count == im) {
                            return rgmol.getRgroupMember(j, k);
                        }
                        ++count;
                    }
                }
                continue;
            }
            if (count == im) {
                return m;
            }
            ++count;
        }
        return null;
    }

    static MolAtom findAtom(MDocument doc, String sm, String sa) throws MolFormatException {
        if (!sm.startsWith("m")) {
            throw new MolFormatException("molecule reference " + sm + " does not start with character `m'");
        }
        if (!sa.startsWith("a")) {
            throw new MolFormatException("atom reference " + sa + " does not start with character `a'");
        }
        int im = Integer.parseInt(sm.substring(1));
        int ia = Integer.parseInt(sa.substring(1));
        if (im < 1 || ia < 1) {
            throw new MolFormatException("molecule or atom number less than 1");
        }
        MoleculeGraph m = DocumentReader.findMol(doc, --im);
        return m.getAtom(--ia);
    }

    static void setEFlowBasePoints(MDocument doc, List<Object> eflowBasePointVector) throws MolFormatException {
        for (int i = 0; i < eflowBasePointVector.size(); i += 2) {
            String sa;
            MEFlowBasePoint p = (MEFlowBasePoint)eflowBasePointVector.get(i);
            String atomRef = (String)eflowBasePointVector.get(i + 1);
            StringTokenizer st = new StringTokenizer(atomRef, ".");
            String sm = st.nextToken();
            MolAtom atom = DocumentReader.findAtom(doc, sm, sa = st.nextToken());
            if (atom == null) {
                throw new MolFormatException("cannot find atom \"" + atomRef + "\"");
            }
            boolean found = false;
            for (int j = 0; j < doc.getObjectCount(); ++j) {
                MEFlow ef;
                MObject o = doc.getObject(j);
                if (!(o instanceof MEFlow) || (ef = (MEFlow)o).getPointRef(0, null) != p) continue;
                p.setStartEnd(atom, ef.getPointRef(1, null));
                found = true;
                break;
            }
            if (found) continue;
            throw new MolFormatException("cannot find containing electron flow arrow for " + p);
        }
    }

    static void setAtomSetPoints(MDocument doc, List<Object> atomSetPointVector) throws MolFormatException {
        for (int i = 0; i < atomSetPointVector.size(); i += 2) {
            MAtomSetPoint p = (MAtomSetPoint)atomSetPointVector.get(i);
            String atomRefs = (String)atomSetPointVector.get(i + 1);
            StringTokenizer st = new StringTokenizer(atomRefs);
            int n = st.countTokens();
            MolAtom[] atoms = new MolAtom[n];
            for (int j = 0; j < n; ++j) {
                String sa;
                String s = st.nextToken();
                StringTokenizer st2 = new StringTokenizer(s, ".");
                String sm = st2.nextToken();
                atoms[j] = DocumentReader.findAtom(doc, sm, sa = st2.nextToken());
                if (atoms[j] != null) continue;
                throw new MolFormatException("cannot find atom \"" + s + "\"");
            }
            p.setAtoms(atoms);
        }
    }

    static void endObjectReading(MDocument doc, Map<String, MObject> objHash, List<Object> atomSetPointVector, List<Object> eflowBasePointVector) throws MolFormatException {
        if (atomSetPointVector != null) {
            DocumentReader.setAtomSetPoints(doc, atomSetPointVector);
        }
        if (eflowBasePointVector != null) {
            DocumentReader.setEFlowBasePoints(doc, eflowBasePointVector);
        }
        DocumentReader.initRectanglePoints(doc, objHash);
        for (int i = 0; i < doc.getObjectCount(); ++i) {
            if (doc.getObject(i).checkValidity(doc, null)) continue;
            doc.removeObject(i);
        }
    }

    static void assignExtraLabelColors(MDocument doc, Molecule mol) {
        for (int i = 0; i < mol.getAtomCount(); ++i) {
            MolAtom a = mol.getAtom(i);
            int seq = a.getExtraLabelSetSeq();
            long rgb = doc.getExtraLabelSetRGBs(seq);
            if (rgb < 0L) {
                rgb = 0L;
                continue;
            }
            a.setExtraLabelColor(rgb);
        }
    }

    static void postProcessDocument(MDocument doc, boolean useSgroupAPO) {
        Molecule mol = (Molecule)doc.getMainMoleculeGraph();
        mol.setGUIContracted(false);
        if (!useSgroupAPO) {
            MolImportUtil.convertRgroupAttachments(mol);
        }
        MolImportUtil.convertAttachments(mol.getGraphUnion());
        DocumentReader.assignExtraLabelColors(doc, mol);
        mol.revalidateCoordDependentProps();
    }
}

