/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.cml;

import chemaxon.formats.MolFormatException;
import chemaxon.marvin.io.formats.cml.MTempMidPoint;
import chemaxon.marvin.io.formats.cml.MTempRectanglePoint;
import chemaxon.struc.MObject;
import chemaxon.struc.MPoint;
import chemaxon.struc.graphics.MAtomSetPoint;
import chemaxon.struc.graphics.MEFlowBasePoint;
import chemaxon.struc.graphics.MNameTextBox;
import chemaxon.struc.graphics.MPolyline;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MObjectReader {
    static List<Object> readMAtomSetPoint(List<Object> atomSetPointVector, boolean add, List<MPoint> points, String atomRefs, double[] weights) throws MolFormatException {
        MAtomSetPoint p = new MAtomSetPoint();
        p.setWeights(weights);
        if (add) {
            points.add(p);
        }
        if (atomSetPointVector == null) {
            atomSetPointVector = new ArrayList<Object>();
        }
        atomSetPointVector.add(p);
        atomSetPointVector.add(atomRefs);
        return atomSetPointVector;
    }

    static List<Object> readMEFlowBasePoint(List<Object> eflowBasePointVector, boolean add, List<MPoint> points, String atomRef) {
        MEFlowBasePoint basep = new MEFlowBasePoint();
        if (eflowBasePointVector == null) {
            eflowBasePointVector = new ArrayList<Object>();
        }
        eflowBasePointVector.add(basep);
        eflowBasePointVector.add(atomRef);
        if (add) {
            points.add(basep);
        }
        return eflowBasePointVector;
    }

    static void readMMidPoint(boolean add, List<MPoint> points, String spos, String ref) {
        int pos = 0;
        if (spos != null) {
            try {
                pos = Integer.parseInt(spos);
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        if (add) {
            points.add(new MTempMidPoint(ref, pos));
        }
    }

    static void readMRectanglePoint(boolean add, List<MPoint> points, String spos, String ref) {
        int pos = -1;
        try {
            pos = Integer.parseInt(spos);
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        if (add) {
            points.add(new MTempRectanglePoint(ref, pos));
        }
    }

    static void readMPoint(boolean add, List<MPoint> points, String sx, String sy, String sz) {
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        try {
            if (sx != null) {
                x = Double.valueOf(sx);
            }
            if (sy != null) {
                y = Double.valueOf(sy);
            }
            if (sz != null) {
                z = Double.valueOf(sz);
            }
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        if (add) {
            points.add(new MPoint(x, y, z));
        }
    }

    static void initGraphicsObject(Map<String, String> attrHash, MObject o, Map<String, MObject> objHash, MPoint[] points) throws MolFormatException {
        Iterator<String> it = attrHash.keySet().iterator();
        try {
            while (it.hasNext()) {
                String key = it.next();
                String val = attrHash.get(key);
                if (key.equalsIgnoreCase("id")) {
                    if (objHash == null) continue;
                    objHash.put(val, o);
                    continue;
                }
                o.setAttribute(key, val);
            }
        }
        catch (IllegalArgumentException ex) {
            throw new MolFormatException(ex.getMessage());
        }
        if (o instanceof MPolyline) {
            boolean oldResizingBehavior = false;
            if (o instanceof MNameTextBox) {
                oldResizingBehavior = ((MNameTextBox)o).isAutoResize();
            }
            ((MPolyline)o).setPoints(points);
            if (o instanceof MNameTextBox) {
                ((MNameTextBox)o).setAutoResize(oldResizingBehavior);
            }
        }
    }

    static MPoint[] toArray(List<MPoint> points) {
        MPoint[] p = new MPoint[points.size()];
        points.toArray(p);
        return p;
    }
}

