/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.cml;

import chemaxon.formats.MolFormatException;
import chemaxon.marvin.io.formats.cml.BicycloStereoIndexDescriptor;
import chemaxon.marvin.io.formats.cml.ParsedData;
import chemaxon.marvin.util.MolImportUtil;
import chemaxon.struc.BicycloStereoDescriptor;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.RgMolecule;
import chemaxon.struc.RxnMolecule;
import java.util.ArrayList;
import java.util.Map;

public class MoleculeReader {
    static final int[] REACTION_LIST_IDS = new int[]{0, 2, 1};

    static void setRlogic(RgMolecule m, int r1, String thenRstr, String restHstr, String range) throws MolFormatException {
        r1 &= Short.MAX_VALUE;
        int r2 = -1;
        if (thenRstr != null) {
            try {
                r2 = Integer.parseInt(thenRstr);
            }
            catch (NumberFormatException ex) {
                throw new MolFormatException("invalid thenR value");
            }
        }
        int restH = 0;
        if (restHstr != null && (restHstr.equalsIgnoreCase("on") || restHstr.equals("1") || restHstr.equalsIgnoreCase("true"))) {
            restH = Integer.MIN_VALUE;
        }
        int f = r1 | restH;
        if (r2 >= 0) {
            f |= 0x8000 | (r2 & Short.MAX_VALUE) << 16;
        }
        int i = m.findRgroupIndex(r1);
        m.setRlogic(i, f);
        if (range != null) {
            m.setRlogicRange(i, range);
        }
    }

    static Molecule findInRxn(int count, RxnMolecule rxn, int im) {
        for (int i = 0; i < REACTION_LIST_IDS.length; ++i) {
            int f = REACTION_LIST_IDS[i];
            int n = rxn.getComponentCount(f);
            if (count + n > im) {
                return rxn.getComponent(f, im - count);
            }
            count += n;
        }
        return null;
    }

    static int countSubMolecules(RxnMolecule rxn) {
        int count = 0;
        for (int i = 0; i < REACTION_LIST_IDS.length; ++i) {
            int f = REACTION_LIST_IDS[i];
            count += rxn.getComponentCount(f);
        }
        return count;
    }

    static RxnMolecule initRxnMolecule(Molecule mol) throws MolFormatException {
        RxnMolecule rxn = null;
        if (mol instanceof RxnMolecule) {
            rxn = (RxnMolecule)mol;
        } else if (mol instanceof RgMolecule) {
            RgMolecule rgmol = (RgMolecule)mol;
            Molecule m = rgmol.getRoot();
            if (m instanceof RxnMolecule) {
                rxn = (RxnMolecule)m;
            } else {
                rxn = new RxnMolecule();
                MolImportUtil.addProperties(rxn.properties(), rgmol.getRoot().properties());
                rgmol.setRoot(rxn);
            }
        }
        if (rxn == null) {
            throw new MolFormatException("cannot read reaction into non-reaction molecule object");
        }
        return rxn;
    }

    static void setRxnAttributes(RxnMolecule rxn, int dimension) {
        if (rxn.getReactionArrow(false) == null) {
            rxn.setReactionArrow0();
        }
        rxn.setDim(dimension);
    }

    static String getMolID(String id, String molId) {
        return id != null ? id : molId;
    }

    static int getBicycloStereoValue(String tagProperty) throws MolFormatException {
        if (tagProperty == null) {
            throw new MolFormatException("Missing bicyclo stereo value in atom bicyclo stereo description");
        }
        String value = tagProperty.replaceAll("\"", "");
        if (value.equals("either")) {
            return 6;
        }
        if (value.equals("lower")) {
            return 5;
        }
        if (value.equals("higher")) {
            return 4;
        }
        throw new MolFormatException("unknown bicyclo stereo value: " + tagProperty);
    }

    static BicycloStereoIndexDescriptor readAtomBicycloStereo(String connectionAtom, String[] lowBridge, String[] highBridge, String value) throws MolFormatException {
        if (connectionAtom == null) {
            throw new MolFormatException("Missing connectionAtom attribute in atom bicyclo stereo description");
        }
        BicycloStereoIndexDescriptor descriptor = new BicycloStereoIndexDescriptor();
        descriptor.connectionAtom = connectionAtom;
        descriptor.lowBridge = lowBridge;
        descriptor.highBridge = highBridge;
        descriptor.stereoValue = MoleculeReader.getBicycloStereoValue(value);
        return descriptor;
    }

    public static void setBicycloStereoDescriptors(Molecule mol, ParsedData parsedData) {
        for (MolAtom a : parsedData.bicycloStereoHash.keySet()) {
            ArrayList<BicycloStereoIndexDescriptor> indexDescriptors = parsedData.bicycloStereoHash.get(a);
            if (indexDescriptors == null) continue;
            BicycloStereoDescriptor[] descriptors = new BicycloStereoDescriptor[indexDescriptors.size()];
            for (int i = 0; i < descriptors.length; ++i) {
                BicycloStereoIndexDescriptor indexDescriptor = indexDescriptors.get(i);
                MolAtom connectionAtom = parsedData.idAtomHash.get(indexDescriptor.connectionAtom);
                MolAtom[] highBridge = MoleculeReader.getBridgeAtoms(parsedData.idAtomHash, indexDescriptor.highBridge);
                MolAtom[] lowBridge = MoleculeReader.getBridgeAtoms(parsedData.idAtomHash, indexDescriptor.lowBridge);
                descriptors[i] = new BicycloStereoDescriptor(connectionAtom, indexDescriptor.stereoValue, highBridge, lowBridge);
            }
            a.setBicycloStereo(descriptors);
        }
    }

    static MolAtom[] getBridgeAtoms(Map<String, MolAtom> idAtomHash, String[] bridgeIndexes) {
        MolAtom[] highBridge = new MolAtom[bridgeIndexes.length - 1];
        for (int i = 0; i < bridgeIndexes.length - 1; ++i) {
            highBridge[i] = idAtomHash.get(bridgeIndexes[i]);
        }
        return highBridge;
    }
}

