/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.cml;

import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.Sgroup;
import java.io.IOException;
import java.util.Set;

public class ReaderUtil {
    protected static Integer getTagPropertyAsInteger(String s) {
        if (s != null) {
            try {
                if (s.startsWith("+")) {
                    s = s.substring(1);
                }
                return Integer.valueOf(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    static double readDoubleValue(String valueString, String errorMsg) throws IOException {
        double value;
        try {
            value = Double.parseDouble(valueString);
        }
        catch (NumberFormatException e) {
            throw new IOException(errorMsg + valueString);
        }
        return value;
    }

    static Sgroup getSgroup(MolAtom a, MoleculeGraph mol) {
        if (mol instanceof Molecule) {
            return ((Molecule)mol).findSmallestSgroupContaining(a);
        }
        return null;
    }

    public static void valenceCheck(Molecule mol, Set<MolAtom> atomsWithHcount) {
        if (atomsWithHcount.size() == 0) {
            mol.valenceCheck();
        } else {
            int n = mol.getAtomCount();
            for (int i = 0; i < n; ++i) {
                MolAtom a = mol.getAtom(i);
                if (atomsWithHcount.contains(a)) continue;
                a.valenceCheck();
            }
        }
    }
}

