/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.d2s;

import chemaxon.common.util.ByteVector;
import chemaxon.formats.recognizer.Recognizer;
import chemaxon.formats.recognizer.RecognizerList;
import chemaxon.util.LoggingUtil;
import java.util.logging.Logger;
import org.apache.tika.Tika;

public class D2SRecognizer
extends Recognizer {
    private String ourFormat;
    ByteVector data = new ByteVector();
    int nbChars;
    int nbLetters;
    int nbWhitespace;
    private boolean needsMore;
    private static final Logger logger = LoggingUtil.getLogger(D2SRecognizer.class);

    public D2SRecognizer(String fmt) {
        this.ourFormat = fmt;
    }

    @Override
    public void tryToRecognize(String line, int linenum, RecognizerList reclist) {
        int i = line.length();
        while (--i >= 0) {
            char c = line.charAt(i);
            if (Character.getType(c) == 15) {
                reclist.remove("d2s");
                return;
            }
            ++this.nbChars;
            if (Character.isLetter(c)) {
                ++this.nbLetters;
            }
            if (!Character.isWhitespace(c)) continue;
            ++this.nbWhitespace;
        }
        if (this.notFreeTextLike()) {
            reclist.remove("d2s");
        }
    }

    private boolean notFreeTextLike() {
        if (this.nbLetters < this.nbChars / 2) {
            return true;
        }
        return this.nbWhitespace < this.nbChars / 20;
    }

    private Result recognize() {
        String mime = new Tika().detect(this.data.toArray());
        logger.fine("Currently recognized mime type: " + mime);
        if (mime == null) {
            return Result.Failed;
        }
        return Result.NeedsMore;
    }

    @Override
    public boolean needsMore() {
        return this.needsMore;
    }

    private static enum Result {
        Recognized,
        Failed,
        NeedsMore;

    }
}

