/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.gaussian;

import chemaxon.marvin.io.formats.xyz.XYZExport;
import chemaxon.marvin.modules.mprop.VolumetricData;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;

public class CubeExport
extends XYZExport {
    public static final String VDATA_PROPKEY = "VOLUMETRIC_DATA";
    private static final double ANGSTROMS_TO_BOHR_FACTOR = 1.889726;

    private static double convertBeforeExport(double v) {
        return v * 1.889726;
    }

    @Override
    public Object convert(Molecule mol) {
        int i;
        StringBuffer s = this.stringBuffer;
        s.setLength(0);
        mol = this.preconvert(mol);
        VolumetricData vdata = (VolumetricData)mol.properties().get(VDATA_PROPKEY);
        if (vdata == null) {
            vdata = new VolumetricData();
        }
        s.append(vdata.comment1);
        s.append("\n");
        s.append(vdata.comment2);
        s.append("\n");
        int na = mol.getAtomCount();
        if (na < 10) {
            s.append(" ");
        }
        s.append("   ");
        s.append(String.valueOf(na));
        for (i = 0; i < 3; ++i) {
            this.appendRight(CubeExport.convertBeforeExport(vdata.origo[i]));
        }
        s.append("\n");
        for (i = 0; i < 3; ++i) {
            s.append("   ");
            s.append(" " + vdata.size[2 - i]);
            for (int j = 0; j < 3; ++j) {
                this.appendRight(CubeExport.convertBeforeExport(vdata.axes[i][j]));
            }
            s.append("\n");
        }
        for (i = 0; i < na; ++i) {
            MolAtom a = mol.getAtom(i);
            int atno = a.getAtno();
            if (atno < 100) {
                s.append(" ");
            }
            if (atno < 10) {
                s.append(" ");
            }
            s.append("  ");
            s.append(atno);
            this.appendRight(atno);
            double x = a.getX();
            double y = a.getY();
            double z = a.getZ();
            this.appendRight(CubeExport.convertBeforeExport(x));
            this.appendRight(CubeExport.convertBeforeExport(y));
            this.appendRight(CubeExport.convertBeforeExport(z));
            s.append("\n");
        }
        s.append(vdata.convertGridToString());
        return s.toString();
    }

    private void appendRight(double t) {
        int iy;
        double y = Math.abs(t);
        int b = (int)(1000000.0 * (y - (double)(iy = (int)y)) + 0.5);
        if (b == 1000000) {
            ++iy;
        }
        String sb = "000000".concat(String.valueOf(b));
        int l = sb.length();
        String r = String.valueOf(iy).concat(".");
        r = r.concat(sb.substring(l - 6, l));
        r = (t < 0.0 ? "     -" : "      ").concat(r);
        l = r.length();
        r = r.substring(l - 12, l);
        this.stringBuffer.append(r);
    }
}

