/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.gaussian;

import chemaxon.marvin.io.MolExportException;
import chemaxon.marvin.io.MolExportModule;
import chemaxon.marvin.modelling.struc.MolGeom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.PeriodicSystem;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;

public class GjfZExport
extends MolExportModule {
    private static final String GAUSSIAN_COMMAND = "# opt=z-matrix am1 geom=connectivity\n";
    private static final String SEP = " ";
    private ArrayList<Variable> vars = new ArrayList();
    private static DecimalFormat df = new DecimalFormat("0.00000000");
    private double[][] c;
    private int[][] ctab;
    private int bondSeq = 0;
    private int angleSeq = 0;
    private int dihSeq = 0;
    private BitSet visited;
    private int atomSeqInGjf;
    private int[] mol2gjfPositions;
    private ArrayList<MolBond> addedBonds;

    private int charge(Molecule m) {
        double charge = 0.0;
        for (int i = 0; i < m.getAtomCount(); ++i) {
            charge += (double)m.getAtom(i).getCharge();
        }
        return (int)charge;
    }

    private void add(int prev, Molecule mol) throws MolGeom.LinearBondAngleException {
        if (this.ctab[prev] == null && this.ctab[prev].length == 0) {
            return;
        }
        for (int j = 0; j < this.ctab[prev].length; ++j) {
            int n = this.ctab[prev][j];
            boolean selected = mol.getAtom(n).isSelected();
            if (this.visited.get(n)) continue;
            this.stringBuffer.append(PeriodicSystem.getSymbol(mol.getAtom(n).getAtno()));
            double d = MolGeom.getLength(this.c[prev], this.c[n]);
            Variable bond = new Variable("B", this.bondSeq, d);
            this.mol2gjfPositions[n] = ++this.atomSeqInGjf;
            this.stringBuffer.append(SEP);
            this.stringBuffer.append(this.getGjf(prev));
            this.stringBuffer.append(SEP);
            if (!selected) {
                this.stringBuffer.append(bond.getVariableName());
                this.vars.add(bond);
            } else {
                this.stringBuffer.append(bond.getDFormatted());
            }
            if (this.bondSeq > 1) {
                int anglePos = this.visitedButNotCurrent(n, prev);
                double a = Math.toDegrees(MolGeom.getAngle(n, prev, anglePos, this.c));
                Variable angle = new Variable("A", this.angleSeq, a);
                this.stringBuffer.append(SEP);
                this.stringBuffer.append(this.getGjf(anglePos));
                this.stringBuffer.append(SEP);
                ++this.angleSeq;
                if (!selected) {
                    this.stringBuffer.append(angle.getVariableName());
                    this.vars.add(angle);
                } else {
                    this.stringBuffer.append(angle.getDFormatted());
                }
                if (this.bondSeq > 2) {
                    int dihedPos = this.visitedButNotCurrent(prev, anglePos);
                    if (dihedPos == -1) {
                        dihedPos = this.visitedButNotCurrent(anglePos, n, prev);
                    }
                    double dih = Math.toDegrees(MolGeom.getDihedral(n, prev, anglePos, dihedPos, this.c, false));
                    Variable dihed = new Variable("D", this.dihSeq, dih);
                    this.stringBuffer.append(SEP);
                    this.stringBuffer.append(this.getGjf(dihedPos));
                    this.stringBuffer.append(SEP);
                    ++this.dihSeq;
                    if (!selected) {
                        this.stringBuffer.append(dihed.getVariableName());
                        this.vars.add(dihed);
                    } else {
                        this.stringBuffer.append(dihed.getDFormatted());
                    }
                    this.stringBuffer.append(SEP);
                    this.stringBuffer.append("0");
                }
            }
            this.stringBuffer.append("\n");
            ++this.bondSeq;
            this.visited.set(n, true);
            this.add(n, mol);
        }
    }

    private int getGjf(int pos) {
        if (this.mol2gjfPositions[pos] == 0) {
            throw new IllegalStateException("Zero returned");
        }
        if (this.mol2gjfPositions[pos] >= this.atomSeqInGjf) {
            throw new IllegalStateException(this.mol2gjfPositions[pos] + " should not exceed " + this.atomSeqInGjf);
        }
        return this.mol2gjfPositions[pos];
    }

    private int visitedButNotCurrent(int current, int center) {
        for (int i = 0; i < this.ctab[center].length; ++i) {
            if (this.ctab[center][i] == current || !this.visited.get(this.ctab[center][i])) continue;
            return this.ctab[center][i];
        }
        return -1;
    }

    private int visitedButNotCurrent(int current1, int current2, int center) {
        for (int i = 0; i < this.ctab[center].length; ++i) {
            if (this.ctab[center][i] == current1 || this.ctab[center][i] == current2 || !this.visited.get(this.ctab[center][i])) continue;
            return this.ctab[center][i];
        }
        return -1;
    }

    private Molecule connectFragments(Molecule mol, double[][] crds) {
        if (mol.getFragCount() <= 1) {
            return mol;
        }
        Molecule ret = mol.cloneMolecule();
        while (ret.getFragCount() > 1) {
            int imin = -1;
            int jmin = -1;
            double dmin = 0.0;
            int[] frags = ret.getFragIds();
            for (int i = 0; i < ret.getAtomCount() - 1; ++i) {
                for (int j = i + 1; j < ret.getAtomCount(); ++j) {
                    if (frags[i] == frags[j]) continue;
                    double d = MolGeom.getLength(crds[i], crds[j]);
                    if (imin != -1 && !(dmin > d)) continue;
                    imin = i;
                    jmin = j;
                    dmin = d;
                }
            }
            MolBond mb = new MolBond(ret.getAtom(imin), ret.getAtom(jmin));
            this.addedBonds.add(mb);
            ret.add(mb);
        }
        return ret;
    }

    private void removeAddedBonds(Molecule m) {
        for (MolBond molBond : this.addedBonds) {
            m.removeBond(molBond);
        }
    }

    @Override
    public Object convert(Molecule mol) throws MolExportException {
        this.visited = new BitSet();
        this.atomSeqInGjf = 0;
        this.bondSeq = 1;
        this.angleSeq = 1;
        this.dihSeq = 1;
        this.addedBonds = new ArrayList();
        this.c = MolGeom.getCoordniates(mol);
        Molecule oneFrag = this.connectFragments(mol, this.c);
        this.ctab = oneFrag.getCtab();
        this.mol2gjfPositions = new int[oneFrag.getAtomCount()];
        this.vars.clear();
        this.stringBuffer.setLength(0);
        this.stringBuffer.append(GAUSSIAN_COMMAND);
        this.stringBuffer.append("\n");
        this.stringBuffer.append("Gaussian Z matrix generated by Marvin ");
        boolean sel = false;
        for (int idx = 0; idx < oneFrag.getAtomCount(); ++idx) {
            if (!oneFrag.getAtom(idx).isSelected()) continue;
            if (!sel) {
                this.stringBuffer.append("selected atoms: ");
                sel = true;
            }
            this.stringBuffer.append(idx + 1).append(SEP);
        }
        this.stringBuffer.append("\n\n");
        this.stringBuffer.append(this.charge(oneFrag));
        this.stringBuffer.append(" 1\n");
        if (oneFrag.getAtomCount() > 0) {
            int i;
            this.stringBuffer.append(PeriodicSystem.getSymbol(oneFrag.getAtom(0).getAtno())).append("\n");
            this.visited.set(0, true);
            this.mol2gjfPositions[0] = ++this.atomSeqInGjf;
            if (oneFrag.getAtomCount() > 1) {
                try {
                    this.add(0, oneFrag);
                    this.removeAddedBonds(oneFrag);
                    this.ctab = oneFrag.getCtab();
                }
                catch (MolGeom.LinearBondAngleException li) {
                    throw new RuntimeException(li);
                }
            }
            this.stringBuffer.append("\n");
            Collections.sort(this.vars, new VariableComparator());
            for (Variable variable : this.vars) {
                this.stringBuffer.append(variable);
                this.stringBuffer.append("\n");
            }
            this.stringBuffer.append("\n");
            BitSet wasBond = new BitSet(oneFrag.getBondCount());
            int[] inverted = new int[this.mol2gjfPositions.length + 1];
            for (i = 0; i < this.mol2gjfPositions.length; ++i) {
                inverted[this.mol2gjfPositions[i]] = i;
            }
            for (i = 1; i < inverted.length; ++i) {
                this.stringBuffer.append(i);
                this.stringBuffer.append(SEP);
                int m = inverted[i];
                for (int j = 0; j < this.ctab[m].length; ++j) {
                    int k = this.ctab[m][j];
                    int bi = oneFrag.getBondTable().getBondIndex(m, k);
                    if (wasBond.get(bi)) continue;
                    this.stringBuffer.append(this.mol2gjfPositions[k]);
                    this.stringBuffer.append(SEP);
                    MolBond mb = oneFrag.getBond(bi);
                    String bondType = "1.0";
                    if (mb.getType() == 2) {
                        bondType = "2.0";
                    }
                    if (mb.getType() == 3) {
                        bondType = "3.0";
                    }
                    if (mb.getType() == 4) {
                        bondType = "1.5";
                    }
                    this.stringBuffer.append(bondType);
                    this.stringBuffer.append(SEP);
                    wasBond.set(bi, true);
                }
                this.stringBuffer.append("\n");
            }
        }
        return this.stringBuffer.toString();
    }

    private int getFirstNonVisitedAtom() {
        for (int i = 0; i < this.visited.size(); ++i) {
            if (this.visited.get(i)) continue;
            return i;
        }
        return -1;
    }

    private static class VariableComparator
    implements Comparator<Variable> {
        private VariableComparator() {
        }

        @Override
        public int compare(Variable o1, Variable o2) {
            if (o1.isBond() && (o2.isAngle() || o2.isDih())) {
                return -1;
            }
            if (o1.isAngle() && o2.isDih()) {
                return -1;
            }
            if (o1.isAngle() && o2.isBond()) {
                return 1;
            }
            if (o1.isDih() && (o2.isBond() || o2.isAngle())) {
                return 1;
            }
            if (!o1.s.equals(o2.s)) {
                throw new IllegalStateException();
            }
            return o1.seq - o2.seq;
        }
    }

    private static class Variable {
        private String s;
        private double d;
        private int seq;

        Variable(String s, int seq, double d) {
            this.s = s;
            this.d = d;
            this.seq = seq;
        }

        public String getVariableName() {
            return this.s + this.seq;
        }

        public double getD() {
            return this.d;
        }

        public String toString() {
            return this.getVariableName() + GjfZExport.SEP + this.getDFormatted();
        }

        public boolean isBond() {
            return this.s.equals("B");
        }

        public boolean isAngle() {
            return this.s.equals("A");
        }

        public boolean isDih() {
            return this.s.equals("D");
        }

        public String getDFormatted() {
            return df.format(this.d);
        }
    }
}

