/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.inchi;

import chemaxon.marvin.util.Environment;
import chemaxon.marvin.util.InstallFromJar;
import chemaxon.util.DotfileUtil;
import chemaxon.util.FindCodeBase;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import net.sf.jniinchi.JniInchiWrapper;

public class Inchi {
    public static final String INCHI_VERSION = "1.3";
    private static File inchiDir = null;
    private static String libname = null;
    private static boolean loaded = false;
    private static Exception instErr = null;
    private static Object syncLock = new Object();

    public static void configure() throws SecurityException {
        if (Environment.UNTRUSTED) {
            throw new SecurityException("Non secure context: InChi library is not accessible");
        }
        libname = System.mapLibraryName("inchi");
        String arch = System.getProperty("os.arch");
        if (Environment.LINUX && arch != null && arch.endsWith("64")) {
            libname = System.mapLibraryName("inchi64");
        }
        if (Environment.MSWINDOWS && arch != null && arch.endsWith("64")) {
            libname = System.mapLibraryName("inchi64");
        }
        inchiDir = DotfileUtil.getDotFile("lib/inchi-1.3");
    }

    public static void install() throws IOException {
        if (!inchiDir.exists() && !inchiDir.mkdirs()) {
            throw new IOException("Cannot create " + inchiDir.getAbsolutePath());
        }
        File inchiNatlibFile = new File(inchiDir, libname);
        if (!inchiNatlibFile.exists()) {
            Inchi.installNative(inchiNatlibFile);
        }
        Inchi.loadNative(inchiNatlibFile);
    }

    private static void installNative(File inchiNatlibFile) throws IOException {
        if (Inchi.installFromResource(inchiNatlibFile)) {
            return;
        }
        String codeBaseDir = null;
        URL codeBase = Environment.getCodeBase();
        if (codeBase == null) {
            codeBaseDir = Inchi.getCodeBaseDir();
            if (Environment.JAVAWEBSTART && FindCodeBase.isURL(codeBaseDir)) {
                codeBase = new URL(codeBaseDir);
            }
        }
        if (codeBase != null) {
            Inchi.installFromURL(codeBase);
        } else if (codeBaseDir != null) {
            Inchi.installFromJar(codeBaseDir, inchiNatlibFile);
        }
    }

    private static String getCodeBaseDir() {
        String codebasedir;
        try {
            Class<?> c = Class.forName("chemaxon.inchi.natives.InchiNative");
            codebasedir = FindCodeBase.getCodeBaseDir("/chemaxon/inchi/natives/InchiNative.class");
        }
        catch (Throwable thw) {
            codebasedir = FindCodeBase.getCodeBaseDir();
        }
        return codebasedir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean installFromResource(File inchiNatlibFile) throws IOException {
        boolean success = false;
        InputStream libStream = Inchi.class.getResourceAsStream("/" + libname);
        if (libStream != null) {
            try {
                FileOutputStream natLibTarget = new FileOutputStream(inchiNatlibFile);
                try {
                    int n;
                    byte[] buffer = new byte[4096];
                    while ((n = libStream.read(buffer)) != -1) {
                        natLibTarget.write(buffer, 0, n);
                    }
                    success = true;
                }
                finally {
                    natLibTarget.close();
                }
            }
            finally {
                libStream.close();
            }
        }
        return success;
    }

    private static void installFromJar(String codebasedir, File inchiNatlibFile) throws IOException {
        String natjarname = null;
        natjarname = Environment.JAVAWEBSTART ? Inchi.getNativeJarName("RM", null) : Inchi.getNativeJarName(null, null);
        File localjar = new File(codebasedir, natjarname);
        InstallFromJar.extractFromJar(localjar, libname, inchiDir);
    }

    private static void installFromURL(URL codebase) throws IOException {
        String natjarname = Inchi.getNativeJarName(null, null);
        URL remotejar = new URL(codebase, natjarname);
        File localjar = new File(inchiDir, natjarname);
        Environment.downloadURL(remotejar, localjar);
        InstallFromJar.extractFromJar(localjar, libname, inchiDir);
    }

    private static void loadNative(File inchiNatlibFile) {
        if (inchiNatlibFile.canRead()) {
            try {
                JniInchiWrapper.loadLibrary((String)inchiNatlibFile.getCanonicalPath());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String getNativeDinamicLinkLibraryName() {
        return libname;
    }

    public String getInChIDirectory() {
        return inchiDir.getAbsolutePath();
    }

    public static String getNativeJarName(String cachePrefix, String cachePostfix) throws IOException {
        String jarname = null;
        if (Environment.MSWINDOWS) {
            String arch = System.getProperty("os.arch");
            jarname = arch != null && arch.endsWith("64") ? "inchi-native-windows64-1.3.jar" : "inchi-native-windows-1.3.jar";
        } else if (Environment.MACOS) {
            jarname = "inchi-native-macosx-1.3.jar";
        } else if (Environment.LINUX) {
            String arch = System.getProperty("os.arch");
            jarname = arch != null && arch.endsWith("64") ? "inchi-native-linux64-1.3.jar" : "inchi-native-linux-1.3.jar";
        } else {
            throw new IOException("Unsupported platform: no InChi library for this platform");
        }
        if (Environment.JAVAWEBSTART) {
            if (cachePrefix != null) {
                jarname = cachePrefix + jarname;
            }
            if (cachePostfix != null) {
                jarname = jarname + cachePostfix;
            }
        }
        return jarname;
    }

    public static boolean init() {
        if (instErr != null) {
            return false;
        }
        if (!loaded) {
            try {
                Inchi.configure();
                Inchi.install();
                loaded = true;
            }
            catch (Exception e) {
                instErr = e;
                return false;
            }
        }
        return true;
    }

    static {
        try {
            Inchi.configure();
            Inchi.install();
            loaded = true;
        }
        catch (Exception e) {
            instErr = e;
        }
    }
}

