/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.inchi;

import chemaxon.marvin.io.MolExportException;
import chemaxon.marvin.io.MolExportModule;
import chemaxon.marvin.io.formats.inchi.Inchi;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.PeriodicSystem;
import java.util.ArrayList;
import java.util.List;
import net.sf.jniinchi.INCHI_BOND_TYPE;
import net.sf.jniinchi.INCHI_PARITY;
import net.sf.jniinchi.INCHI_RADICAL;
import net.sf.jniinchi.JniInchiAtom;
import net.sf.jniinchi.JniInchiBond;
import net.sf.jniinchi.JniInchiInput;
import net.sf.jniinchi.JniInchiOutput;
import net.sf.jniinchi.JniInchiStereo0D;
import net.sf.jniinchi.JniInchiStructure;
import net.sf.jniinchi.JniInchiWrapper;

public class InchiExport
extends MolExportModule {
    static final String IGNORE_WARNINGS = "Woff";
    protected ArrayList<String> optC = new ArrayList();
    protected static final String OPTION_STARTER_CHARACTER;
    protected boolean auxInfoNeeded;
    protected boolean inchikeyNeeded;
    protected boolean warningsNeeded;

    @Override
    public boolean isCleanable() {
        return false;
    }

    protected void getOptionDescriptors(String fmtname, String optnames, List l) {
    }

    @Override
    public Object convert(Molecule mol) throws MolExportException {
        String inchiString = "";
        try {
            String inchiKey;
            mol = this.initInchi(mol);
            this.auxInfoNeeded = true;
            this.inchikeyNeeded = false;
            this.warningsNeeded = true;
            String inchiopts = this.createOptionString();
            JniInchiStructure jnistruc = new JniInchiStructure();
            this.convertStructure(mol, jnistruc);
            JniInchiOutput jniout = JniInchiWrapper.getInchi((JniInchiInput)new JniInchiInput(jnistruc, inchiopts));
            switch (jniout.getReturnStatus()) {
                case OKAY: {
                    break;
                }
                case WARNING: {
                    if (!this.warningsNeeded) break;
                    System.err.println(jniout.getMessage());
                    break;
                }
                case EOF: {
                    throw new MolExportException("No structure found.");
                }
                default: {
                    throw new MolExportException(jniout.getMessage());
                }
            }
            inchiString = jniout.getInchi() + "\n";
            if (this.auxInfoNeeded && jniout.getAuxInfo() != null && jniout.getAuxInfo().length() > 0) {
                inchiString = inchiString + jniout.getAuxInfo() + "\n";
            }
            if (this.inchikeyNeeded && (inchiKey = JniInchiWrapper.getInchiKey((String)jniout.getInchi()).getKey()) != null && inchiKey.length() > 0) {
                inchiString = inchiString + "InChIKey=" + inchiKey + "\n";
            }
        }
        catch (Exception e) {
            throw new MolExportException(e.getMessage());
        }
        return inchiString;
    }

    protected String createOptionString() {
        StringBuilder inchiopts = new StringBuilder(OPTION_STARTER_CHARACTER).append("WarnOnEmptyStructure");
        for (int i = 0; i < this.optC.size(); ++i) {
            String nextOption = this.optC.get(i);
            if (nextOption.equalsIgnoreCase("auxnone")) {
                this.auxInfoNeeded = false;
            }
            if (nextOption.equalsIgnoreCase("key")) {
                this.inchikeyNeeded = true;
                continue;
            }
            if (nextOption.equalsIgnoreCase(IGNORE_WARNINGS)) {
                this.warningsNeeded = false;
                continue;
            }
            inchiopts.append(" ");
            inchiopts.append(OPTION_STARTER_CHARACTER);
            inchiopts.append(nextOption);
        }
        return inchiopts.toString();
    }

    protected Molecule initInchi(Molecule mol) {
        mol = this.preconvert(mol);
        mol.dearomatize();
        return mol;
    }

    protected void convertStructure(Molecule mol, JniInchiStructure jnistruc) throws MolExportException {
        MolBond mbond;
        MolAtom matom;
        int i;
        for (i = 0; i < mol.getAtomCount(); ++i) {
            matom = mol.getAtom(i);
            JniInchiAtom jniatom = new JniInchiAtom(matom.getX(), matom.getY(), matom.getZ(), matom.getSymbol());
            jniatom.setCharge(matom.getCharge());
            jniatom.setImplicitH(matom.getImplicitHcount());
            if (matom.getMassno() > 0) {
                int isotopeshift = matom.getMassno() - (int)Math.round(PeriodicSystem.getMass(matom.getAtno()));
                jniatom.setIsotopicMassShift(isotopeshift);
            }
            switch (matom.getRadical()) {
                case 2: 
                case 6: {
                    jniatom.setRadical(INCHI_RADICAL.SINGLET);
                    break;
                }
                case 1: 
                case 3: 
                case 7: 
                case 11: {
                    jniatom.setRadical(INCHI_RADICAL.DOUBLET);
                    break;
                }
                case 10: {
                    jniatom.setRadical(INCHI_RADICAL.TRIPLET);
                }
            }
            jnistruc.addAtom(jniatom);
        }
        for (i = 0; i < mol.getBondCount(); ++i) {
            mbond = mol.getBond(i);
            INCHI_BOND_TYPE jnibondtype = INCHI_BOND_TYPE.NONE;
            switch (mbond.getType()) {
                case 1: 
                case 9: {
                    jnibondtype = INCHI_BOND_TYPE.SINGLE;
                    break;
                }
                case 2: {
                    jnibondtype = INCHI_BOND_TYPE.DOUBLE;
                    break;
                }
                case 3: {
                    jnibondtype = INCHI_BOND_TYPE.TRIPLE;
                    break;
                }
                case 4: 
                case 8: {
                    jnibondtype = INCHI_BOND_TYPE.ALTERN;
                    break;
                }
                case 0: 
                case 5: 
                case 6: {
                    throw new MolExportException("Can not convert query bonds to inchi.");
                }
            }
            JniInchiBond jnibond = new JniInchiBond(jnistruc.getAtom(mol.indexOf(mbond.getAtom1())), jnistruc.getAtom(mol.indexOf(mbond.getAtom2())), jnibondtype);
            jnistruc.addBond(jnibond);
        }
        for (i = 0; i < mol.getAtomCount(); ++i) {
            int temp;
            int idxa3;
            int idxa2;
            int idxa1;
            matom = mol.getAtom(i);
            if (matom.getBondCount() == 3 && mol.getLocalParity(i) != 0) {
                int temp2;
                idxa1 = mol.indexOf(matom.getLigand(0));
                idxa2 = mol.indexOf(matom.getLigand(1));
                idxa3 = mol.indexOf(matom.getLigand(2));
                if (idxa1 > idxa2) {
                    temp2 = idxa1;
                    idxa1 = idxa2;
                    idxa2 = temp2;
                }
                if (idxa2 > idxa3) {
                    temp2 = idxa2;
                    idxa2 = idxa3;
                    idxa3 = temp2;
                }
                if (idxa1 > idxa2) {
                    temp2 = idxa1;
                    idxa1 = idxa2;
                    idxa2 = temp2;
                }
                INCHI_PARITY inchiParity = INCHI_PARITY.UNDEFINED;
                if (mol.getLocalParity(i) == 2) {
                    inchiParity = INCHI_PARITY.EVEN;
                } else if (mol.getLocalParity(i) == 1) {
                    inchiParity = INCHI_PARITY.ODD;
                }
                jnistruc.addStereo0D(JniInchiStereo0D.createNewTetrahedralStereo0D((JniInchiAtom)jnistruc.getAtom(i), (JniInchiAtom)jnistruc.getAtom(i), (JniInchiAtom)jnistruc.getAtom(idxa1), (JniInchiAtom)jnistruc.getAtom(idxa2), (JniInchiAtom)jnistruc.getAtom(idxa3), (INCHI_PARITY)inchiParity));
                continue;
            }
            if (matom.getBondCount() != 4 || mol.getLocalParity(i) == 0) continue;
            idxa1 = mol.indexOf(matom.getLigand(0));
            idxa2 = mol.indexOf(matom.getLigand(1));
            idxa3 = mol.indexOf(matom.getLigand(2));
            int idxa4 = mol.indexOf(matom.getLigand(3));
            int stored = -1;
            if (mol.getAtom(idxa1).getAtno() == 1) {
                stored = idxa1;
                idxa1 = Integer.MAX_VALUE;
            } else if (mol.getAtom(idxa2).getAtno() == 1) {
                stored = idxa2;
                idxa2 = Integer.MAX_VALUE;
            } else if (mol.getAtom(idxa3).getAtno() == 1) {
                stored = idxa3;
                idxa3 = Integer.MAX_VALUE;
            } else if (mol.getAtom(idxa4).getAtno() == 1) {
                stored = idxa4;
                idxa4 = Integer.MAX_VALUE;
            }
            if (idxa1 > idxa2) {
                temp = idxa1;
                idxa1 = idxa2;
                idxa2 = temp;
            }
            if (idxa2 > idxa3) {
                temp = idxa2;
                idxa2 = idxa3;
                idxa3 = temp;
            }
            if (idxa3 > idxa4) {
                temp = idxa3;
                idxa3 = idxa4;
                idxa4 = temp;
            }
            if (idxa1 > idxa2) {
                temp = idxa1;
                idxa1 = idxa2;
                idxa2 = temp;
            }
            if (idxa2 > idxa3) {
                temp = idxa2;
                idxa2 = idxa3;
                idxa3 = temp;
            }
            if (idxa1 > idxa2) {
                temp = idxa1;
                idxa1 = idxa2;
                idxa2 = temp;
            }
            if (stored > -1) {
                if (idxa4 == Integer.MAX_VALUE) {
                    idxa4 = stored;
                } else {
                    throw new RuntimeException("Bad indexes or sorting.");
                }
            }
            INCHI_PARITY inchiParity = INCHI_PARITY.UNDEFINED;
            if (mol.getLocalParity(i) == 2) {
                inchiParity = INCHI_PARITY.EVEN;
            } else if (mol.getLocalParity(i) == 1) {
                inchiParity = INCHI_PARITY.ODD;
            }
            jnistruc.addStereo0D(JniInchiStereo0D.createNewTetrahedralStereo0D((JniInchiAtom)jnistruc.getAtom(i), (JniInchiAtom)jnistruc.getAtom(idxa4), (JniInchiAtom)jnistruc.getAtom(idxa1), (JniInchiAtom)jnistruc.getAtom(idxa2), (JniInchiAtom)jnistruc.getAtom(idxa3), (INCHI_PARITY)inchiParity));
        }
        for (i = 0; i < mol.getBondCount(); ++i) {
            int tempstereo2;
            mbond = mol.getBond(i);
            if (mbond.getType() != 2 || (tempstereo2 = mol.getDim() == 0 ? mbond.getFlags() & 0xC0 : mbond.calcStereo2()) == 0) continue;
            INCHI_PARITY parity = INCHI_PARITY.UNKNOWN;
            if (tempstereo2 == 128) {
                parity = INCHI_PARITY.ODD;
            } else if (tempstereo2 == 64) {
                parity = INCHI_PARITY.EVEN;
            }
            jnistruc.addStereo0D(JniInchiStereo0D.createNewDoublebondStereo0D((JniInchiAtom)jnistruc.getAtom(mol.indexOf(mbond.getCTAtom1())), (JniInchiAtom)jnistruc.getAtom(mol.indexOf(mbond.getAtom1())), (JniInchiAtom)jnistruc.getAtom(mol.indexOf(mbond.getAtom2())), (JniInchiAtom)jnistruc.getAtom(mol.indexOf(mbond.getCTAtom4())), (INCHI_PARITY)parity));
        }
    }

    @Override
    protected int parseOption(String opts, int i) {
        char c;
        int j;
        int ii = super.parseOption(opts, i);
        if (ii != i) {
            return ii;
        }
        for (j = i; j < opts.length() && ' ' != (c = opts.charAt(j)) && ',' != c && '\n' != c && '\t' != c; ++j) {
        }
        if (i == j) {
            return i + 1;
        }
        String s = opts.substring(i, j);
        if (!(s.equals("D") || s.equals("EQU") || s.equals("Fnumber") || s.equals("Wnumber") || s.equals("NoLabels") || s.equals("OutputSDF") || s.equals("STDIO") || s.equals("WarnOnEmptyStructure") || s.startsWith("SDF:") || s.equals("CML"))) {
            this.optC.add(s);
        }
        i = j;
        return i;
    }

    static {
        Inchi.init();
        OPTION_STARTER_CHARACTER = System.getProperty("file.separator").startsWith("\\") ? "/" : "-";
    }
}

