/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.inchi;

import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolInputStream;
import chemaxon.marvin.io.MolExportException;
import chemaxon.marvin.io.MolImportModule;
import chemaxon.marvin.io.formats.inchi.Inchi;
import chemaxon.marvin.io.formats.inchi.InchiExport;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.PeriodicSystem;
import java.io.IOException;
import java.util.LinkedList;
import java.util.StringTokenizer;
import net.sf.jniinchi.INCHI_BOND_TYPE;
import net.sf.jniinchi.INCHI_RADICAL;
import net.sf.jniinchi.INCHI_RET;
import net.sf.jniinchi.INCHI_STEREOTYPE;
import net.sf.jniinchi.JniInchiAtom;
import net.sf.jniinchi.JniInchiBond;
import net.sf.jniinchi.JniInchiException;
import net.sf.jniinchi.JniInchiInput;
import net.sf.jniinchi.JniInchiInputData;
import net.sf.jniinchi.JniInchiInputInchi;
import net.sf.jniinchi.JniInchiOutputStructure;
import net.sf.jniinchi.JniInchiStereo0D;
import net.sf.jniinchi.JniInchiWrapper;

public class InchiImport
extends MolImportModule {
    private static final String DEFAULT_IMPORT_OPTION_STRING = InchiExport.OPTION_STARTER_CHARACTER + "OutputSDF" + " " + InchiExport.OPTION_STARTER_CHARACTER + "WarnOnEmptyStructure";
    private MolInputStream istream;
    private String auxInfo = null;
    private String optC;
    protected boolean warningsNeeded = true;

    @Override
    public void setOptions(String opts) {
        this.optC = opts == null ? "" : new String(opts);
    }

    @Override
    public void initMolImport(MolInputStream mis) {
        this.istream = mis;
    }

    private String readInput() throws IOException {
        StringBuffer input = new StringBuffer();
        String line = this.istream.readLine();
        if (!line.startsWith("InChI=")) {
            throw new MolFormatException("InChI string not starting with \"InChI=\"");
        }
        input.append(line);
        this.auxInfo = null;
        int linebreaksRemoved = 0;
        while ((line = this.istream.readLine()) != null) {
            if (line.startsWith("InChI=")) {
                this.istream.putBackLine();
                break;
            }
            if (line.startsWith("AuxInfo=")) {
                this.auxInfo = line;
                continue;
            }
            if (++linebreaksRemoved <= 10) continue;
            throw new MolFormatException("Data stops to be in InChI format");
        }
        return input.toString();
    }

    @Override
    public boolean readMol(Molecule mol) throws IOException {
        Inchi.init();
        if (this.auxInfo == null) {
            mol.setDim(0);
        }
        boolean hascoords = false;
        String input = this.readInput();
        try {
            int i;
            JniInchiInput jnistructure;
            String inchiopts = DEFAULT_IMPORT_OPTION_STRING;
            StringTokenizer sTokenizer = new StringTokenizer(this.optC);
            while (sTokenizer.hasMoreTokens()) {
                String next = sTokenizer.nextToken();
                if (next.equals("Woff")) {
                    this.warningsNeeded = false;
                    continue;
                }
                inchiopts = inchiopts + " " + InchiExport.OPTION_STARTER_CHARACTER + sTokenizer.nextToken();
            }
            INCHI_RET returnStatus = INCHI_RET.OKAY;
            String message = "";
            if (this.auxInfo == null || this.auxInfo.length() < 1) {
                JniInchiOutputStructure jnistructureO = JniInchiWrapper.getStructureFromInchi((JniInchiInputInchi)new JniInchiInputInchi(input, inchiopts));
                returnStatus = jnistructureO.getReturnStatus();
                message = jnistructureO.getMessage();
                jnistructure = jnistructureO;
            } else {
                JniInchiInputData jiid = JniInchiWrapper.getInputFromAuxInfo((String)this.auxInfo);
                jnistructure = jiid.getInput();
                returnStatus = jiid.getReturnValue();
                message = jiid.getErrorMessage();
            }
            switch (returnStatus) {
                case OKAY: {
                    break;
                }
                case WARNING: {
                    if (!this.warningsNeeded) break;
                    System.err.println(message);
                    break;
                }
                case EOF: {
                    throw new MolExportException("No structure found.");
                }
                default: {
                    throw new MolExportException(message);
                }
            }
            LinkedList<MolAtom> atomsWithDeuterium = new LinkedList<MolAtom>();
            LinkedList<MolAtom> atomsWithTritium = new LinkedList<MolAtom>();
            for (i = 0; i < jnistructure.getNumAtoms(); ++i) {
                int j;
                JniInchiAtom jniatom = jnistructure.getAtom(i);
                MolAtom matom = new MolAtom(MolAtom.numOf(jniatom.getElementType()), jniatom.getX(), jniatom.getY(), jniatom.getZ());
                hascoords = hascoords || jniatom.getX() != 0.0 || jniatom.getY() != 0.0 || jniatom.getZ() != 0.0;
                matom.setCharge(jniatom.getCharge());
                if (jniatom.getImplicitH() > -1) {
                    matom.setImplicitHcount(jniatom.getImplicitH());
                }
                if (jniatom.getIsotopicMass() != 0) {
                    if (jniatom.getIsotopicMass() > 500) {
                        matom.setMassno((int)Math.round(PeriodicSystem.getMass(matom.getAtno())) + jniatom.getIsotopicMass() - 10000);
                    } else {
                        matom.setMassno(jniatom.getIsotopicMass());
                    }
                }
                if (jniatom.getRadical() == INCHI_RADICAL.SINGLET) {
                    matom.setRadical(2);
                } else if (jniatom.getRadical() == INCHI_RADICAL.DOUBLET) {
                    matom.setRadical(1);
                } else if (jniatom.getRadical() == INCHI_RADICAL.TRIPLET) {
                    matom.setRadical(10);
                }
                mol.add(matom);
                for (j = 0; j < jniatom.getImplicitDeuterium(); ++j) {
                    atomsWithDeuterium.add(matom);
                }
                for (j = 0; j < jniatom.getImplicitTritium(); ++j) {
                    atomsWithTritium.add(matom);
                }
            }
            if (!hascoords) {
                mol.setDim(0);
            }
            for (i = 0; i < jnistructure.getNumBonds(); ++i) {
                JniInchiBond jnibond = jnistructure.getBond(i);
                MolBond mbond = new MolBond(mol.getAtom(jnistructure.getAtomIndex(jnibond.getOriginAtom())), mol.getAtom(jnistructure.getAtomIndex(jnibond.getTargetAtom())));
                if (jnibond.getBondType() == INCHI_BOND_TYPE.SINGLE) {
                    mbond.setType(1);
                } else if (jnibond.getBondType() == INCHI_BOND_TYPE.DOUBLE) {
                    mbond.setType(2);
                } else if (jnibond.getBondType() == INCHI_BOND_TYPE.TRIPLE) {
                    mbond.setType(3);
                } else if (jnibond.getBondType() == INCHI_BOND_TYPE.ALTERN) {
                    mbond.setType(4);
                }
                mol.add(mbond);
            }
            for (MolAtom molAtom : atomsWithDeuterium) {
                MolAtom deuterium = new MolAtom(1);
                deuterium.setMassno(2);
                mol.add(deuterium);
                mol.add(new MolBond(molAtom, deuterium));
            }
            for (MolAtom molAtom : atomsWithTritium) {
                MolAtom tritium = new MolAtom(1);
                tritium.setMassno(3);
                mol.add(tritium);
                mol.add(new MolBond(molAtom, tritium));
            }
            mol.valenceCheck();
            for (int i2 = 0; i2 < jnistructure.getNumStereo0D(); ++i2) {
                JniInchiStereo0D jnistereo = jnistructure.getStereo0D(i2);
                if (jnistereo.getStereoType() == INCHI_STEREOTYPE.TETRAHEDRAL) {
                    int cxnparity = 0;
                    switch (jnistereo.getParity()) {
                        case EVEN: {
                            cxnparity = 2;
                            break;
                        }
                        case ODD: {
                            cxnparity = 1;
                            break;
                        }
                        case UNDEFINED: 
                        case UNKNOWN: {
                            cxnparity = 3;
                            break;
                        }
                    }
                    boolean invert = false;
                    int idx1 = jnistructure.getAtomIndex(jnistereo.getNeighbors()[0]);
                    int idx2 = jnistructure.getAtomIndex(jnistereo.getNeighbors()[1]);
                    int idx3 = jnistructure.getAtomIndex(jnistereo.getNeighbors()[2]);
                    int idx4 = jnistructure.getAtomIndex(jnistereo.getNeighbors()[3]);
                    int idxC = jnistructure.getAtomIndex(jnistereo.getCentralAtom());
                    if (idxC == idx1) {
                        if (idx2 > idx3) {
                            boolean bl = invert = !invert;
                        }
                        if (idx3 > idx4) {
                            boolean bl = invert = !invert;
                        }
                        if (idx2 > idx4) {
                            invert = !invert;
                        }
                    } else if (idxC == idx2) {
                        boolean bl = invert = !invert;
                        if (idx1 > idx3) {
                            boolean bl2 = invert = !invert;
                        }
                        if (idx3 > idx4) {
                            boolean bl3 = invert = !invert;
                        }
                        if (idx1 > idx4) {
                            invert = !invert;
                        }
                    } else if (idxC == idx3) {
                        boolean bl = invert = !invert;
                        if (idx2 > idx1) {
                            boolean bl4 = invert = !invert;
                        }
                        if (idx1 > idx4) {
                            boolean bl5 = invert = !invert;
                        }
                        if (idx2 > idx4) {
                            invert = !invert;
                        }
                    } else if (idxC == idx4) {
                        boolean bl = invert = !invert;
                        if (idx2 > idx3) {
                            boolean bl6 = invert = !invert;
                        }
                        if (idx3 > idx1) {
                            boolean bl7 = invert = !invert;
                        }
                        if (idx2 > idx1) {
                            invert = !invert;
                        }
                    } else {
                        if (mol.getAtom(idx1).getAtno() == 1 && mol.getAtom(idx1).getMass() == 1.0) {
                            idx1 = Integer.MAX_VALUE;
                        } else if (mol.getAtom(idx2).getAtno() == 1 && mol.getAtom(idx2).getMass() == 1.0) {
                            idx2 = Integer.MAX_VALUE;
                        } else if (mol.getAtom(idx3).getAtno() == 1 && mol.getAtom(idx3).getMass() == 1.0) {
                            idx3 = Integer.MAX_VALUE;
                        } else if (mol.getAtom(idx4).getAtno() == 1 && mol.getAtom(idx4).getMass() == 1.0) {
                            idx4 = Integer.MAX_VALUE;
                        }
                        if (idx1 > idx2) {
                            boolean bl = invert = !invert;
                        }
                        if (idx1 > idx3) {
                            boolean bl = invert = !invert;
                        }
                        if (idx1 > idx4) {
                            boolean bl = invert = !invert;
                        }
                        if (idx2 > idx3) {
                            boolean bl = invert = !invert;
                        }
                        if (idx2 > idx4) {
                            boolean bl = invert = !invert;
                        }
                        if (idx3 > idx4) {
                            invert = !invert;
                        }
                        boolean bl = invert = !invert;
                    }
                    if (invert) {
                        if (cxnparity == 1) {
                            cxnparity = 2;
                        } else if (cxnparity == 2) {
                            cxnparity = 1;
                        }
                    }
                    int[] indexes = new int[]{idxC};
                    int[] parities = new int[]{cxnparity};
                    mol.setLocalParity(indexes, parities, true);
                    continue;
                }
                if (jnistereo.getStereoType() == INCHI_STEREOTYPE.DOUBLEBOND) {
                    int stereo2 = 0;
                    switch (jnistereo.getParity()) {
                        case EVEN: {
                            stereo2 = 64;
                            break;
                        }
                        case ODD: {
                            stereo2 = 128;
                            break;
                        }
                        case UNDEFINED: 
                        case UNKNOWN: {
                            stereo2 = 192;
                            break;
                        }
                    }
                    MolAtom a1 = mol.getAtom(jnistructure.getAtomIndex(jnistereo.getNeighbor(0)));
                    MolAtom a2 = mol.getAtom(jnistructure.getAtomIndex(jnistereo.getNeighbor(1)));
                    MolAtom a3 = mol.getAtom(jnistructure.getAtomIndex(jnistereo.getNeighbor(2)));
                    MolAtom a4 = mol.getAtom(jnistructure.getAtomIndex(jnistereo.getNeighbor(3)));
                    MolBond b = a2.getBondTo(a3);
                    if (b == null) continue;
                    if (b.getAtom1() == a3) {
                        a2 = a1;
                        a1 = a4;
                        a4 = a2;
                    }
                    b.setStereo2Flags(a1, a4, stereo2);
                    continue;
                }
                if (jnistereo.getStereoType() != INCHI_STEREOTYPE.ALLENE) continue;
            }
        }
        catch (JniInchiException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
        return true;
    }

    @Override
    public Molecule createMol() {
        return new Molecule();
    }
}

