/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.inchi;

import chemaxon.marvin.io.MolExportException;
import chemaxon.marvin.io.formats.inchi.Inchi;
import chemaxon.marvin.io.formats.inchi.InchiExport;
import chemaxon.struc.Molecule;
import net.sf.jniinchi.JniInchiInput;
import net.sf.jniinchi.JniInchiOutput;
import net.sf.jniinchi.JniInchiStructure;
import net.sf.jniinchi.JniInchiWrapper;

public class InchikeyExport
extends InchiExport {
    @Override
    public Object convert(Molecule mol) throws MolExportException {
        try {
            mol = this.initInchi(mol);
            this.auxInfoNeeded = true;
            this.inchikeyNeeded = true;
            String inchiopts = this.createOptionString();
            JniInchiStructure jnistruc = new JniInchiStructure();
            this.convertStructure(mol, jnistruc);
            JniInchiOutput jniout = JniInchiWrapper.getInchi((JniInchiInput)new JniInchiInput(jnistruc, inchiopts));
            switch (jniout.getReturnStatus()) {
                case OKAY: {
                    break;
                }
                case WARNING: {
                    if (!this.warningsNeeded) break;
                    System.err.println(jniout.getMessage());
                    break;
                }
                case EOF: {
                    throw new MolExportException("No structure found.");
                }
                default: {
                    throw new MolExportException(jniout.getMessage());
                }
            }
            String inchiKey = JniInchiWrapper.getInchiKey((String)jniout.getInchi()).getKey();
            if (inchiKey != null && inchiKey.length() > 0) {
                return "InChIKey=" + inchiKey + "\n";
            }
            return new MolExportException("Native code can not generate inchikey from structure.");
        }
        catch (Exception e) {
            throw new MolExportException(e.getMessage());
        }
    }

    static {
        Inchi.init();
    }
}

