/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.jtf;

import chemaxon.formats.MFileFormatUtil;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.formats.MolInputStream;
import chemaxon.marvin.io.MRecord;
import chemaxon.marvin.io.MRecordParseException;
import chemaxon.marvin.io.MRecordReader;
import chemaxon.marvin.io.MolImportModule;
import chemaxon.struc.MPropertyContainer;
import chemaxon.struc.Molecule;
import chemaxon.struc.RxnMolecule;
import java.io.IOException;

public class JTFImport
extends MolImportModule {
    private String options = null;
    private MRecordReader reader = null;

    @Override
    public void initMolImport(MolInputStream is) throws MolFormatException, IOException {
        this.reader = MFileFormatUtil.createRecordReader(is, null);
    }

    @Override
    public boolean readMol(Molecule m) throws MolFormatException, IOException {
        MRecord record = null;
        try {
            record = this.reader.nextRecord();
        }
        catch (MRecordParseException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
        if (record == null) {
            return false;
        }
        String structure = record.getString();
        MolImporter.importMol(structure, m);
        MPropertyContainer props = record.getPropertyContainer();
        String[] fields = props.getKeys();
        for (int x = 0; x < fields.length; ++x) {
            String fieldName = fields[x];
            Object fieldValue = props.getObject(fields[x]);
            m.setPropertyObject(fieldName, fieldValue);
        }
        return true;
    }

    @Override
    public Molecule createMol() {
        return new RxnMolecule();
    }
}

