/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.mdl;

import chemaxon.common.util.text.SimpleTeX;
import chemaxon.marvin.io.MPropHandler;
import chemaxon.marvin.io.MolExportException;
import chemaxon.marvin.io.MolExportModule;
import chemaxon.marvin.io.formats.mdl.MolfileUtil;
import chemaxon.marvin.paint.internal.util.DrawingUtil;
import chemaxon.marvin.util.AttachmentConverter;
import chemaxon.marvin.util.OptionDescriptor;
import chemaxon.marvin.util.text.EncodingUtil;
import chemaxon.marvin.util.text.LocaleUtil;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MProp;
import chemaxon.struc.MPropertyContainer;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.PageSettings;
import chemaxon.struc.RgMolecule;
import chemaxon.struc.RxnMolecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.StereoConstants;
import chemaxon.struc.graphics.MBracket;
import chemaxon.struc.prop.MMoleculeProp;
import chemaxon.struc.prop.MStringProp;
import chemaxon.struc.sgroup.DataSgroup;
import chemaxon.struc.sgroup.Expandable;
import chemaxon.struc.sgroup.MulticenterSgroup;
import chemaxon.struc.sgroup.MultipleSgroup;
import chemaxon.struc.sgroup.RepeatingUnitSgroup;
import chemaxon.util.EnhStereoConverter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.ResourceBundle;

public class MolExport
extends MolExportModule
implements StereoConstants {
    private static final String[] SGROUP_SUBTYPES = new String[4];
    private static final String[] SGROUP_CONNECTIVITIES = new String[4];
    private static final char[] CHARS64 = new char[64];
    private boolean useMaxPrecision = false;
    private boolean mapp6;
    private StringBuffer tmpsbuf = new StringBuffer();
    private Calendar date = Calendar.getInstance();
    private double xyzScale;
    private boolean xyzScaleSet;
    private boolean versionSet;
    private boolean version3;
    private boolean version3this;
    private int lineStartIndex;
    private boolean convertToEnhStereo = false;
    private boolean absStereo = false;
    private boolean omitClean0D = false;

    @Override
    protected void getOptionDescriptors(String fmtname, String optnames, List<OptionDescriptor> l) {
        super.getOptionDescriptors(null, null, l);
        ResourceBundle rc = LocaleUtil.getResourceBundle(MolExport.class.getName(), null);
        MolExport.getOptionDescriptors(rc, fmtname, null, l);
    }

    @Override
    public Object open(String fmtopts) throws MolExportException {
        this.xyzScale = 1.0;
        this.xyzScaleSet = false;
        this.versionSet = false;
        this.version3 = false;
        this.useMaxPrecision = false;
        super.open(fmtopts);
        String fmt = this.getFormat();
        if (fmt != null && (fmt.equals("rdf") || fmt.equals("csrdf"))) {
            StringBuffer sbuf = this.stringBuffer;
            sbuf.setLength(0);
            sbuf.append("$RDFILE 1\n$DATM    ");
            this.appendRight(this.date.get(2) + 1, 2, '0');
            sbuf.append('/');
            this.appendRight(this.date.get(5), 2, '0');
            sbuf.append('/');
            this.appendRight(this.date.get(1) % 100, 2, '0');
            sbuf.append(' ');
            this.appendRight(this.date.get(11), 2, '0');
            sbuf.append(':');
            this.appendRight(this.date.get(12), 2, '0');
            sbuf.append('\n');
            return sbuf.toString();
        }
        return null;
    }

    @Override
    protected int parseOption(String opts, int i) throws IllegalArgumentException {
        int ii = super.parseOption(opts, i);
        if (ii != i) {
            return ii;
        }
        char c = opts.charAt(i);
        if (c == 'b') {
            int j;
            for (j = i + 1; j < opts.length() && ((c = opts.charAt(j)) >= '0' && c <= '9' || c == '.'); ++j) {
            }
            String s = opts.substring(i + 1, j);
            try {
                double blen = Double.valueOf(s);
                this.xyzScale = blen == 0.0 ? 1.0 : blen / 1.54;
                this.xyzScaleSet = true;
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
            i = j;
        } else {
            int j = MolExport.nextOpt(opts, i, "V2");
            if (j > i) {
                this.versionSet = true;
                this.version3 = false;
                i = j;
            } else {
                j = MolExport.nextOpt(opts, i, "V3e");
                if (j > i) {
                    this.versionSet = true;
                    this.version3 = true;
                    i = j;
                    if (i >= opts.length()) {
                        throw new IllegalArgumentException("export option V3e requires an argument");
                    }
                    c = opts.charAt(i);
                    if (c != 'a' && c != 'c') {
                        throw new IllegalArgumentException("Illegal enhanced stereo conversion specified:" + c + ", must be V3ec or V3ea.");
                    }
                    this.convertToEnhStereo = true;
                    this.absStereo = c == 'a';
                    ++i;
                } else {
                    j = MolExport.nextOpt(opts, i, "V3");
                    if (j > i) {
                        this.versionSet = true;
                        this.version3 = true;
                        i = j;
                    } else if (c == 'P') {
                        this.useMaxPrecision = true;
                        ++i;
                    } else {
                        j = MolExport.nextOpt(opts, i, "omitClean0D");
                        if (j > i) {
                            this.omitClean0D = true;
                            i = j;
                        }
                    }
                }
            }
        }
        return i;
    }

    private void getRegValue(String v, StringBuffer s) {
        if (v.startsWith("RI")) {
            s.append(" $RIREG " + v.substring(2));
        } else if (v.startsWith("RE")) {
            s.append(" $REREG " + v.substring(2));
        }
        if (v.startsWith("MI")) {
            s.append(" $MIREG " + v.substring(2));
        } else if (v.startsWith("ME")) {
            s.append(" $MEREG " + v.substring(2));
        }
    }

    @Override
    public Object convert(Molecule mol) throws MolExportException {
        boolean useRG;
        this.stringBuffer.setLength(0);
        RgMolecule rgmol = null;
        RxnMolecule rxmol = null;
        String fmt = this.getFormat();
        if (fmt == null) {
            fmt = "mol";
        }
        mol = this.preconvert(mol, true, 1, true);
        if (!(this.omitClean0D || mol.getDim() != 0 || this.versionSet && this.version3)) {
            mol.clean(2, "");
        }
        AttachmentConverter attachmentConverter = new AttachmentConverter(mol);
        this.convertPageSettingsToData(mol);
        this.convertMultiCenterSgroupsToData(mol);
        this.convertCoordinateBondsToData(mol);
        this.convertChargeLocationToData(mol);
        if (this.convertToEnhStereo) {
            EnhStereoConverter.convert(mol, this.absStereo);
        }
        this.version3this = this.version3;
        if (MolExport.isV3recommended(mol) && !this.version3) {
            if (this.versionSet) {
                if (MolExport.isV3required(mol)) {
                    throw new MolExportException("molecule cannot be represented in V2 format");
                }
            } else {
                this.version3this = true;
            }
        }
        boolean bl = useRG = fmt.equals("rgf") || fmt.equals("csrgf");
        if (mol instanceof RxnMolecule) {
            rxmol = (RxnMolecule)mol;
        } else if (mol instanceof RgMolecule) {
            rgmol = (RgMolecule)mol;
            Molecule m = rgmol.getRoot();
            if (m instanceof RxnMolecule) {
                rxmol = (RxnMolecule)m;
            }
            if (useRG |= rgmol.getRgroupCount() != 0) {
                if (rxmol != null && !this.versionSet) {
                    this.version3this = true;
                }
            } else {
                rgmol = null;
            }
        } else if (useRG) {
            rgmol = new RgMolecule();
            mol.clonelesscopy(rgmol);
        }
        boolean isRDF = fmt.equals("rdf") || fmt.equals("csrdf");
        boolean writeMol = true;
        if (isRDF) {
            StringBuffer s = this.stringBuffer;
            String v = MPropHandler.convertToString(mol.properties(), "$REGNO");
            if (v != null) {
                Molecule root = mol instanceof RgMolecule ? ((RgMolecule)mol).getRoot() : null;
                MPropertyContainer props = mol.properties();
                if (mol.isEmpty()) {
                    writeMol = false;
                } else {
                    for (int i = 0; i < props.size() && writeMol; ++i) {
                        Object o;
                        String key = props.getKey(i);
                        MProp prop = props.get(key);
                        if (!props.isValid(prop) || (o = prop.getPropValue()) != mol && o != root) continue;
                        writeMol = false;
                    }
                }
                if (!writeMol) {
                    if (v.startsWith("MI")) {
                        s.append("$MIREG ");
                    } else if (v.startsWith("ME")) {
                        s.append("$MEREG ");
                    } else if (v.startsWith("RI")) {
                        s.append("$RIREG ");
                    } else if (v.startsWith("RE")) {
                        s.append("$REREG ");
                    } else {
                        writeMol = true;
                    }
                }
                if (!writeMol) {
                    s.append(v.substring(2));
                    s.append('\n');
                }
            }
            if (writeMol) {
                this.stringBuffer.append(rxmol == null ? "$MFMT" : "$RFMT");
                if (v != null) {
                    this.getRegValue(v, this.stringBuffer);
                }
                this.stringBuffer.append("\n");
            }
        }
        if (writeMol) {
            if (rxmol != null) {
                if (this.getMolfileVersion() == 3) {
                    this.appendRxnV3(rxmol, this.xyzScale, rgmol, attachmentConverter);
                } else if (useRG) {
                    this.appendRgf(rgmol, fmt, attachmentConverter);
                } else {
                    this.appendRxnV2(rxmol, fmt, attachmentConverter);
                }
            } else if (rgmol != null && this.getMolfileVersion() < 3) {
                this.appendRgf(rgmol, fmt, attachmentConverter);
            } else {
                this.appendHeader(mol);
                this.appendCtab(mol, fmt, attachmentConverter);
            }
        }
        if (isRDF || fmt.equals("sdf") || fmt.equals("cssdf")) {
            this.appendRDForSDFProps(mol);
        }
        return this.stringBuffer.toString();
    }

    protected int getMolfileVersion() {
        return this.version3this ? 3 : 2;
    }

    private static boolean isV3recommended(Molecule mol) {
        if (MolExport.isV3required(mol)) {
            return true;
        }
        MoleculeGraph u = mol.getGraphUnion();
        for (int i = 0; i < u.getAtomCount(); ++i) {
            MolAtom a = u.getAtom(i);
            if (a.getStereoGroupType() == 0) continue;
            return true;
        }
        if (mol instanceof RgMolecule) {
            RgMolecule rmol = (RgMolecule)mol;
            Molecule root = rmol.getRoot();
            if (root instanceof RxnMolecule && rmol.getRgroupCount() != 0) {
                return true;
            }
            for (int i = 0; i < rmol.getRgroupCount(); ++i) {
                int id = rmol.getRgroupId(i);
                if (id <= 999) continue;
                return true;
            }
            MoleculeGraph umol = rmol.getGraphUnion();
            for (int i = 0; i < umol.getAtomCount(); ++i) {
                MolAtom a = umol.getAtom(i);
                if (a.getAtno() != 134 || a.getRgroup() <= 999) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isV3required(Molecule mol) {
        return mol.getAtomCount() > 999 || mol.getBondCount() > 999;
    }

    private void appendHeader(Molecule mol) {
        StringBuffer s = this.stringBuffer;
        s.append(mol.getName());
        int dim = mol.getDim();
        s.append("\n  Mrv0541 ");
        this.appendDate(100, 2);
        s.append((char)(48 + dim));
        s.append("D");
        s.append("          ");
        this.appendEnergy(mol);
        s.append('\n');
        this.appendComment(mol.getComment());
    }

    private void appendEnergy(Molecule mol) {
        StringBuffer s = this.stringBuffer;
        Double d = null;
        String energy = mol.getProperty("Energy");
        if (energy != null) {
            try {
                d = new Double(energy);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (d != null) {
            String str = d.toString();
            int pos = str.indexOf(46);
            if (pos < 0) {
                return;
            }
            String num = str.substring(0, pos);
            int n = Integer.parseInt(num);
            if (n < 1000000) {
                int zeros;
                int end;
                for (int i = 0; i < 6 - num.length(); ++i) {
                    s.append(' ');
                }
                s.append(num);
                s.append('.');
                int l = str.length() - pos - 1;
                if (l >= 5) {
                    end = pos + 6;
                    zeros = 0;
                } else {
                    end = str.length();
                    zeros = 5 - l;
                }
                s.append(str.substring(pos + 1, end));
                for (int i = 0; i < zeros; ++i) {
                    s.append('0');
                }
            }
        }
    }

    private void appendDate(int yearMax, int yearDigits) {
        this.mapp6 = false;
        this.appendRight(this.date.get(2) + 1, 2, '0');
        this.appendRight(this.date.get(5), 2, '0');
        this.appendRight((this.date.get(1) - 1900) % yearMax, yearDigits, '0');
        this.appendRight(this.date.get(11), 2, '0');
        this.appendRight(this.date.get(12), 2, '0');
    }

    private void appendCtab(Molecule mol, String format2, AttachmentConverter attachmentConverter) {
        boolean bin6 = format2.equals("csmol") || format2.equals("cssdf") || format2.equals("csrdf") || format2.equals("csrgf") || format2.equals("csrxn");
        int na = mol.getAtomCount();
        int nb = mol.getBondCount();
        if (!this.xyzScaleSet) {
            double d = this.xyzScale = this.getMolfileVersion() < 3 && mol.getDim() == 2 ? 0.5357142857142857 : 1.0;
        }
        if (this.getMolfileVersion() == 3) {
            this.stringBuffer.append("  0  0  0     0  0            999 V3000\n");
            this.appendCtabV3(mol, na, nb, this.xyzScale, false, attachmentConverter);
            if (mol instanceof RgMolecule) {
                this.appendRgroupBlockV3((RgMolecule)mol, this.xyzScale, true, attachmentConverter);
            }
        } else {
            this.appendCtabV2(mol, na, nb, this.xyzScale, bin6, attachmentConverter);
        }
        this.appendMEnd(mol);
    }

    private void appendCtabV2(Molecule mol, int na, int nb, double xyzCoordScale, boolean bin6, AttachmentConverter attachmentConverter) {
        int i;
        ArrayList<Integer> list;
        int size;
        int count;
        int i2;
        int j;
        MolAtom a;
        int i3;
        StringBuffer s = this.stringBuffer;
        int nl = 0;
        int nc = 0;
        int nrad = 0;
        int niso = 0;
        int nsma = 0;
        int nrgp = 0;
        ArrayList<MolAtom> atomList = attachmentConverter.getAtomListForSimpleAttachment();
        int napo = atomList.size();
        int nlin = 0;
        int nsub = 0;
        int nrbc = 0;
        int nuns = 0;
        for (int i4 = 0; i4 < na; ++i4) {
            int rgid;
            MolAtom a2 = mol.getAtom(i4);
            int atno = a2.getAtno();
            if (atno == 128 || atno == 129) {
                ++nl;
            }
            if (a2.getCharge() != 0) {
                ++nc;
            }
            if (a2.getRadical() != 0) {
                ++nrad;
            }
            if (a2.getMassno() != 0 && !a2.isSpecIsotopeSymbolUsed()) {
                ++niso;
            }
            if (MolExport.hasSMARTSOnlyProps(a2)) {
                ++nsma;
            }
            if (atno == 134 && (rgid = a2.getRgroup()) > 0 && rgid < 1000) {
                ++nrgp;
            }
            if (a2.isLinkNode()) {
                ++nlin;
            }
            if (a2.getQPropAsInt("s") != -1) {
                ++nsub;
            }
            if (a2.getQPropAsInt("rb") != -1) {
                ++nrbc;
            }
            if (a2.getQPropAsInt("u") == -1) continue;
            ++nuns;
        }
        int nCTorU = 0;
        for (int i5 = 0; i5 < nb; ++i5) {
            MolBond b = mol.getBond(i5);
            int f = b.getFlags();
            int stereo2 = f & 0x1C0;
            if ((stereo2 & 0x100) == 0) continue;
            ++nCTorU;
        }
        int[] cA = new int[nc];
        int[] radA = new int[nrad];
        int[] isoA = new int[niso];
        int[] rgpA = new int[nrgp];
        int[] rgpN = new int[nrgp];
        int[] subA = new int[nsub];
        int[] rbcA = new int[nrbc];
        int[] unsA = new int[nuns];
        int[] linA = nlin != 0 ? new int[nlin] : null;
        int[] smaA = nsma != 0 ? new int[nsma] : null;
        int[] ctuA = nCTorU != 0 ? new int[nCTorU] : null;
        int[] apoA = napo != 0 ? new int[napo] : null;
        int irgp = 0;
        int maxRgp = 0;
        this.appendRight(na, 3);
        this.appendRight(nb, 3);
        this.appendRight(nl, 3);
        s.append("  0  ");
        s.append(mol.isAbsStereo() ? (char)'1' : '0');
        s.append("  0            999 V2000\n");
        nuns = 0;
        nsub = 0;
        nrbc = 0;
        nlin = 0;
        napo = 0;
        nsma = 0;
        irgp = 0;
        niso = 0;
        nrad = 0;
        nc = 0;
        for (i3 = 0; i3 < na; ++i3) {
            int k;
            a = mol.getAtom(i3);
            int chg = a.getCharge();
            int para = mol.getLocalParity(i3);
            int v = a.getValenceProp();
            int aamap = a.getAtomMap();
            int rxnstereo = a.getReactionStereo();
            int massno = a.getMassno();
            int atno = a.getAtno();
            boolean stereoCare = a.getStereoCare();
            boolean specH = MolExport.isImplicitHcountImportant(a);
            this.mapp6 = bin6 && v == -1 && !specH && !stereoCare && aamap == 0 && rxnstereo == 0 && atno <= 109;
            double z0 = a.getZ();
            if (chg != 0) {
                cA[nc++] = i3;
            }
            if (a.getRadical() != 0) {
                radA[nrad++] = i3;
            }
            if (massno != 0 && !a.isSpecIsotopeSymbolUsed()) {
                isoA[niso++] = i3;
            }
            if (MolExport.hasSMARTSOnlyProps(a)) {
                smaA[nsma++] = i3;
            }
            if (atno == 134 && (k = a.getRgroup()) > 0 && k < 1000) {
                rgpA[irgp] = i3;
                if (k > maxRgp) {
                    maxRgp = k;
                }
                rgpN[irgp] = k;
                ++irgp;
            }
            if (atomList.contains(a)) {
                apoA[napo++] = i3;
            }
            if (a.isLinkNode()) {
                linA[nlin++] = i3;
            }
            if (a.getQPropAsInt("s") != -1) {
                subA[nsub++] = i3;
            }
            if (a.getQPropAsInt("rb") != -1) {
                rbcA[nrbc++] = i3;
            }
            if (a.getQPropAsInt("u") != -1) {
                unsA[nuns++] = i3;
            }
            this.appendRight(xyzCoordScale * a.getX());
            this.appendRight(xyzCoordScale * a.getY());
            if (this.mapp6) {
                double z = xyzCoordScale * z0;
                if (z < -5.0E-5 || z > 5.0E-5) {
                    this.appendRight(z);
                }
                int f = atno;
                this.appendRight(f |= MolExport.mdlParity(para) << 7, 2);
                s.append('\n');
                continue;
            }
            this.appendRight(xyzCoordScale * z0);
            s.append(' ');
            this.appendLeft(MolExport.symbolOf(a), 3);
            s.append(" 0");
            this.appendRight(this.getV1charge(chg), 3);
            s.append("  ");
            s.append(MolExport.mdlParity(para));
            int qhcount = a.getQPropAsInt("H");
            s.append("  ");
            s.append(qhcount < 9 ? qhcount + 1 : 0);
            s.append("  ");
            s.append(stereoCare ? (char)'1' : '0');
            this.appendRight(v == 0 ? 15 : (v > 0 ? v : 0), 3);
            s.append("  0  0  0");
            this.appendRight(aamap, 3);
            this.appendRight(rxnstereo, 3);
            s.append("  0\n");
        }
        nCTorU = 0;
        for (i3 = 0; i3 < nb; ++i3) {
            MolBond b = mol.getBond(i3);
            int flags = b.getFlags();
            MolAtom a1 = b.getAtom1();
            MolAtom a2 = b.getAtom2();
            int j1 = mol.indexOf(a1);
            int j2 = mol.indexOf(a2);
            int topology = flags & 0xC00;
            int rCenter = flags & 0xF000;
            int type = flags & 0xF;
            int stereo1 = flags & 0x30;
            int stereo2 = flags & 0x1C0;
            if ((stereo2 & 0x100) != 0) {
                ctuA[nCTorU++] = i3;
            }
            int molstereo = 0;
            if (b.isBold()) {
                molstereo = 1;
            }
            if (type == 2) {
                int mask = 192;
                if ((stereo2 & 0xC0) == 192) {
                    molstereo = 3;
                }
            } else if (stereo1 == 16) {
                molstereo = 1;
            } else if (stereo1 == 32) {
                molstereo = 6;
            } else if (stereo1 == 48) {
                molstereo = 4;
            }
            this.mapp6 = topology == 0 ? bin6 : false;
            int isize = this.mapp6 ? 2 : 3;
            this.appendRight(j1 + 1, isize);
            this.appendRight(j2 + 1, isize);
            if (this.mapp6) {
                this.appendRight(type | molstereo << 3, 1);
                s.append('\n');
                continue;
            }
            s.append("  ");
            s.append((char)(type == 0 ? 56 : 48 + type));
            s.append("  ");
            s.append((char)(48 + molstereo));
            s.append("  0  ");
            s.append((char)(topology == 0 ? 48 : (topology == 1024 ? 49 : 50)));
            if (rCenter > 0) {
                int rCenterFlag = flags & 0xF000;
                if (rCenterFlag == 20480) {
                    s.append(" -1\n");
                    continue;
                }
                if (rCenterFlag == 4096) {
                    s.append("  1\n");
                    continue;
                }
                if (rCenterFlag == 24576) {
                    s.append("  2\n");
                    continue;
                }
                if (rCenterFlag == 8192) {
                    s.append("  4\n");
                    continue;
                }
                if (rCenterFlag == 12288) {
                    s.append("  8\n");
                    continue;
                }
                if (rCenterFlag == 16384) {
                    s.append(" 12\n");
                    continue;
                }
                s.append("  0\n");
                continue;
            }
            s.append("  0\n");
        }
        this.mapp6 = false;
        for (i3 = 0; i3 < na; ++i3) {
            a = mol.getAtom(i3);
            int atno = a.getAtno();
            int[] list2 = a.getList();
            if (list2 == null || list2.length <= 0 || atno != 128 && atno != 129) continue;
            int count2 = list2.length;
            if (count2 > 5) {
                count2 = 5;
            }
            this.appendRight(i3 + 1, 3);
            s.append(atno == 128 ? " F" : " T");
            this.appendRight(count2, 5);
            for (j = 0; j < count2; ++j) {
                this.appendRight(list2[j], 4);
            }
            s.append('\n');
        }
        int l = -1;
        for (i2 = 0; i2 < na; ++i2) {
            boolean beilstein;
            MolAtom a3 = mol.getAtom(i2);
            String aliasstr = MolExport.convert2MDL(a3.getAliasstr());
            if (aliasstr == null || aliasstr.length() == 0) continue;
            boolean pseudo = a3.getAtno() == 136;
            boolean bl = beilstein = pseudo && MolfileUtil.isSpecBeilsteinGeneric(aliasstr);
            if (pseudo && aliasstr.length() <= 3 && !beilstein) continue;
            s.append("A  ");
            this.appendRight(i2 + 1, 3);
            s.append('\n');
            if (pseudo && !beilstein) {
                s.append('\'');
            }
            s.append(aliasstr);
            if (pseudo && !beilstein) {
                s.append('\'');
            }
            s.append('\n');
        }
        for (i2 = 0; i2 < na; ++i2) {
            MolAtom a4 = mol.getAtom(i2);
            String valueString = a4.getExtraLabel();
            if (valueString == null || valueString.length() == 0 || valueString.length() <= 0) continue;
            s.append("V  ");
            this.appendRight(i2 + 1, 3);
            s.append(" ");
            s.append(valueString);
            s.append('\n');
        }
        for (i2 = 0; i2 < nl; ++i2) {
            MolAtom a5 = null;
            int type = 0;
            while ((type = (a5 = mol.getAtom(++l)).getAtno()) != 128 && type != 129) {
            }
            s.append("M  ALS ");
            this.appendRight(l + 1, 3);
            int[] list3 = a5.getList();
            this.appendRight(list3 != null ? list3.length : 0, 3);
            s.append(type == 128 ? " F " : " T ");
            if (list3 != null) {
                for (j = 0; j < list3.length; ++j) {
                    this.appendLeft(MolAtom.symbolOf(list3[j]), 4);
                }
            }
            s.append('\n');
        }
        if (nc != 0) {
            count = 0;
            while (count < nc) {
                int n;
                int n2 = n = nc - count < 8 ? nc - count : 8;
                if (n == 0) {
                    n = 8;
                }
                s.append("M  CHG");
                this.appendRight(n, 3);
                for (int i6 = 0; i6 < n; ++i6) {
                    this.appendRight(cA[count] + 1, 4);
                    this.appendRight(mol.getAtom(cA[count]).getCharge(), 4);
                    ++count;
                }
                s.append('\n');
            }
        }
        if (nrad != 0) {
            count = 0;
            while (count < nrad) {
                int n;
                int n3 = n = nrad - count < 8 ? nrad - count : 8;
                if (n == 0) {
                    n = 8;
                }
                s.append("M  RAD");
                this.appendRight(n, 3);
                for (int i7 = 0; i7 < n; ++i7) {
                    this.appendRight(radA[count] + 1, 4);
                    MolAtom a6 = mol.getAtom(radA[count]);
                    int r = MolExport.convertRadical(a6.getRadical());
                    this.appendRight(r, 4);
                    ++count;
                }
                s.append('\n');
            }
        }
        if (niso != 0) {
            count = 0;
            while (count < niso) {
                int n;
                int n4 = n = niso - count < 8 ? niso - count : 8;
                if (n == 0) {
                    n = 8;
                }
                s.append("M  ISO");
                this.appendRight(n, 3);
                for (int i8 = 0; i8 < n; ++i8) {
                    this.appendRight(isoA[count] + 1, 4);
                    this.appendRight(mol.getAtom(isoA[count]).getMassno(), 4);
                    ++count;
                }
                s.append('\n');
            }
        }
        this.appendRlogicLines(mol);
        if (nrgp != 0) {
            count = 0;
            while (count < nrgp) {
                int n;
                int n5 = n = nrgp - count < 8 ? nrgp - count : 8;
                if (n == 0) {
                    n = 8;
                }
                s.append("M  RGP");
                this.appendRight(n, 3);
                for (int i9 = 0; i9 < n; ++i9) {
                    this.appendRight(rgpA[count] + 1, 4);
                    int k = rgpN[count];
                    if (k < 0) {
                        k = maxRgp - k;
                    }
                    this.appendRight(k, 4);
                    ++count;
                }
                s.append('\n');
            }
        }
        if (napo != 0) {
            s.append("M  APO");
            this.appendRight(napo, 3);
            for (i2 = 0; i2 < napo; ++i2) {
                int k = apoA[i2];
                this.appendRight(k + 1, 4);
                this.appendRight(attachmentConverter.getOrderValue(mol.getAtom(k)), 4);
            }
            s.append('\n');
        }
        if (nlin != 0) {
            count = 0;
            while (count < nlin) {
                int n;
                int n6 = n = nlin - count < 4 ? nlin - count : 4;
                if (n == 0) {
                    n = 4;
                }
                s.append("M  LIN");
                this.appendRight(n, 3);
                for (int i10 = 0; i10 < n; ++i10) {
                    this.appendRight(linA[count] + 1, 4);
                    MolAtom a7 = mol.getAtom(linA[count]);
                    this.appendRight(a7.getMaxRepetitions(), 4);
                    int out1 = a7.getLinkNodeOuterAtom(0);
                    int out2 = a7.getLinkNodeOuterAtom(1);
                    int i1 = -1;
                    if (out1 != -1 && out1 < a7.getBondCount()) {
                        i1 = mol.indexOf(a7.getLigand(out1));
                    }
                    int i22 = -1;
                    if (out2 != -1 && out2 < a7.getBondCount()) {
                        i22 = mol.indexOf(a7.getLigand(out2));
                    }
                    if (i1 > i22) {
                        int tmp = i1;
                        i1 = i22;
                        i22 = tmp;
                    }
                    this.appendRight(i1 + 1, 4);
                    this.appendRight(i22 + 1, 4);
                    ++count;
                }
                s.append('\n');
            }
        }
        if (nsub != 0) {
            count = 0;
            while (count < nsub) {
                int n;
                int n7 = n = nsub - count < 8 ? nsub - count : 8;
                if (n == 0) {
                    n = 8;
                }
                s.append("M  SUB");
                this.appendRight(n, 3);
                for (int i11 = 0; i11 < n; ++i11) {
                    this.appendRight(subA[count] + 1, 4);
                    int v = mol.getAtom(subA[count]).getQPropAsInt("s");
                    if (v == 0) {
                        v = -1;
                    }
                    this.appendRight(v, 4);
                    ++count;
                }
                s.append('\n');
            }
        }
        if (nrbc != 0) {
            count = 0;
            while (count < nrbc) {
                int n;
                int n8 = n = nrbc - count < 8 ? nrbc - count : 8;
                if (n == 0) {
                    n = 8;
                }
                s.append("M  RBC");
                this.appendRight(n, 3);
                for (int i12 = 0; i12 < n; ++i12) {
                    this.appendRight(rbcA[count] + 1, 4);
                    int v = mol.getAtom(rbcA[count]).getQPropAsInt("rb");
                    if (v == 0) {
                        v = -1;
                    }
                    this.appendRight(v, 4);
                    ++count;
                }
                s.append('\n');
            }
        }
        if (nuns != 0) {
            count = 0;
            while (count < nuns) {
                int n;
                int n9 = n = nuns - count < 8 ? nuns - count : 8;
                if (n == 0) {
                    n = 8;
                }
                s.append("M  UNS");
                this.appendRight(n, 3);
                for (int i13 = 0; i13 < n; ++i13) {
                    this.appendRight(unsA[count] + 1, 4);
                    this.appendRight(mol.getAtom(unsA[count]).getQPropAsInt("u"), 4);
                    ++count;
                }
                s.append('\n');
            }
        }
        int nsg = mol.getSgroupCount();
        ArrayList<Integer> pcsgroups = null;
        if (nsg != 0) {
            int count3 = 0;
            while (count3 < nsg) {
                int n;
                int n10 = n = nsg - count3 < 8 ? nsg - count3 : 8;
                if (n == 0) {
                    n = 8;
                }
                s.append("M  STY");
                this.appendRight(n, 3);
                for (int i14 = 0; i14 < n; ++i14) {
                    Sgroup sg = mol.getSgroup(count3);
                    this.appendRight(count3 + 1, 4);
                    s.append(' ');
                    int type = sg.getType();
                    s.append(MolfileUtil.SGROUP_TYPENAMES[type]);
                    Sgroup psg = sg.getParentSgroup();
                    if (psg != null) {
                        if (pcsgroups == null) {
                            pcsgroups = new ArrayList<Integer>();
                        }
                        pcsgroups.add(new Integer(count3));
                        pcsgroups.add(new Integer(mol.indexOf(psg)));
                    }
                    ++count3;
                }
                s.append('\n');
            }
        }
        if (pcsgroups != null) {
            int j2 = 0;
            int nspl = pcsgroups.size() / 2;
            while (j2 < nspl) {
                int n;
                int n11 = n = nspl - j2 < 8 ? nspl - j2 : 8;
                if (n == 0) {
                    n = 8;
                }
                s.append("M  SPL");
                this.appendRight(n, 3);
                for (int i15 = 0; i15 < n; ++i15) {
                    int k1 = (Integer)pcsgroups.get(2 * j2);
                    int k2 = (Integer)pcsgroups.get(2 * j2 + 1);
                    this.appendRight(k1 + 1, 4);
                    this.appendRight(k2 + 1, 4);
                    ++j2;
                }
                s.append('\n');
            }
        }
        int nfsg = mol.countOrderedComponentSgroups();
        int nsgs = mol.getSgroupCount();
        if (nfsg != 0) {
            int count4 = 0;
            int componentCount = 0;
            while (count4 < nsgs && componentCount < nfsg) {
                int n;
                int n12 = n = nfsg - componentCount < 8 ? nfsg - componentCount : 8;
                if (n == 0) {
                    n = 8;
                }
                s.append("M  SNC");
                this.appendRight(n, 3);
                for (int i16 = 0; i16 < n; ++i16) {
                    while (!mol.getSgroup(count4).isOrderedComponentSgroup()) {
                        ++count4;
                    }
                    Sgroup sg = mol.getSgroup(count4);
                    this.appendRight(count4 + 1, 4);
                    int order = Integer.parseInt(sg.getSubscript().substring(1));
                    this.appendRight(order, 4);
                    ++componentCount;
                    ++count4;
                }
                s.append('\n');
            }
        }
        if ((size = (list = this.getSpecialTypeSgroups(mol)).size()) != 0) {
            s.append("M  SBT");
            this.appendRight(size, 3);
            for (i = 0; i < size; ++i) {
                this.appendRight(list.get(i) + 1, 4);
                this.appendRight(1, 4);
            }
            s.append('\n');
        }
        for (i = 1; i <= nsg; ++i) {
            MolBond[] sgbonds;
            int k;
            int j3;
            int scn;
            Sgroup sg = mol.getSgroup(i - 1);
            int type = sg.getType();
            int subtype = sg.getSubType();
            if (subtype != 0) {
                s.append("M  SST  1");
                this.appendRight(i, 4);
                s.append(' ');
                s.append(SGROUP_SUBTYPES[subtype]);
                s.append('\n');
            }
            if ((scn = sg.getConnectivity()) != 0) {
                s.append("M  SCN  1");
                this.appendRight(i, 4);
                s.append(' ');
                s.append(SGROUP_CONNECTIVITIES[scn]);
                s.append(" \n");
            }
            int n = sg.getAtomCount();
            for (int j4 = 0; j4 < n; j4 += 15) {
                int m = j4 < n - 15 ? 15 : n - j4;
                s.append("M  SAL");
                this.appendRight(i, 4);
                this.appendRight(m, 3);
                m += j4;
                for (int k2 = j4; k2 < m; ++k2) {
                    this.appendRight(mol.indexOf(sg.getAtom(k2)) + 1, 4);
                }
                s.append('\n');
            }
            if (sg instanceof MultipleSgroup) {
                MultipleSgroup mulsg = (MultipleSgroup)sg;
                n = mulsg.getRepeatingUnitAtomCount();
                for (j3 = 0; j3 < n; j3 += 15) {
                    int m = j3 < n - 15 ? 15 : n - j3;
                    s.append("M  SPA");
                    this.appendRight(i, 4);
                    this.appendRight(m, 3);
                    m += j3;
                    for (k = j3; k < m; ++k) {
                        MolAtom a8 = mulsg.getRepeatingUnitAtom(k);
                        this.appendRight(mol.indexOf(a8) + 1, 4);
                    }
                    s.append('\n');
                }
            }
            if (type != 0 && type != 10 && sg.hasBrackets() && sg.getBracketCount() == 0) {
                double[][] coords = DrawingUtil.getBracketCoords(sg);
                for (j3 = 0; j3 < coords.length; ++j3) {
                    s.append("M  SDI");
                    this.appendRight(i, 4);
                    this.appendRight(4, 3);
                    for (int k3 = 0; k3 < 6; ++k3) {
                        if (k3 % 3 == 2) continue;
                        this.appendRight(xyzCoordScale * coords[1 - j3][k3]);
                    }
                    s.append('\n');
                }
            }
            if (sg.getBracketCount() != 0) {
                double[][] coords = this.getCoords(sg);
                for (j3 = 0; j3 < coords.length; ++j3) {
                    s.append("M  SDI");
                    this.appendRight(i, 4);
                    this.appendRight(4, 3);
                    for (int k4 = 0; k4 < 6; ++k4) {
                        if (k4 % 3 == 2) continue;
                        this.appendRight(xyzCoordScale * coords[j3][k4]);
                    }
                    s.append('\n');
                }
            }
            if (sg instanceof RepeatingUnitSgroup && (sgbonds = ((RepeatingUnitSgroup)sg).getBondConnectionInfo()) != null) {
                for (j3 = 0; j3 < sgbonds.length; j3 += 15) {
                    int m = j3 < sgbonds.length - 15 ? 15 : sgbonds.length - j3;
                    s.append("M  CRS");
                    this.appendRight(i, 4);
                    this.appendRight(m, 3);
                    m += j3;
                    for (k = j3; k < m; ++k) {
                        this.appendRight(mol.indexOf(sgbonds[k]) + 1, 4);
                    }
                    s.append('\n');
                }
            }
            if (type == 0 || type == 1 || sg instanceof RepeatingUnitSgroup) {
                sgbonds = sg.findCrossingBonds();
                for (j3 = 0; j3 < sgbonds.length; j3 += 15) {
                    int m = j3 < sgbonds.length - 15 ? 15 : sgbonds.length - j3;
                    s.append("M  SBL");
                    this.appendRight(i, 4);
                    this.appendRight(m, 3);
                    m += j3;
                    for (k = j3; k < m; ++k) {
                        this.appendRight(mol.indexOf(sgbonds[k]) + 1, 4);
                    }
                    s.append('\n');
                }
            }
            if (type == 0 || sg instanceof RepeatingUnitSgroup) {
                String name;
                String string = name = type == 0 ? MolExport.convert2MDL(sg.getSubscript()) : sg.getSubscript();
                if (name.length() != 0) {
                    s.append("M  SMT");
                    this.appendRight(i, 4);
                    s.append(' ');
                    s.append(name);
                    s.append('\n');
                }
            }
            if (type == 1) {
                s.append("M  SMT");
                this.appendRight(i, 4);
                s.append(' ');
                s.append(((MultipleSgroup)sg).getMultiplier());
                s.append('\n');
            }
            if (type == 0) {
                n = sg.getAtomCount();
                boolean appendAPO = false;
                for (j3 = 0; j3 < n; ++j3) {
                    MolAtom atom = sg.getAtom(j3);
                    int molIndex = mol.indexOf(atom);
                    if (atom.getAttach() == 1 || atom.getAttach() == 2) {
                        this.appendSAPV2(s, i, molIndex);
                        appendAPO = true;
                        continue;
                    }
                    if (atom.getAttach() != 3) continue;
                    this.appendSAPV2(s, i, molIndex);
                    this.appendSAPV2(s, i, molIndex);
                    appendAPO = true;
                }
                if (appendAPO) {
                    this.appendSCL(s, i);
                }
            }
            if (type == 10) {
                this.appendDataSgroupV2(sg, i);
            }
            if (sg.getXState() != 1 || !(sg instanceof Expandable) || !((Expandable)((Object)sg)).isExpanded()) continue;
            s.append("M  SDS EXP  1");
            this.appendRight(i, 4);
            s.append('\n');
        }
        for (i = 0; i < nsma; ++i) {
            s.append("M  MRV SMA");
            int k = smaA[i];
            this.appendRight(k + 1, 4);
            s.append(' ');
            MolAtom a9 = mol.getAtom(k);
            s.append(a9.getAtomSymbol(33, -1, null, null));
            s.append('\n');
        }
        if (nCTorU != 0) {
            s.append("M  MRV CTU");
            this.appendRight(nCTorU, 3);
            for (i = 0; i < nCTorU; ++i) {
                this.appendRight(ctuA[i] + 1, 4);
            }
            s.append('\n');
        }
    }

    private void appendSCL(StringBuffer s, int i) {
        s.append("M  SCL");
        this.appendRight(i, 4);
        s.append(' ');
        s.append("CXN");
        s.append('\n');
    }

    private void appendSAPV2(StringBuffer s, int sgroupIndex, int atomIndex) {
        s.append("M  SAP");
        this.appendRight(sgroupIndex, 4);
        this.appendRight(1, 3);
        this.appendRight(atomIndex + 1, 4);
        s.append('\n');
    }

    private static int mdlParity(int p) {
        return p == 0 ? 0 : (p == 1 ? 1 : (p == 2 ? 2 : 3));
    }

    private double[][] getCoords(Sgroup sg) {
        Object coords = null;
        if (sg.getBracketCount() != 0) {
            ArrayList<MBracket> list = sg.getBrackets();
            if (list.get(0).getBracketOrientation() == 4) {
                coords = new double[sg.getBracketCount()][];
                for (int i = list.size() - 1; i > -1; --i) {
                    coords[i] = this.fill(list.get(i).getPoint(0).getLocation(), list.get(i).getPoint(3).getLocation());
                }
            } else {
                coords = new double[2][];
                coords[0] = this.fill(list.get(0).getPoint(3).getLocation(), list.get(0).getPoint(0).getLocation());
                coords[1] = this.fill(list.get(0).getPoint(1).getLocation(), list.get(0).getPoint(2).getLocation());
            }
        } else {
            RepeatingUnitSgroup sru;
            MolBond[] bondList;
            coords = sg instanceof RepeatingUnitSgroup ? ((bondList = (sru = (RepeatingUnitSgroup)sg).findCrossingBonds()).length > 0 ? (sru.getHeadCrossingBonds() != null && sru.getTailCrossingBonds() != null ? DrawingUtil.getBracketCoords(sru) : DrawingUtil.getSimpleBracketCoords(sru)) : DrawingUtil.getBracketCoordsfromChildren(sru)) : DrawingUtil.getBracketCoordsfromChildren(sg);
        }
        return coords;
    }

    private double[] fill(DPoint3 p0, DPoint3 p3) {
        double[] coords = new double[]{p0.x, p0.y, p0.z, p3.x, p3.y, p3.z, 0.0, 0.0, 0.0};
        return coords;
    }

    private void appendDataSgroupV2(Sgroup sg, int sgroupNo) {
        DataSgroup dsg = (DataSgroup)sg;
        StringBuffer s = this.stringBuffer;
        s.append("M  SDT");
        this.appendRight(sgroupNo, 4);
        s.append(' ');
        this.appendLeft(dsg.getFieldName(), 30);
        String typeS = "  ";
        if (dsg.getFieldType() == 1) {
            typeS = "F ";
        } else if (dsg.getFieldType() == 2) {
            typeS = "N ";
        } else if (dsg.getFieldType() == 3) {
            typeS = "T ";
        }
        this.appendLeft(typeS, 2);
        this.appendLeft(dsg.getUnits(), 20);
        this.appendLeft(dsg.getQueryCode(), 2);
        s.append(dsg.getQueryOp() == null ? "" : dsg.getQueryOp());
        s.append("\n");
        s.append("M  SDD");
        this.appendRight(sgroupNo, 4);
        s.append(' ');
        String sddData = this.getSDDData(dsg);
        s.append(sddData);
        s.append("  \n");
        if (dsg.getContextId() != -1) {
            s.append("M  MRV SDD");
            this.appendRight(sgroupNo, 4);
            this.appendRight(dsg.getContextId(), 3);
            s.append("\n");
        }
        for (int i = 0; i < dsg.getDataLineCount(); ++i) {
            this.appendDataSgroupLineV2(dsg.getDataLine(i), s, sgroupNo);
        }
    }

    private void appendDataSgroupLineV2(String line, StringBuffer s, int sgroupNo) {
        while (line.length() > 69) {
            s.append("M  SCD");
            this.appendRight(sgroupNo, 4);
            s.append(' ');
            s.append(line.substring(0, 69));
            s.append('\n');
            line = line.substring(69);
        }
        s.append("M  SED");
        this.appendRight(sgroupNo, 4);
        s.append(' ');
        s.append(line);
        s.append('\n');
    }

    private int getV1charge(int chg) {
        if (chg == 0) {
            return 0;
        }
        if (chg >= -3 && chg <= 3) {
            return 4 - chg;
        }
        return 0;
    }

    private static int countSpecBeilsteinSgroup(MoleculeGraph m) {
        int n = 0;
        int na = m.getAtomCount();
        for (int i = 0; i < na; ++i) {
            MolAtom a = m.getAtom(i);
            if (a.getAtno() != 136 || !MolfileUtil.isSpecBeilsteinGeneric(a.getAliasstr())) continue;
            ++n;
        }
        return n;
    }

    private void appendCtabV3(Molecule mol, int na, int nb, double xyzCoordsScale, boolean inRgroupBlock, AttachmentConverter attachmentConverter) {
        int i;
        StringBuffer s = this.stringBuffer;
        StringBuffer stmp = new StringBuffer();
        s.append("M  V30 BEGIN CTAB\nM  V30 COUNTS ");
        s.append(na);
        s.append(' ');
        s.append(nb);
        s.append(' ');
        int nbeilsteinsg = MolExport.countSpecBeilsteinSgroup(mol);
        int nsg = this.getSgroupCount(mol, inRgroupBlock);
        ArrayList<MolAtom> atomList = attachmentConverter.getAtomListForMultipleAttachment();
        s.append(nsg + nbeilsteinsg);
        s.append(" 0 ");
        s.append(mol.isAbsStereo() ? (char)'1' : '0');
        s.append("\nM  V30 BEGIN ATOM\n");
        ArrayList<MolAtom> linA = null;
        for (i = 0; i < na; ++i) {
            int rbcnt;
            int subst;
            int rxnstereo;
            int qhcount;
            int val;
            int mass;
            int para;
            int rad;
            boolean beilstein;
            MolAtom a = mol.getAtom(i);
            int chg = a.getCharge();
            int aamap = a.getAtomMap();
            int atno = a.getAtno();
            this.lineStartIndex = s.length();
            s.append("M  V30 ");
            s.append(i + 1);
            s.append(' ');
            boolean bl = beilstein = atno == 136 && MolfileUtil.isSpecBeilsteinGeneric(a.getAliasstr());
            if (beilstein) {
                s.append("C");
            } else if (atno == 128 || atno == 129) {
                s.append(atno == 129 ? "\"NOT [" : "[");
                int[] list = a.getList();
                for (int j = 0; j < list.length; ++j) {
                    if (j > 0) {
                        s.append(',');
                    }
                    String sym = MolAtom.symbolOf(list[j]);
                    s.append(sym);
                }
                s.append(atno == 129 ? "]\"" : "]");
            } else if (atno == 136) {
                s.append(a.getAliasstr());
            } else if (atno == 137) {
                s.append("\" \"");
            } else {
                s.append(a.getSymbol());
            }
            s.append(' ');
            this.appendCoordV3(xyzCoordsScale * a.getX());
            s.append(' ');
            this.appendCoordV3(xyzCoordsScale * a.getY());
            s.append(' ');
            this.appendCoordV3(xyzCoordsScale * a.getZ());
            s.append(' ');
            s.append(aamap);
            if (chg != 0) {
                this.appendV3field("CHG", chg, stmp);
            }
            if ((rad = a.getRadical()) != 0) {
                this.appendV3field("RAD", MolExport.convertRadical(rad), stmp);
            }
            if ((para = mol.getLocalParity(i)) != 0) {
                this.appendV3field("CFG", MolExport.mdlParity(para), stmp);
            }
            if ((mass = a.getMassno()) != 0 && !a.isSpecIsotopeSymbolUsed()) {
                this.appendV3field("MASS", mass, stmp);
            }
            if ((val = a.getValenceProp()) != -1) {
                this.appendV3field("VAL", val == 0 ? -1 : val, stmp);
            }
            if ((qhcount = a.getQPropAsInt("H")) != -1) {
                this.appendV3field("HCOUNT", qhcount == 0 ? -1 : qhcount, stmp);
            }
            if (a.getStereoCare()) {
                this.appendV3field("STBOX", 1, stmp);
            }
            if ((rxnstereo = a.getReactionStereo()) != 0) {
                this.appendV3field("INVRET", rxnstereo, stmp);
            }
            if ((subst = a.getQPropAsInt("s")) == 0) {
                this.appendV3field("SUBST", -1, stmp);
            } else if (subst != -1) {
                this.appendV3field("SUBST", subst, stmp);
            }
            int unsat = a.getQPropAsInt("u");
            if (unsat != -1) {
                this.appendV3field("UNSAT", unsat, stmp);
            }
            if ((rbcnt = a.getQPropAsInt("rb")) == 0) {
                this.appendV3field("RBCNT", -1, stmp);
            } else if (rbcnt != -1) {
                this.appendV3field("RBCNT", rbcnt, stmp);
            }
            if (atomList.contains(a)) {
                this.appendATTCHPT(attachmentConverter, stmp, a);
            }
            if (a.getAtno() == 134) {
                int[] data = new int[]{a.getRgroup()};
                this.appendV3list("RGROUPS", data, stmp);
            }
            if (a.isLinkNode()) {
                if (linA == null) {
                    linA = new ArrayList<MolAtom>();
                }
                linA.add(a);
            }
            s.append('\n');
        }
        s.append("M  V30 END ATOM\n");
        if (nb != 0) {
            s.append("M  V30 BEGIN BOND\n");
            for (i = 0; i < nb; ++i) {
                int rCenterFlag;
                this.lineStartIndex = s.length();
                s.append("M  V30 ");
                s.append(i + 1);
                s.append(' ');
                MolBond b = mol.getBond(i);
                int flags = b.getFlags();
                MolAtom a1 = b.getAtom1();
                MolAtom a2 = b.getAtom2();
                int j1 = mol.indexOf(a1);
                int j2 = mol.indexOf(a2);
                int type = flags & 0xF;
                s.append((char)(type == 0 ? 56 : 48 + type));
                s.append(' ');
                s.append(j1 + 1);
                s.append(' ');
                s.append(j2 + 1);
                if (b.isBold()) {
                    this.appendV3field("CFG", 1, stmp);
                }
                int stereo1 = flags & 0x30;
                int stereo2 = flags & 0x1C0;
                if (stereo1 != 0) {
                    this.appendV3field("CFG", stereo1 == 16 ? 1 : (stereo1 == 32 ? 3 : 2), stmp);
                } else if (type == 2 && stereo2 == 192) {
                    this.appendV3field("CFG", 2, stmp);
                }
                int topo = flags & 0xC00;
                if (topo != 0) {
                    this.appendV3field("TOPO", topo == 1024 ? 1 : 2, stmp);
                }
                if ((rCenterFlag = flags & 0xF000) != 0 && (rCenterFlag = rCenterFlag == 20480 ? -1 : (rCenterFlag == 4096 ? 1 : (rCenterFlag == 24576 ? 2 : (rCenterFlag == 8192 ? 4 : (rCenterFlag == 12288 ? 8 : (rCenterFlag == 16384 ? 12 : 0)))))) != 0) {
                    this.appendV3field("RXCTR", rCenterFlag, stmp);
                }
                if ((flags & 0x200) != 0) {
                    this.appendV3field("STBOX", 1, stmp);
                }
                s.append('\n');
            }
            s.append("M  V30 END BOND\n");
        }
        if (linA != null) {
            this.appendV3LinkNodes(mol, linA);
        }
        this.appendV3Sgroup(mol, stmp, inRgroupBlock, nbeilsteinsg);
        this.appendV3Collection(mol, na, stmp);
        s.append("M  V30 END CTAB\n");
    }

    private void appendATTCHPT(AttachmentConverter attachmentConverter, StringBuffer stmp, MolAtom a) {
        ArrayList<Integer> orderList = attachmentConverter.getOrderValues(a);
        if (orderList.contains(1) && orderList.contains(2)) {
            orderList.remove(orderList.indexOf(1));
            orderList.remove(orderList.indexOf(2));
            this.appendV3field("ATTCHPT", -1, stmp);
        }
        for (int order : orderList) {
            this.appendV3field("ATTCHPT", order, stmp);
        }
    }

    private void appendV3LinkNodes(Molecule mol, List<MolAtom> linA) {
        StringBuffer s = this.stringBuffer;
        for (int i = 0; i < linA.size(); ++i) {
            MolAtom a = linA.get(i);
            int i0 = mol.indexOf(a);
            s.append("M  V30 LINKNODE ");
            s.append(a.getMinRepetitions());
            s.append(' ');
            s.append(a.getMaxRepetitions());
            s.append(' ');
            int out1 = a.getLinkNodeOuterAtom(0);
            int out2 = a.getLinkNodeOuterAtom(1);
            int i1 = -1;
            if (out1 != -1 && out1 < a.getBondCount()) {
                i1 = mol.indexOf(a.getLigand(out1));
            }
            int i2 = -1;
            if (out2 != -1 && out2 < a.getBondCount()) {
                i2 = mol.indexOf(a.getLigand(out2));
            }
            int n = (i1 == -1 ? 0 : 1) + (i2 == -1 ? 0 : 1);
            s.append(n);
            if (i1 > i2) {
                int tmp = i1;
                i1 = i2;
                i2 = tmp;
            }
            if (i1 != -1) {
                s.append(' ');
                s.append(i0 + 1);
                s.append(' ');
                s.append(i1 + 1);
            }
            if (i2 != -1) {
                s.append(' ');
                s.append(i0 + 1);
                s.append(' ');
                s.append(i2 + 1);
            }
            s.append('\n');
        }
    }

    private boolean isSgroupToWrite(Molecule mol, Sgroup sg, boolean inRgroupBlock) {
        if (inRgroupBlock) {
            return mol.getParent() != null && mol.getParent() instanceof RgMolecule;
        }
        if (!inRgroupBlock && mol instanceof RgMolecule) {
            RgMolecule rgm = (RgMolecule)mol;
            int m = rgm.getRgroupCount();
            for (int j = 0; j < m; ++j) {
                int n = rgm.getRgroupMemberCount(j);
                for (int i = 0; i < n; ++i) {
                    Molecule mm = rgm.getRgroupMember(j, i);
                    if (mm.indexOf(sg) < 0) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean findSgroupsToWrite(Molecule mol, boolean inRgroupBlock) {
        int nsg = mol.getSgroupCount();
        for (int i = 0; i < nsg; ++i) {
            Sgroup sg = mol.getSgroup(i);
            if (!this.isSgroupToWrite(mol, sg, inRgroupBlock)) continue;
            return true;
        }
        return false;
    }

    private int getSgroupCount(Molecule mol, boolean inRgroupBlock) {
        int nsg = mol.getSgroupCount();
        int nsgw = 0;
        for (int i = 0; i < nsg; ++i) {
            Sgroup sg = mol.getSgroup(i);
            if (!this.isSgroupToWrite(mol, sg, inRgroupBlock)) continue;
            ++nsgw;
        }
        return nsgw;
    }

    private void appendV3Sgroup(Molecule molecule, StringBuffer stmp, boolean inRgroupBlock, int nbeilsteinsg) {
        int nsg = molecule.getSgroupCount();
        if (nbeilsteinsg == 0 && !this.findSgroupsToWrite(molecule, inRgroupBlock)) {
            return;
        }
        if (nsg + nbeilsteinsg != 0) {
            int i;
            StringBuffer s = this.stringBuffer;
            s.append("M  V30 BEGIN SGROUP\n");
            if (nbeilsteinsg != 0) {
                i = 0;
                int na = molecule.getAtomCount();
                for (int j = 0; j < na && i < nbeilsteinsg; ++j) {
                    MolAtom a = molecule.getAtom(j);
                    if (a.getAtno() != 136 || !MolfileUtil.isSpecBeilsteinGeneric(a.getAliasstr())) continue;
                    s.append("M  V30 ");
                    s.append(++i);
                    s.append(" SUP 0 -\nM  V30 ATOMS=(1 ");
                    s.append(j + 1);
                    s.append(") -\nM  V30 LABEL=\"");
                    s.append(a.getAliasstr());
                    s.append("\"\n");
                }
            }
            for (i = 1; i <= nsg; ++i) {
                Sgroup psg;
                int scn;
                int subtype;
                MultipleSgroup mulsg;
                int n;
                MolBond[] sgbonds;
                Sgroup sg = molecule.getSgroup(i - 1);
                if (!this.isSgroupToWrite(molecule, sg, inRgroupBlock)) continue;
                int type = sg.getType();
                this.lineStartIndex = s.length();
                s.append("M  V30 ");
                s.append(nbeilsteinsg + i);
                s.append(' ');
                s.append(MolfileUtil.SGROUP_TYPENAMES[type]);
                s.append(" 0");
                int[] data = new int[sg.getAtomCount()];
                for (int j = 0; j < data.length; ++j) {
                    data[j] = molecule.indexOf(sg.getAtom(j)) + 1;
                }
                this.appendV3list("ATOMS", data, stmp);
                if (type == 0 || type == 1) {
                    MolAtom[] atoms;
                    for (MolAtom atom : atoms = sg.getAtomArray()) {
                        if (atom.getAttach() == 1 || atom.getAttach() == 2) {
                            this.appendSAPV3(molecule.indexOf(atom), atom.getAttach(), stmp);
                            continue;
                        }
                        if (atom.getAttach() != 3) continue;
                        this.appendSAPV3(molecule.indexOf(atom), 1, stmp);
                        this.appendSAPV3(molecule.indexOf(atom), 2, stmp);
                    }
                }
                if ((type == 0 || type == 1 || sg instanceof RepeatingUnitSgroup) && (sgbonds = sg.findCrossingBonds()).length != 0) {
                    data = new int[sgbonds.length];
                    for (int j = 0; j < data.length; ++j) {
                        data[j] = molecule.indexOf(sgbonds[j]) + 1;
                    }
                    this.appendV3list("XBONDS", data, stmp);
                }
                if (sg instanceof RepeatingUnitSgroup && (sgbonds = ((RepeatingUnitSgroup)sg).getHeadCrossingBonds()) != null) {
                    data = new int[sgbonds.length];
                    for (int j = 0; j < data.length; ++j) {
                        data[j] = molecule.indexOf(sgbonds[j]) + 1;
                    }
                    this.appendV3list("XBHEAD", data, stmp);
                }
                if (sg.getType() == 2 && (sgbonds = ((RepeatingUnitSgroup)sg).getBondCorrespondence()) != null) {
                    data = new int[sgbonds.length];
                    for (int j = 0; j < data.length; ++j) {
                        data[j] = molecule.indexOf(sgbonds[j]) + 1;
                    }
                    this.appendV3list("XBCORR", data, stmp);
                }
                if (sg.hasBrackets() && sg.getBracketCount() == 0 && type != 0 && type != 10) {
                    double[][] coords = DrawingUtil.getBracketCoords(sg);
                    for (int j = 0; j < 2; ++j) {
                        int k = 0;
                        while (k < coords[j].length) {
                            double[] dArray = coords[j];
                            int n2 = k++;
                            dArray[n2] = dArray[n2] * this.xyzScale;
                        }
                        this.appendV3list("BRKXYZ", coords[j], stmp);
                    }
                }
                if (sg.hasBrackets() && sg.getBracketCount() != 0) {
                    double[][] coords = this.getCoords(sg);
                    for (int j = 0; j < coords.length; ++j) {
                        double[] bracketCoords3D = this.getBracketCoordList(coords[j]);
                        this.appendV3list("BRKXYZ", bracketCoords3D, stmp);
                    }
                }
                if (sg.hasBrackets() && sg.getBracketCount() != 0 && sg.getBrackets().get(0).getType() == 0) {
                    this.appendV3field("BRKTYP", "PAREN", stmp, true);
                }
                if (sg instanceof MultipleSgroup && (n = (mulsg = (MultipleSgroup)sg).getRepeatingUnitAtomCount()) != 0) {
                    data = new int[n];
                    for (int j = 0; j < data.length; ++j) {
                        MolAtom a = mulsg.getRepeatingUnitAtom(j);
                        data[j] = molecule.indexOf(a) + 1;
                    }
                    this.appendV3list("PATOMS", data, stmp);
                }
                if ((subtype = sg.getSubType()) != 0) {
                    this.appendV3field("SUBTYPE", SGROUP_SUBTYPES[subtype], stmp, true);
                }
                if ((scn = sg.getConnectivity()) != 0) {
                    this.appendV3field("CONNECT", SGROUP_CONNECTIVITIES[scn], stmp, true);
                }
                if ((psg = sg.getParentSgroup()) != null) {
                    this.appendV3field("PARENT", molecule.indexOf(psg) + 1, stmp);
                }
                if (sg.isOrderedComponentSgroup()) {
                    this.appendV3field("COMPNO", sg.getSubscript().substring(1), stmp, true);
                }
                if (type == 0 || sg instanceof RepeatingUnitSgroup) {
                    String name = MolExport.convert2MDL(sg.getSubscript());
                    if (name.length() != 0) {
                        this.appendV3field("LABEL", name, stmp, true);
                    }
                } else if (type == 1) {
                    this.appendV3field("MULT", ((MultipleSgroup)sg).getMultiplier(), stmp);
                } else if (type == 10) {
                    this.appendDataSgroupV3((DataSgroup)sg, stmp);
                }
                if (sg.getXState() == 1 && sg instanceof Expandable && ((Expandable)((Object)sg)).isExpanded()) {
                    this.appendV3field("ESTATE", "E", stmp, true);
                }
                s.append('\n');
            }
            s.append("M  V30 END SGROUP\n");
        }
    }

    private void appendSAPV3(int atomIndex, int order, StringBuffer stmp) {
        StringBuffer s = this.stringBuffer;
        this.appendV3listHead("SAP", stmp);
        stmp.append('3');
        this.appendV3String(s.length() - this.lineStartIndex, stmp);
        stmp.setLength(0);
        stmp.append(' ');
        stmp.append(Integer.toString(atomIndex + 1));
        this.appendV3String(s.length() - this.lineStartIndex, stmp);
        stmp.setLength(0);
        stmp.append(' ');
        stmp.append('0');
        this.appendV3String(s.length() - this.lineStartIndex, stmp);
        stmp.setLength(0);
        stmp.append(' ');
        stmp.append(Integer.toString(order) + ")");
        this.appendV3String(s.length() - this.lineStartIndex, stmp);
    }

    private void appendString(StringBuffer stmp, String value, boolean addSpace) {
        stmp.setLength(0);
        if (addSpace) {
            stmp.append(' ');
        }
        stmp.append(value);
        this.appendV3String(this.stringBuffer.length() - this.lineStartIndex, stmp);
    }

    private double[] getBracketCoordList(double[] coords) {
        double[] bracketCoords = new double[]{coords[0] * this.xyzScale, coords[1] * this.xyzScale, coords[2] * this.xyzScale, coords[3] * this.xyzScale, coords[4] * this.xyzScale, coords[5] * this.xyzScale, 0.0, 0.0, 0.0};
        return bracketCoords;
    }

    private void appendDataSgroupV3(DataSgroup dsg, StringBuffer stmp) {
        this.appendV3field("FIELDNAME", dsg.getFieldName(), stmp, true);
        String typeS = "";
        if (dsg.getFieldType() == 1) {
            typeS = "F ";
        } else if (dsg.getFieldType() == 2) {
            typeS = "N ";
        } else if (dsg.getFieldType() == 3) {
            typeS = "T ";
        }
        String units = dsg.getUnits();
        if (units == null) {
            units = "";
        }
        if (typeS.length() + units.length() > 0) {
            this.appendV3field("FIELDINFO", typeS + units, stmp, true);
        }
        this.appendV3field("FIELDDISP", this.getSDDData(dsg), stmp, true);
        if (dsg.getContextId() != -1) {
            this.appendV3field("MRV_FIELDDISP", dsg.getContextId(), stmp);
        }
        if (dsg.getQueryCode() != null) {
            this.appendV3field("QUERYTYPE", dsg.getQueryCode(), stmp, true);
        }
        if (dsg.getQueryOp() != null) {
            this.appendV3field("QUERYOP", dsg.getQueryOp(), stmp, true);
        }
        for (int i = 0; i < dsg.getDataLineCount(); ++i) {
            this.appendV3field("FIELDDATA", dsg.getDataLine(i), stmp, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSDDData(DataSgroup dsg) {
        StringBuffer s = new StringBuffer(80);
        StringBuffer oldsb = this.stringBuffer;
        this.stringBuffer = s;
        try {
            this.appendRight(this.xyzScale * dsg.getX());
            this.appendRight(this.xyzScale * dsg.getY());
            this.appendChars(4, ' ');
            s.append(dsg.isDataDetached() ? (char)'D' : 'A');
            s.append(dsg.isAbsolutePlacement() ? (char)'A' : 'R');
            s.append(dsg.isUnitDisplayed() ? (char)'U' : ' ');
            this.appendChars(3, ' ');
            if (dsg.getDisplayedChars() == 0) {
                s.append("ALL");
            } else {
                this.appendRight(dsg.getDisplayedChars(), 3);
            }
            this.appendRight(dsg.getDisplayedLines(), 3);
            this.appendChars(4, ' ');
            s.append(dsg.getTag());
            s.append("  ");
            this.appendRight(dsg.getPos(), 1);
        }
        finally {
            this.stringBuffer = oldsb;
        }
        return s.toString();
    }

    private void appendV3Collection(Molecule mol, int na, StringBuffer stmp) {
        int nstgrpAbs = 0;
        int nstgrpOr = 0;
        int nstgrpAnd = 0;
        int stgrpmax = 0;
        for (int i = 0; i < na; ++i) {
            MolAtom a = mol.getAtom(i);
            int t = a.getStereoGroupType();
            if (t == 0) continue;
            if (t == 1) {
                ++nstgrpAbs;
            } else if (t == 2) {
                ++nstgrpOr;
            } else if (t == 3) {
                ++nstgrpAnd;
            }
            int n = a.getStereoGroupNumber();
            if (n <= stgrpmax) continue;
            stgrpmax = n;
        }
        if (nstgrpAbs != 0 || nstgrpOr != 0 || nstgrpAnd != 0) {
            StringBuffer s = this.stringBuffer;
            s.append("M  V30 BEGIN COLLECTION\n");
            int[] data = new int[nstgrpAbs];
            int[] groupNumbersOr = new int[stgrpmax + 1];
            int[] groupNumbersAnd = new int[stgrpmax + 1];
            int j = 0;
            for (int i = 0; i < na; ++i) {
                MolAtom a = mol.getAtom(i);
                int t = a.getStereoGroupType();
                if (t == 1) {
                    data[j++] = i + 1;
                    continue;
                }
                if (t == 2) {
                    int n = a.getStereoGroupNumber();
                    groupNumbersOr[n] = groupNumbersOr[n] + 1;
                    continue;
                }
                if (t != 3) continue;
                int n = a.getStereoGroupNumber();
                groupNumbersAnd[n] = groupNumbersAnd[n] + 1;
            }
            if (nstgrpAbs > 0) {
                this.lineStartIndex = s.length();
                s.append("M  V30 MDLV30/STEABS");
                this.appendV3list("ATOMS", data, stmp);
                s.append('\n');
            }
            if (nstgrpOr > 0) {
                this.appendV3StereoGroups(2, groupNumbersOr, mol, stmp);
            }
            if (nstgrpAnd > 0) {
                this.appendV3StereoGroups(3, groupNumbersAnd, mol, stmp);
            }
            s.append("M  V30 END COLLECTION\n");
        }
    }

    private void appendV3StereoGroups(int type, int[] groupNumbers, Molecule mol, StringBuffer stmp) {
        StringBuffer s = this.stringBuffer;
        for (int i = 0; i < groupNumbers.length; ++i) {
            if (groupNumbers[i] == 0) continue;
            int[] data = new int[groupNumbers[i]];
            int k = 0;
            for (int j = 0; j < mol.getAtomCount(); ++j) {
                MolAtom a = mol.getAtom(j);
                if (a.getStereoGroupType() != type || a.getStereoGroupNumber() != i) continue;
                data[k++] = j + 1;
            }
            this.lineStartIndex = s.length();
            s.append("M  V30 MDLV30/STER");
            s.append(type == 2 ? "EL" : "AC");
            s.append(i);
            this.appendV3list("ATOMS", data, stmp);
            s.append('\n');
        }
    }

    private void appendRgroupBlockV2(RgMolecule mol, String ctabfmt, AttachmentConverter attachmentConverter) {
        StringBuffer s = this.stringBuffer;
        for (int i = 0; i < mol.getRgroupCount(); ++i) {
            int rgid = mol.getRgroupId(i);
            if (rgid <= 0 || rgid >= 1000) continue;
            s.append("$RGP\n");
            this.appendRight(mol.getRgroupId(i), 3);
            s.append("\n");
            int nmembers = mol.getRgroupMemberCount(i);
            for (int j = 0; j < nmembers; ++j) {
                Molecule rgroup = mol.getRgroupMember(i, j);
                s.append("$CTAB\n");
                this.appendCtab(rgroup, ctabfmt, attachmentConverter);
                s.append("$END CTAB\n");
            }
            s.append("$END RGP\n");
        }
    }

    private void appendRgroupBlockV3(RgMolecule mol, double xyzCoordsScale, boolean inRgroupBlock, AttachmentConverter attachmentConverter) {
        StringBuffer s = this.stringBuffer;
        for (int i = 0; i < mol.getRgroupCount(); ++i) {
            int f = mol.getRlogic(i);
            int r1 = f & Short.MAX_VALUE;
            int r2 = f >> 16 & Short.MAX_VALUE;
            if ((f & 0x8000) == 0) {
                r2 = -1;
            }
            s.append("M  V30 BEGIN RGROUP " + r1 + "\n");
            s.append("M  V30 RLOGIC ");
            s.append(r2 > 0 ? r2 : 0);
            s.append((f & Integer.MIN_VALUE) != 0 ? " 1 " : " 0 ");
            String range = mol.getRlogicRange(i);
            s.append(range.equals("") ? "\"\"" : range);
            s.append('\n');
            for (int j = 0; j < mol.getRgroupMemberCount(i); ++j) {
                Molecule rg = mol.getRgroupMember(i, j);
                this.appendCtabV3(rg, rg.getAtomCount(), rg.getBondCount(), xyzCoordsScale, inRgroupBlock, attachmentConverter);
            }
            s.append("M  V30 END RGROUP\n");
        }
    }

    private void appendRlogicLines(Molecule mol) {
        RgMolecule rgmol;
        StringBuffer s = this.stringBuffer;
        MoleculeGraph parentGraph = mol.getParent();
        if (parentGraph != null && parentGraph instanceof RgMolecule && (rgmol = (RgMolecule)parentGraph).getRoot() == mol) {
            for (int i = 0; i < rgmol.getRgroupCount(); ++i) {
                int f = rgmol.getRlogic(i);
                int r1 = f & Short.MAX_VALUE;
                int r2 = f >> 16 & Short.MAX_VALUE;
                if ((f & 0x8000) == 0) {
                    r2 = -1;
                }
                if (r1 <= 0 || r1 >= 1000 || (r2 <= 0 || r2 >= 1000) && r2 != -1) continue;
                s.append("M  LOG  1");
                this.appendRight(r1, 4);
                this.appendRight(r2 > 0 ? r2 : 0, 4);
                s.append((f & Integer.MIN_VALUE) != 0 ? "   1   " : "   0   ");
                s.append(rgmol.getRlogicRange(i));
                s.append('\n');
            }
        }
    }

    private void appendRDForSDFProps(Molecule mol) throws MolExportException {
        StringBuffer s = this.stringBuffer;
        String fmt = this.getFormat();
        boolean isRDF = fmt.equals("rdf") || fmt.equals("csrdf");
        MPropertyContainer props = mol.properties();
        for (int i = 0; i < props.size(); ++i) {
            String sval;
            MProp value;
            String key = props.getKey(i);
            if (key.equals("$REGNO") || (value = props.get(key)) == null || !props.isValid(value)) continue;
            if (value instanceof MMoleculeProp && isRDF) {
                String f;
                Molecule m = ((MMoleculeProp)value).getMolecule();
                if (!isRDF) continue;
                boolean compressed = fmt.equals("csrdf");
                s.append("$DTYPE ");
                s.append(key);
                s.append("\n$DATUM ");
                if (m.isReaction()) {
                    s.append("$RFMT\n");
                    f = compressed ? "csrxn" : "rxn";
                } else {
                    s.append("$MFMT\n");
                    String string = f = compressed ? "csmol" : "mol";
                }
                if (this.versionSet && this.version3 || MolExport.isV3recommended(m)) {
                    f = f + ":V3";
                }
                s.append(m.toFormat(f));
                continue;
            }
            if (MolExport.isEnergyProp(key, value) || mol.isSelfReference(value)) continue;
            if (value instanceof MStringProp) {
                sval = ((MStringProp)value).stringValue();
            } else {
                try {
                    sval = value.convertToString(fmt.startsWith("cs") ? "csmol" : "mol", 0);
                }
                catch (IllegalArgumentException e) {
                    throw new MolExportException(e);
                }
                sval = EncodingUtil.escape(sval, 1);
                int arrsize = value.getPropArraySize();
                sval = arrsize >= 0 ? "MProp:array:" + String.valueOf(arrsize) + ":" + value.getPropType() + ": " + sval : "MProp:scalar:" + value.getPropType() + ":" + sval;
            }
            if (sval.length() <= 0) continue;
            s.append(isRDF ? "$DTYPE " : ">  <");
            s.append(key);
            if (isRDF) {
                this.appendDATUMWithUndocPlusCont(s, sval);
            } else {
                s.append(">\n");
                s.append(sval);
                s.append('\n');
            }
            if (isRDF) continue;
            s.append('\n');
        }
        if (!isRDF) {
            s.append("$$$$\n");
        }
    }

    private static boolean isEnergyProp(String key, MProp p) {
        if ((key.equals("ENERGY") || key.equals("Energy")) && p instanceof MStringProp) {
            String sval = ((MStringProp)p).stringValue();
            try {
                Double.valueOf(sval);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    private void appendDATUMWithUndocPlusCont(StringBuffer s, String sval) {
        s.append("\n$DATUM ");
        int i = 0;
        int j = sval.indexOf(10);
        if (j < 0) {
            j = sval.length();
        }
        if (j <= 74) {
            s.append(sval.substring(i, j));
            s.append('\n');
            i = j + 1;
            j = sval.indexOf(10, i);
            if (j < 0) {
                j = sval.length();
            }
        } else {
            s.append(sval.substring(0, 73));
            s.append("+\n");
            i = 73;
        }
        while (i < sval.length() && i <= j) {
            while (j - i > 80) {
                s.append(sval.substring(i, i + 80));
                s.append("+\n");
                i += 80;
            }
            s.append(sval.substring(i, j));
            s.append('\n');
            i = j + 1;
            if ((j = sval.indexOf(10, i)) >= 0) continue;
            j = sval.length();
        }
    }

    private void appendComment(String comment) {
        StringBuffer s = this.stringBuffer;
        for (int i = 0; i < comment.length(); ++i) {
            char c = comment.charAt(i);
            if (c == '\r' || c == '\n') {
                c = ' ';
            }
            s.append(c);
        }
        s.append('\n');
    }

    private void appendRxnV2(RxnMolecule rxmol, String format2, AttachmentConverter attachmentConverter) {
        StringBuffer s = this.stringBuffer;
        s.append("$RXN\n\n  Marvin       ");
        this.appendDate(10000, 4);
        s.append('\n');
        this.appendComment(rxmol.getComment());
        int nr = rxmol.getReactantCount();
        int np = rxmol.getProductCount();
        int na = rxmol.getAgentCount();
        this.appendRight(nr, 3);
        this.appendRight(np, 3);
        if (na > 0) {
            this.appendRight(na, 3);
        }
        s.append("\n");
        int m = nr + np;
        int n = m + na;
        for (int i = 0; i < n; ++i) {
            s.append("$MOL\n");
            Molecule mol = null;
            mol = i < nr ? rxmol.getReactant(i) : (i < m ? rxmol.getProduct(i - nr) : rxmol.getAgent(i - m));
            this.appendHeader(mol);
            this.appendCtab(mol, format2, attachmentConverter);
        }
        this.appendRlogicLines(rxmol);
    }

    private void appendRxnV3(RxnMolecule rxmol, double xyzCoordsScale, RgMolecule rgmol, AttachmentConverter attachmentConverter) {
        Molecule m;
        int i;
        StringBuffer s = this.stringBuffer;
        s.append("$RXN V3000\n\n  Marvin       ");
        this.appendDate(10000, 4);
        s.append('\n');
        this.appendComment(rxmol.getComment());
        int nr = rxmol.getReactantCount();
        int np = rxmol.getProductCount();
        int na = rxmol.getAgentCount();
        s.append("M  V30 COUNTS ");
        s.append(nr);
        s.append(' ');
        s.append(np);
        if (na > 0) {
            s.append(' ');
            s.append(na);
        }
        s.append("\nM  V30 BEGIN REACTANT\n");
        for (i = 0; i < nr; ++i) {
            m = rxmol.getReactant(i);
            this.appendCtabV3(m, m.getAtomCount(), m.getBondCount(), xyzCoordsScale, false, attachmentConverter);
        }
        s.append("M  V30 END REACTANT\nM  V30 BEGIN PRODUCT\n");
        for (i = 0; i < np; ++i) {
            m = rxmol.getProduct(i);
            this.appendCtabV3(m, m.getAtomCount(), m.getBondCount(), xyzCoordsScale, false, attachmentConverter);
        }
        s.append("M  V30 END PRODUCT\n");
        if (na > 0) {
            s.append("M  V30 BEGIN AGENT\n");
            for (i = 0; i < na; ++i) {
                m = rxmol.getAgent(i);
                this.appendCtabV3(m, m.getAtomCount(), m.getBondCount(), xyzCoordsScale, false, attachmentConverter);
            }
            s.append("M  V30 END AGENT\n");
        }
        if (rgmol != null) {
            this.appendRgroupBlockV3(rgmol, xyzCoordsScale, false, attachmentConverter);
        }
        this.appendMEnd(rgmol != null ? rgmol : rxmol);
    }

    private void appendRgf(RgMolecule mol, String format2, AttachmentConverter attachmentConverter) {
        StringBuffer s = this.stringBuffer;
        s.append("$MDL  REV  1 ");
        this.appendDate(100, 2);
        s.append("\n$MOL\n$HDR\n");
        this.appendHeader(mol);
        s.append("$END HDR\n$CTAB\n");
        String ctabfmt = format2.equals("sdf") ? "mol" : (format2.equals("cssdf") ? "csmol" : format2);
        Molecule root = mol.getRoot();
        if (root instanceof RxnMolecule) {
            this.appendRxnV2((RxnMolecule)root, ctabfmt, attachmentConverter);
        } else {
            this.appendCtab(root, ctabfmt, attachmentConverter);
        }
        s.append("$END CTAB\n");
        this.appendRgroupBlockV2(mol, ctabfmt, attachmentConverter);
        s.append("$END MOL\n");
    }

    protected void appendMEnd(Molecule mol) {
        this.stringBuffer.append("M  END\n");
    }

    private static String symbolOf(MolAtom a) {
        boolean beilstein;
        String aliasstr = a.getAliasstr();
        boolean pseudo = a.getAtno() == 136;
        boolean bl = beilstein = pseudo && MolfileUtil.isSpecBeilsteinGeneric(aliasstr);
        if (beilstein) {
            return "C";
        }
        if (pseudo) {
            return aliasstr.length() > 3 ? "A" : aliasstr;
        }
        int massno = a.getMassno();
        int z = a.getAtno();
        if (z == 129) {
            return "L";
        }
        if (massno != 0 && a.isSpecIsotopeSymbolUsed()) {
            return MolAtom.symbolOf(z, massno);
        }
        if (z == 134 && a.getRgroup() == 0) {
            return "R";
        }
        return MolAtom.symbolOf(z);
    }

    private void appendRight(int t, int n) {
        if (this.mapp6) {
            StringBuffer sb = this.stringBuffer;
            char[] c64 = CHARS64;
            for (int j = 0; j < n; ++j) {
                sb.append(c64[t & 0x3F]);
                t >>= 6;
            }
        } else {
            this.appendRight(t, n, ' ');
        }
    }

    private void appendRight(double t) {
        if (this.mapp6) {
            int x = (int)(t * 10000.0 + 8388608.5);
            StringBuffer sb = this.stringBuffer;
            char[] c64 = CHARS64;
            sb.append(c64[x & 0x3F]);
            sb.append(c64[x >> 6 & 0x3F]);
            sb.append(c64[x >> 12 & 0x3F]);
            sb.append(c64[x >> 18 & 0x3F]);
        } else {
            StringBuffer sb = this.tmpsbuf;
            sb.setLength(0);
            sb.append(t < 0.0 ? "    -" : "     ");
            String s = this.format4digitPosV2(Math.abs(t));
            int l = s.length();
            this.stringBuffer.append(s.substring(l - 10, l));
        }
    }

    private void appendCoordV3(double t) {
        if (this.useMaxPrecision) {
            this.stringBuffer.append(t);
        } else {
            this.tmpsbuf.setLength(0);
            if (t < 0.0) {
                this.tmpsbuf.append('-');
            }
            String s = this.format4digitPosV3(Math.abs(t));
            this.stringBuffer.append(s);
        }
    }

    private void appendCoordV3(StringBuffer stmp, double t) {
        if (this.useMaxPrecision) {
            stmp.append(t);
        } else {
            this.tmpsbuf.setLength(0);
            if (t < 0.0) {
                this.tmpsbuf.append('-');
            }
            String s = this.format4digitPosV3(Math.abs(t));
            stmp.append(s);
        }
    }

    private String format4digitPosV2(double y) {
        StringBuffer sb = this.tmpsbuf;
        int iy = (int)y;
        int a = (int)(10000.0 * (y - (double)iy) + 0.5);
        if (a == 10000) {
            sb.append(iy + 1);
            sb.append(".0000");
        } else {
            String sa = "0000" + a;
            int l = sa.length();
            sb.append(iy);
            sb.append('.');
            sb.append(sa.substring(l - 4, l));
        }
        return sb.toString();
    }

    private String format4digitPosV3(double y) {
        StringBuffer sb = this.tmpsbuf;
        int iy = (int)y;
        int a = (int)(10000.0 * (y - (double)iy) + 0.5);
        if (a == 10000) {
            sb.append(iy + 1);
        } else if (a == 0) {
            sb.append(iy);
        } else {
            String sa = "0000" + a;
            int l = sa.length();
            sb.append(iy);
            sb.append('.');
            for (int i = l - 1; i >= l - 4; --i) {
                if (sa.charAt(i) == '0') continue;
                sb.append(sa.substring(l - 4, i + 1));
                return sb.toString();
            }
        }
        return sb.toString();
    }

    private static int convertRadical(int r) {
        switch (r) {
            case 1: {
                return 2;
            }
            case 2: 
            case 6: {
                return 1;
            }
            case 10: {
                return 3;
            }
        }
        return 0;
    }

    private void appendV3field(String field, int v, StringBuffer stmp) {
        this.appendV3field(field, String.valueOf(v), stmp, false);
    }

    private void appendV3field(String field, String v, StringBuffer stmp, boolean isString) {
        StringBuffer s = this.stringBuffer;
        if (isString && (v.indexOf(34) > -1 || v.indexOf(32) > -1 || v.indexOf(45) > -1)) {
            v = this.quotify(v);
        }
        int l = s.length() - this.lineStartIndex;
        stmp.setLength(0);
        stmp.append(' ');
        stmp.append(field);
        stmp.append('=');
        stmp.append(v);
        this.appendV3String(l, stmp);
    }

    private String quotify(String s) {
        StringBuffer sb = new StringBuffer(s);
        int pos = 0;
        int quotePos = this.indexOf(sb, '\"', pos);
        while (quotePos != -1) {
            sb.insert(quotePos, '\"');
            pos = quotePos + 2;
            quotePos = this.indexOf(sb, '\"', pos);
        }
        sb.insert(0, '\"');
        sb.append('\"');
        return sb.toString();
    }

    private int indexOf(StringBuffer buffer, char c, int pos) {
        for (int i = pos; i < buffer.length(); ++i) {
            if (buffer.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    private void appendV3list(String field, int[] data, StringBuffer stmp) {
        StringBuffer s = this.stringBuffer;
        int l = s.length() - this.lineStartIndex;
        this.appendV3listHead(field, stmp);
        stmp.append(data.length);
        if (data.length == 0) {
            stmp.append(')');
        }
        this.appendV3String(l, stmp);
        for (int i = 0; i < data.length; ++i) {
            l = s.length() - this.lineStartIndex;
            stmp.setLength(0);
            stmp.append(' ');
            stmp.append(data[i]);
            if (i == data.length - 1) {
                stmp.append(')');
            }
            this.appendV3String(l, stmp);
        }
    }

    private void appendV3list(String field, double[] data, StringBuffer stmp) {
        StringBuffer s = this.stringBuffer;
        int l = s.length() - this.lineStartIndex;
        this.appendV3listHead(field, stmp);
        stmp.append(data.length);
        if (data.length == 0) {
            stmp.append(')');
        }
        this.appendV3String(l, stmp);
        for (int i = 0; i < data.length; ++i) {
            l = s.length() - this.lineStartIndex;
            stmp.setLength(0);
            stmp.append(' ');
            this.appendCoordV3(stmp, data[i]);
            if (i == data.length - 1) {
                stmp.append(')');
            }
            this.appendV3String(l, stmp);
        }
    }

    private void appendV3listHead(String field, StringBuffer stmp) {
        stmp.setLength(0);
        stmp.append(' ');
        stmp.append(field);
        stmp.append("=(");
    }

    private void appendV3String(int l, StringBuffer stmp) {
        StringBuffer s = this.stringBuffer;
        if (l + stmp.length() > 77) {
            s.append(" -\n");
            this.lineStartIndex = s.length();
            s.append("M  V30");
        }
        while (stmp.length() > 73) {
            char[] tca = new char[73];
            stmp.getChars(0, 73, tca, 0);
            s.append(tca);
            s.append("-\n");
            this.lineStartIndex = s.length();
            s.append("M  V30");
            int newLength = stmp.length() - 72;
            for (int i = 0; i < newLength; ++i) {
                stmp.setCharAt(i, stmp.charAt(i + 72));
            }
            stmp.setCharAt(0, ' ');
            stmp.setLength(newLength);
        }
        s.append(stmp.toString());
    }

    private static boolean hasSMARTSOnlyProps(MolAtom a) {
        if (a.hasSMARTSPropsExcluding("vrbsu") || a.getQuerystr() != null) {
            return true;
        }
        return a.getValenceProp() > 14;
    }

    private static String convert2MDL(String s) {
        String tex = SimpleTeX.convertShort2TeX(s, 0);
        return SimpleTeX.convertTeX2Short(tex, 1);
    }

    protected void convertMultiCenterSgroupsToData(Molecule mol) {
        for (int i = 0; i < mol.getSgroupCount(); ++i) {
            Sgroup sg = mol.getSgroup(i);
            if (!(sg instanceof MulticenterSgroup)) continue;
            MulticenterSgroup msg = (MulticenterSgroup)sg;
            this.addDataFromMulticenter(mol, msg);
            --i;
        }
    }

    protected void convertPageSettingsToData(Molecule mol) {
        if (mol.getDocument() == null || mol.getAtomCount() == 0) {
            return;
        }
        PageSettings ps = mol.getDocument().getPageSettings();
        if (ps.isEnabled()) {
            this.addData(mol, mol.getAtom(0), "MRV_PAGE_WIDTH", Double.toString(ps.getWidth()));
            this.addData(mol, mol.getAtom(0), "MRV_PAGE_HEIGHT", Double.toString(ps.getHeight()));
            this.addData(mol, mol.getAtom(0), "MRV_PAGE_COLUMN_COUNT", Integer.toString(ps.getColumnCount()));
            this.addData(mol, mol.getAtom(0), "MRV_PAGE_ROW_COUNT", Integer.toString(ps.getRowCount()));
            this.addData(mol, mol.getAtom(0), "MRV_PAGE_SELECTED", Integer.toString(ps.getSelectedPage()));
            this.addData(mol, mol.getAtom(0), "MRV_PAGE_LEFT_MARGIN", Double.toString(ps.getLeftMargin()));
            this.addData(mol, mol.getAtom(0), "MRV_PAGE_RIGHT_MARGIN", Double.toString(ps.getRightMargin()));
            this.addData(mol, mol.getAtom(0), "MRV_PAGE_TOP_MARGIN", Double.toString(ps.getTopMargin()));
            this.addData(mol, mol.getAtom(0), "MRV_PAGE_BOTTOM_MARGIN", Double.toString(ps.getBottomMargin()));
        }
    }

    protected void convertCoordinateBondsToData(Molecule molecule) {
        MoleculeGraph mol = molecule.getGraphUnion();
        if (mol.getBondCount() == 0) {
            return;
        }
        for (int i = 0; i < mol.getBondCount(); ++i) {
            MolBond bond = mol.getBond(i);
            if (bond.getType() != 9) continue;
            MoleculeGraph parent = bond.getParent();
            this.addData(bond, "MRV_COORDINATE_BOND_TYPE", "" + (parent.indexOf(bond) + 1));
            bond.setType(0);
        }
    }

    private void convertChargeLocationToData(Molecule mol) {
        for (int i = 0; i < mol.getSgroupCount(); ++i) {
            Sgroup sgroup = mol.getSgroup(i);
            if (sgroup.getChargeLocation() != 2) continue;
            this.addData(mol, sgroup, "MRV_CHARGE_ON_GROUP");
        }
    }

    private void addData(Molecule mol, Sgroup sgroup, String fieldName) {
        DataSgroup dsg = new DataSgroup(mol);
        dsg.setFieldName(fieldName);
        String data = "" + sgroup.getTotalCharge();
        dsg.setData(data);
        dsg.setDataDetached(true);
        dsg.setAbsolutePlacement(false);
        dsg.setX(0.0);
        dsg.setY(0.0);
        sgroup.addChildSgroup(dsg);
        mol.addSgroup(dsg, true);
    }

    private void addData(MolBond bond, String fieldName, String value) {
        MoleculeGraph moleculeGraph = bond.getParent();
        if (moleculeGraph instanceof Molecule) {
            Molecule mol = (Molecule)moleculeGraph;
            DataSgroup dsg = new DataSgroup(mol);
            dsg.setFieldName(fieldName);
            dsg.setData(value);
            dsg.setDataDetached(true);
            dsg.setAbsolutePlacement(false);
            dsg.setX(0.0);
            dsg.setY(0.0);
            mol.setSgroupParent(bond.getAtom1(), dsg, true);
            mol.setSgroupParent(bond.getAtom2(), dsg, true);
        }
    }

    private void addDataFromMulticenter(Molecule mol, MulticenterSgroup sgroup) {
        Molecule pmol = sgroup.getParentMolecule();
        DataSgroup dsg = new DataSgroup(pmol);
        dsg.setFieldName("MRV_MULTICENTER_ATOM_INDEX");
        dsg.setData(Integer.toString(pmol.indexOf(sgroup.getCentralAtom()) + 1));
        dsg.setDataDetached(true);
        dsg.setAbsolutePlacement(false);
        dsg.setX(0.0);
        dsg.setY(0.0);
        for (int i = 0; i < sgroup.getAtomCount(); ++i) {
            MolAtom a = sgroup.getAtom(i);
            pmol.setSgroupParent(a, dsg, true);
        }
        MolAtom center = sgroup.getCentralAtom();
        MolBond[] bondList = new MolBond[center.getBondCount()];
        for (int i = center.getBondCount() - 1; i >= 0; --i) {
            bondList[i] = center.getBond(i);
        }
        sgroup.setCentralAtom(null);
        pmol.ungroupSgroup(sgroup);
    }

    private ArrayList<Integer> getSpecialTypeSgroups(Molecule mol) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < mol.getSgroupCount(); ++i) {
            Sgroup sg = mol.getSgroup(i);
            if (sg.getBracketCount() == 0 || sg.getBrackets().get(0).getType() != 0) continue;
            list.add(i);
        }
        return list;
    }

    static {
        for (int x = 0; x < 64; ++x) {
            int c = x == 62 ? 43 : (x == 63 ? 45 : (x >= 36 ? 97 + (x - 36) : (x >= 10 ? 65 + (x - 10) : 48 + x)));
            MolExport.CHARS64[x] = (char)c;
        }
        MolExport.SGROUP_SUBTYPES[1] = "ALT";
        MolExport.SGROUP_SUBTYPES[2] = "RAN";
        MolExport.SGROUP_SUBTYPES[3] = "BLO";
        MolExport.SGROUP_CONNECTIVITIES[1] = "HH";
        MolExport.SGROUP_CONNECTIVITIES[2] = "HT";
        MolExport.SGROUP_CONNECTIVITIES[0] = "EU";
    }
}

