/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.mdl;

import chemaxon.marvin.io.MRecord;
import chemaxon.marvin.io.MRecordParseException;
import chemaxon.marvin.io.formats.AbstractMRecordReader;
import chemaxon.marvin.io.formats.mdl.MDLRecordReaderUtil;
import chemaxon.struc.MPropertyContainer;
import java.io.IOException;
import java.io.InputStream;

public class MolRecordReader
extends AbstractMRecordReader {
    private String previousLine = null;
    private String currentLine = null;
    private int currentColumn;
    private boolean inputIsRgfV2 = false;
    private boolean inputIsRxn = false;
    private boolean inputIsSDF = false;
    private boolean inputIsV3;
    private boolean inputIsCompressed = false;

    public MolRecordReader(InputStream istr, String opts) throws IOException {
        super(istr, opts);
        String fmt = this.getMolInputStream().getFormat();
        if (fmt != null) {
            this.inputIsRxn = fmt.startsWith("rxn");
            this.inputIsSDF = fmt.startsWith("sdf") || fmt.equals("cssdf");
        }
    }

    @Override
    public MRecord nextRecord() throws MRecordParseException, IOException {
        return this.nextRecord(false);
    }

    @Override
    public MRecord skipRecord() throws MRecordParseException, IOException {
        return this.nextRecord(true);
    }

    private MRecord nextRecord(boolean skip) throws MRecordParseException, IOException {
        boolean okay;
        MPropertyContainer props;
        StringBuffer sb = skip ? null : new StringBuffer();
        long startpos = this.getFilePointer();
        int lineno = this.getLineCount();
        String l = this.readLine();
        if (l == null) {
            return null;
        }
        this.inputIsRgfV2 = false;
        this.inputIsRxn = false;
        this.inputIsSDF = false;
        MPropertyContainer mPropertyContainer = props = skip ? null : new MPropertyContainer();
        if (l.startsWith("$RXN")) {
            this.putBackLine();
            this.inputIsRxn = true;
            if (l.startsWith("$RXN V3000")) {
                okay = this.readRxnV3(sb);
            } else {
                okay = this.readRxnV2(sb);
                if (okay && this.currentLine != null) {
                    this.putBackLine();
                }
            }
            if (okay) {
                this.tryReadingSDFProps(props);
            }
        } else if (l.startsWith("$MDL ")) {
            this.putBackLine();
            this.inputIsRgfV2 = true;
            okay = this.readRgfV2(sb, props, true);
        } else if (l.startsWith(">  <")) {
            sb.append("\n  Marvin  10020809352D\n\n  0  0  0  0  0  0            999 V2000\nM  END\n");
            this.putBackLine();
            okay = this.tryReadingSDFProps(props);
        } else {
            this.putBackLine();
            okay = this.readMol0(sb, props);
        }
        if (okay) {
            return this.endMolecule(sb != null ? sb.toString() : null, props, startpos, lineno);
        }
        return null;
    }

    @Override
    public String getRecognizedFormat() {
        String s = this.inputIsSDF ? (this.inputIsV3 ? "sdf:V3" : "sdf") : (this.inputIsRgfV2 ? "rgf" : (this.inputIsRxn ? (this.inputIsV3 ? "rxn:V3" : "rxn") : (this.inputIsV3 ? "mol:V3" : "mol")));
        return this.inputIsCompressed ? "cs" + s : s;
    }

    private MRecord endMolecule(String str, MPropertyContainer pc, long startpos, int lineno) {
        boolean skip = str == null;
        int[] map = this.endRecord(skip);
        long endpos = this.getFilePointer();
        return new MRecord(startpos, endpos, lineno, str, pc, map);
    }

    @Override
    protected String readLine() throws IOException {
        String l;
        this.currentLine = l = super.readLine();
        this.currentColumn = 0;
        return l;
    }

    @Override
    protected void putBackLine() throws IOException {
        super.putBackLine();
        this.currentLine = this.previousLine = null;
    }

    private boolean readMol0(StringBuffer sb, MPropertyContainer props) throws MRecordParseException, IOException {
        Object[] hinfo = this.readHeader(sb);
        if (hinfo == null) {
            return false;
        }
        int v = this.readCtab(sb, hinfo);
        if (v < 0) {
            return false;
        }
        if (v == 3) {
            this.currentLine = this.readBlocksV3(sb, this.currentLine);
            this.checkEnd(sb);
        }
        if (this.currentLine == null) {
            return true;
        }
        this.putBackLine();
        if (this.getMolInputStream().markSupported()) {
            String currLineCache = this.currentLine;
            String prevLineCache = this.previousLine;
            int currColCache = this.currentColumn;
            this.getMolInputStream().mark(255);
            String line = this.readLine();
            while (line != null && line.trim().equals("")) {
                line = this.readLine();
            }
            if (line != null && !line.startsWith("$$$$") && !MolRecordReader.isSDFHeader(line)) {
                this.getMolInputStream().reset();
                this.currentLine = currLineCache;
                this.previousLine = prevLineCache;
                this.currentColumn = currColCache;
            } else {
                this.putBackLine();
            }
        }
        this.tryReadingSDFProps(props);
        return true;
    }

    private boolean readRxnV2(StringBuffer sb) throws MRecordParseException, IOException {
        int na;
        int np;
        int nr;
        int i;
        String[] lines = new String[3];
        for (i = 0; i < 3; ++i) {
            String s = this.readLine();
            lines[i] = s;
            if (lines[i] != null) continue;
            return false;
        }
        if (!lines[0].startsWith("$RXN")) {
            return false;
        }
        for (i = 0; i < lines.length; ++i) {
            this.appendLine(sb, lines[i]);
        }
        String commentLine = this.readLine();
        this.appendLine(sb, commentLine);
        String l = this.readLine();
        this.currentColumn = 0;
        try {
            nr = this.atoiV2(3);
            np = this.atoiV2(3);
            na = this.atoiV2(3);
        }
        catch (NumberFormatException ex) {
            throw new MRecordParseException(this.getPosition(), "Invalid counts line");
        }
        this.appendLine(sb, l);
        if (na < 0) {
            na = 0;
        }
        int m = nr + np;
        int n = m + na;
        boolean format2 = false;
        for (int i2 = 0; i2 < n; ++i2) {
            l = this.currentLine;
            if (l != null && l.startsWith("$MOL")) {
                this.appendLine(sb, l);
            } else {
                l = this.readLine();
                if (l == null) {
                    throw new MRecordParseException(this.getPosition(), "Unexpected end of Rxnfile before " + (i2 < nr ? "reactant " + (i2 + 1) : "product " + (i2 - nr + 1)));
                }
                if (!l.startsWith("$MOL")) {
                    throw new MRecordParseException(this.getPosition(), "Unexpected line in Rxnfile ($MOL expected)");
                }
                this.appendLine(sb, l);
            }
            Object[] hinfo = this.readHeader(sb);
            if (hinfo == null) {
                throw new MRecordParseException(this.getPosition(), "Unexpected end of Rxnfile");
            }
            int v = this.readCtab(sb, hinfo);
            this.currentColumn = 0;
            if (v >= 0) continue;
            throw new MRecordParseException(this.getPosition(), "Reactant or product in bad format");
        }
        return true;
    }

    private boolean readRxnV3(StringBuffer sb) throws MRecordParseException, IOException {
        int i;
        String[] lines = new String[3];
        for (i = 0; i < 3; ++i) {
            String s = super.readLine();
            lines[i] = s;
            if (lines[i] != null) continue;
            return false;
        }
        if (!lines[0].startsWith("$RXN V3000")) {
            return false;
        }
        for (i = 0; i < lines.length; ++i) {
            this.appendLine(sb, lines[i]);
        }
        String commentLine = this.readLine();
        this.appendLine(sb, commentLine);
        String l = this.readLine();
        if (l == null || !l.startsWith("M  V30 COUNTS ")) {
            throw new MRecordParseException(this.getPosition(), "COUNTS line expected");
        }
        this.appendLine(sb, l);
        l = this.readLine();
        l = this.readBlocksV3(sb, l);
        if (l == null) {
            throw new MRecordParseException(this.getPosition(), "Unexpected end of file");
        }
        this.checkEnd(sb);
        l = this.currentLine;
        if (l != null) {
            this.putBackLine();
        }
        return true;
    }

    private String readBlocksV3(StringBuffer sb, String l) throws MRecordParseException, IOException {
        while (l != null && l.startsWith("M  V30 BEGIN ")) {
            this.appendLine(sb, l);
            String what = l.substring(13).trim();
            int k = what.indexOf(32);
            if (k > 0) {
                what = what.substring(0, k);
            }
            String end = "M  V30 END " + what;
            do {
                if ((l = this.readLine()) == null) continue;
                this.appendLine(sb, l);
            } while (l != null && !l.startsWith(end));
            if (l == null) {
                throw new MRecordParseException(this.getPosition(), "Premature end of V3 file in " + what + "block");
            }
            l = this.readLine();
        }
        return l;
    }

    private boolean readRgfV2(StringBuffer sb, MPropertyContainer props, boolean trySDF) throws MRecordParseException, IOException {
        int i;
        String[] lines = new String[3];
        for (i = 0; i < 3; ++i) {
            String s = super.readLine();
            lines[i] = s;
            if (lines[i] != null) continue;
            return false;
        }
        if (!lines[0].startsWith("$MDL ")) {
            return false;
        }
        if (!lines[1].equals("$MOL") || !lines[2].equals("$HDR")) {
            throw new IOException("Not in MDL RGfile format");
        }
        for (i = 0; i < lines.length; ++i) {
            this.appendLine(sb, lines[i]);
        }
        Object[] hinfo = this.readHeader(sb);
        for (int i2 = 0; i2 < 2; ++i2) {
            lines[i2] = super.readLine();
            if (lines[i2] == null) {
                throw new MRecordParseException(this.getPosition(), "Unexpected end of RGfile");
            }
            this.appendLine(sb, lines[i2]);
        }
        if (!lines[0].equals("$END HDR") || !lines[1].equals("$CTAB")) {
            throw new MRecordParseException(this.getPosition(), "Bad RGfile");
        }
        String l = this.readLine();
        this.putBackLine();
        if (l.equals("$RXN")) {
            this.readRxnV2(sb);
            while (true) {
                if ((l = this.currentLine) == null) {
                    throw new MRecordParseException(this.getPosition(), "Unexpected end of RGfile after the root structure (a reaction)");
                }
                this.appendLine(sb, l);
                if (l.startsWith("M  LOG")) {
                    l = this.readLine();
                    continue;
                }
                break;
            }
        } else {
            if (this.readCtab(sb, hinfo) < 0) {
                throw new MRecordParseException(this.getPosition(), "Root structure in bad format");
            }
            l = this.currentLine;
            if (l == null) {
                throw new MRecordParseException(this.getPosition(), "Unexpected end of RGfile after the root structure");
            }
            this.appendLine(sb, l);
        }
        if (!l.equals("$END CTAB")) {
            throw new MRecordParseException(this.getPosition(), "Bad RGfile");
        }
        l = super.readLine();
        while (l != null && l.equals("$RGP")) {
            this.appendLine(sb, l);
            l = super.readLine();
            if (l == null) {
                throw new MRecordParseException(this.getPosition(), "Unexpected end of RGfile");
            }
            this.appendLine(sb, l);
            l = super.readLine();
            while (l != null && l.equals("$CTAB")) {
                this.appendLine(sb, l);
                if (this.readCtab(sb, hinfo) < 0) {
                    throw new MRecordParseException(this.getPosition(), "Rgroup in bad format");
                }
                l = this.currentLine;
                if (l != null && !l.equals("$END CTAB")) {
                    throw new MRecordParseException(this.getPosition(), "Bad RGfile");
                }
                this.appendLine(sb, l);
                l = super.readLine();
            }
            if (l == null) {
                throw new MRecordParseException(this.getPosition(), "Unexpected end of RGfile");
            }
            if (!l.equals("$END RGP")) {
                throw new MRecordParseException(this.getPosition(), "Bad RGfile");
            }
            this.appendLine(sb, l);
            l = super.readLine();
        }
        if (l == null || !l.equals("$END MOL")) {
            return true;
        }
        this.appendLine(sb, l);
        if (trySDF) {
            this.tryReadingSDFProps(props);
        } else {
            this.readLine();
        }
        return true;
    }

    boolean tryReadingSDFProps(MPropertyContainer props) throws MRecordParseException, IOException {
        boolean issdf = false;
        String l = this.readLine();
        if (l != null) {
            if (l.length() == 0) {
                this.putBackLine();
            } else if (MolRecordReader.isSDFHeader(l)) {
                String fieldname = null;
                StringBuffer sbuf = new StringBuffer();
                int dataoffset = 0;
                while (l != null && !l.startsWith("$$$$")) {
                    if (MolRecordReader.isSDFHeader(l)) {
                        int j;
                        int i;
                        if (fieldname != null && props != null) {
                            int n = sbuf.length();
                            if (n > 0 && sbuf.charAt(n - 1) == '\n') {
                                sbuf.setLength(n - 1);
                            }
                            MDLRecordReaderUtil.setMProp(props, fieldname, sbuf.toString());
                        }
                        fieldname = null;
                        dataoffset = 0;
                        sbuf.setLength(0);
                        if (l.indexOf(60) != -1) {
                            i = l.indexOf(60) + 1;
                            if (i > 0 && (j = l.indexOf(62, i)) > i) {
                                fieldname = l.substring(i, j);
                            }
                        } else {
                            i = l.indexOf("DT");
                            if (i > 0) {
                                j = l.indexOf(32, i);
                                if (j < 0) {
                                    j = l.length();
                                }
                                if (j > i) {
                                    fieldname = l.substring(i, j);
                                }
                            }
                        }
                    } else {
                        if (dataoffset > 0) {
                            sbuf.append('\n');
                        }
                        sbuf.append(l);
                        ++dataoffset;
                    }
                    l = super.readLine();
                }
                if (props != null) {
                    int len;
                    if (fieldname != null && (len = sbuf.length()) > 0 && sbuf.charAt(len - 1) == '\n') {
                        sbuf.setLength(len - 1);
                    }
                    MDLRecordReaderUtil.setMProp(props, fieldname, sbuf.toString());
                }
                issdf = true;
            } else if (l.startsWith("$$$$")) {
                issdf = true;
            } else {
                super.putBackLine();
            }
            if (issdf) {
                this.inputIsSDF = true;
            }
        }
        return issdf;
    }

    private Object[] readHeader(StringBuffer sb) throws IOException {
        Object[] hinfo = new Object[3];
        for (int i = 0; i < 3; ++i) {
            String s = this.readLine();
            if (s == null) {
                return null;
            }
            if (sb == null) continue;
            if (i == 0 || i == 2) {
                hinfo[i] = s;
            } else if (i == 1 && s.length() >= 22 && s.charAt(21) == 'D') {
                int dim = s.charAt(20) - 48;
                if (dim > 3) {
                    dim = -1;
                }
                hinfo[1] = new Integer(dim);
            }
            this.appendLine(sb, s);
        }
        return hinfo;
    }

    private int readCtab(StringBuffer sb, Object[] hinfo) throws MRecordParseException, IOException {
        int v;
        int nl;
        int nb;
        int na;
        String l = this.readLine();
        if (l == null) {
            return -1;
        }
        this.appendLine(sb, l);
        try {
            na = this.atoiV2(3);
            nb = this.atoiV2(3);
            nl = this.atoiV2(3);
        }
        catch (NumberFormatException ex) {
            throw new MRecordParseException(this.getPosition(), "Invalid counts line");
        }
        if (na == 0 && nb != 0) {
            throw new MRecordParseException(this.getPosition(), "Molfile contains bonds but no atoms");
        }
        if (sb != null) {
            int len;
            int i;
            for (i = 0; i < na; ++i) {
                l = this.readLine();
                if (l == null) {
                    throw new MRecordParseException(this.getPosition(), "Premature end of cfile in CTAB");
                }
                len = l.length();
                if (len == 10 || len == 14) {
                    this.inputIsCompressed = true;
                }
                this.appendLine(sb, l);
            }
            for (i = 0; i < nb; ++i) {
                l = this.readLine();
                if (l == null) {
                    throw new MRecordParseException(this.getPosition(), "Premature end of cfile in CTAB");
                }
                len = l.length();
                if (len == 5) {
                    this.inputIsCompressed = true;
                }
                this.appendLine(sb, l);
            }
            for (i = 0; i < nl; ++i) {
                l = this.readLine();
                if (l == null) {
                    throw new MRecordParseException(this.getPosition(), "Premature end of cfile in CTAB");
                }
                this.appendLine(sb, l);
            }
        } else {
            int n = na + nb + nl;
            for (int i = 0; i < n; ++i) {
                if (this.skipLine()) continue;
                throw new MRecordParseException(this.getPosition(), "Premature end of cfile in CTAB");
            }
        }
        if ((v = this.readPropertiesBlockV2(sb)) == 3) {
            this.readCtabV3(sb);
            this.readLine();
            this.inputIsV3 = true;
            return 3;
        }
        this.inputIsV3 = false;
        return 2;
    }

    private void readCtabV3(StringBuffer sb) throws MRecordParseException, IOException {
        String line = this.currentLine;
        this.appendLine(sb, line);
        line = this.readLine();
        if (!line.startsWith("M  V30 COUNTS ")) {
            throw new MRecordParseException(this.getPosition(), "COUNTS line missing from V30 CTAB");
        }
        this.appendLine(sb, line);
        while (line != null && !line.startsWith("M  V30 END CTAB")) {
            line = this.readLine();
            if (line == null) {
                throw new IOException("Premature end of file");
            }
            this.appendLine(sb, line);
        }
    }

    private int readPropertiesBlockV2(StringBuffer sb) throws IOException {
        if (this.readLine() == null) {
            return 2;
        }
        if (this.currentLine.equals("$$$$")) {
            return 2;
        }
        if (this.currentLine.startsWith("M  V30 BEGIN CTAB")) {
            return 3;
        }
        while (!this.currentLine.startsWith("$MOL") && !this.currentLine.startsWith("$DTYPE ")) {
            if (this.currentLine.length() < 6) {
                this.appendLine(sb, this.currentLine);
            } else {
                String s = this.currentLine.substring(0, 6);
                if (s.startsWith(">") || s.startsWith("$$$$")) break;
                if (s.equals("M  END")) {
                    this.appendLine(sb, s);
                    String l = this.readLine();
                    if (l == null || !l.startsWith("$RXN")) break;
                    this.putBackLine();
                    break;
                }
                this.appendLine(sb, this.currentLine);
            }
            if (this.readLine() != null) continue;
        }
        return 2;
    }

    private void checkEnd(StringBuffer sb) throws MRecordParseException, IOException {
        String line = this.currentLine;
        if (line != null) {
            if (line.startsWith("M  END") || line.startsWith("$MOL")) {
                this.appendLine(sb, line);
                this.readLine();
            } else {
                throw new MRecordParseException(this.getPosition(), "Molfile does not end with M  END");
            }
        }
    }

    private int atoiV2(int w) {
        int i = this.currentColumn;
        if (this.currentLine.length() < i + w) {
            return 0;
        }
        boolean spaceonly = true;
        for (int j = 0; j < w && spaceonly; ++j) {
            if (this.currentLine.charAt(i + j) == ' ') continue;
            spaceonly = false;
        }
        if (spaceonly) {
            return 0;
        }
        String s = this.currentLine;
        this.currentColumn = i + w;
        return Integer.parseInt(s.substring(i, i + w).trim());
    }

    private boolean goToWordStartV3() {
        int i = this.currentColumn;
        String s = this.currentLine;
        if (i >= s.length()) {
            return false;
        }
        char c = s.charAt(i);
        while ((c == ' ' || c == '\t') && i < s.length() - 1) {
            c = s.charAt(++i);
        }
        this.currentColumn = i;
        return i < s.length();
    }

    private static boolean isSDFHeader(String l) {
        if (l.startsWith(">")) {
            if (l.indexOf(60) != -1) {
                if ((l = l.substring(l.indexOf(60)).trim()).length() != 0 && l.charAt(0) == '<') {
                    for (int i = 1; i < l.length(); ++i) {
                        char c = l.charAt(i);
                        if (c == '<') {
                            return false;
                        }
                        if (c != '>') continue;
                        return true;
                    }
                }
            } else if (l.indexOf("DT") != -1) {
                return true;
            }
        }
        return false;
    }
}

