/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.mdl;

import chemaxon.formats.MolFormatException;
import chemaxon.marvin.io.MRecord;
import chemaxon.marvin.io.MRecordParseException;
import chemaxon.marvin.io.formats.AbstractMRecordReader;
import chemaxon.marvin.io.formats.mdl.MDLRecordReaderUtil;
import chemaxon.struc.MPropertyContainer;
import chemaxon.struc.prop.MMoleculeStringProp;
import java.io.IOException;
import java.io.InputStream;

public class RDfileRecordReader
extends AbstractMRecordReader {
    private String header;

    public RDfileRecordReader(InputStream istr, String opts) throws IOException {
        super(istr, opts);
        StringBuffer sb = new StringBuffer();
        String l = this.readLine();
        if (l.startsWith("$RDFILE ")) {
            String s = l.substring(8);
            if (!s.startsWith("1")) {
                throw new MolFormatException("Only version 1 RDfiles can be imported");
            }
        } else {
            throw new MolFormatException("RDfile does not start with a  valid $RDFILE line");
        }
        sb.append(l);
        sb.append('\n');
        l = this.readLine();
        if (!l.startsWith("$DATM ")) {
            throw new MolFormatException("invalid RDfile date line: \"" + RDfileRecordReader.abbreviateString(l, 32) + "\"");
        }
        sb.append(l);
        sb.append('\n');
        this.header = sb.toString();
    }

    @Override
    public MRecord nextRecord() throws MRecordParseException, IOException {
        return this.nextRecord(false);
    }

    @Override
    public MRecord skipRecord() throws MRecordParseException, IOException {
        return this.nextRecord(true);
    }

    private MRecord nextRecord(boolean skip) throws MRecordParseException, IOException {
        long startpos = this.getFilePointer();
        int lineno = this.getLineCount();
        String l = this.readLine();
        if (l == null) {
            return null;
        }
        if (!RDfileRecordReader.isValidStartingLine(l)) {
            throw new MRecordParseException(this.getPosition(), "invalid record starting line: \"" + RDfileRecordReader.abbreviateString(l, 32) + "\"");
        }
        StringBuffer sb = skip ? null : new StringBuffer();
        int n = 0;
        int descflags = 0;
        if (RDfileRecordReader.isRegnoLine(l)) {
            descflags |= 1;
        }
        this.appendLine(sb, l);
        ++n;
        while ((l = this.readLine()) != null) {
            if (l.startsWith("$DTYPE ")) {
                MPropertyContainer props = new MPropertyContainer();
                if ((l = this.readRDFProps(l, props)) != null) {
                    this.putBackLine();
                }
                return this.endMolecule(sb != null ? sb.toString() : null, props, startpos, lineno, descflags);
            }
            if (RDfileRecordReader.isValidStartingLine(l)) {
                this.putBackLine();
                return this.endMolecule(sb != null ? sb.toString() : null, null, startpos, lineno, descflags);
            }
            this.appendLine(sb, l);
            ++n;
        }
        return n != 0 ? this.endMolecule(sb != null ? sb.toString() : null, null, startpos, lineno, descflags) : null;
    }

    @Override
    public String getHeaderAsString() {
        return this.header;
    }

    private static boolean isValidStartingLine(String l) {
        return l.startsWith("$MFMT") || l.startsWith("$RFMT") || RDfileRecordReader.isRegnoLine(l);
    }

    private static boolean isRegnoLine(String l) {
        return l.startsWith("$MIREG") || l.startsWith("$MEREG") || l.startsWith("$RIREG") || l.startsWith("$REREG");
    }

    private MRecord endMolecule(String str, MPropertyContainer pc, long startpos, int lineno, int descflags) {
        boolean skip = str == null;
        int[] map = this.endRecord(skip);
        if (pc == null && !skip) {
            pc = new MPropertyContainer();
        }
        long endpos = this.getFilePointer();
        return new MRecord(startpos, endpos, lineno, str, pc, map, descflags);
    }

    private String readRDFProps(String l, MPropertyContainer props) throws IOException {
        if (l != null && l.equals("") && (l = this.readLine()) != null && !l.startsWith("$DTYPE ")) {
            this.putBackLine();
            l = "";
        }
        while (l != null) {
            if (l.startsWith("$DTYPE ")) {
                boolean molprop;
                String fieldname;
                do {
                    fieldname = l.substring(7).trim();
                } while ((l = this.readLine()) != null && l.startsWith("$DTYPE "));
                if (l == null) break;
                if (!l.startsWith("$DATUM ")) {
                    this.putBackLine();
                    break;
                }
                String s = l.substring(7).trim();
                boolean undocPlusCont = l.length() == 81 && l.endsWith("+");
                boolean bl = molprop = s.equals("$MFMT") || s.equals("$RFMT") || s.startsWith("$MFMT $MIREG ") || s.startsWith("$RFMT $RIREG ");
                if (!molprop && undocPlusCont) {
                    s = s.substring(0, s.length() - 1);
                }
                StringBuffer sbuf = new StringBuffer(molprop ? "" : s);
                l = this.readLine();
                int count = 0;
                while (!(l == null || l.startsWith("$DTYPE ") || l.startsWith("$MFMT") || l.startsWith("$RFMT") || l.startsWith("$MIREG") || l.startsWith("$MEREG") || l.startsWith("$RIREG") || l.startsWith("$REREG"))) {
                    if (l.endsWith("\r\n") || l.endsWith("\n\r")) {
                        l = l.substring(0, l.length() - 2);
                    } else if (l.endsWith("\r") || l.endsWith("\n")) {
                        l = l.substring(0, l.length() - 1);
                    }
                    if (!(molprop && count == 0 || !molprop && undocPlusCont)) {
                        sbuf.append('\n');
                    }
                    if (l.length() == 81 && l.endsWith("+")) {
                        undocPlusCont = true;
                        l = l.substring(0, 80);
                    } else {
                        undocPlusCont = false;
                    }
                    sbuf.append(l);
                    l = this.readLine();
                    ++count;
                }
                s = sbuf.toString();
                if (molprop) {
                    MMoleculeStringProp p = new MMoleculeStringProp(s, null);
                    props.set(fieldname, p);
                    continue;
                }
                MDLRecordReaderUtil.setMProp(props, fieldname, s);
                continue;
            }
            return l;
        }
        return null;
    }

    private static String abbreviateString(String s, int max) {
        if (s.length() > max) {
            s = s.substring(0, max - 3) + "...";
        }
        return s;
    }
}

