/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.dictionaries;

import chemaxon.naming.n2s.Standardize;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashSet;

public class Blacklist {
    private static HashSet<String> commonLanguageWords = new HashSet();
    static HashSet<String> englishWords;
    private static HashSet<String> genericNames;

    public static boolean isCommonLanguageWord(String name, boolean acceptGenericNames) {
        if (acceptGenericNames && genericNames.contains(name)) {
            return false;
        }
        return Blacklist.isCommonLanguageWord(name);
    }

    public static boolean isCommonLanguageWord(String name) {
        return commonLanguageWords.contains(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadWords(InputStream source, HashSet<String> words) {
        BufferedReader r = new BufferedReader(new InputStreamReader(source));
        try {
            try {
                String word;
                while ((word = r.readLine()) != null) {
                    if (word.startsWith("#")) continue;
                    word = Standardize.get(word);
                    words.add(word);
                }
            }
            finally {
                r.close();
            }
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    static {
        String resource = "/chemaxon/marvin/io/formats/name/dictionaries/common-words.txt";
        InputStream words = Blacklist.class.getResourceAsStream(resource);
        if (words == null) {
            throw new Error("Common language word list not found: " + resource);
        }
        Blacklist.loadWords(words, commonLanguageWords);
        englishWords = new HashSet();
        File dict = new File("/usr/share/dict/words");
        if (dict.exists()) {
            try {
                String word;
                BufferedReader reader = new BufferedReader(new FileReader(dict));
                while ((word = reader.readLine()) != null) {
                    englishWords.add(word);
                }
            }
            catch (IOException e) {
                System.err.println("Error reading english dictionary: " + dict);
            }
        }
        genericNames = new HashSet<String>(Arrays.asList("water", "waters", "steam", "ice"));
    }
}

