/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.dictionaries;

import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.marvin.io.MolExportException;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.util.ArrayList;

public class MoleculeComparator {
    private boolean ignoreDuplicateFragments;
    private boolean ignoreSmallFragments;
    private boolean printDifferences;
    private boolean printAgreements;
    private boolean ignoreCisTrans;
    private boolean ignoreRelativeStereoDifferences;
    private boolean ignoreStereo;
    private boolean neutralizeIons;
    private boolean ignoreProtons;
    private boolean anomerize;
    private boolean ignoreBondType;
    Molecule prevM1;
    Molecule prevM2;
    long prevGrinv1;
    long prevGrinv2;
    boolean prevRes;

    public MoleculeComparator() {
    }

    public MoleculeComparator(boolean printDifferences, boolean ignoreCisTrans, boolean ignoreRelativeStereoDifferences, boolean ignoreStereo, boolean ignoreDuplicateFragments, boolean neutralizeIons) {
        this.printDifferences = printDifferences;
        this.ignoreCisTrans = ignoreCisTrans;
        this.ignoreRelativeStereoDifferences = ignoreRelativeStereoDifferences;
        this.ignoreStereo = ignoreStereo;
        this.ignoreDuplicateFragments = ignoreDuplicateFragments;
        this.neutralizeIons = neutralizeIons;
    }

    public MoleculeComparator ignoreDuplicateFragments() {
        this.ignoreDuplicateFragments = true;
        return this;
    }

    public MoleculeComparator ignoreSmallFragments() {
        this.ignoreSmallFragments = true;
        return this;
    }

    public MoleculeComparator printDifferences() {
        this.printDifferences = true;
        return this;
    }

    public MoleculeComparator ignoreCisTrans() {
        this.ignoreCisTrans = true;
        return this;
    }

    public MoleculeComparator ignoreRelativeStereoDifferences() {
        this.ignoreRelativeStereoDifferences = true;
        return this;
    }

    public MoleculeComparator ignoreStereo() {
        this.ignoreStereo = true;
        return this;
    }

    public MoleculeComparator neutralizeIons() {
        this.neutralizeIons = true;
        return this;
    }

    public MoleculeComparator ignoreProtons() {
        this.ignoreProtons = true;
        return this;
    }

    public MoleculeComparator anomerize() {
        this.anomerize = true;
        return this;
    }

    public MoleculeComparator ignoreBondType() {
        this.ignoreBondType = true;
        return this;
    }

    public static boolean equal(Molecule m1, Molecule m2) {
        return new MoleculeComparator().eq(m1, m2);
    }

    public boolean eq(Molecule m1, Molecule m2) {
        if (m1 == null || m2 == null) {
            return m1 == m2;
        }
        if (this.cachedEq(m1, m2)) {
            return true;
        }
        if (this.ignoreDuplicateFragments && this.cachedEq(m1 = MoleculeComparator.removeDuplicateFragments(m1, false), m2 = MoleculeComparator.removeDuplicateFragments(m2, false))) {
            return true;
        }
        if (this.ignoreDuplicateFragments && this.cachedEq(m1 = MoleculeComparator.removeDuplicateFragments(m1, true), m2 = MoleculeComparator.removeDuplicateFragments(m2, true))) {
            return true;
        }
        if (this.ignoreSmallFragments && this.cachedEq(m1 = MoleculeComparator.removeSmallFragments(m1), m2 = MoleculeComparator.removeSmallFragments(m2))) {
            return true;
        }
        if (this.neutralizeIons && this.cachedEq(m1 = MoleculeComparator.neutralizeIons(m1), m2 = MoleculeComparator.neutralizeIons(m2))) {
            return true;
        }
        if (this.ignoreDuplicateFragments && this.neutralizeIons && this.cachedEq(m1 = MoleculeComparator.removeDuplicateFragments(m1, true), m2 = MoleculeComparator.removeDuplicateFragments(m2, true))) {
            return true;
        }
        if (this.anomerize && this.cachedEq(m1, m2 = this.anomerize(m2))) {
            return true;
        }
        return this.ignoreBondType && this.cachedEq(m1 = this.changeBondsToSingle(m1), m2 = this.changeBondsToSingle(m2));
    }

    boolean cachedEq(Molecule m1, Molecule m2) {
        if (m1 == this.prevM1 && m2 == this.prevM2 && m1.getGrinvCC() == this.prevGrinv1 && m2.getGrinvCC() == this.prevGrinv2) {
            return this.prevRes;
        }
        this.prevRes = this.eqImplementation(m1, m2);
        this.prevM1 = m1;
        this.prevM2 = m2;
        this.prevGrinv1 = m1.getGrinvCC();
        this.prevGrinv2 = m2.getGrinvCC();
        return this.prevRes;
    }

    private boolean eqImplementation(Molecule m1, Molecule m2) {
        String formula2;
        String formula1 = this.getFormula(m1);
        if (!formula1.equals(formula2 = this.getFormula(m2))) {
            if (this.printDifferences) {
                System.out.println(formula1 + " != " + formula2);
            }
            return false;
        }
        return this.eqSmiles(m1, m2) || this.eqInChI(m1, m2);
    }

    private String getFormula(Molecule m) {
        String formula = m.getFormula();
        int H = formula.indexOf(72);
        if (H != -1) {
            int afterH;
            int len = formula.length();
            for (afterH = H + 1; afterH < len && Character.isDigit(formula.charAt(afterH)); ++afterH) {
            }
            formula = formula.substring(0, H) + formula.substring(afterH);
        }
        return formula;
    }

    public boolean eqInChI(Molecule m1, Molecule m2) {
        String inchi2;
        String inchi1;
        if (m1 == null || m2 == null) {
            return m1 == m2;
        }
        if (m1.isQuery() != m2.isQuery()) {
            if (this.printDifferences) {
                System.out.println("isQuery: " + m1.isQuery() + " != " + m2.isQuery());
            }
            return false;
        }
        if (!this.ignoreStereo && !this.ignoreRelativeStereoDifferences && m1.isAbsStereo() != m2.isAbsStereo()) {
            if (this.printDifferences) {
                System.out.println("Abs stereo: " + m1.isAbsStereo() + " != " + m2.isAbsStereo());
            }
            return false;
        }
        try {
            inchi1 = m1.exportToFormat("inchi:AuxNone,Woff");
            inchi2 = m2.exportToFormat("inchi:AuxNone,Woff");
        }
        catch (MolExportException e) {
            return false;
        }
        if (this.ignoreStereo) {
            inchi1 = MoleculeComparator.removeInchiParts(inchi1, "btms");
            inchi2 = MoleculeComparator.removeInchiParts(inchi2, "btms");
        } else if (this.ignoreCisTrans) {
            inchi1 = MoleculeComparator.removeInchiParts(inchi1, "b");
            inchi2 = MoleculeComparator.removeInchiParts(inchi2, "b");
        }
        if (this.ignoreProtons) {
            inchi1 = MoleculeComparator.removeInchiParts(inchi1, "p");
            inchi2 = MoleculeComparator.removeInchiParts(inchi2, "p");
        }
        if (inchi1.equals(inchi2)) {
            if (this.printAgreements) {
                System.out.println("Agreement on " + inchi1);
            }
            return true;
        }
        if (this.printDifferences) {
            System.out.println("   " + inchi1 + "\n!= " + inchi2);
        }
        return false;
    }

    private static String removeInchiParts(String inchi, String parts) {
        for (int i = 0; i < parts.length(); ++i) {
            char part = parts.charAt(i);
            int start = inchi.indexOf("/" + part);
            if (start == -1) continue;
            int end = inchi.indexOf("/", start + 2);
            if (end == -1) {
                end = inchi.length();
            }
            inchi = inchi.substring(0, start) + inchi.substring(end);
        }
        return inchi;
    }

    boolean eqSmiles(Molecule m1, Molecule m2) {
        String s2;
        String s1;
        if (m1 == null || m2 == null) {
            return m1 == m2;
        }
        if (this.ignoreCisTrans) {
            MoleculeComparator.removeCisTransInfo(m1);
            MoleculeComparator.removeCisTransInfo(m2);
        }
        if (this.ignoreRelativeStereoDifferences && m1.isAbsStereo() != m2.isAbsStereo()) {
            m1.setAbsStereo(false);
            m2.setAbsStereo(false);
        }
        try {
            if (m1.isQuery()) {
                if (!m2.isQuery()) {
                    return false;
                }
                s1 = m1.toFormat("cxsmarts:u");
                s2 = m2.toFormat("cxsmarts:u");
            } else {
                if (m2.isQuery()) {
                    return false;
                }
                String format2 = "cxsmiles:ufRL-l";
                format2 = this.ignoreStereo ? format2 + ",0" : format2 + "+e";
                s1 = m1.toFormat(format2);
                s2 = m2.toFormat(format2);
            }
        }
        catch (Exception e) {
            return false;
        }
        if (s1.equals(s2)) {
            return true;
        }
        if (this.printDifferences) {
            System.out.println("   " + s1 + "\n!= " + s2);
        }
        return false;
    }

    private static void removeCisTransInfo(Molecule m) {
        int i = m.getBondCount();
        while (--i >= 0) {
            MolBond b = m.getBond(i);
            if (b.getType() != 2) continue;
            b.setFlags(192, 448);
        }
    }

    static Molecule neutralizeIons(Molecule m) {
        if (!MoleculeComparator.hasIon(m)) {
            return m;
        }
        m = m.cloneMolecule();
        int i = m.getAtomCount();
        while (--i >= 0) {
            MolAtom a = m.getAtom(i);
            if (!MoleculeComparator.isIon(a)) continue;
            a.setCharge(0);
        }
        return m;
    }

    static boolean hasIon(Molecule m) {
        int i = m.getAtomCount();
        while (--i >= 0) {
            if (!MoleculeComparator.isIon(m.getAtom(i))) continue;
            return true;
        }
        return false;
    }

    static boolean isIon(MolAtom a) {
        if (a.getCharge() == 0) {
            return false;
        }
        if (a.getAtno() == 8 && a.getCharge() == -1) {
            return true;
        }
        if (a.getBondCount() == 0) {
            return true;
        }
        return a.getBondCount() == a.getExplicitHcount();
    }

    static Molecule removeDuplicateFragments(Molecule original, boolean removeAlsoMonoAtomic) {
        if (original.getFragCount() == 1) {
            return original;
        }
        Molecule copy = original.cloneMolecule();
        Molecule[] frags = (Molecule[])copy.findFrags(Molecule.class);
        ArrayList<Molecule> uniqueFrags = new ArrayList<Molecule>();
        boolean changed = false;
        block0: for (Molecule frag : frags) {
            if (frag.getAtomCount() == 1 && !removeAlsoMonoAtomic) {
                uniqueFrags.add(frag);
                continue;
            }
            for (Molecule other : uniqueFrags) {
                if (!MoleculeComparator.equal(other, frag)) continue;
                changed = true;
                continue block0;
            }
            uniqueFrags.add(frag);
        }
        if (!changed) {
            return original;
        }
        Molecule res = new Molecule();
        for (Molecule frag : uniqueFrags) {
            res.fuse(frag, false);
        }
        return res;
    }

    static Molecule removeSmallFragments(Molecule original) {
        if (original.getFragCount() == 1) {
            return original;
        }
        boolean isAbsStereo = original.isAbsStereo();
        Molecule copy = original.cloneMolecule();
        Molecule[] frags = (Molecule[])copy.findFrags(Molecule.class);
        int biggestAtomCount = 0;
        for (Molecule frag : frags) {
            biggestAtomCount = Math.max(biggestAtomCount, frag.getAtomCount() - frag.getExplicitHcount());
        }
        Molecule res = new Molecule();
        boolean removed = false;
        for (Molecule frag : frags) {
            int size = frag.getAtomCount() - frag.getExplicitHcount();
            if (size <= 2 && size < biggestAtomCount / 2) {
                removed = true;
                continue;
            }
            res.fuse(frag, false);
        }
        if (!removed) {
            return original;
        }
        res.setAbsStereo(isAbsStereo);
        return res;
    }

    Molecule anomerize(Molecule m) {
        return this.anomerize(m, true);
    }

    private Molecule anomerize(Molecule m, boolean clone) {
        for (MolAtom a : m.getAtomArray()) {
            MolBond b2;
            if (a.getAtno() != 6 || a.getBondCount() != 3) continue;
            MolAtom o1 = null;
            MolAtom o2 = null;
            for (MolAtom n : a.getLigands()) {
                if (n.getAtno() != 8) continue;
                if (o1 == null) {
                    o1 = n;
                    continue;
                }
                if (o2 == null) {
                    o2 = n;
                    continue;
                }
                return m;
            }
            if (o2 == null) continue;
            MolBond b1 = a.getBondTo(o1);
            Molecule res = this.anomerize(m, b1, b2 = a.getBondTo(o2), o2, clone);
            if (res != null) {
                return res;
            }
            res = this.anomerize(m, b2, b1, o1, clone);
            if (res == null) continue;
            return res;
        }
        return m;
    }

    private Molecule anomerize(Molecule m, MolBond b1, MolBond b2, MolAtom o2, boolean clone) {
        if (o2.getBondCount() == 1 && m.isRingBond(m.indexOf(b1))) {
            if (clone) {
                return this.anomerize(m.cloneMolecule(), false);
            }
            m.removeBond(b1);
            b2.setType(2);
            return m;
        }
        return null;
    }

    public static void main(String[] args) throws MolFormatException {
        String s1 = "CO[C@H]1[C@H](O)CC(=O)O[C@H](C)C\\C=C\\C=C\\[C@H](OC2CCC(N(C)C)C(C)O2)[C@H](C)C[C@H](CC=O)[C@@H]1OC1OC(C)C(OC2OC(C)C(O)C(C)(O)C2)C(N(C)C)C1O";
        String s2 = "CO[C@H]1[C@H](O)CC(=O)O[C@H](C)C\\C=C\\C=C\\[C@H](O[C@H]2CC[C@H](N(C)C)C(C)O2)[C@H](C)C[C@H](CC=O)[C@@H]1O[C@@H]1O[C@H](C)[C@@H](O[C@@H]2O[C@H](C)[C@H](O)C(C)(O)C2)C(N(C)C)C1C";
        Molecule m1 = MolImporter.importMol(s1);
        Molecule m2 = MolImporter.importMol(s2);
        MoleculeComparator comparator = new MoleculeComparator();
        comparator.ignoreStereo();
        comparator.printDifferences();
        System.out.println(comparator.eq(m1, m2));
    }

    private Molecule changeBondsToSingle(Molecule m) {
        Molecule res = m.cloneMolecule();
        for (MolBond b : res.getBondArray()) {
            b.setType(1);
        }
        return res;
    }
}

