/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameexport;

import chemaxon.common.util.IntVector;
import chemaxon.marvin.io.formats.name.nameexport.Chem;
import chemaxon.marvin.io.formats.name.nameexport.GroupDictionary;
import chemaxon.marvin.io.formats.name.nameexport.IUPACNamer;
import chemaxon.marvin.io.formats.name.nameexport.Util;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import java.util.ArrayList;

class Acid
extends GroupDictionary.Structure
implements Cloneable {
    int wholeLength;
    private static final int[] O_OR_REPLACEMENT = new int[]{8, 35, 17, 9, 53, 6, 7};
    private boolean notEster;
    private boolean halide = false;
    private boolean pseudoHalide = false;
    private IntVector ohs;
    private int charge;
    private int hydrogen = 0;
    private boolean namesChanged = false;
    private static final int[] CHAIN_azide = new int[]{2, 7, 3, 7};
    private static final int[] CHAIN_isocyanide = new int[]{2, 6};
    private static final int[] CHAIN_isotellurocyanate = new int[]{2, 6, 2, 52};
    private static final int[] CHAIN_isoselenocyanate = new int[]{2, 6, 2, 34};
    private static final int[] CHAIN_isothiocyanate = new int[]{2, 6, 2, 16};
    private static final int[] CHAIN_isocyanate = new int[]{2, 6, 2, 8};
    private static final int AZIDE = -7;
    private static final int CYANIDE = -6;
    private static final int ISOCYANIDE = -5;
    private static final int ISOTELLUROCYANATE = -4;
    private static final int ISOSELENOCYANATE = -3;
    private static final int ISOTHIOCYANATE = -2;
    private static final int ISOCYANATE = -1;

    Acid(int suffix2, int suffix3, String suffixName, String prefixName, String query) {
        super(7, suffix2, suffix3, suffixName, prefixName, query);
        this.ignoreCharge = true;
        this.ignoreQueryProperties = true;
        if (query.indexOf(61) != -1 || query.indexOf(35) != -1) {
            this.updateQueryForHalides();
        }
    }

    @Override
    void setMolecule(Molecule wholePart) {
        this.wholeLength = wholePart.getAtomCount();
    }

    boolean inChain() {
        return this.wholeLength > this.query.getAtomCount();
    }

    void updateQueryForHalides() {
        int i = this.query.getAtomCount();
        while (--i > 0) {
            MolAtom a = this.query.getAtom(i);
            if (a.getAtno() != 8 || a.getQPropAsInt("H") != 1) continue;
            a.setAtno(128);
            a.setList(O_OR_REPLACEMENT);
            a.setQProp("H", null);
        }
    }

    Acid notEster() {
        this.notEster = true;
        return this;
    }

    @Override
    boolean canHaveSubstituents() {
        return !this.pseudoHalide;
    }

    public Object clone() throws CloneNotSupportedException {
        Acid res = (Acid)super.clone();
        res.ohs = new IntVector();
        return res;
    }

    private boolean addOH(int atno) {
        this.ohs.addElement(atno);
        if (atno != 8) {
            this.makeHalide(atno);
        }
        return true;
    }

    private String computeSuffixName() {
        if (!this.suffixName.endsWith(" ")) {
            return this.suffixName;
        }
        ArrayList suffixes = new ArrayList(this.ohs.size());
        int i = this.ohs.size();
        while (--i >= 0) {
            String suffix = this.suffix(this.ohs.elementAt(i));
            if (suffix == null) {
                return null;
            }
            Util.insertSortedAlphabetically(suffix, suffixes);
        }
        return this.suffixName + Util.multipliedNames(suffixes);
    }

    private String suffix(int atno) {
        switch (atno) {
            case 9: {
                return "fluoride";
            }
            case 17: {
                return "chloride";
            }
            case 35: {
                return "bromide";
            }
            case 53: {
                return "iodide";
            }
            case -7: {
                return "azide";
            }
            case -6: {
                return "cyanide";
            }
            case -5: {
                return "isocyanide";
            }
            case -1: {
                return "isocyanate";
            }
            case -2: {
                return "isothiocyanate";
            }
            case -3: {
                return "isoselenocyanate";
            }
            case -4: {
                return "isotellurocyanate";
            }
        }
        return null;
    }

    void makeIon(MolAtom atom) {
        boolean anion = atom.getCharge() < 0;
        this.setSuffix1(anion ? 4 : 6);
        this.charge = anion ? --this.charge : ++this.charge;
        if (anion) {
            this.setAnionNames();
        } else {
            this.setCationNames(atom);
        }
    }

    void makeEster() {
        if (this.getSuffix1() != 7) {
            return;
        }
        this.setSuffix1(9);
        this.setAnionNames();
        this.prefixName = null;
    }

    void makeHalide(int atomType) {
        if (atomType < 0) {
            this.pseudoHalide = true;
        }
        if (this.halide) {
            return;
        }
        this.halide = true;
        this.setSuffix1(10);
        String ending = this.suffix(atomType);
        int halideSeniority = this.pseudoHalide ? 0 : Chem.MAX_SENIORITY - Chem.seniority(atomType);
        switch (atomType) {
            case -6: {
                --this.wholeLength;
                halideSeniority = Chem.MAX_SENIORITY + 10;
                break;
            }
            case -1: {
                this.wholeLength -= 2;
                halideSeniority = Chem.MAX_SENIORITY + 9;
            }
        }
        this.setSuffix4(halideSeniority);
        if (!this.inChain() && this.suffixName == "carboxylic acid") {
            this.prefixName = "carbono" + ending.substring(0, ending.length() - 1) + "oyl";
            this.complex = true;
        } else if (!this.inChain() && this.suffixName == "carbothioic O-acid") {
            this.prefixName = "carbono" + ending.substring(0, ending.length() - 1) + "othioyl";
            this.complex = true;
        } else {
            this.prefixName = null;
        }
        this.suffixName = Acid.acyl(this.suffixName) + " ";
    }

    static String acyl(String suffix) {
        if (suffix == "carboxylic acid" || suffix == "carbonic acid") {
            return "carbonyl";
        }
        if (suffix.endsWith("carbonic acid")) {
            return Acid.remove(suffix, "carbonic acid") + "carbonic";
        }
        if (suffix == "carboximidic acid") {
            return "carbonimidoyl";
        }
        if (suffix == "oxalic acid") {
            return "oxalic";
        }
        if (suffix == "cyanic acid") {
            return "carbononitridic";
        }
        String base = suffix.indexOf("oic ") != -1 ? suffix.substring(0, suffix.indexOf("oic ")) : Acid.remove(suffix, "ic acid");
        if ((base = base.intern()) == "sulfon" || base == "sulfin" || base == "selenon" || base == "selenin" || base == "telluron" || base == "tellurin") {
            return base + "yl";
        }
        return base + "oyl";
    }

    @Override
    int getCharge() {
        return this.charge;
    }

    void setCationNames(MolAtom atom) {
        if (this.namesChanged) {
            return;
        }
        this.namesChanged = true;
        String suffix = "ium";
        if (!this.suffixName.endsWith("ic acid") && !this.suffixName.endsWith("ous acid")) {
            throw new IUPACNamer.Failure("Unhandled cation acid: " + this.suffixName);
        }
        this.suffixName = this.suffixName + suffix;
        this.suffixName = this.suffixName.intern();
    }

    void setAnionNames() {
        if (this.namesChanged) {
            return;
        }
        this.namesChanged = true;
        if (this.suffixName == "phosphoric acid") {
            this.suffixName = "phosphate";
        } else if (this.suffixName == "phosphorous acid") {
            this.suffixName = "phosphite";
        } else if (this.suffixName == "sulfuric acid") {
            this.suffixName = "sulfate";
        } else if (this.suffixName == "sulfurous acid") {
            this.suffixName = "sulfite";
        } else if (this.suffixName.endsWith("ic acid")) {
            this.suffixName = Acid.remove(this.suffixName, "ic acid") + "ate";
        } else if (this.suffixName.endsWith("ous acid")) {
            this.suffixName = Acid.remove(this.suffixName, "ous acid") + "ite";
        } else if (this.suffixName.endsWith("ic O-acid")) {
            this.suffixName = Acid.remove(this.suffixName, "ic O-acid") + "ate";
        } else {
            throw new IUPACNamer.Failure("Incorrect acid name: " + this.suffixName);
        }
        this.suffixName = this.suffixName.intern();
        this.prefixName = this.suffixName.endsWith("ate") ? (this.suffixName.substring(0, this.suffixName.length() - 1) + 'o').intern() : null;
    }

    static String remove(String from, String suffix) {
        return from.substring(0, from.length() - suffix.length());
    }

    @Override
    String getPrefix() {
        if (this.hydrogen == 0 || !this.namesChanged) {
            return null;
        }
        return Chem.diMultiplier(this.hydrogen) + "hydrogen ";
    }

    MolAtom getMatched(MolAtom queryAtom, Molecule m, int[] groupAtoms) {
        return m.getAtom(groupAtoms[this.query.indexOf(queryAtom)]);
    }

    MolAtom getMatching(MolAtom matchedAtom, Molecule m, int[] groupAtoms) {
        int index = Util.indexOf(m.indexOf(matchedAtom), groupAtoms);
        if (index == -1) {
            return null;
        }
        return this.query.getAtom(index);
    }

    boolean isOH(MolAtom queryAtom) {
        return queryAtom.getAtno() == 8 && queryAtom.getQPropAsInt("H") == 1 || queryAtom.getAtno() == 128;
    }

    @Override
    boolean checkRadical(MolAtom matched, MolAtom queryAtom) {
        if (queryAtom != this.query.getAtom(0)) {
            return false;
        }
        return super.checkRadical(matched, queryAtom);
    }

    @Override
    boolean specificCheckMatchedAtom(MolAtom matchedAtom, MolAtom queryAtom) {
        int charge = matchedAtom.getCharge();
        if (!this.isOH(queryAtom)) {
            return charge == 0;
        }
        int atno = matchedAtom.getAtno();
        if (atno == 6) {
            atno = -6;
            boolean ok = false;
            int i = matchedAtom.getBondCount();
            while (--i >= 0) {
                MolAtom neighbour = matchedAtom.getLigand(i);
                if (neighbour.getAtno() != 7 || matchedAtom.getBond(i).getType() != 3) continue;
                ok = true;
                break;
            }
            if (!ok) {
                return false;
            }
        }
        if (atno == 7) {
            if (this.findChain(matchedAtom, CHAIN_azide)) {
                atno = -7;
            } else if (this.findChain(matchedAtom, CHAIN_isocyanide)) {
                atno = -5;
            } else if (this.findChain(matchedAtom, CHAIN_isocyanate)) {
                atno = -1;
            } else if (this.findChain(matchedAtom, CHAIN_isothiocyanate)) {
                atno = -2;
            } else if (this.findChain(matchedAtom, CHAIN_isoselenocyanate)) {
                atno = -3;
            } else if (this.findChain(matchedAtom, CHAIN_isotellurocyanate)) {
                atno = -4;
            } else {
                return false;
            }
        }
        if (!this.addOH(atno)) {
            return false;
        }
        if (charge == -1 || charge == 1) {
            if (this.halide) {
                return false;
            }
            if (charge == 1 && (atno != 8 || matchedAtom.getValence() != 3)) {
                return false;
            }
            this.makeIon(matchedAtom);
        } else if (charge != 0) {
            return false;
        }
        if (Chem.getHCount(matchedAtom) == 0) {
            try {
                this.makeEster();
            }
            catch (Error e) {
                return false;
            }
            queryAtom.setAliasstr(" ");
        } else if (Chem.getHCount(matchedAtom) == 1) {
            ++this.hydrogen;
        }
        return true;
    }

    private boolean findChain(MolAtom atom, int[] chain) {
        for (int i = 0; i < chain.length; i += 2) {
            int bondType = chain[i];
            int atno = chain[i + 1];
            int bondCount = atom.getBondCount();
            boolean ok = false;
            int l = bondCount;
            while (--l >= 0) {
                MolAtom next;
                if (atom.getBond(l).getType() != bondType || (next = atom.getLigand(l)).getAtno() != atno) continue;
                ok = true;
                atom = next;
                break;
            }
            if (!ok) {
                return false;
            }
            bondCount = atom.getBondCount();
            if (!(i + 2 == chain.length ? bondCount != 1 : i > 0 && bondCount > 2)) continue;
            return false;
        }
        return true;
    }

    @Override
    boolean checkSubstitutedAtom(MolAtom matchedAtom, MolAtom queryAtom, Molecule target, int[] groupAtoms) {
        if ((this.suffixName == "carbamic acid" || this.suffixName == "carbamate") && queryAtom.getAtno() == 7) {
            int i = matchedAtom.getBondCount();
            while (--i >= 0) {
                MolAtom a = matchedAtom.getLigand(i);
                if (a.getAtno() != 7) continue;
                return false;
            }
            return true;
        }
        if (!this.isOH(queryAtom)) {
            return super.checkSubstitutedAtom(matchedAtom, queryAtom, target, groupAtoms);
        }
        int i = queryAtom.getBondCount();
        while (--i >= 0) {
            MolAtom queryNeighbour = queryAtom.getLigand(i);
            MolAtom matchedNeighbour = this.getMatched(queryNeighbour, target, groupAtoms);
            if (matchedNeighbour == null) continue;
            int j = matchedNeighbour.getBondCount();
            while (--j >= 0) {
                MolAtom candidate = matchedNeighbour.getLigand(j);
                if (this.getMatching(candidate, target, groupAtoms) != null || (candidate.getAtno() != 8 || candidate.getBondCount() != 1) && candidate.getAtno() != 7) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    boolean isAcceptable() {
        if (this.notEster && this.getSuffix1() == 9 && this.hydrogen > 0) {
            return false;
        }
        if (this.namesChanged && this.halide) {
            return false;
        }
        this.suffixName = this.computeSuffixName();
        return this.suffixName != null;
    }

    @Override
    boolean needsLocants() {
        return this.suffixName != "carbamic acid";
    }
}

