/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameexport;

import chemaxon.common.util.IntVector;
import chemaxon.marvin.io.formats.name.nameexport.AminoAcid;
import chemaxon.marvin.io.formats.name.nameexport.Canonicalizer;
import chemaxon.marvin.io.formats.name.nameexport.Chain;
import chemaxon.marvin.io.formats.name.nameexport.ChainComparator;
import chemaxon.marvin.io.formats.name.nameexport.CharacteristicGroup;
import chemaxon.marvin.io.formats.name.nameexport.Chem;
import chemaxon.marvin.io.formats.name.nameexport.EtherParent;
import chemaxon.marvin.io.formats.name.nameexport.EtherSubstituent;
import chemaxon.marvin.io.formats.name.nameexport.GroupDictionary;
import chemaxon.marvin.io.formats.name.nameexport.GroupMatch;
import chemaxon.marvin.io.formats.name.nameexport.GroupSearch;
import chemaxon.marvin.io.formats.name.nameexport.IUPACNamer;
import chemaxon.marvin.io.formats.name.nameexport.MonoNuclear;
import chemaxon.marvin.io.formats.name.nameexport.ParentFinder;
import chemaxon.marvin.io.formats.name.nameexport.Part;
import chemaxon.marvin.io.formats.name.nameexport.SimpleGroup;
import chemaxon.marvin.io.formats.name.nameexport.SubmoleculeBuilder;
import chemaxon.marvin.io.formats.name.nameexport.TopologyAnalyser;
import chemaxon.marvin.io.formats.name.nameexport.Util;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class Acyclic {
    Molecule m;
    int[] marker;
    int[] substituentRootGroupRoot;
    ArrayList<MolAtom[]> principalChains = new ArrayList();
    MolAtom root = null;
    MolAtom radical;
    MolBond rootBond;
    int[] atomIndexMap;
    ArrayList parts;
    IntVector additionalEnds = new IntVector();
    int[] substituted;
    TopologyAnalyser topologyAnalyser;
    boolean incompleteMatch = false;
    ArrayList matches = new ArrayList();
    IntVector groupRoots = new IntVector();
    IntVector groupStarts = new IntVector();
    int turnedGroup = -1;
    private static final boolean dbg = false;

    static Part create(Molecule m) {
        if (m.getAtomCount() == 1) {
            return new MonoNuclear(m);
        }
        return new Acyclic(m).create(true, true);
    }

    Acyclic(Molecule m) {
        this.m = m;
        this.marker = new int[m.getAtomCount()];
        this.substituentRootGroupRoot = new int[m.getAtomCount()];
    }

    Acyclic(Molecule m, int[] atomIndexMap, MolAtom root, MolAtom radical, TopologyAnalyser topologyAnalyser) {
        this(m);
        this.atomIndexMap = atomIndexMap;
        this.root = root;
        this.radical = radical;
        this.topologyAnalyser = topologyAnalyser;
    }

    Acyclic(Molecule m, MolAtom radical, MolBond rootBond, int[] atomIndexMap, ArrayList parts, IntVector substituted, TopologyAnalyser topologyAnalyser) {
        this(m, radical, rootBond, atomIndexMap, parts, topologyAnalyser);
        this.substituted = substituted == null ? null : substituted.toArray();
    }

    Acyclic(Molecule m, MolAtom radical, MolBond rootBond, int[] atomIndexMap, ArrayList parts, TopologyAnalyser topologyAnalyser) {
        this(m);
        this.radical = radical;
        this.rootBond = rootBond;
        this.atomIndexMap = atomIndexMap;
        this.parts = parts;
        this.topologyAnalyser = topologyAnalyser;
    }

    MolBond getRootBond() {
        if (this.rootBond != null) {
            return this.rootBond;
        }
        if (this.root == null) {
            return null;
        }
        return this.root.getBondTo(this.radical);
    }

    MolAtom global(MolAtom atom) {
        return SubmoleculeBuilder.originalAtom(atom);
    }

    private void findRadical() {
        int i = this.m.getAtomCount();
        while (--i >= 0) {
            MolAtom a = this.m.getAtom(i);
            if (!Chem.isRadical(SubmoleculeBuilder.originalAtom(a))) continue;
            this.radical = a;
        }
    }

    Part create(boolean completeFragment, boolean asParent) {
        return this.make(true, completeFragment, asParent, false, false);
    }

    Part branch() {
        return this.branch(false, false);
    }

    Part branch(boolean ether, boolean groupSubstituent) {
        return this.make(false, false, false, ether, groupSubstituent);
    }

    private Part make(boolean main, boolean completeFragment, boolean asParent, boolean ether, boolean groupSubstituent) {
        int rootIndex;
        if (this.radical == null) {
            this.findRadical();
        }
        if (this.root != null && (rootIndex = this.m.indexOf(this.root)) != -1) {
            this.marker[rootIndex] = -1;
        }
        this.findGroups();
        Part res = this.findGroupOnRadical();
        if (res != null) {
            return res;
        }
        res = this.findEther(asParent);
        if (res != null) {
            if (main) {
                res.originalMolecule = this.m;
            }
            return res;
        }
        if (main) {
            res = this.findSingleGroup(completeFragment);
            if (res != null) {
                return res;
            }
            res = this.getParentGroup(true);
            if (res != null) {
                return res;
            }
        }
        if ((res = this.findPrincipalChainCandidates()) != null) {
            return res;
        }
        if (this.principalChains.isEmpty()) {
            return this.getParentGroup(false);
        }
        Util.removeConsecutiveArrayDuplicates(this.principalChains);
        if (main) {
            return this.choosePrincipalChainAsMain(asParent);
        }
        return this.choosePrincipalChainAsBranch(ether, groupSubstituent);
    }

    private Part findPrincipalChainCandidates() {
        if (this.turnedGroup >= 0) {
            MolAtom a;
            int rootIndex = this.groupRoots.get(this.turnedGroup);
            if (rootIndex >= 0 && (a = this.m.getAtom(rootIndex)).getAtno() == 6 && this.match((int)this.turnedGroup).group.eatCarbon) {
                this.radical = a;
                this.findPrincipalChain(a);
                this.radical = null;
            }
            if (this.principalChains.isEmpty()) {
                return this.group(this.turnedGroup, this.root, this.m.getAtom(this.groupStarts.get(this.turnedGroup)));
            }
        } else {
            MolAtom[] ends = this.root == null ? this.findEnds() : this.findEnds(this.root);
            int e = ends.length;
            while (--e >= 0) {
                this.findPrincipalChain(ends[e]);
            }
            int i = this.additionalEnds.size();
            while (--i >= 0) {
                MolAtom end = this.m.getAtom(this.additionalEnds.get(i));
                this.findPrincipalChain(end);
            }
        }
        if (this.principalChains.isEmpty() && this.radical != null) {
            this.findPrincipalChain(this.radical);
        }
        return null;
    }

    private Part choosePrincipalChainAsMain(boolean asParent) {
        if (this.principalChains.size() == 1) {
            MolAtom[] principalChain = this.principalChains.get(0);
            return this.createChain(principalChain, asParent);
        }
        Part[] chains = new Part[this.principalChains.size()];
        int[] originalMarker = this.marker;
        int i = this.principalChains.size();
        while (--i >= 0) {
            MolAtom[] principalChain = this.principalChains.get(i);
            this.marker = (int[])originalMarker.clone();
            chains[i] = this.createChain(principalChain, asParent);
        }
        return this.bestChain(chains);
    }

    private Part choosePrincipalChainAsBranch(boolean ether, boolean groupSubstituent) {
        Part res;
        if (this.principalChains.size() == 1) {
            MolAtom a;
            MolAtom[] principalChain = this.principalChains.get(0);
            if (principalChain.length == 1 && (SimpleGroup.isGroup(a = SubmoleculeBuilder.originalAtom(principalChain[0])) || SimpleGroup.isGroup2(a))) {
                if (this.rootBond != null) {
                    return SimpleGroup.create(this.rootBond, a);
                }
                return SimpleGroup.create(this.root, principalChain[0]);
            }
            if (this.rootBond != null) {
                res = this.createChainOrGroup(principalChain, ether);
            } else {
                HashMap atomOwner = new HashMap();
                res = Chain.create(this.m, atomOwner, this.atomIndexMap, this.root, ether ? null : this.radical, principalChain, this.branches(principalChain, atomOwner), groupSubstituent);
            }
        } else {
            Part[] chains = new Part[this.principalChains.size()];
            int[] originalMarker = this.marker;
            int i = this.principalChains.size();
            while (--i >= 0) {
                MolAtom[] principalChain = this.principalChains.get(i);
                this.marker = (int[])originalMarker.clone();
                if (this.rootBond != null) {
                    res = this.createChainOrGroup(principalChain, ether);
                } else {
                    HashMap atomOwner = new HashMap();
                    res = Chain.create(this.m, atomOwner, this.atomIndexMap, this.root, ether ? null : this.radical, principalChain, this.branches(principalChain, atomOwner), groupSubstituent);
                }
                chains[i] = res;
            }
            res = this.bestChain(chains);
        }
        if (res.originalMolecule != null && res instanceof Chain) {
            int i = res.originalMolecule.getAtomCount();
            while (--i >= 0) {
                res.makeOwner(res.originalMolecule.getAtom(i));
            }
        }
        return res;
    }

    private Part createChain(MolAtom[] principalChain, boolean asParent) {
        GroupDictionary.Structure g;
        Part res = this.findEther(principalChain);
        if (res != null) {
            return res;
        }
        if (!Acyclic.bondTouchesChain(this.rootBond, principalChain)) {
            this.rootBond = null;
        }
        if (asParent && this.m.getAtomCount() == 1 && (SimpleGroup.isGroup(principalChain[0]) || SimpleGroup.isGroup2(principalChain[0]))) {
            return SimpleGroup.create(this.rootBond, principalChain[0]);
        }
        if (principalChain.length == 1 && principalChain[0].getAtno() == 6 && (g = this.asGroup(principalChain)) != null) {
            int main = this.findParentGroup(false);
            if (main >= 0 && g != this.match((int)main).group) {
                return this.getParentGroup(false);
            }
            MolAtom a = principalChain[0];
            int i = a.getBondCount();
            while (--i >= 0) {
                MolAtom neighbour = a.getLigand(i);
                if (this.marker[this.m.indexOf(neighbour)] < 0 || !this.isSingleAtomGroup(neighbour, a) || SimpleGroup.create(a, neighbour).suffixJuniority() <= 0 || SimpleGroup.create(a, neighbour).suffixJuniority() >= g.suffixJuniority) continue;
                return new Acyclic(this.m, this.atomIndexMap, null, neighbour, this.topologyAnalyser).create(false, asParent);
            }
        }
        return this.createChainOrGroup(principalChain, false);
    }

    private Part createChainOrGroup(MolAtom[] principalChain, boolean ether) {
        CharacteristicGroup g;
        HashMap atomOwner = new HashMap();
        Part[] branches = this.branches(principalChain, atomOwner, false, this.radical != null || Acyclic.isAmine(principalChain));
        if (this.parts != null && (g = this.asCompleteGroup(principalChain, branches)) != null) {
            g.clearAsSuffix();
            return g;
        }
        return Chain.create(this.m, atomOwner, this.atomIndexMap, ether ? null : this.radical, this.rootBond, principalChain, branches, this.substituentRootGroupRoot);
    }

    static boolean isAmine(MolAtom[] chain) {
        if (chain.length != 1) {
            return false;
        }
        MolAtom a = chain[0];
        return a.getAtno() == 7 && a.getCharge() <= 1;
    }

    private static boolean bondTouchesChain(MolBond bond, MolAtom[] chain) {
        if (bond == null) {
            return false;
        }
        int i = chain.length;
        while (--i >= 0) {
            MolAtom a = chain[i];
            a = SubmoleculeBuilder.originalAtom(a);
            if (bond.getAtom1() != a && bond.getAtom2() != a) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Part findSingleGroup(boolean completeFragment) {
        if (this.radical != null || this.incompleteMatch || this.matches.size() != 1) {
            return null;
        }
        GroupMatch match = this.match(0);
        GroupDictionary.Structure group = match.group;
        if (group.query.getAtomCount() == this.m.getAtomCount() && !group.eatCarbon) {
            if (completeFragment && group.suffixName == null) {
                this.matches.clear();
                this.groupStarts.clear();
                this.groupRoots.clear();
                int i = match.map.length;
                while (--i >= 0) {
                    this.marker[match.map[i]] = 0;
                }
                return null;
            } else {
                MolAtom root = this.groupRoots.get(0) < 0 ? null : this.m.getAtom(this.groupRoots.get(0));
                MolAtom start = this.groupStarts.get(0) < 0 ? null : this.m.getAtom(this.groupStarts.get(0));
                CharacteristicGroup g = this.part(0, root, null, start, false);
                this.match(0).setSpecialLocants(this, g);
                return g;
            }
        }
        if (this.groupRoots.get(0) != -1) return null;
        return this.group(0, null, this.m.getAtom(this.groupStarts.get(0)));
    }

    private CharacteristicGroup asCompleteGroup(MolAtom[] principalChain, Part[] branches) {
        if (principalChain.length != 1 || branches == null || branches.length != 1) {
            return null;
        }
        Part p = branches[0];
        if (p.root != this.radical && p.root == principalChain[0] && p instanceof CharacteristicGroup) {
            CharacteristicGroup g = (CharacteristicGroup)p;
            if (g.eatCarbon) {
                return g;
            }
            if (principalChain[0].getAtno() == 7 && g.group != null) {
                Part amino = SimpleGroup.create(this.m.getAtom(this.groupStarts.get(0)), principalChain[0]);
                g.addSubstituents(new Part[]{amino});
                return g;
            }
        }
        return null;
    }

    private CharacteristicGroup part(int groupIndex, MolAtom root, MolAtom alternateRoot, MolAtom start, boolean asParent) {
        GroupMatch match = this.match(groupIndex);
        int i = match.map.length;
        while (--i >= 0) {
            if (match.group.query.getAtom(i).getAtno() == 131) continue;
            this.marker[match.map[i]] = -2;
        }
        GroupDictionary.Structure group = match.group;
        ArrayList<Part> groupSubstituents = null;
        if (start != null && (asParent || !group.eatCarbon)) {
            int i2 = start.getBondCount();
            while (--i2 >= 0) {
                MolAtom neighbour = start.getLigand(i2);
                int neighbourIndex = this.m.indexOf(neighbour);
                int mark = this.marker[neighbourIndex];
                if (mark < -1 || neighbour == root || neighbour == alternateRoot) continue;
                this.marker[neighbourIndex] = -2;
                Part subst = new Acyclic(this.m, this.atomIndexMap, start, neighbour, this.topologyAnalyser).branch();
                if (groupSubstituents == null) {
                    groupSubstituents = new ArrayList<Part>();
                }
                groupSubstituents.add(subst);
            }
        }
        boolean turned = groupIndex == this.turnedGroup;
        MolAtom usualRadical = null;
        if (turned) {
            start = this.m.getAtom(match.map[match.map.length - 1]);
            usualRadical = this.m.getAtom(match.map[0]);
        }
        CharacteristicGroup res = CharacteristicGroup.create(root, alternateRoot, start, group, false, usualRadical);
        res.addSubstituents(groupSubstituents);
        res.originalMolecule = this.m;
        res.atoms = match.getAtoms(this);
        res.ezBond = match.getEZBond(this, res);
        return res;
    }

    CharacteristicGroup group(int groupIndex, MolAtom root, MolAtom start) {
        return this.group(groupIndex, root, null, start, false);
    }

    CharacteristicGroup group(int groupIndex, MolAtom root, MolAtom alternateRoot, MolAtom start, boolean asParent) {
        CharacteristicGroup g = this.part(groupIndex, root, alternateRoot, start, asParent);
        GroupMatch match = this.match(groupIndex);
        ArrayList groupSubstituentRoots = match.substituentRoots;
        if (groupSubstituentRoots.size() > 0) {
            ArrayList<Part> groupSubstituents = new ArrayList<Part>(groupSubstituentRoots.size());
            Iterator it = groupSubstituentRoots.iterator();
            while (it.hasNext()) {
                MolAtom substituentStart;
                MolAtom root1 = (MolAtom)it.next();
                while ((substituentStart = (MolAtom)it.next()) != null) {
                    groupSubstituents.add(new Acyclic(this.m, this.atomIndexMap, root1, substituentStart, this.topologyAnalyser).branch(false, true));
                }
            }
            if (groupSubstituents != null) {
                g.addSubstituents(groupSubstituents);
            }
        }
        match.setSpecialLocants(this, g);
        return g;
    }

    void findPrincipalChain(MolAtom atom) {
        MolAtom[] chain = new MolAtom[this.m.getAtomCount()];
        this.findPrincipalChain(atom, null, chain, 0, this.radical == null);
    }

    void findPrincipalChain(MolAtom atom, MolAtom from, MolAtom[] chain, int len, boolean radicalFound) {
        chain[len++] = atom;
        radicalFound |= atom == this.radical;
        boolean couldExtend = false;
        int i = atom.getBondCount();
        while (--i >= 0) {
            MolAtom neighbour = atom.getLigand(i);
            if (neighbour == from || neighbour == this.root || this.marker[this.m.indexOf(neighbour)] == -1) continue;
            couldExtend = true;
            this.findPrincipalChain(neighbour, atom, chain, len, radicalFound);
        }
        if (couldExtend) {
            return;
        }
        if (!radicalFound) {
            return;
        }
        MolAtom[] newChain = this.removeGroups(chain, len);
        if (newChain != chain) {
            chain = newChain;
            len = chain.length;
        }
        if (len > 1) {
            MolAtom[] fromStart;
            MolAtom[] c = new MolAtom[len];
            System.arraycopy(chain, 0, c, 0, len);
            chain = this.seniorPart(c);
            if (this.radical == null && chain != c && this.matches.size() > 0 && (!this.isGroup(fromStart = this.homogeneousPart(c)) || Chem.isEtherAnalog(chain[0]) && chain.length <= 2 && this.hasExternalConnection(chain[0]))) {
                this.addCandidate(fromStart, fromStart.length);
            }
            len = chain.length;
        }
        this.addCandidate(chain, len);
    }

    private boolean isGroup(MolAtom[] chain) {
        return this.asGroup(chain) != null;
    }

    private GroupDictionary.Structure asGroup(MolAtom[] chain) {
        if (chain.length > 1) {
            return null;
        }
        MolAtom atom = chain[0];
        int index = this.m.indexOf(atom);
        int i = this.groupRoots.indexOf(index);
        while (i != -1) {
            GroupDictionary.Structure group = this.match((int)i).group;
            if (group.eatCarbon) {
                return group;
            }
            i = this.groupRoots.indexOf(index, i + 1);
        }
        return null;
    }

    private void addCandidate(MolAtom[] chain, int len) {
        int diff = this.betterPrincipalChain(chain, len);
        if (diff <= 0) {
            if (diff < 0) {
                this.principalChains.clear();
            }
            MolAtom[] c = new MolAtom[len];
            System.arraycopy(chain, 0, c, 0, len);
            this.principalChains.add(c);
        }
    }

    void addSeniority(MolAtom atom, int[] seniority) {
        if (atom.getCharge() != 0) {
            Acyclic.updateSeniority(SimpleGroup.ionSeniority(atom), seniority);
        }
        if (AminoAcid.isAminoAcid(atom)) {
            Acyclic.updateSeniority(GroupDictionary.Structure.seniority(7, 0, 0), seniority);
            return;
        }
        if (Canonicalizer.isCoA(atom)) {
            Acyclic.updateSeniority(GroupDictionary.Structure.seniority(1, 0, 0), seniority);
            return;
        }
        int idx = this.m.indexOf(atom);
        int groupIndex = this.groupStarts.indexOf(idx);
        if (groupIndex == -1) {
            groupIndex = this.groupRoots.indexOf(idx);
        }
        if (groupIndex == -1) {
            return;
        }
        GroupDictionary.Structure match = this.match((int)groupIndex).group;
        int juniority = match.suffixJuniority;
        Acyclic.updateSeniority(juniority, seniority);
    }

    private static void updateSeniority(int juniority, int[] seniority) {
        if (juniority == -1 || juniority > seniority[0]) {
            return;
        }
        if (juniority < seniority[0]) {
            seniority[0] = juniority;
            seniority[1] = 1;
        } else {
            seniority[1] = seniority[1] + 1;
        }
    }

    int betterPrincipalChain(MolAtom[] chain, int len) {
        if (this.principalChains.isEmpty()) {
            return -1;
        }
        MolAtom[] principalChain = this.principalChains.get(0);
        return this.compareChains(chain, len, principalChain);
    }

    int compareChains(MolAtom[] chain, int len, MolAtom[] principalChain) {
        return ChainComparator.compare(chain, len, principalChain, this);
    }

    int[] chainSeniority(MolAtom[] chain, int len) {
        int[] seniority = new int[2];
        if (len == 1 && chain[0].getCharge() != 0) {
            MolAtom a = chain[0];
            int seniorityClass = a.getCharge() < 0 ? 4 : 6;
            seniority[0] = GroupDictionary.Structure.seniority(seniorityClass, Chem.seniority(a.getAtno()), 0);
            return seniority;
        }
        seniority[0] = Integer.MAX_VALUE;
        int i = len;
        while (--i >= 0) {
            this.addSeniority(chain[i], seniority);
        }
        return seniority;
    }

    Part[] branches(MolAtom[] principalChain, HashMap atomOwner) {
        return this.branches(principalChain, atomOwner, false, this.radical != null);
    }

    Part[] branches(MolAtom[] principalChain, HashMap atomOwner, boolean ether, boolean prefixesOnly) {
        if (principalChain.length == this.m.getAtomCount()) {
            return null;
        }
        int bestJuniority = this.radical != null ? 0 : this.getBestBranchJuniority(principalChain);
        ArrayList<Part> res = new ArrayList<Part>();
        int i = principalChain.length;
        while (--i >= 0) {
            MolAtom cur = principalChain[i];
            int groupIndex = this.groupStarts.indexOf(this.m.indexOf(cur));
            if (groupIndex != -1) {
                GroupDictionary.Structure group = this.match((int)groupIndex).group;
                if (group.prefixName != null || this.radical == null && group.suffixJuniority == bestJuniority) {
                    MolAtom alternateRoot = null;
                    if (i == 0 && principalChain.length > 1) {
                        alternateRoot = principalChain[1];
                    } else if (i > 0 && i == principalChain.length - 1) {
                        alternateRoot = principalChain[i - 1];
                    }
                    CharacteristicGroup g = this.group(groupIndex, cur, alternateRoot, cur, false);
                    if (groupIndex == this.turnedGroup) {
                        g.forceAsSuffix();
                    }
                    res.add(g);
                }
            }
            int n = cur.getBondCount();
            while (--n >= 0) {
                MolAtom root;
                Part branch;
                int neighbourIndex;
                MolAtom neighbour = cur.getLigand(n);
                if (neighbour.getAtno() == 138 || neighbour == this.root || i != 0 && neighbour == principalChain[i - 1] || i != principalChain.length - 1 && neighbour == principalChain[i + 1] || this.marker[neighbourIndex = this.m.indexOf(neighbour)] <= -2) continue;
                groupIndex = this.groupStarts.indexOf(neighbourIndex);
                if (groupIndex != -1 && prefixesOnly && this.match((int)groupIndex).group.prefixName == null) {
                    groupIndex = -1;
                }
                if (groupIndex != -1) {
                    CharacteristicGroup g = this.group(groupIndex, cur, neighbour);
                    if (atomOwner != null) {
                        this.match(groupIndex).setOwners(this.m, atomOwner, g);
                    }
                    g.eatCarbon = false;
                    branch = g;
                } else {
                    branch = new Acyclic(this.m, this.atomIndexMap, cur, neighbour, this.topologyAnalyser).branch(ether, false);
                }
                if (this.radical != null && AminoAcid.isAminoAcid(principalChain) && branch.isHydroxy() && (root = AminoAcid.findAtomConnectedTo(neighbour, principalChain[0])).getAtno() == 6) continue;
                res.add(branch);
            }
        }
        return res.toArray(new Part[res.size()]);
    }

    private int getBestBranchJuniority(MolAtom[] principalChain) {
        int bestJuniority = Integer.MAX_VALUE;
        int i = principalChain.length;
        while (--i >= 0) {
            MolAtom cur = principalChain[i];
            int groupIndex = this.groupStarts.indexOf(this.m.indexOf(cur));
            if (groupIndex != -1) {
                int juniority = this.match((int)groupIndex).group.suffixJuniority;
                if (juniority <= 0 || juniority >= bestJuniority) continue;
                bestJuniority = juniority;
                continue;
            }
            int n = cur.getBondCount();
            while (--n >= 0) {
                int juniority;
                MolAtom neighbour = cur.getLigand(n);
                if (i != 0 && neighbour == principalChain[i - 1] || i != principalChain.length - 1 && neighbour == principalChain[i + 1] || neighbour == this.root) continue;
                int neighbourIndex = this.m.indexOf(neighbour);
                groupIndex = this.groupStarts.indexOf(neighbourIndex);
                if (this.marker[neighbourIndex] <= -2 || groupIndex == -1 || (juniority = this.match((int)groupIndex).group.suffixJuniority) <= 0 || juniority >= bestJuniority) continue;
                bestJuniority = juniority;
            }
        }
        return bestJuniority;
    }

    Part findGroupOnRadical() {
        if (this.radical == null || this.matches.isEmpty()) {
            return null;
        }
        int radicalIndex = this.m.indexOf(this.radical);
        int groupIndex = this.groupStarts.indexOf(radicalIndex);
        if (groupIndex != -1) {
            return this.group(groupIndex, this.root, this.radical);
        }
        return null;
    }

    CharacteristicGroup getParentGroup(boolean alwaysParent) {
        int parent = this.findParentGroup(alwaysParent);
        if (parent < 0) {
            return null;
        }
        return this.group(parent, this.root, null, this.m.getAtom(this.groupStarts.get(parent)), true);
    }

    int findParentGroup(boolean alwaysParent) {
        if (this.radical != null) {
            return -1;
        }
        int bestJuniority = Integer.MAX_VALUE;
        int parent = -1;
        int i = this.matches.size();
        while (--i >= 0) {
            int suffixJuniority;
            GroupDictionary.Structure match = this.match((int)i).group;
            if (alwaysParent && match.suffixName == null || (suffixJuniority = match.suffixJuniority >= 0 ? match.suffixJuniority : 0x7FFFFFFE) >= bestJuniority) continue;
            bestJuniority = suffixJuniority;
            if (!alwaysParent || match.alwaysParent) {
                parent = i;
                continue;
            }
            parent = -1;
        }
        return parent;
    }

    Part findEther(boolean asParent) {
        MolAtom candidate;
        if (this.getRootBond() != null && this.getRootBond().getType() != 1) {
            return null;
        }
        if (this.radical != null) {
            candidate = this.radical;
        } else if (this.m.getAtomCount() == 1) {
            candidate = this.m.getAtom(0);
        } else {
            return null;
        }
        if (this.marker[this.m.indexOf(candidate)] < 0 || candidate.getBondCount() > 2) {
            return null;
        }
        if (!Chem.isEtherAnalog(candidate)) {
            return null;
        }
        int i = candidate.getBondCount();
        while (--i >= 0) {
            MolAtom neighbour = candidate.getLigand(i);
            if (neighbour == this.root) continue;
            Part inner = new Acyclic(this.m, this.atomIndexMap, candidate, neighbour, this.topologyAnalyser).branch();
            return new EtherSubstituent(this.root, candidate, inner);
        }
        return this.externalEther(candidate, asParent);
    }

    boolean hasExternalConnection(MolAtom candidate) {
        MolAtom globalAtom = this.global(candidate);
        return globalAtom != null && globalAtom.getBondCount() == 2 && globalAtom.getBondCount() >= candidate.getBondCount() + 1;
    }

    Part externalEther(MolAtom candidate, boolean asParent) {
        if (!this.hasExternalConnection(candidate)) {
            return null;
        }
        MolAtom globalAtom = this.global(candidate);
        Part etherPart = null;
        int i = globalAtom.getBondCount();
        while (--i >= 0) {
            Part neighbourPart;
            MolAtom neighbour = globalAtom.getLigand(i);
            if (neighbour == SubmoleculeBuilder.originalAtom(this.root) || (neighbourPart = this.topologyAnalyser.getOwner(neighbour)) == null) continue;
            if (etherPart != null) {
                return new EtherParent(this.m, this.root, candidate.getAtno(), etherPart, neighbourPart, this.global(candidate));
            }
            etherPart = neighbourPart;
        }
        if (etherPart != null && !asParent) {
            return new EtherSubstituent(this.root, candidate, etherPart);
        }
        return null;
    }

    Part findEther(MolAtom[] principalChain) {
        Part substituent;
        Part parentAsSubstituent;
        Part parent;
        if (principalChain.length != 1 && (principalChain.length != 2 || principalChain[0].getAtno() != principalChain[1].getAtno())) {
            return null;
        }
        if (!Chem.isEtherAnalog(principalChain[0])) {
            return null;
        }
        int[] originalMarker = (int[])this.marker.clone();
        Part[] parentBranches = this.branches(principalChain, null, true, true);
        this.marker = originalMarker;
        if (parentBranches == null || parentBranches.length != 2) {
            return null;
        }
        originalMarker = (int[])this.marker.clone();
        Part[] substituentBranches = this.branches(principalChain, null, false, true);
        this.marker = originalMarker;
        if (ParentFinder.compare(parentBranches[0], parentBranches[1]) >= Util.randomInt(2)) {
            parent = parentBranches[1];
            parentAsSubstituent = substituentBranches[1];
            substituent = substituentBranches[0];
        } else {
            parent = parentBranches[0];
            parentAsSubstituent = substituentBranches[0];
            substituent = substituentBranches[1];
        }
        if (!parent.canBeParent()) {
            return null;
        }
        EtherSubstituent ether = principalChain.length == 2 ? new EtherSubstituent(parent.radical, principalChain[0], principalChain[1], substituent) : new EtherSubstituent(parent.radical, principalChain[0], substituent);
        int etherIndex = parentAsSubstituent.originalMolecule == null ? -1 : parentAsSubstituent.originalMolecule.indexOf(parentAsSubstituent.radical);
        parent.addSubstituent(ether, etherIndex);
        return parent;
    }

    static int seniorAtom(MolAtom[] chain) {
        long best = Long.MIN_VALUE;
        int res = -1;
        int i = chain.length;
        while (--i >= 0) {
            MolAtom a = chain[i];
            long value = ParentFinder.atomSeniority(a);
            if (value <= best) continue;
            best = value;
            res = i;
        }
        return res;
    }

    MolAtom[] seniorPart(MolAtom[] chain) {
        int end;
        int start;
        int centerIndex = this.radical == null ? Acyclic.seniorAtom(chain) : Util.indexOf(this.radical, chain);
        if (centerIndex == -1) {
            throw new IUPACNamer.Failure("Radical not found in chain");
        }
        MolAtom center = chain[centerIndex];
        if (center.getAtno() == 135) {
            return new MolAtom[]{center};
        }
        boolean homogeneous = true;
        boolean hasSgroup = false;
        int heteroUnits = 0;
        int lastAtom = -1;
        int i = chain.length;
        while (--i >= 0) {
            MolAtom a = chain[i];
            int atno = a.getAtno();
            if (atno != 6 && atno != lastAtom) {
                ++heteroUnits;
            }
            lastAtom = atno;
            homogeneous &= a.getAtno() == center.getAtno();
            if (atno <= 109) continue;
            hasSgroup = true;
        }
        if ((homogeneous || heteroUnits >= 4) && !hasSgroup) {
            return chain;
        }
        for (start = centerIndex; start > 0 && chain[start - 1].getAtno() == chain[centerIndex].getAtno(); --start) {
        }
        for (end = centerIndex; end < chain.length - 1 && chain[end + 1].getAtno() == chain[centerIndex].getAtno(); ++end) {
        }
        MolAtom[] res = new MolAtom[end - start + 1];
        int i2 = res.length;
        while (--i2 >= 0) {
            res[i2] = chain[end - i2];
        }
        return res;
    }

    MolAtom[] homogeneousPart(MolAtom[] chain) {
        int end;
        if (chain[0].getAtno() == 135) {
            return new MolAtom[]{chain[0]};
        }
        for (end = 0; end < chain.length - 1 && chain[end + 1].getAtno() == chain[0].getAtno(); ++end) {
        }
        MolAtom[] res = new MolAtom[end + 1];
        int i = res.length;
        while (--i >= 0) {
            res[i] = chain[i];
        }
        return res;
    }

    MolAtom[] findEnds() {
        ArrayList<MolAtom> res = new ArrayList<MolAtom>();
        int i = this.m.getAtomCount();
        while (--i >= 0) {
            MolAtom a;
            if (this.marker[i] == -1 || (a = this.m.getAtom(i)).getBondCount() > 1) continue;
            res.add(a);
        }
        return res.toArray(new MolAtom[res.size()]);
    }

    MolAtom[] findEnds(MolAtom from) {
        ArrayList ends = new ArrayList();
        this.findEnds(this.radical, from, ends);
        return ends.toArray(new MolAtom[ends.size()]);
    }

    void findEnds(MolAtom a, MolAtom from, ArrayList ends) {
        boolean couldContinue = false;
        int i = a.getBondCount();
        while (--i >= 0) {
            MolAtom neighbour = a.getLigand(i);
            if (neighbour == from || this.marker[this.m.indexOf(neighbour)] < 0) continue;
            couldContinue = true;
            this.findEnds(neighbour, a, ends);
        }
        if (!couldContinue) {
            ends.add(a);
        }
    }

    Part bestChain(Part[] chains) {
        int i = chains.length;
        while (--i >= 0) {
            if (chains[i] instanceof Chain) continue;
            return chains[i];
        }
        Chain best = (Chain)chains[0];
        int i2 = chains.length;
        while (--i2 >= 1) {
            int diff = ChainComparator.compare((Chain)chains[i2], best);
            if (diff >= 0 && (diff != 0 || !Util.randomBoolean())) continue;
            best = (Chain)chains[i2];
        }
        return best;
    }

    boolean isSingleAtomGroup(MolAtom atom, MolAtom neighbour) {
        int atno = atom.getAtno();
        if (atno == neighbour.getAtno()) {
            return false;
        }
        switch (atom.getBondTo(neighbour).getType()) {
            case 1: {
                return SimpleGroup.isGroup(atom);
            }
            case 2: {
                return SimpleGroup.isGroup2(atom);
            }
        }
        return false;
    }

    MolAtom[] removeGroups(MolAtom[] chain, int len) {
        MolAtom globalAtom;
        if (len == 1) {
            return chain;
        }
        int start = 0;
        int end = len;
        MolAtom atom = chain[0];
        if (atom != this.radical && ((globalAtom = this.global(atom)) == null || globalAtom.getBondCount() <= 1) && this.isSingleAtomGroup(atom, chain[1])) {
            ++start;
        }
        if (((globalAtom = this.global(atom = chain[len - 1])) == null || globalAtom.getBondCount() <= 1) && this.isSingleAtomGroup(atom, chain[len - 2])) {
            --end;
        }
        if (start == 0 && end == len) {
            return chain;
        }
        if (start == end) {
            return chain;
        }
        MolAtom[] res = new MolAtom[end - start];
        System.arraycopy(chain, start, res, 0, end - start);
        return res;
    }

    GroupMatch match(int index) {
        return (GroupMatch)this.matches.get(index);
    }

    void findGroups() {
        GroupSearch s = new GroupSearch(this.m);
        block0: while (s.findNext()) {
            int atom;
            GroupDictionary.Structure match = s.getMatch().cloneIfNeeded(this.m);
            int root = s.getMatchRoot();
            int[] groupAtoms = s.getMatchedAtoms();
            Molecule query = s.getQuery();
            ArrayList groupSubstituentRoots = new ArrayList();
            boolean startMustBeBondedToCarbon = false;
            int i = groupAtoms.length;
            while (--i >= 0) {
                MolBond rootBond;
                atom = groupAtoms[i];
                if (this.marker[atom] == -1) continue block0;
                MolAtom localMatched = this.m.getAtom(atom);
                MolAtom queryAtom = query.getAtom(i);
                MolAtom matched = this.global(localMatched);
                if (matched == null) {
                    matched = localMatched;
                }
                if (localMatched == this.radical && !match.checkRadical(matched, queryAtom) || !match.checkMatchedAtom(matched, queryAtom)) continue block0;
                if (i == 0 && startMustBeBondedToCarbon) {
                    if (this.isBondedToCarbon(queryAtom, matched)) continue;
                    continue block0;
                }
                if (i == 0 && this.radical != null && root >= 0 && (rootBond = this.m.getAtom(root).getBondTo(localMatched)) != null && match.rootBond > 0 && match.rootBond != rootBond.getType()) continue block0;
                if (i == 0 && !match.checkAllSubstitutions()) continue;
                if (localMatched == this.radical && localMatched.getAtno() == 7) {
                    MolBond bondToRoot;
                    if (i != groupAtoms.length - 1 || this.root != null && ((bondToRoot = this.global(this.radical).getBondTo(this.global(this.root))) == null || bondToRoot.getType() != 1)) continue block0;
                    startMustBeBondedToCarbon = true;
                }
                if (queryAtom.getAtno() == 131 || matched.getBondCount() == queryAtom.getBondCount() || match.checkSubstitutedAtom(matched, queryAtom, this.m, groupAtoms)) continue;
                continue block0;
            }
            if (!match.isAcceptable()) continue;
            i = groupAtoms.length;
            while (--i >= 0) {
                atom = groupAtoms[i];
                boolean mark = true;
                if (i == 0) {
                    if (match.eatCarbon) {
                        mark = false;
                    }
                } else {
                    MolAtom localMatched = this.m.getAtom(atom);
                    MolAtom queryAtom = query.getAtom(i);
                    MolAtom matched = this.global(localMatched);
                    if (matched == null) {
                        matched = localMatched;
                    }
                    if (localMatched == this.radical && localMatched.getAtno() == 7) {
                        this.turnedGroup = this.matches.size();
                        this.radical = null;
                    }
                    if (queryAtom.getAtno() == 131) {
                        this.incompleteMatch = true;
                        mark = false;
                    } else if (matched.getBondCount() != queryAtom.getBondCount()) {
                        this.findSubstituents(groupAtoms, groupSubstituentRoots, atom, localMatched, match.canHaveSubstituents());
                    }
                }
                if (!mark) continue;
                this.marker[atom] = -1;
            }
            if (root >= 0 && this.marker[root] >= 0) {
                if (this.marker[root] == 0) {
                    this.marker[root] = this.m.getAtom(root).getBondCount() + 1;
                }
                int connections = match.eatCarbon ? query.getAtom(0).getBondCount() : 1;
                int n = root;
                this.marker[n] = this.marker[n] - connections;
                if (this.marker[root] <= 2) {
                    this.additionalEnds.add(root);
                }
            }
            GroupMatch groupMatch = new GroupMatch(match, groupAtoms, groupSubstituentRoots);
            this.matches.add(groupMatch);
            this.groupRoots.add(root);
            this.groupStarts.add(s.getMatchStart());
        }
        if (this.groupRoots.size() > 50) {
            throw new IUPACNamer.UnsupportedError("Structure is too large to be named");
        }
    }

    private boolean isBondedToCarbon(MolAtom queryAtom, MolAtom matched) {
        if (matched.getBondCount() == queryAtom.getBondCount()) {
            return true;
        }
        int j = matched.getBondCount();
        while (--j >= 0) {
            MolAtom a = matched.getLigand(j);
            if (a.getAtno() != 6) continue;
            return true;
        }
        return false;
    }

    private void findSubstituents(int[] groupAtoms, ArrayList groupSubstituentRoots, int atom, MolAtom localMatched, boolean canHaveSubstituents) {
        if (canHaveSubstituents) {
            groupSubstituentRoots.add(localMatched);
        } else {
            this.marker[this.m.indexOf((MolAtom)localMatched)] = -1;
        }
        int n = localMatched.getBondCount();
        while (--n >= 0) {
            MolAtom neighbour = localMatched.getLigand(n);
            if (neighbour == this.root || Util.indexOf(this.m.indexOf(neighbour), groupAtoms) != -1) continue;
            if (canHaveSubstituents) {
                groupSubstituentRoots.add(neighbour);
                continue;
            }
            this.markChain(neighbour);
        }
        if (!canHaveSubstituents) {
            return;
        }
        groupSubstituentRoots.add(null);
        this.substituentRootGroupRoot[atom] = groupAtoms[0];
    }

    private void markChain(MolAtom atom) {
        int idx = this.m.indexOf(atom);
        if (this.marker[idx] < 0) {
            return;
        }
        this.marker[idx] = -1;
        int i = atom.getBondCount();
        while (--i >= 0) {
            this.markChain(atom.getLigand(i));
        }
    }

    private String debugPrintChainIndexes(MolAtom[] chain) {
        StringBuilder res = new StringBuilder();
        for (int j = 0; j < chain.length; ++j) {
            MolAtom a = chain[j];
            if (j > 0) {
                res.append('-');
            }
            if (a == null) {
                res.append("null");
                continue;
            }
            res.append(a.getSymbol());
            int index = SubmoleculeBuilder.indexOf(chain[j]);
            res.append("(").append(index).append(")");
        }
        return res.toString();
    }
}

