/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameexport;

import chemaxon.marvin.io.formats.name.nameexport.Chem;
import chemaxon.marvin.io.formats.name.nameexport.HeteroAnalyser;
import chemaxon.marvin.io.formats.name.nameexport.IUPACNamer;
import chemaxon.marvin.io.formats.name.nameexport.Monocycle;
import chemaxon.marvin.io.formats.name.nameexport.SimplePart;
import chemaxon.marvin.io.formats.name.nameexport.SpecialFusedRingSystem;
import chemaxon.marvin.io.formats.name.nameexport.Util;
import chemaxon.struc.Molecule;

public class BenzoHeterocycle
extends SpecialFusedRingSystem {
    private int[] benzo;
    private int[] hetero;

    static SimplePart create(Molecule m, int[] atomIndexMap) {
        int[][] sssr = m.getSSSR();
        if (sssr.length == 2) {
            int benzo = BenzoHeterocycle.findBenzo(m, sssr);
            if (benzo == -1) {
                return null;
            }
            int[] other = sssr[1 - benzo];
            int i = other.length;
            while (--i >= 0) {
                if (Chem.aPrefixForAtom(m.getAtom(other[i]).getAtno(), true, false) != null) continue;
                return null;
            }
            if (other.length >= 5) {
                return new BenzoHeterocycle(m, atomIndexMap, sssr[benzo], other);
            }
        }
        return null;
    }

    private static int findBenzo(Molecule m, int[][] rings) {
        block0: for (int i = 0; i < rings.length; ++i) {
            int[] ring = rings[i];
            if (ring.length != 6) continue;
            for (int a = 0; a < 6; ++a) {
                if (m.getAtom(ring[a]).getAtno() != 6) continue block0;
            }
            return i;
        }
        return -1;
    }

    private BenzoHeterocycle(Molecule m, int[] atomIndexMap, int[] benzo, int[] hetero) {
        super(m, atomIndexMap, null);
        this.benzo = benzo;
        this.hetero = hetero;
    }

    @Override
    int[][][] recognize() {
        int[] descriptor2;
        int fusion1 = -1;
        int len = this.hetero.length;
        for (int i = 0; i < 6 && (fusion1 = Util.indexOf(this.benzo[i], this.hetero)) == -1; ++i) {
        }
        if (fusion1 == -1) {
            throw new IUPACNamer.Failure("Could not find fusion indexes");
        }
        int fusion2 = (fusion1 + 1) % len;
        if (Util.indexOf(this.hetero[fusion2], this.benzo) == -1) {
            fusion2 = fusion1;
            fusion1 = (fusion2 + len - 1) % len;
        }
        int[] numbering1 = this.numbering(fusion1, false, false);
        int[] numbering2 = this.numbering(fusion2, true, false);
        HeteroAnalyser ha = new HeteroAnalyser(this);
        int[] descriptor1 = ha.heteroAtomLocations(numbering1, null);
        int diff = this.compare(descriptor1, descriptor2 = ha.heteroAtomLocations(numbering2, null));
        if (diff < 0) {
            return new int[][][]{new int[][]{descriptor1, numbering1}};
        }
        if (diff > 0) {
            return new int[][][]{new int[][]{descriptor2, numbering2}};
        }
        if (descriptor1.length == 0) {
            numbering1 = this.numbering(fusion1, false, true);
            numbering2 = this.numbering(fusion2, true, true);
        }
        return new int[][][]{new int[][]{descriptor1, numbering1}, new int[][]{descriptor2, numbering2}};
    }

    private int[] numbering(int fusion, boolean right, boolean startOnBenzene) {
        int[] res = new int[this.originalMolecule.getAtomCount()];
        int len = this.hetero.length;
        int inc = right ? 1 : -1;
        int start = (fusion + len + inc) % len;
        int max = this.originalMolecule.getAtomCount() - 1;
        int n = 0;
        int atom = -1;
        int i = 0;
        while (true) {
            atom = this.hetero[(start + i * inc + len) % len];
            if (i == len - 2) break;
            res[atom] = startOnBenzene ? max - n : ++n;
            ++i;
        }
        int end = Util.indexOf(this.hetero[(start - inc + len) % len], this.benzo);
        start = Util.indexOf(atom, this.benzo);
        inc = (start + 1) % 6 == end ? -1 : 1;
        for (int i2 = 0; i2 < 6; ++i2) {
            int num;
            char letter = '\u0000';
            if (i2 != 0 && i2 != 5) {
                ++n;
            } else {
                letter = 'a';
            }
            if (!startOnBenzene) {
                num = n;
            } else {
                num = max - n;
                if (letter == 'a') {
                    num = num == 1 ? max - 1 : --num;
                }
            }
            res[this.benzo[(start + i2 * inc + 6) % 6]] = Util.locant(num, 0, letter, 0);
        }
        return res;
    }

    private int compare(int[] d1, int[] d2) {
        int diff = Util.setComparison(d1, d2);
        if (diff != 0) {
            return diff;
        }
        return Util.pointToPointComparison(d1, d2);
    }

    @Override
    void namePrefix(int[] _descriptor, int[] numbering, boolean bracket, boolean global, boolean printHeteros, StringBuffer to) {
        int[] descriptor = new HeteroAnalyser(this).heteroAtomLocations(numbering, this.primes);
        HeteroAnalyser.printHeteroAtomLocations(descriptor, bracket, to);
    }

    @Override
    String nameDescriptor(int[] descriptor, int[] numbering, boolean saturatedBase, boolean omitSuffix) {
        if (omitSuffix) {
            throw new IUPACNamer.Failure("Unsupported");
        }
        StringBuffer res = new StringBuffer("benzo");
        Util.appendRemovingVowel(Monocycle.getName(this.originalMolecule, numbering, false, true, true, this.hetero.length), res);
        return res.toString();
    }

    @Override
    boolean ignoreHeteroAtoms() {
        return true;
    }
}

