/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameexport;

import chemaxon.common.util.IntVector;
import chemaxon.marvin.io.formats.name.nameexport.GeneralSpiroNamer;
import chemaxon.marvin.io.formats.name.nameexport.RingSystem;
import chemaxon.marvin.io.formats.name.nameexport.RingSystemRecognizer;
import chemaxon.marvin.io.formats.name.nameexport.Util;
import chemaxon.struc.Molecule;

public class BranchedSpiroNamer
extends GeneralSpiroNamer {
    int center;
    private int centerLocation = -1;

    static GeneralSpiroNamer create(RingSystemRecognizer.RingTree tree, Molecule m) {
        int center = BranchedSpiroNamer.findCenter(0, tree.ringSystems, new boolean[tree.ringSystems.length]);
        if (center != -1) {
            return new BranchedSpiroNamer(tree, m, center);
        }
        return null;
    }

    static int findCenter(int node, RingSystem[] ringSystems, boolean[] visited) {
        visited[node] = true;
        RingSystem rs = ringSystems[node];
        IntVector neighbours = rs.connections;
        if (neighbours.size() >= 3) {
            return node;
        }
        for (int i = 0; i < neighbours.size(); ++i) {
            if (visited[neighbours.get(i)]) continue;
            return BranchedSpiroNamer.findCenter(neighbours.get(i), ringSystems, visited);
        }
        return -1;
    }

    BranchedSpiroNamer(RingSystemRecognizer.RingTree tree, Molecule m, int center) {
        super(tree, m);
        this.center = center;
    }

    @Override
    protected void computePartNames() {
        this.getAllNames();
    }

    private void getAllNames() {
        RingSystem centerRS = this.tree.ringSystems[this.center];
        GeneralSpiroNamer.NameComponent centerComponent = this.nameRingSystem(this.center, centerRS);
        IntVector neighbours = centerRS.connections;
        for (int i = 0; i < neighbours.size(); ++i) {
            int n = neighbours.get(i);
            int outgoingSpiroAtom = centerRS.spiroAtoms.get(i);
            int centerSpiroLocant = this.numbering[outgoingSpiroAtom];
            GeneralSpiroNamer.NameComponent component = this.nameRingSystem(n, this.tree.ringSystems[n]);
            int terminalSpiroLocant = this.numbering[outgoingSpiroAtom];
            component.addSpiroAtom(outgoingSpiroAtom);
            this.insertSorted(component);
            centerComponent.addSpiroAtom(outgoingSpiroAtom, this.components.indexOf(component));
        }
        centerComponent.getNumbering(true);
        this.findCenterLocation();
        this.components.add(this.centerLocation, centerComponent);
    }

    private void findCenterLocation() {
        int index = 0;
        String firstName = this.component(0).getFullName(true);
        while (this.component(index + 1).getFullName(true).equals(firstName)) {
            if (++index != this.components.size() - 1) continue;
            this.centerLocation = 0;
            return;
        }
        this.centerLocation = index + 1;
    }

    @Override
    protected String getFirstPrime(int rank, String rankPrime) {
        return rank < this.centerLocation ? rankPrime : Util.primes(this.centerLocation);
    }

    @Override
    protected String getSecondPrime(int rank, String rankPrime) {
        return rank < this.centerLocation ? Util.primes(this.centerLocation) : rankPrime;
    }

    GeneralSpiroNamer.NameComponent getCenter() {
        return (GeneralSpiroNamer.NameComponent)this.components.get(this.centerLocation);
    }

    @Override
    int getFirstSpiroLocant(int rank, IntVector localSpiroAtoms, int[] numbering) {
        GeneralSpiroNamer.NameComponent center = this.getCenter();
        return rank < this.centerLocation ? numbering[localSpiroAtoms.get(0)] : center.getNumbering()[center.localSpiroAtoms.get(rank)];
    }

    @Override
    int getSecondSpiroLocant(int rank, IntVector localSpiroAtoms, int[] numbering) {
        GeneralSpiroNamer.NameComponent center = this.getCenter();
        return rank <= this.centerLocation ? center.getNumbering()[center.localSpiroAtoms.get(rank - 1)] : numbering[localSpiroAtoms.get(0)];
    }
}

