/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameexport;

import chemaxon.marvin.io.formats.name.nameexport.AminoAcid;
import chemaxon.marvin.io.formats.name.nameexport.Chem;
import chemaxon.marvin.io.formats.name.nameexport.IUPACNamer;
import chemaxon.marvin.io.formats.name.nameexport.SubmoleculeBuilder;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.sgroup.Expandable;
import chemaxon.struc.sgroup.RepeatingUnitSgroup;
import chemaxon.struc.sgroup.SgroupAtom;
import chemaxon.struc.sgroup.SuperatomSgroup;
import java.util.Map;
import java.util.WeakHashMap;

public class Canonicalizer {
    private static Map<MolBond, Integer> bondStereo = new WeakHashMap<MolBond, Integer>();

    static int getStereo(MolAtom a1, MolAtom a2) {
        MolBond b = (a1 = SubmoleculeBuilder.originalAtom(a1)).getBondTo(a2 = SubmoleculeBuilder.originalAtom(a2));
        Integer value = bondStereo.get(b);
        if (value == null) {
            return 0;
        }
        return value;
    }

    static Molecule prepareForS2N(Molecule m) {
        Molecule res = (Molecule)m.clone();
        Canonicalizer.handleGroups(res);
        int i = res.getBondCount();
        while (--i >= 0) {
            MolBond b = res.getBond(i);
            int stereo = res.getStereo2(res.getBond(i));
            if ((stereo &= 0x1C0) == 0 || stereo != 128 && stereo != 64) continue;
            bondStereo.put(b, stereo);
        }
        res.implicitizeHydrogens(673);
        res.dearomatize();
        Canonicalizer.findMesomers(res);
        Canonicalizer.canonicalizeZwitterions(res);
        return res;
    }

    private static void handleGroups(Molecule m) {
        int i = m.getSgroupCount();
        while (--i >= 0) {
            Sgroup g = m.getSgroup(i);
            if (!(g instanceof Expandable)) {
                if (!Canonicalizer.forbiddenGroup(g)) continue;
                throw new IUPACNamer.UnsupportedError("unsupported group: " + g.getClass().getSimpleName());
            }
            Expandable expandableGroup = (Expandable)((Object)g);
            if (Canonicalizer.keepGroup(g)) {
                expandableGroup.contract(0);
                continue;
            }
            m.ungroupSgroup(g);
        }
    }

    private static boolean forbiddenGroup(Sgroup g) {
        return g instanceof RepeatingUnitSgroup;
    }

    static boolean isCoA(MolAtom a) {
        return a.getSymbol().equals("CoA");
    }

    private static boolean keepGroup(Sgroup g) {
        if (!(g instanceof SuperatomSgroup)) {
            return false;
        }
        SgroupAtom sa = ((SuperatomSgroup)g).getSuperAtom();
        if (AminoAcid.isAminoAcid(sa)) {
            return true;
        }
        return Canonicalizer.isCoA(sa);
    }

    private static void findMesomers(Molecule m) {
        int p = m.getAtomCount();
        while (--p >= 0) {
            MolAtom pos = m.getAtom(p);
            if (pos.getCharge() != 1 || Chem.isRingAtom(pos)) continue;
            int n = pos.getBondCount();
            while (--n >= 0) {
                MolBond bond;
                MolAtom neg = pos.getLigand(n);
                if (neg.getCharge() != -1 || Chem.isRingAtom(neg) || (bond = pos.getBond(n)).getType() != 1 && bond.getType() != 2 || pos.getAtno() == 7 && neg.getAtno() == 7 && bond.getType() == 1 || pos.getRadical() != 0 || neg.getRadical() != 0) continue;
                bond.setType(bond.getType() + 1);
                pos.setCharge(0);
                neg.setCharge(0);
                m.valenceCheck();
            }
        }
    }

    private static void canonicalizeZwitterions(Molecule m) {
        int a = m.getAtomCount();
        while (--a >= 0) {
            MolAtom o = m.getAtom(a);
            if (o.getAtno() != 8 || o.getCharge() != 1 || o.getBondCount() != 1 || o.getBond(0).getType() != 2) continue;
            MolAtom center = o.getLigand(0);
            int b = center.getBondCount();
            while (--b >= 0) {
                MolAtom otherO = center.getLigand(b);
                if (otherO == o || otherO.getAtno() != 8 || otherO.getCharge() != -1) continue;
                o.setCharge(0);
                otherO.setCharge(0);
                m.valenceCheck();
            }
        }
    }
}

