/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameexport;

import chemaxon.common.util.IntVector;
import chemaxon.core.calculations.FindAllRings;
import chemaxon.marvin.io.formats.name.nameexport.Chem;
import chemaxon.marvin.io.formats.name.nameexport.GraphUtil;
import chemaxon.marvin.io.formats.name.nameexport.Options;
import chemaxon.marvin.io.formats.name.nameexport.Part;
import chemaxon.marvin.io.formats.name.nameexport.SimplePart;
import chemaxon.marvin.io.formats.name.nameexport.Util;
import chemaxon.struc.Molecule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;

public class CarbonBridgedRingSystem
extends SimplePart {
    private Molecule m;
    private int head1 = -1;
    private int head2 = -1;
    private int lastAtom;
    BitSet border = new BitSet();
    private GraphUtil graphUtil = new GraphUtil(60000000);
    private static boolean debug = false;

    CarbonBridgedRingSystem(Molecule molecule, int[] atomIndexMap) {
        super(molecule, atomIndexMap);
    }

    private void backtrack(Backup b) {
        this.m = b.m;
        this.lastAtom = b.lastAtom;
        this.border = b.border;
    }

    int getRingCount() {
        int[][] sssr = this.originalMolecule.getSSSR();
        return sssr.length;
    }

    @Override
    String nameDescriptor(int[] descriptor, int[] numbering, boolean saturatedBase, boolean omitSuffix) {
        StringBuffer res = new StringBuffer();
        res.append(Chem.multiplier(this.getRingCount()));
        res.append("cyclo[");
        res.append(descriptor[0]).append('.').append(descriptor[1]).append('.').append(descriptor[2]);
        for (int i = 3; i < descriptor.length; i += 3) {
            res.append('.').append(descriptor[i]);
            if (Options.unicode) {
                res.append(Util.unicodeSuperscriptNumber(descriptor[i + 1])).append(',').append(Util.unicodeSuperscriptNumber(descriptor[i + 2]));
                continue;
            }
            res.append("^{").append(descriptor[i + 1]).append(',').append(descriptor[i + 2]).append('}');
        }
        res.append(']');
        if (!omitSuffix) {
            res.append(Chem.carbonChainName(this.originalMolecule.getAtomCount()));
        }
        return res.toString();
    }

    @Override
    int[][][] recognize() {
        int[][] mainRingCandidates = this.getMainRings();
        ArrayList results = new ArrayList();
        int i = mainRingCandidates.length;
        while (--i >= 0) {
            int[] mainRing = mainRingCandidates[i];
            this.recognize(mainRing, results);
        }
        return Util.intArrayArrayArray(results);
    }

    int[][] getMainRings() {
        FindAllRings finder = new FindAllRings(this.originalMolecule);
        finder.startRingSearch(0, false, 600, 5, true);
        int[][] longestRings = finder.getRings();
        return longestRings;
    }

    int compareResults(int[] d1, int[] d2) {
        int deps2;
        if (d1 == null) {
            return 1;
        }
        if (d2 == null) {
            return -1;
        }
        int balance1 = d1[0] - d1[1];
        int balance2 = d2[0] - d2[1];
        if (balance1 < balance2) {
            return -1;
        }
        if (balance2 < balance1) {
            return 1;
        }
        int deps1 = this.numberOfDependentBridges(d1);
        if (deps1 < (deps2 = this.numberOfDependentBridges(d2))) {
            return -1;
        }
        if (deps2 < deps1) {
            return 1;
        }
        int diff = Util.orderedComparison(d1, d2);
        if (diff != 0) {
            return diff;
        }
        diff = Util.pointToPointComparison(d1, d2);
        if (diff != 0) {
            return diff;
        }
        return 0;
    }

    int numberOfDependentBridges(int[] descriptor) {
        int mainAtoms = descriptor[0] + descriptor[1] + descriptor[2] + 2;
        int res = 0;
        for (int i = 3; i < descriptor.length; i += 3) {
            if (descriptor[i + 2] <= mainAtoms) continue;
            ++res;
        }
        return res;
    }

    void addResult(int[][] newResult, ArrayList results) {
        if (results.size() == 0) {
            results.add(newResult);
        } else {
            int diff;
            int[][] best = (int[][])results.get(0);
            if (debug) {
                System.out.println("Comparing " + Util.print(newResult[0]) + " to " + Util.print(best[0]));
            }
            if ((diff = this.compareResults(best[0], newResult[0])) == 0) {
                results.add(newResult);
            } else if (diff > 0) {
                results.clear();
                results.add(newResult);
            }
        }
    }

    void recognize(int[] mainRing, ArrayList results) {
        this.m = (Molecule)this.originalMolecule.clone();
        this.border = new BitSet();
        this.extendBorder(mainRing, true);
        int[][] mainBridgeCandidates = this.getMainBridgeCandidates(mainRing);
        if (mainBridgeCandidates == null) {
            results.add(new int[][]{{mainRing.length}, null});
            return;
        }
        for (int i = 0; i < mainBridgeCandidates.length; ++i) {
            Backup bk = new Backup();
            this.recognize(mainRing, mainBridgeCandidates[i], results);
            this.backtrack(bk);
        }
    }

    void recognize(int[] mainRing, int[] mainBridge, ArrayList results) {
        this.head1 = mainBridge[0];
        this.head2 = mainBridge[mainBridge.length - 1];
        int l1 = Util.distance(this.head1, this.head2, mainRing);
        int l2 = Util.distance(this.head2, this.head1, mainRing);
        if (l2 > l1) {
            int tmp = l1;
            l1 = l2;
            l2 = tmp;
            tmp = this.head1;
            this.head1 = this.head2;
            this.head2 = tmp;
        }
        this.extendBorder(mainBridge, false);
        int[][] numbering = this.generateMainNumberings(mainRing, mainBridge, this.m.getAtomCount(), l1, l2);
        if (debug) {
            System.out.println("Main bridge: " + Util.print(mainBridge));
            System.out.println("Heads: " + this.head1 + "-" + this.head2);
        }
        for (int n = 0; n < numbering.length; ++n) {
            Backup bk = new Backup();
            IntVector candidate = new IntVector();
            candidate.add(l1);
            candidate.add(l2);
            candidate.add(mainBridge.length - 2);
            this.findSecondaryBridges(candidate, numbering[n]);
            if (debug) {
                System.out.println("Candidate for numbering " + n + ": " + Util.print(candidate.toArray()));
            }
            this.addResult(new int[][]{candidate.toArray(), numbering[n]}, results);
            this.backtrack(bk);
        }
    }

    private void findSecondaryBridges(IntVector res, final int[] numbering) {
        int[] bridge;
        int[][] bridges;
        final boolean[] independent = new boolean[]{true};
        Comparator<int[]> secondaryBridgeComparator = new Comparator<int[]>(){

            @Override
            public int compare(int[] bridge1, int[] bridge2) {
                long diff;
                if (independent[0] && (diff = (long)(bridge2.length - bridge1.length)) != 0L) {
                    return (int)diff;
                }
                long locants1 = CarbonBridgedRingSystem.this.locantsLowHigh(bridge1, numbering);
                long locants2 = CarbonBridgedRingSystem.this.locantsLowHigh(bridge2, numbering);
                diff = locants1 - locants2;
                if (debug) {
                    // empty if block
                }
                if (diff < 0L) {
                    return -1;
                }
                if (diff > 0L) {
                    return 1;
                }
                return Util.randomBoolean() ? -1 : 1;
            }
        };
        BitSet mainBorder = (BitSet)this.border.clone();
        ArrayList<int[]> secondaryBridges = new ArrayList<int[]>();
        while ((bridges = this.graphUtil.longestBridges(this.m, mainBorder, this.border)).length != 0) {
            Arrays.sort(bridges, secondaryBridgeComparator);
            if (debug) {
                System.out.println("Independent secondary bridges:" + Util.print(bridges));
            }
            bridge = bridges[0];
            secondaryBridges.add(bridge);
            this.addBridge(bridge, res, numbering);
        }
        this.performNumberingOfSecondaryBridges(secondaryBridges, numbering);
        independent[0] = true;
        secondaryBridges.clear();
        while ((bridges = this.graphUtil.longestBridges(this.m, this.border, null)).length != 0) {
            if (debug) {
                System.out.println("Dependent secondary bridges:" + Util.print(bridges));
            }
            Arrays.sort(bridges, secondaryBridgeComparator);
            bridge = bridges[0];
            secondaryBridges.add(bridge);
            this.addBridge(bridge, res, numbering);
        }
        this.performNumberingOfSecondaryBridges(secondaryBridges, numbering);
    }

    private int[][] generateMainNumberings(int[] mainRing, int[] mainBridge, int numberOfAtoms, int l1, int l2) {
        int i;
        int[][] res = new int[l1 == l2 ? 4 : 2][numberOfAtoms];
        for (int i2 = 0; i2 < res.length; ++i2) {
            for (int j = 0; j < numberOfAtoms; ++j) {
                res[i2][j] = 0;
            }
        }
        int idxHead1 = Util.indexOf(this.head1, mainRing);
        int idxHead2 = Util.indexOf(this.head2, mainRing);
        int len = mainRing.length;
        this.lastAtom = 0;
        for (i = 0; i < mainRing.length; ++i) {
            res[0][mainRing[(idxHead1 + i) % len]] = ++this.lastAtom;
        }
        this.lastAtom = 0;
        for (i = 0; i < mainRing.length; ++i) {
            res[1][mainRing[(idxHead2 + len - i) % len]] = ++this.lastAtom;
        }
        if (l1 == l2) {
            this.lastAtom = 0;
            for (i = 0; i < mainRing.length; ++i) {
                res[2][mainRing[(idxHead1 + len - i) % len]] = ++this.lastAtom;
            }
            this.lastAtom = 0;
            for (i = 0; i < mainRing.length; ++i) {
                res[3][mainRing[(idxHead2 + i) % len]] = ++this.lastAtom;
            }
        }
        int lastAtom = this.lastAtom;
        for (int n = 0; n < res.length; ++n) {
            int i3;
            boolean startsWithFirst;
            lastAtom = this.lastAtom;
            boolean bl = startsWithFirst = res[n][mainBridge[0]] == 1;
            if (startsWithFirst) {
                for (i3 = 1; i3 < mainBridge.length - 1; ++i3) {
                    res[n][mainBridge[i3]] = ++lastAtom;
                }
                continue;
            }
            i3 = mainBridge.length - 1;
            while (--i3 >= 1) {
                res[n][mainBridge[i3]] = ++lastAtom;
            }
        }
        this.lastAtom = lastAtom;
        if (debug) {
            System.out.println("Main Numberings: " + Util.print(res));
        }
        return res;
    }

    private void extendBorder(int[] path, boolean ring) {
        Util.addAll(path, this.border);
        Util.removePath(this.m, path);
        if (ring) {
            Util.removeBond(this.m, path[0], path[path.length - 1]);
        }
    }

    private void performNumberingOfSecondaryBridges(ArrayList secondaryBridges, final int[] numbering) {
        int[][] bridges = (int[][])secondaryBridges.toArray((T[])new int[secondaryBridges.size()][]);
        Comparator numberingComparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                int[] bridge1 = (int[])o1;
                int[] bridge2 = (int[])o2;
                long diff = CarbonBridgedRingSystem.this.locantsHighLow(bridge2, numbering) - CarbonBridgedRingSystem.this.locantsHighLow(bridge1, numbering);
                if (diff != 0L) {
                    return diff < 0L ? -1 : 1;
                }
                diff = bridge2.length - bridge1.length;
                if (diff != 0L) {
                    return (int)diff;
                }
                return Util.randomBoolean() ? -1 : 1;
            }
        };
        Arrays.sort(bridges, numberingComparator);
        for (int b = 0; b < bridges.length; ++b) {
            int i;
            boolean startsWithFirst;
            int[] bridge = bridges[b];
            boolean bl = startsWithFirst = numbering[bridge[0]] > numbering[bridge[bridge.length - 1]];
            if (startsWithFirst) {
                for (i = 1; i < bridge.length - 1; ++i) {
                    this.addNumber(bridge[i], numbering);
                }
                continue;
            }
            i = bridge.length - 1;
            while (--i >= 1) {
                this.addNumber(bridge[i], numbering);
            }
        }
    }

    private void addNumber(int index, int[] numbering) {
        numbering[index] = ++this.lastAtom;
    }

    private void addBridge(int[] bridge, IntVector res, int[] numbering) {
        int locant2 = numbering[bridge[bridge.length - 1]];
        int locant1 = numbering[bridge[0]];
        if (locant2 < locant1) {
            int tmp = locant1;
            locant1 = locant2;
            locant2 = tmp;
        }
        int len = bridge.length - 2;
        res.add(len);
        res.add(locant1);
        res.add(locant2);
        if (debug) {
            System.out.println("Numbering: " + Util.print(numbering));
        }
        this.extendBorder(bridge, false);
    }

    private int[][] getMainBridgeCandidates(final int[] mainRing) {
        int[][] bridgeCandidates = this.graphUtil.longestBridges(this.m, this.border, null);
        Comparator<int[]> mainBridgeComparator = new Comparator<int[]>(){

            @Override
            public int compare(int[] bridge1, int[] bridge2) {
                int lenDiff = bridge2.length - bridge1.length;
                if (lenDiff != 0) {
                    return lenDiff;
                }
                int balanceDiff = this.balance(bridge1) - this.balance(bridge2);
                if (balanceDiff != 0) {
                    return balanceDiff;
                }
                return 0;
            }

            private int balance(int[] bridge) {
                int head1 = bridge[0];
                int head2 = bridge[bridge.length - 1];
                int l1 = Util.distance(head1, head2, mainRing);
                int l2 = Util.distance(head2, head1, mainRing);
                return Math.abs(l2 - l1);
            }
        };
        return Util.smallestMembers(bridgeCandidates, mainBridgeComparator);
    }

    private long locantsLowHigh(int[] bridge, int[] numbering) {
        long head2 = numbering[bridge[bridge.length - 1]];
        long head1 = numbering[bridge[0]];
        if (head2 < head1) {
            long tmp = head2;
            head2 = head1;
            head1 = tmp;
        }
        return head1 << 32 | head2;
    }

    private long locantsHighLow(int[] bridge, int[] numbering) {
        long head2 = numbering[bridge[bridge.length - 1]];
        long head1 = numbering[bridge[0]];
        if (head2 > head1) {
            long tmp = head2;
            head2 = head1;
            head1 = tmp;
        }
        return head1 << 32 | head2;
    }

    String printBridge(int[] bridge, int[] numbering) {
        return "" + numbering[bridge[0]] + "-" + numbering[bridge[bridge.length - 1]];
    }

    @Override
    int parentSeniority() {
        return 0x50000000;
    }

    @Override
    boolean cyclic() {
        return true;
    }

    @Override
    int compareSeniority(Part other) {
        int[] d1 = this.recognize()[0][0];
        int[] d2 = ((CarbonBridgedRingSystem)other).recognize()[0][0];
        return Util.pointToPointComparison(d1, d2);
    }

    private class Backup {
        Molecule m;
        int lastAtom;
        BitSet border;

        private Backup() {
            this.m = (Molecule)CarbonBridgedRingSystem.this.m.clone();
            this.lastAtom = CarbonBridgedRingSystem.this.lastAtom;
            this.border = (BitSet)CarbonBridgedRingSystem.this.border.clone();
        }
    }
}

