/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameexport;

import chemaxon.common.util.IntVector;
import chemaxon.marvin.io.formats.name.nameexport.Acyclic;
import chemaxon.marvin.io.formats.name.nameexport.AminoAcid;
import chemaxon.marvin.io.formats.name.nameexport.Canonicalizer;
import chemaxon.marvin.io.formats.name.nameexport.CharacteristicGroup;
import chemaxon.marvin.io.formats.name.nameexport.Chem;
import chemaxon.marvin.io.formats.name.nameexport.IUPACNamer;
import chemaxon.marvin.io.formats.name.nameexport.MonoNuclear;
import chemaxon.marvin.io.formats.name.nameexport.Options;
import chemaxon.marvin.io.formats.name.nameexport.Part;
import chemaxon.marvin.io.formats.name.nameexport.SimpleGroup;
import chemaxon.marvin.io.formats.name.nameexport.SimplePart;
import chemaxon.marvin.io.formats.name.nameexport.SubmoleculeBuilder;
import chemaxon.marvin.io.formats.name.nameexport.Suffix;
import chemaxon.marvin.io.formats.name.nameexport.Util;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class Chain
extends SimplePart {
    int[] chain;
    Part[] branches;
    Molecule completeMolecule;
    int[] completeAtomIndexMap;
    MolAtom[] originalChain;
    MolBond rootBond;
    private boolean isMonoRadical = false;
    static final String[] retainedNames = new String[]{"silanyl", "silyl", "silanylium", "silylium", "germanyl", "germyl", "plumbanyl", "plumbyl", "stannanyl", "stannyl"};

    static Part create(Molecule m, HashMap owners, int[] atomIndexMap, MolAtom start, MolBond rootBond, MolAtom[] chain, Part[] branches, int[] substituentRootGroupRoot) {
        Part res = Chain.specialChain(m, owners, chain, branches, rootBond, rootBond == null);
        if (res == null) {
            res = new Chain(m, atomIndexMap, owners, start, rootBond, chain, branches, substituentRootGroupRoot, false);
        }
        res.owners = owners;
        return res;
    }

    static Part create(Molecule m, HashMap owners, int[] atomIndexMap, MolAtom root, MolAtom start, MolAtom[] chain, Part[] branches, boolean groupSubstituent) {
        Part res = Chain.specialChain(m, owners, chain, branches, start == null ? null : start.getBondTo(root), root == null);
        if (res != null) {
            res.root = root;
        } else {
            res = new Chain(m, atomIndexMap, owners, root, start, chain, branches, groupSubstituent);
        }
        res.owners = owners;
        return res;
    }

    static Part specialChain(Molecule m, HashMap owners, MolAtom[] chain, Part[] branches, MolBond rootBond, boolean completeMolecule) {
        if (chain.length == 1 && chain[0].getAtno() == 6 && branches != null && branches.length == 1 && !completeMolecule) {
            Part branch = branches[0];
            String name = null;
            try {
                name = branch.getName();
            }
            catch (RuntimeException e) {
                // empty catch block
            }
            if (name != null) {
                if (name.equals("one")) {
                    Suffix res = new Suffix(m, chain[0], "carbonyl");
                    owners.put(SubmoleculeBuilder.originalAtom(chain[0]), res);
                    return res;
                }
                String carboGroupName = Chain.carboGroupName(name);
                if (carboGroupName != null && !branch.complex()) {
                    Suffix res = new Suffix(m, chain[0], carboGroupName);
                    owners.put(SubmoleculeBuilder.originalAtom(((CharacteristicGroup)branch).radical), res);
                    return res;
                }
            }
        }
        if (Acyclic.isAmine(chain)) {
            SimpleGroup amine = new SimpleGroup(rootBond, chain[0]);
            amine.originalMolecule = m;
            owners.put(SubmoleculeBuilder.originalAtom(chain[0]), amine);
            amine.addSubstituents(branches);
            return amine;
        }
        return null;
    }

    private static String carboGroupName(String name) {
        if (name == "thione") {
            return "carbothioyl";
        }
        if (name == "selone") {
            return "carboselenoyl";
        }
        if (name == "tellone") {
            return "carbotelluroyl";
        }
        if (name == "imine") {
            return "carboximidoyl";
        }
        if (name == "hydrazinylidene") {
            return "carbohydrazonoyl";
        }
        return null;
    }

    Chain(Molecule m) {
        super(m);
        this.chain = this.findChain();
    }

    private Chain(Molecule m, int[] atomIndexMap, HashMap owners, MolAtom root, MolAtom start, MolAtom[] chain, Part[] branches, boolean groupSubstituent) {
        this(m, atomIndexMap, owners, start, root == null ? null : root.getBondTo(start), chain, branches, null, groupSubstituent);
        this.root = root;
    }

    private Chain(Molecule m, int[] atomIndexMap, HashMap owners, MolAtom start, MolBond rootBond, MolAtom[] chain, Part[] branches, int[] substituentRootGroupRoot, boolean groupSubstituent) {
        super(Chain.molecule(chain, m, atomIndexMap));
        int i;
        this.owners = owners;
        if (atomIndexMap != null) {
            this.completeAtomIndexMap = atomIndexMap;
            this.atomIndexMap = new int[chain.length];
            for (i = 0; i < chain.length; ++i) {
                this.atomIndexMap[i] = this.completeAtomIndexMap[m.indexOf(chain[i])];
            }
        }
        this.completeMolecule = m;
        this.originalChain = chain;
        this.chain = new int[chain.length];
        i = chain.length;
        while (--i >= 0) {
            this.chain[i] = i;
        }
        this.branches = branches;
        this.rootBond = rootBond;
        if (start != null) {
            String ending;
            if (rootBond != null) {
                this.modifiers.setRootBond(rootBond, !groupSubstituent);
                ending = Chem.substituentEnding[rootBond.getType()];
            } else {
                int radicalNum = Chem.standardValence(start.getAtno()) - start.getValence() + start.getCharge();
                ending = 0 <= radicalNum && radicalNum <= 3 ? Chem.substituentEnding[radicalNum] : null;
            }
            int loc = Util.indexOf(start, this.originalChain);
            this.modifiers.setEnding(loc, ending);
        }
        if (branches != null) {
            IntVector indexes = new IntVector();
            indexes.setSize(branches.length);
            int i2 = branches.length;
            while (--i2 >= 0) {
                int index = Util.indexOf(branches[i2].root, this.originalChain);
                if (index == -1 && (index = Util.indexOf(m.getAtom(substituentRootGroupRoot[m.indexOf(branches[i2].root)]), this.originalChain)) != -1) {
                    index = -1 - index;
                }
                indexes.set(i2, index);
            }
            ArrayList<Part> branchesList = new ArrayList<Part>(Arrays.asList(branches));
            this.modifiers.findSuffixGroup(m, indexes, branchesList);
            branches = branchesList.toArray(new Part[branchesList.size()]);
            int from = 0;
            int to = chain.length;
            int i3 = branches.length;
            while (--i3 >= 0) {
                Part p = branches[i3];
                if (p == null || !(p instanceof CharacteristicGroup)) continue;
                CharacteristicGroup g = (CharacteristicGroup)p;
                if (!g.eatCarbon || g.root.getAtno() != 6) continue;
                if (g.prefixName == "formyl" && !this.modifiers.isSuffix(g)) {
                    g.prefixName = "oxo";
                    continue;
                }
                if (g.root == chain[0]) {
                    from = 1;
                    g.root = chain[1];
                    g.eatCarbon = false;
                    indexes.set(i3, Util.indexOf(g.root, this.originalChain));
                    continue;
                }
                if (g.root != chain[chain.length - 1]) continue;
                to = chain.length - 1;
                g.root = chain[to - 1];
                g.eatCarbon = false;
                indexes.set(i3, Util.indexOf(g.root, this.originalChain));
            }
            if (from != 0 || to != chain.length) {
                int[] newChain = new int[to - from];
                System.arraycopy(this.chain, from, newChain, 0, to - from);
                this.chain = newChain;
            }
            this.modifiers.addSubstituents(indexes == null ? null : indexes.toArray(), branches);
        }
        for (i = 0; i < chain.length; ++i) {
            MolAtom newAtom = this.originalMolecule.getAtom(i);
            if (start == chain[i]) {
                start = newAtom;
            }
            chain[i] = newAtom;
        }
        this.handleHydrido();
        this.radical = start;
    }

    int length() {
        return this.chain.length;
    }

    private MolAtom getSingleMetalAtom() {
        if (this.chain.length != 1) {
            return null;
        }
        MolAtom a = this.originalMolecule.getAtom(0);
        int group = MolAtom.getColumn(a.getAtno());
        if (3 <= group && group <= 12) {
            return a;
        }
        return null;
    }

    private void handleHydrido() {
        MolAtom a = this.getSingleMetalAtom();
        if (a == null) {
            return;
        }
        a = SubmoleculeBuilder.originalAtom(a);
        int i = Chem.getHCount(a);
        while (--i >= 0) {
            this.modifiers.addPrefix("hydrido");
        }
    }

    @Override
    int getSeniorityClass() {
        MolAtom a = this.getSingleMetalAtom();
        if (a != null) {
            return 0;
        }
        return super.getSeniorityClass();
    }

    static Molecule molecule(MolAtom[] chain, Molecule m, int[] atomIndexMap) {
        Molecule res = new Molecule();
        for (int i = 0; i < chain.length; ++i) {
            MolAtom a = (MolAtom)chain[i].clone();
            SubmoleculeBuilder.setParentAtom(a, chain[i]);
            SubmoleculeBuilder.setOriginalAtom(a, chain[i]);
            res.add(a);
            if (i <= 0) continue;
            MolBond b = chain[i - 1].getBondTo(chain[i]);
            res.add(new MolBond(res.getAtom(i - 1), a, b.getFlags()));
        }
        return res;
    }

    @Override
    boolean needsLocants() {
        boolean fixedNumbering;
        if (this.chain.length == 1) {
            return this.originalChain[0].getAtno() == 6 && this.modifiers.getEnding() == "amide";
        }
        if (this.chain.length > 2) {
            return true;
        }
        if (this.originalChain[0].getAtno() != this.originalChain[1].getAtno()) {
            return true;
        }
        if (!Options.strictLocants && this.isAceticAcid()) {
            return false;
        }
        int numSubstituents = this.modifiers.getNumberOfSubstituents();
        String ending = this.modifiers.getEnding();
        boolean bl = fixedNumbering = ending != null && ending.startsWith("yl");
        if (numSubstituents == 2 && !fixedNumbering && Chem.getHCount(SubmoleculeBuilder.originalAtom(this.originalChain[0])) == 0 && Chem.getHCount(SubmoleculeBuilder.originalAtom(this.originalChain[1])) == 0) {
            return false;
        }
        return numSubstituents >= (fixedNumbering ? 1 : 2);
    }

    int[] findChain() {
        int index;
        MolAtom next;
        int i;
        int len = this.originalMolecule.getAtomCount();
        int[] chain = new int[len];
        if (len == 1) {
            return chain;
        }
        boolean[] visited = new boolean[len];
        int startIndex = 0;
        MolAtom middle = this.originalMolecule.getAtom(startIndex);
        int rank = 0;
        chain[rank++] = startIndex;
        visited[startIndex] = true;
        MolAtom atom = middle;
        block0: while (rank == 1 || atom.getBondCount() > 1) {
            i = atom.getBondCount();
            while (--i >= 0) {
                next = atom.getLigand(i);
                index = this.originalMolecule.indexOf(next);
                if (visited[index]) continue;
                atom = next;
                visited[index] = true;
                chain[rank++] = index;
                continue block0;
            }
            throw new IUPACNamer.Failure("Not a chain");
        }
        System.arraycopy(chain, 0, chain, this.originalMolecule.getAtomCount() - rank, rank);
        rank = this.originalMolecule.getAtomCount() - rank;
        atom = middle;
        block2: while (atom.getBondCount() > 1) {
            i = atom.getBondCount();
            while (--i >= 0) {
                next = atom.getLigand(i);
                index = this.originalMolecule.indexOf(next);
                if (visited[index]) continue;
                atom = next;
                visited[index] = true;
                chain[--rank] = index;
                continue block2;
            }
            throw new IUPACNamer.Failure("Not a chain");
        }
        if (rank != 0) {
            throw new IUPACNamer.Failure("Not a chain");
        }
        return chain;
    }

    @Override
    int[][][] recognize() {
        int len = this.completeMolecule.getAtomCount();
        int[] numbering1 = new int[len];
        int[] numbering2 = new int[len];
        int i = this.chain.length;
        while (--i >= 0) {
            numbering1[this.chain[i]] = i + 1;
            numbering2[this.chain[i]] = this.chain.length - i;
        }
        return new int[][][]{new int[][]{null, numbering1}, new int[][]{null, numbering2}};
    }

    @Override
    boolean ignoreHeteroAtoms() {
        if (this.chain.length == 1) {
            return true;
        }
        return this.isHydrazineFamily();
    }

    @Override
    boolean ignoreBonds() {
        return this.isHydrazineFamily();
    }

    @Override
    String nameDescriptor(int[] descriptor, int[] numbering, boolean saturatedBase, boolean omitSuffix) {
        if (this.isHydrazine()) {
            return "hydrazine";
        }
        if (this.isDiazene()) {
            return "diazene";
        }
        if (this.isDiazyne()) {
            return "diazyne";
        }
        if (this.chain.length == 1) {
            MolAtom a = this.originalMolecule.getAtom(this.chain[0]);
            boolean substituent = false;
            if (this.modifiers.getEnding() == "yl" || this.isMonoRadical) {
                substituent = true;
                this.isMonoRadical = true;
            }
            return MonoNuclear.baseName(a, this.modifiers, substituent, true, false);
        }
        return omitSuffix ? "" : Chem.carbonChainName(this.chain.length);
    }

    @Override
    String getName() {
        String res = super.getName();
        if (this.chain.length == 1) {
            for (int i = 0; i < retainedNames.length; i += 2) {
                String root = retainedNames[i];
                if (!res.endsWith(root)) continue;
                return res.substring(0, res.length() - root.length()) + retainedNames[i + 1];
            }
        }
        if (res.equals("ethanedial")) {
            return "oxaldehyde";
        }
        if (res.equals("2-methylpropan-2-yl")) {
            if (Options.minimizeBrackets) {
                this.notComplex = true;
            }
            return "tert-butyl";
        }
        if (Options.traditionalGroups) {
            if (res.equals("propan-2-yl")) {
                return "isopropyl";
            }
            if (res.equals("butan-2-yl")) {
                return "sec-butyl";
            }
        }
        if (res.equals("phenylmethyl")) {
            this.notComplex = true;
            return "benzyl";
        }
        if (res.endsWith(")phenylmethyl")) {
            return res.substring(0, res.length() - "phenylmethyl".length()) + "benzyl";
        }
        return res;
    }

    @Override
    boolean isMethane() {
        return this.originalChain.length == 1 && this.originalChain[0].getAtno() == 6;
    }

    boolean isAceticAcid() {
        if (this.originalChain.length != 2) {
            return false;
        }
        if (this.originalChain[0].getAtno() != 6 || this.originalChain[1].getAtno() != 6) {
            return false;
        }
        if (this.modifiers.suffixGroups == null || this.modifiers.suffixGroups.size() != 1) {
            return false;
        }
        return "carboxy".equals(this.modifiers.suffixGroup((int)0).prefixName);
    }

    @Override
    boolean isAminoAcid() {
        return this.originalChain.length == 1 && AminoAcid.isAminoAcid(this.originalChain[0]);
    }

    boolean isHydrazineFamily() {
        return this.originalChain.length == 2 && this.originalChain[0].getAtno() == 7 && this.originalChain[1].getAtno() == 7;
    }

    boolean isHydrazine() {
        return this.isHydrazineFamily() && this.modifiers.bonds2.size() == 0 && this.modifiers.bonds3.size() == 0;
    }

    boolean isDiazene() {
        return this.isHydrazineFamily() && this.modifiers.bonds2.size() > 0;
    }

    boolean isDiazyne() {
        return this.isHydrazineFamily() && this.modifiers.bonds3.size() > 0;
    }

    @Override
    boolean canHaveSuffix() {
        MolAtom a;
        if (this.originalChain.length == 1 && Canonicalizer.isCoA(a = this.originalChain[0])) {
            return false;
        }
        return super.canHaveSuffix();
    }
}

