/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameexport;

import chemaxon.marvin.io.formats.name.nameexport.Chem;
import chemaxon.marvin.io.formats.name.nameexport.HeteroAnalyser;
import chemaxon.marvin.io.formats.name.nameexport.IUPACNamer;
import chemaxon.marvin.io.formats.name.nameexport.Part;
import chemaxon.marvin.io.formats.name.nameexport.SimpleGroup;
import chemaxon.marvin.io.formats.name.nameexport.SimplePart;
import chemaxon.marvin.io.formats.name.nameexport.SubmoleculeBuilder;
import chemaxon.marvin.io.formats.name.nameexport.Util;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;

abstract class Ether
extends SimplePart {
    private Part substituent;
    MolAtom atom;
    boolean peroxide;
    MolAtom atom2;
    int atno;
    boolean complex;
    String name;

    Ether(Molecule m, int atno) {
        super(m);
        this.atno = atno;
    }

    Ether(MolAtom root, MolAtom atom) {
        super(root);
        this.atom = atom;
        this.atno = atom.getAtno();
    }

    Ether(MolAtom root, MolAtom atom, MolAtom atom2) {
        this(root, atom);
        this.atom2 = atom2;
        this.peroxide = atom2 != null;
    }

    @Override
    String getName() {
        if (!this.peroxide && this.substituent instanceof Ether) {
            Ether e = (Ether)this.substituent;
            if (e.atom.getAtno() == this.atno) {
                this.substituent = e.substituent;
                this.atom2 = e.atom;
                this.peroxide = true;
            }
        }
        String innerName = this.substituent.getPrefixName();
        String prefix = this.etherName();
        if ((prefix = SimpleGroup.printIsotope(this.atom, prefix)) == "oxy" && innerName.endsWith("phenyl")) {
            this.name = innerName.substring(0, innerName.length() - 6) + "phenoxy";
            this.complex = false;
        } else {
            int shortenedName = 0;
            if (prefix == "oxy") {
                shortenedName = Ether.shortName(innerName);
            }
            if (shortenedName > 0) {
                this.name = innerName.substring(0, innerName.length() - shortenedName) + prefix;
                this.complex = this.substituent.complex();
            } else if (this.substituent.complex()) {
                this.name = Util.parenthesize(innerName) + prefix;
                this.complex = true;
            } else {
                this.name = innerName + prefix;
                this.complex = true;
            }
        }
        if (this.modifiers.isEmpty()) {
            return this.name;
        }
        StringBuffer res = new StringBuffer();
        this.modifiers.printSubstituents(null, res);
        Util.appendRemovingVowel(this.name, res);
        return res.toString();
    }

    String etherName() {
        int valence;
        String prefix = this.etherAnalogPrefix();
        int n = valence = this.atom == null ? -1 : HeteroAnalyser.lambdaValence(this.atom);
        if (valence <= 0) {
            return prefix;
        }
        StringBuffer res = new StringBuffer("-");
        HeteroAnalyser.printLambda(valence, res);
        res.append('-').append(prefix);
        return res.toString();
    }

    String etherAnalogPrefix() {
        switch (this.atno) {
            case 8: {
                return this.peroxide ? "peroxy" : (this.isRadical() ? "oxidanyl" : "oxy");
            }
            case 16: {
                return this.peroxide ? "disulfanyl" : "sulfanyl";
            }
            case 34: {
                return this.peroxide ? "diselanyl" : "selanyl";
            }
            case 52: {
                return this.peroxide ? "ditellanyl" : "tellanyl";
            }
        }
        throw new IUPACNamer.Failure("incorrect ether");
    }

    static int shortName(String innerName) {
        if (innerName.endsWith("ethyl") || innerName.endsWith("propyl") || innerName.endsWith("butyl")) {
            return 2;
        }
        if (innerName.endsWith("ethane") || innerName.endsWith("propane") || innerName.endsWith("butane")) {
            return 3;
        }
        return 0;
    }

    @Override
    boolean complex() {
        this.getName();
        return this.complex;
    }

    boolean isRadical() {
        if (this.atom == null) {
            return false;
        }
        return Chem.isRealRadical(this.atom);
    }

    @Override
    int[][][] recognize() {
        return null;
    }

    @Override
    String nameDescriptor(int[] descriptor, int[] numbering, boolean saturatedBase, boolean omitSuffix) {
        return this.getName();
    }

    @Override
    Part getRealParent(MolAtom atom) {
        if (this.atom != null && atom == SubmoleculeBuilder.originalAtom(this.atom)) {
            return this;
        }
        if (this.atom2 != null && atom == SubmoleculeBuilder.originalAtom(this.atom2)) {
            return this;
        }
        Part res = this.substituent.getRealParent(atom);
        if (res != null) {
            return res;
        }
        return super.getRealParent(atom);
    }

    Part getSubstituent() {
        return this.substituent;
    }

    void setSubstituent(Part substituent) {
        this.substituent = substituent;
        substituent.setParent(this);
    }

    @Override
    void addSubstituent(Part substituent) {
        if (substituent == this.substituent) {
            substituent.setParent(this);
            return;
        }
        super.addSubstituent(substituent);
    }
}

