/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameexport;

import chemaxon.marvin.io.formats.name.nameexport.Ether;
import chemaxon.marvin.io.formats.name.nameexport.IUPACNamer;
import chemaxon.marvin.io.formats.name.nameexport.Part;
import chemaxon.marvin.io.formats.name.nameexport.SimplePart;
import chemaxon.marvin.io.formats.name.nameexport.SubmoleculeBuilder;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;

public class EtherParent
extends Ether {
    Part part1;
    Part part2;
    Part parent;
    MolAtom globalOxygenAtom;

    public EtherParent(Molecule m, MolAtom root, int atno, Part part1, Part part2, MolAtom globalOxygenAtom) {
        super(m, atno);
        this.root = root;
        this.part1 = part1;
        this.part2 = part2;
        this.globalOxygenAtom = globalOxygenAtom;
    }

    @Override
    void setParent(Part parent) {
        if (this.part1 == parent) {
            this.parent = this.part1;
            this.setSubstituent(this.part2);
        } else {
            this.parent = this.part2;
            this.setSubstituent(this.part1);
        }
        if (this.getSubstituent() instanceof SimplePart) {
            this.setRadicalFromRoot((SimplePart)this.getSubstituent(), this.globalOxygenAtom);
        }
    }

    private void setRadicalFromRoot(SimplePart substituent, MolAtom globalRoot) {
        Molecule m = substituent.originalMolecule;
        int i = m.getAtomCount();
        while (--i >= 0) {
            MolAtom candidate = m.getAtom(i);
            MolBond b = SubmoleculeBuilder.originalAtom(candidate).getBondTo(globalRoot);
            if (b == null) continue;
            substituent.setRadical(candidate, b.getType());
            break;
        }
    }

    @Override
    String getName() {
        if (this.parent == null) {
            throw new IUPACNamer.Failure("Unset parent for ether");
        }
        return super.getName();
    }
}

