/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameexport;

import chemaxon.common.util.IntVector;
import chemaxon.marvin.io.formats.name.nameexport.Dictionary;
import chemaxon.marvin.io.formats.name.nameexport.HeteroAnalyser;
import chemaxon.marvin.io.formats.name.nameexport.IUPACNamer;
import chemaxon.marvin.io.formats.name.nameexport.Options;
import chemaxon.marvin.io.formats.name.nameexport.RingSystem;
import chemaxon.marvin.io.formats.name.nameexport.Search;
import chemaxon.marvin.io.formats.name.nameexport.SimplePart;
import chemaxon.marvin.io.formats.name.nameexport.Util;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.util.LoggingUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.logging.Logger;

public class GeneralFusedRingSystem
extends SimplePart {
    RingSystem rs;
    int[] ringOrder;
    SimplePart[] components;
    int numberingStart1;
    int numberingStart2;
    private static final Logger logger = LoggingUtil.getLogger(GeneralFusedRingSystem.class);

    public static SimplePart create(Molecule molecule, int[] atomIndexMap, RingSystem rs) {
        SimplePart[] components = Search.getCyclicComponents(molecule, atomIndexMap);
        if (components == null) {
            return null;
        }
        if (!Options.numberingOnly && components.length != 2) {
            return null;
        }
        int[] ringOrder = rs.getLinearFusedRings();
        if (ringOrder == null) {
            return null;
        }
        int numberingStart1 = GeneralFusedRingSystem.getNumberingStart(ringOrder, rs);
        if (numberingStart1 == -2) {
            return null;
        }
        int numberingStart2 = ringOrder.length == 3 ? rs.computeAngle(ringOrder[0], ringOrder[1], ringOrder[2]) : -1;
        if (numberingStart2 != -1 && (numberingStart1 < 0 || numberingStart1 >= molecule.getAtomCount())) {
            logger.fine("Invalid numeringStart1 computed(?), fallback to bridged nomenclature");
            return null;
        }
        return new GeneralFusedRingSystem(molecule, atomIndexMap, rs, ringOrder, components, numberingStart1, numberingStart2);
    }

    private static int getNumberingStart(int[] ringOrder, RingSystem rs) {
        int res = -1;
        int i = ringOrder.length;
        while (--i >= 2) {
            int angle = i == 2 ? rs.computeAngle(ringOrder[i], ringOrder[i - 1], ringOrder[i - 2]) : rs.computeAngle(ringOrder[i - 2], ringOrder[i - 1], ringOrder[i]);
            if (angle == -1) continue;
            if (i != 2 && i != ringOrder.length) {
                return -2;
            }
            if (res != -1) {
                return -2;
            }
            res = angle;
        }
        return res;
    }

    GeneralFusedRingSystem(Molecule m, int[] atomIndexMap, RingSystem rs, int[] ringOrder, SimplePart[] components, int numberingStart1, int numberingStart2) {
        super(m, atomIndexMap);
        this.rs = rs;
        this.ringOrder = ringOrder;
        this.components = components;
        this.numberingStart1 = numberingStart1;
        this.numberingStart2 = numberingStart2;
        this.sortComponents();
    }

    void sortComponents() {
        Arrays.sort(this.components, new Comparator<SimplePart>(){

            @Override
            public int compare(SimplePart p1, SimplePart p2) {
                return Dictionary.dictionaryOrder(p1.originalMolecule, p2.originalMolecule);
            }
        });
    }

    @Override
    String nameDescriptor(int[] descriptor, int[] numbering, boolean saturatedBase, boolean omitSuffix) {
        StringBuffer res = new StringBuffer();
        Fusion f = this.fusion(this.components[1], this.components[0]);
        int[] parentNumbering = f.bestParentNumbering(this.components[0].bestNumberings(false));
        int[] attachedNumbering = f.bestAttachedNumbering(this.components[1]);
        this.components[1].namePrefix(null, attachedNumbering, true, true, true, res);
        this.attachedComponentName(this.components[1], attachedNumbering, res);
        f.print(attachedNumbering, parentNumbering, res);
        this.components[0].namePrefix(null, parentNumbering, true, true, true, res);
        res.append(this.components[0].nameDescriptor(null, parentNumbering, false, omitSuffix, true));
        return res.toString();
    }

    @Override
    int[][][] recognize() {
        int[][][] candidates = this.getCandidates();
        candidates = HeteroAnalyser.bestHeteroResults(this.originalMolecule, this.hasRadical() ? this.radical : null, candidates);
        candidates = GeneralFusedRingSystem.bestFusionNumberings(candidates, this.maximizeFusions());
        return candidates;
    }

    int[][][] getCandidates() {
        int[][] numberings = this.rs.linearFusedNumberings(this.ringOrder, this.originalMolecule.getAtomCount());
        int i = numberings.length;
        while (--i >= 0) {
            Util.waitForDisplay();
        }
        if (this.numberingStart2 != -1) {
            int[][][] res = new int[2][][];
            int i2 = numberings.length;
            while (--i2 >= 0) {
                if (numberings[i2][this.numberingStart1] == 1) {
                    res[0] = new int[][]{null, numberings[i2]};
                }
                if (numberings[i2][this.numberingStart2] != 1) continue;
                res[1] = new int[][]{null, numberings[i2]};
            }
            if (res[0] == null || res[1] == null) {
                throw new IUPACNamer.Failure("Expected numbering not found");
            }
            return res;
        }
        if (this.numberingStart1 != -1) {
            int[][][] res = new int[1][][];
            int i3 = numberings.length;
            while (--i3 >= 0) {
                if (numberings[i3][this.numberingStart1] != 1) continue;
                res[0] = new int[][]{null, numberings[i3]};
            }
            if (res[0] == null) {
                throw new IUPACNamer.Failure("Expected numbering not found");
            }
            return res;
        }
        int[][][] res = new int[numberings.length][][];
        int i4 = numberings.length;
        while (--i4 >= 0) {
            res[i4] = new int[][]{null, numberings[i4]};
        }
        return res;
    }

    void attachedComponentName(SimplePart component, int[] numbering, StringBuffer to) {
        String name = component.nameDescriptor(null, numbering, false, false);
        if (name == "anthracene") {
            name = "anthra";
        } else if (name == "benzene") {
            name = "benzo";
        } else if (name == "furan") {
            name = "furo";
        } else if (name == "pyridine") {
            name = "pyrido";
        } else if (name == "thiophene") {
            name = "thieno";
        } else if (name == "naphthalene") {
            name = "naphtho";
        } else if (name == "phenanthrene") {
            name = "phenantho";
        } else if (name == "imidazole") {
            name = "imidazo";
        } else if (name == "pyrimidine") {
            name = "pyrimido";
        } else if (name.startsWith("cyclo") && name.endsWith("ane")) {
            name = name.substring(0, name.length() - 2);
        } else {
            to.append(name);
            Util.appendRemovingVowel("o", to);
            return;
        }
        to.append(name);
    }

    @Override
    boolean ignoreHeteroAtoms() {
        return true;
    }

    @Override
    boolean hasRetainedName() {
        return true;
    }

    @Override
    boolean hasSaturatedBase() {
        return false;
    }

    @Override
    boolean noHydro() {
        return true;
    }

    Fusion fusion(SimplePart attached, SimplePart parent) {
        Fusion res = new Fusion();
        int[] intersection = Util.intersectionIndexes(attached.atomIndexMap, parent.atomIndexMap, 2);
        res.child1 = intersection[1];
        res.child2 = intersection[3];
        MolAtom p1 = parent.getAtom(intersection[2]);
        MolAtom p2 = parent.getAtom(intersection[4]);
        res.parent1 = parent.originalMolecule.indexOf(p1);
        res.parent2 = parent.originalMolecule.indexOf(p2);
        return res;
    }

    public static int[][][] bestFusionNumberings(int[][][] candidates, boolean maximizeFusions) {
        if (candidates.length <= 1) {
            return candidates;
        }
        ArrayList<int[][]> res = new ArrayList<int[][]>();
        res.add(candidates[0]);
        for (int c = 1; c < candidates.length; ++c) {
            int[][] candidate = candidates[c];
            int[][] best = (int[][])res.get(0);
            int diff = GeneralFusedRingSystem.compareFusions(best[1], candidate[1]);
            if (maximizeFusions) {
                diff = -diff;
            }
            if (diff < 0) continue;
            if (diff > 0) {
                res.clear();
            }
            res.add(candidate);
        }
        return Util.intArrayArrayArray(res);
    }

    private static int compareFusions(int[] best, int[] candidate) {
        IntVector bestFusions = new IntVector();
        IntVector candidateFusions = new IntVector();
        assert (best.length == candidate.length);
        for (int i = 0; i < best.length; ++i) {
            int loc = best[i];
            if (Util.getLetter(loc) > '\u0000') {
                bestFusions.add(loc);
            }
            if (Util.getLetter(loc = candidate[i]) <= '\u0000') continue;
            candidateFusions.add(loc);
        }
        return Util.orderedComparison(bestFusions.toArray(), candidateFusions.toArray());
    }

    private static class Fusion {
        int child1;
        int child2;
        int parent1;
        int parent2;
        boolean symmetrical;

        private Fusion() {
        }

        void print(int[] attachedNumbering, int[] parentNumbering, StringBuffer to) {
            if (attachedNumbering == null && parentNumbering == null) {
                return;
            }
            to.append('[');
            if (attachedNumbering != null) {
                if (this.symmetrical && attachedNumbering[this.child2] < attachedNumbering[this.child1]) {
                    int tmp = this.child2;
                    this.child2 = this.child1;
                    this.child1 = tmp;
                }
                to.append(Util.locant(attachedNumbering[this.child1])).append(',').append(Util.locant(attachedNumbering[this.child2]));
                if (parentNumbering != null) {
                    to.append('-');
                }
            }
            if (parentNumbering != null) {
                to.append(this.parentLetter(parentNumbering));
            }
            to.append(']');
        }

        private int parentLocant(int[] numbering) {
            int n2;
            int n1 = Util.getNumber(numbering[this.parent1]);
            if (n1 > (n2 = Util.getNumber(numbering[this.parent2])) + 1) {
                return numbering[this.parent1];
            }
            if (n2 > n1 + 1) {
                return numbering[this.parent2];
            }
            return Math.min(numbering[this.parent1], numbering[this.parent2]);
        }

        char parentLetter(int[] numbering) {
            int num = this.parentLocant(numbering);
            int res = 97 + num - 1;
            int i = numbering.length;
            while (--i >= 0) {
                if (Util.getLetter(numbering[i]) == '\u0000' || Util.getNumber(numbering[i]) > num) continue;
                ++res;
            }
            return (char)res;
        }

        int[] bestAttachedNumbering(SimplePart attached) {
            int[][][] candidates = attached.bestNumberings(false);
            int[] best = candidates[0][1];
            int c = candidates.length;
            while (--c >= 1) {
                int[] candidate = candidates[c][1];
                if (candidate[this.child1] >= best[this.child1] && (candidate[this.child1] != best[this.child1] || candidate[this.child2] >= best[this.child2])) continue;
                best = candidate;
            }
            return best;
        }

        int[] bestParentNumbering(int[][][] candidates) {
            int[] best = candidates[0][1];
            this.symmetrical = false;
            int c = candidates.length;
            while (--c >= 1) {
                int[] candidate = candidates[c][1];
                if (this.parentLocant(candidate) < this.parentLocant(best)) {
                    best = candidate;
                    this.symmetrical = false;
                    continue;
                }
                if (this.parentLocant(candidate) != this.parentLocant(best)) continue;
                this.symmetrical = true;
            }
            if (best != null && this.parentLocant(best) == best[this.parent2]) {
                int tmp = this.parent2;
                this.parent2 = this.parent1;
                this.parent1 = tmp;
                tmp = this.child2;
                this.child2 = this.child1;
                this.child1 = tmp;
            }
            return best;
        }
    }
}

