/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameexport;

import chemaxon.common.util.IntVector;
import chemaxon.marvin.io.formats.name.nameexport.BranchedSpiroNamer;
import chemaxon.marvin.io.formats.name.nameexport.Chem;
import chemaxon.marvin.io.formats.name.nameexport.HeteroAnalyser;
import chemaxon.marvin.io.formats.name.nameexport.Modifiers;
import chemaxon.marvin.io.formats.name.nameexport.MonoSpiroNamer;
import chemaxon.marvin.io.formats.name.nameexport.ParentFinder;
import chemaxon.marvin.io.formats.name.nameexport.Part;
import chemaxon.marvin.io.formats.name.nameexport.RingSystem;
import chemaxon.marvin.io.formats.name.nameexport.RingSystemRecognizer;
import chemaxon.marvin.io.formats.name.nameexport.SaturationAnalyser;
import chemaxon.marvin.io.formats.name.nameexport.SimplePart;
import chemaxon.marvin.io.formats.name.nameexport.SubmoleculeBuilder;
import chemaxon.marvin.io.formats.name.nameexport.SubstituablePart;
import chemaxon.marvin.io.formats.name.nameexport.UnbranchedSpiroNamer;
import chemaxon.marvin.io.formats.name.nameexport.Util;
import chemaxon.struc.Molecule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.ListIterator;

abstract class GeneralSpiroNamer
extends SubstituablePart {
    protected RingSystemRecognizer.RingTree tree;
    protected int[] numbering;
    protected int[] primes;
    ArrayList components;
    Modifiers modifiers;

    static GeneralSpiroNamer create(RingSystemRecognizer.RingTree tree, Molecule m) {
        if (tree.size == 3 && tree.threeRingSpiroAtoms.size() == 1) {
            return new MonoSpiroNamer(tree, m);
        }
        GeneralSpiroNamer res = BranchedSpiroNamer.create(tree, m);
        if (res != null) {
            return res;
        }
        return new UnbranchedSpiroNamer(tree, m);
    }

    protected GeneralSpiroNamer(RingSystemRecognizer.RingTree tree, Molecule m) {
        super(m);
        this.tree = tree;
        this.numbering = new int[this.originalMolecule.getAtomCount()];
        this.primes = new int[this.originalMolecule.getAtomCount()];
        this.components = new ArrayList(tree.size);
    }

    NameComponent component(int index) {
        return (NameComponent)this.components.get(index);
    }

    @Override
    String getName() {
        this.getPartNames();
        this.computeNumbering();
        this.finalizeModifiers();
        StringBuffer name = new StringBuffer();
        this.computeName(name);
        return name.toString();
    }

    protected void computeNumbering() {
        int i = this.components.size();
        while (--i >= 0) {
            NameComponent component = (NameComponent)this.components.get(i);
            this.setNumbering(component, i);
        }
    }

    protected void computeName(StringBuffer name) {
        String components = this.nameAll();
        this.modifiers.printPrefix(this.numbering, this.primes, name);
        if (this.tree.size == 2) {
            HeteroAnalyser.nameHeteroAtoms(this.originalMolecule, this.numbering, this.primes, false, name);
        } else {
            HeteroAnalyser.addLambdas(this.originalMolecule, this.numbering, this.primes, name);
        }
        int spiroCount = this.getSpiroCount();
        if (spiroCount > 1) {
            name.append(Chem.greek(spiroCount));
        }
        name.append("spiro[");
        name.append(components);
        name.append(']');
        this.modifiers.printSuffix(this.numbering, this.primes, true, false, name);
    }

    private int getSpiroCount() {
        return this.tree.size - 1 - this.tree.threeRingSpiroAtoms.size();
    }

    void getPartNames() {
        if (this.components.size() == 0) {
            this.computePartNames();
        }
    }

    abstract void computePartNames();

    private String nameAll() {
        StringBuffer res = new StringBuffer();
        String primes = "";
        int i = 0;
        int multiCount = 1;
        ListIterator it = this.components.listIterator();
        while (it.hasNext()) {
            boolean multi;
            NameComponent component = (NameComponent)it.next();
            int[] numbering = component.getNumbering();
            String fullName = component.getFullName(i == 0);
            NameComponent next = null;
            if (it.hasNext()) {
                next = (NameComponent)it.next();
                it.previous();
            }
            boolean bl = next == null ? false : (multi = fullName.equals(next.getFullName(i == 0)));
            if (multi) {
                ++multiCount;
            }
            if (i > 0) {
                res.append(Util.locant(this.getSecondSpiroLocant(i, component.localSpiroAtoms, numbering)));
                res.append(this.getSecondPrime(i, primes)).append(multi ? (char)':' : '-');
            }
            int startChar = 45;
            if (!multi) {
                String lead = null;
                if (multiCount > 1) {
                    if (multiCount == i + 1) {
                        lead = res.substring(0, res.length() - 1);
                        res.setLength(0);
                    }
                    res.append(Chem.complexMultiplier(multiCount)).append('(');
                }
                res.append(fullName);
                if (multiCount > 1) {
                    res.append(')');
                }
                if (lead != null) {
                    res.append('-').append(lead);
                    startChar = 58;
                }
                multiCount = 1;
            }
            if (it.hasNext()) {
                if (!multi) {
                    res.append((char)startChar);
                }
                res.append(Util.locant(this.getFirstSpiroLocant(i, component.localSpiroAtoms, numbering)));
                res.append(this.getFirstPrime(i, primes)).append(',');
                primes = primes + "'";
            }
            ++i;
        }
        return res.toString();
    }

    protected String getFirstPrime(int rank, String rankPrime) {
        return rankPrime;
    }

    protected String getSecondPrime(int rank, String rankPrime) {
        return rankPrime;
    }

    abstract int getFirstSpiroLocant(int var1, IntVector var2, int[] var3);

    abstract int getSecondSpiroLocant(int var1, IntVector var2, int[] var3);

    protected NameComponent nameRingSystem(int node, RingSystem rs) {
        String mainName;
        NameComponent component = this.molecule(rs);
        SimplePart part = component.part;
        int[][][] result = this.recognize(component, rs.spiroAtoms);
        int[][][] bestResults = HeteroAnalyser.bestHeteroResults(part.originalMolecule, result);
        int idx = Util.randomInt(bestResults.length);
        int[] descriptor = bestResults[idx][0];
        int[] numbering = bestResults[idx][1];
        component.name = mainName = this.nameDescriptor(part, descriptor, numbering);
        component.results = bestResults;
        this.setAtomFlags(component);
        return component;
    }

    void insertSorted(NameComponent component) {
        ListIterator<NameComponent> it = this.components.listIterator();
        while (it.hasNext()) {
            NameComponent other = (NameComponent)it.next();
            int diff = component.name.compareTo(other.name);
            if (diff == 0) {
                diff = component.getFullName(false).compareTo(other.getFullName(false));
            }
            if (diff >= 0) continue;
            it.previous();
            it.add(component);
            return;
        }
        this.components.add(component);
    }

    int[][][] recognize(NameComponent component, IntVector spiroAtoms) {
        SimplePart part = component.part;
        int[][][] results = part.recognize();
        IntVector localSpiroAtoms = new IntVector();
        for (int i = 0; i < spiroAtoms.size(); ++i) {
            localSpiroAtoms.add(Util.indexOf(spiroAtoms.get(i), component.atomIndexMap));
        }
        boolean prioritizeSpiro = this.tree.size == 2 && !part.ignoreHeteroAtoms();
        results = part.addMissingNumbering(results, localSpiroAtoms, prioritizeSpiro);
        ArrayList best = new ArrayList();
        for (int i = 0; i < results.length; ++i) {
            this.addResult(localSpiroAtoms, results[i], best);
        }
        int[][][] res = Util.intArrayArrayArray(best);
        return res;
    }

    int compareResults(IntVector localSpiroAtoms, int[] numbering1, int[] numbering2) {
        return Util.setComparison(numbering1, numbering2, localSpiroAtoms);
    }

    void addResult(IntVector spiroAtoms, int[][] newResult, ArrayList results) {
        if (results.size() == 0) {
            results.add(newResult);
        } else {
            int[][] best = (int[][])results.get(0);
            int diff = this.compareResults(spiroAtoms, best[1], newResult[1]);
            if (diff == 0) {
                results.add(newResult);
            } else if (diff > 0) {
                results.clear();
                results.add(newResult);
            }
        }
    }

    String nameDescriptor(SimplePart part, int[] descriptor, int[] numbering) {
        return part.nameDescriptor(descriptor, numbering, true, false);
    }

    NameComponent molecule(RingSystem rs) {
        SubmoleculeBuilder res = rs.computeMolecule(this.originalMolecule);
        int[] atomIndexMap = res.atomIndexMap.toArray();
        SimplePart part = rs.create(res.getMolecule(), atomIndexMap);
        return new NameComponent(part, atomIndexMap);
    }

    private void setAtomFlags(NameComponent component) {
        boolean ignoreHeteroAtoms = component.part.ignoreHeteroAtoms();
        for (int i = 0; i < component.part.originalMolecule.getAtomCount(); ++i) {
            boolean isSpiro = component.localSpiroAtoms.indexOf(i) != -1;
            component.part.primes[i] = GeneralSpiroNamer.encode(0, ignoreHeteroAtoms, isSpiro);
        }
    }

    private void setNumbering(NameComponent component, int prime) {
        int[] localNumbering = component.getNumbering();
        boolean ignoreHeteroAtoms = component.part.ignoreHeteroAtoms();
        for (int i = 0; i < localNumbering.length; ++i) {
            int index = component.atomIndexMap[i];
            this.numbering[index] = localNumbering[i];
            boolean isSpiro = component.localSpiroAtoms.indexOf(i) != -1;
            component.part.primes[i] = this.primes[index] = GeneralSpiroNamer.encode(prime, ignoreHeteroAtoms, isSpiro);
        }
    }

    static int encode(int i, boolean b1, boolean b2) {
        if (b1) {
            i |= Integer.MIN_VALUE;
        }
        if (b2) {
            i |= 0x40000000;
        }
        return i;
    }

    static int decode2(int i) {
        return i & 0x3FFFFFFF;
    }

    static boolean getBit(int i, int bit) {
        return (i & 1 << 32 - bit) != 0;
    }

    @Override
    int parentSeniority() {
        return 0x10000000 + (0x8000000 - this.getSpiroCount());
    }

    @Override
    int compareSeniority(Part other) {
        int diff;
        int i;
        if (!(other instanceof GeneralSpiroNamer)) {
            return 0;
        }
        GeneralSpiroNamer that = (GeneralSpiroNamer)other;
        this.getPartNames();
        that.getPartNames();
        Part[] thisComponents = GeneralSpiroNamer.getComponentsSortedByParentSeniority(this.components);
        Part[] thatComponents = GeneralSpiroNamer.getComponentsSortedByParentSeniority(that.components);
        for (i = 0; i < thisComponents.length; ++i) {
            diff = ParentFinder.compareCyclic(thisComponents[i], thatComponents[i]);
            if (diff == 0) continue;
            return diff;
        }
        thisComponents = GeneralSpiroNamer.getComponents(this.components);
        thatComponents = GeneralSpiroNamer.getComponents(that.components);
        for (i = 0; i < thisComponents.length; ++i) {
            diff = ParentFinder.compareCyclic(thisComponents[i], thatComponents[i]);
            if (diff == 0) continue;
            return diff;
        }
        return 0;
    }

    static Part[] getComponents(ArrayList components) {
        Part[] res = new Part[components.size()];
        int n = 0;
        for (NameComponent c : components) {
            res[n++] = c.part;
        }
        return res;
    }

    static Part[] getComponentsSortedByParentSeniority(ArrayList components) {
        Part[] res = GeneralSpiroNamer.getComponents(components);
        Arrays.sort(res, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ParentFinder.compareCyclic((Part)o1, (Part)o2);
            }
        });
        return res;
    }

    @Override
    Modifiers getModifiers() {
        if (this.modifiers != null) {
            this.addSubstituents();
            return this.modifiers;
        }
        this.modifiers = new Modifiers(this);
        this.getPartNames();
        int i = this.components.size();
        while (--i >= 0) {
            NameComponent component = (NameComponent)this.components.get(i);
            SaturationAnalyser.analyse(component.part, component.atomIndexMap, component.localSpiroAtoms, this.modifiers);
        }
        SimplePart.analyseAtoms(this.originalMolecule, this.modifiers);
        this.addSubstituents();
        return this.modifiers;
    }

    private void finalizeModifiers() {
        this.getModifiers();
        if (this.radical != null) {
            this.modifiers.setEnding(this.originalMolecule.indexOf(this.radical), this.ending);
        } else {
            this.modifiers.findSuffixGroup();
        }
    }

    private void addSubstituents() {
        if (this.substituents != null) {
            int i = this.substituents.length;
            while (--i >= 0) {
                this.addSubstituent(this.substituents[i]);
            }
            this.substituents = null;
        }
    }

    @Override
    void addSubstituent(Part substituent, int root) {
        this.modifiers.addSubstituent(root, substituent);
    }

    @Override
    boolean cyclic() {
        return true;
    }

    class NameComponent {
        SimplePart part;
        String name;
        int[][][] results;
        private int[] numbering;
        private int[] descriptor;
        IntVector localSpiroAtoms = new IntVector();
        int[] atomIndexMap;

        NameComponent(SimplePart part, int[] atomIndexMap) {
            this.part = part;
            this.atomIndexMap = atomIndexMap;
        }

        void addSpiroAtom(int spiroAtom) {
            this.localSpiroAtoms.add(Util.indexOf(spiroAtom, this.atomIndexMap));
        }

        void addSpiroAtom(int spiroAtom, int index) {
            this.localSpiroAtoms.add(index, Util.indexOf(spiroAtom, this.atomIndexMap));
        }

        int[] getNumbering() {
            return this.getNumbering(false);
        }

        int[] getNumbering(boolean canReorder) {
            if (this.numbering == null) {
                this.numbering = this.results[0][1];
                this.descriptor = this.results[0][0];
                IntVector bestLSA = this.reorderSpiroAtoms(canReorder, this.numbering);
                Modifiers modifiers = null;
                for (int i = 1; i < this.results.length; ++i) {
                    int[] cur = this.results[i][1];
                    IntVector curLSA = this.reorderSpiroAtoms(canReorder, cur);
                    int diff = Util.pointToPointComparison(this.numbering, cur, this.localSpiroAtoms, curLSA);
                    if (diff == 0) {
                        if (modifiers == null) {
                            modifiers = new Modifiers(GeneralSpiroNamer.this);
                            SaturationAnalyser.analyse(this.part, modifiers);
                        }
                        diff = modifiers.compare(this.numbering, null, cur, null);
                    }
                    if (diff <= 0 && (diff != 0 || !Util.randomBoolean())) continue;
                    this.numbering = cur;
                    this.descriptor = this.results[i][0];
                    bestLSA = curLSA;
                }
                this.localSpiroAtoms = bestLSA;
            }
            return this.numbering;
        }

        int[] getDescriptor() {
            this.getNumbering();
            return this.descriptor;
        }

        IntVector reorderSpiroAtoms(boolean canReorder, int[] numbering) {
            if (!canReorder || this.localSpiroAtoms.size() == 1) {
                return this.localSpiroAtoms;
            }
            IntVector res = this.localSpiroAtoms;
            for (int i = 0; i < GeneralSpiroNamer.this.components.size() - 1; ++i) {
                if (!GeneralSpiroNamer.this.component((int)i).name.equals(GeneralSpiroNamer.this.component((int)(i + 1)).name) || numbering[res.get(i)] <= numbering[res.get(i + 1)]) continue;
                if (res == this.localSpiroAtoms) {
                    res = (IntVector)this.localSpiroAtoms.clone();
                }
                int tmp = res.get(i);
                res.set(i, res.get(i + 1));
                res.set(i + 1, tmp);
                if (i <= 0) continue;
                i -= 2;
            }
            return res;
        }

        String getFullName(boolean first) {
            StringBuffer res = new StringBuffer();
            if (GeneralSpiroNamer.this.tree.size > 2 && !this.part.ignoreHeteroAtoms()) {
                HeteroAnalyser.nameHeteroAtoms(this.part.originalMolecule, this.getNumbering(), null, !first, res);
                if (Util.isVowel(this.name.charAt(0))) {
                    Util.removeTrailingVowel(res);
                }
            } else {
                this.part.namePrefix(this.getDescriptor(), this.getNumbering(), !first, false, false, res);
            }
            res.append(this.name);
            return res.toString();
        }

        int compareTo(NameComponent that) {
            if (this == that) {
                return 0;
            }
            int diff = this.name.compareTo(that.name);
            if (diff != 0) {
                return diff;
            }
            return Util.pointToPointComparison(this.getDescriptor(), that.getDescriptor());
        }
    }
}

