/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameexport;

import chemaxon.formats.MolImporter;
import chemaxon.formats.MolInputStream;
import chemaxon.marvin.io.formats.name.nameexport.Acid;
import chemaxon.marvin.io.formats.name.nameexport.Aldehyde;
import chemaxon.marvin.io.formats.name.nameexport.Chem;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.StaticMolecule;
import java.io.ByteArrayInputStream;
import java.io.IOException;

abstract class GroupDictionary {
    static Structure[] structures = new Structure[]{new Acid(2, 1, "pentacarbonic acid", null, "C([OH])(=O)OC(=O)OC(=O)OC(=O)OC(=O)[OH]"), new Acid(2, 2, "tetracarbonic acid", null, "C([OH])(=O)OC(=O)OC(=O)OC(=O)[OH]"), new Acid(2, 3, "tricarbonic acid", null, "C([OH])(=O)OC(=O)OC(=O)[OH]"), new Acid(2, 4, "dicarbonic acid", null, "C([OH])(=O)OC(=O)[OH]"), new Acid(2, 5, "oxalic acid", null, "C([OH])(=O)C(=O)[OH]"), new Acid(2, 6, "carbonic acid", null, "C([OH])(=O)[OH]"), new Acid(2, 7, "cyanic acid", null, "C([OH])#N"), new Acid(2, 100, "carbamic acid", null, "C([Nv3])(=O)[OH]").alwaysParent(), new Structure(11, 16, 100, "urea", null, "C(=O)(N)N |$2;;1;3;$|").alwaysParent(), new Structure(11, 16, 101, "carbamimidic acid", "(C-hydroxycarbonimidoyl)amino", "C(N)(O)=N |$;N;;N';$|").complex(), new Structure(11, 16, 102, "thiourea", null, "C(=S)(N)N |$2;;1;3;$|").alwaysParent(), new Structure(11, 16, 103, "carbamimidothioic acid", "(C-sulfanylcarbonimidoyl)amino", "C(N)(S)=N |$;N;;N';$|").complex(), new Structure(11, 16, 104, "selenourea", null, "C(=[Se])(N)N |$2;;1;3;$|").alwaysParent(), new Structure(11, 16, 105, "carbamimidoselenoic acid", "(C-selanylcarbonimidoyl)amino", "C(N)([Se])=N |$;N;;N';$|").complex(), new Structure(11, 16, 106, "tellurourea", null, "C(=[Te])(N)N |$2;;1;3;$|").alwaysParent(), new Structure(11, 16, 107, "carbamimidotelluroic acid", "(C-tellanylcarbonimidoyl)amino", "C(N)([Te])=N |$;N;;N';$|").complex(), new Acid(1, 1, "carboperoxoic acid", "carbonoperoxoyl", "C(=O)O[OH]").carbonEating(), new Structure(7, 1, 2, "carboperoxothioic OO-acid", "(hydroperoxy)carbonothioyl", "C(=S)OO").complex().carbonEating(), new Structure(7, 1, 3, "carboperoxoselenoic acid", "(hydroperoxy)carbonoselenoyl", "C(=[Se])OO").complex().carbonEating(), new Structure(7, 1, 4, "carbo(thioperoxoic) SO-acid", "(hydroxysulfanyl)carbonyl", "C(=O)SO").complex().carbonEating(), new Structure(7, 1, 5, "carbo(thioperoxoic) OS-acid", "(sulfanyloxy)carbonyl", "C(=O)OS").complex().carbonEating(), new Structure(7, 1, 6, "carbo(selenoperoxoic) SeO-acid", "(hydroxyselanyl)carbonyl", "C(=O)[Se]O").complex().carbonEating(), new Structure(7, 1, 7, "carbo(selenoperoxoic) OSe-acid", "(selanyloxy)carbonyl", "C(=O)O[Se]").complex().carbonEating(), new Structure(7, 1, 8, "carbothio(thioperoxoic) SO-acid", "(SO-thiohydroperoxy)carbonothioyl", "C(=S)SO").complex().carbonEating(), new Structure(7, 1, 9, "carbothio(thioperoxoic) OS-acid", "(OS-thiohydroperoxy)carbonothioyl", "C(=S)OS").complex().carbonEating(), new Structure(7, 1, 10, "carboseleno(thioperoxoic) OS-acid", "(OS-thiohydroperoxy)carbonoselenoyl", "C(=[Se])OS").complex().carbonEating(), new Structure(7, 1, 11, "carbo(selenoperoxo)thioic SeO-acid", "(hydroxyselanyl)carbonothioyl", "C(=S)[Se]O").complex().carbonEating(), new Structure(7, 1, 12, "carbo(selenoperoxo)thioic OSe-acid", "(selanyloxy)carbonothioyl", "C(=S)O[Se]").complex().carbonEating(), new Structure(7, 1, 13, "carbo(dithioperoxo)thioic acid", "(disulfanyl)carbonothioyl", "C(=S)SS").complex().carbonEating(), new Structure(7, 1, 14, "carbo(diselenoperoxo)selenoic acid", "(diselanyl)carbonoselenoyl", "C(=[Se])[Se][Se]").complex().carbonEating(), new Structure(7, 1, 15, "carbo(ditelluroperoxo)telluroic acid", "(ditellanyl)carbonotelluroyl", "C(=[Te])[Te][Te]").complex().carbonEating(), new Acid(1, 0, "carboxylic acid", "carboxy", "C(=O)[OH]").carbonEating(), new Acid(1, 17, "carbothioic O-acid", "hydroxy(carbonothioyl)", "C(=S)[OH]").complex().carbonEating(), new Structure(7, 1, 18, "carbothioic S-acid", "sulfanylcarbonyl", "C(=O)S").complex().carbonEating(), new Structure(7, 1, 19, "carbothioic Se-acid", "selanylcarbonyl", "C(=O)[Se]").complex().carbonEating(), new Structure(7, 1, 20, "carbothioic Te-acid", "tellanylcarbonyl", "C(=O)[Te]").complex().carbonEating(), new Structure(7, 1, 21, "carbodithioic acid", "sulfanyl(carbonothioyl)", "C(=S)S").complex().carbonEating(), new Structure(7, 1, 22, "carboselenothioic S-acid", "sulfanyl(carbonoselenoyl)", "C(=[Se])S").complex().carbonEating(), new Structure(7, 1, 23, "carboselenothioic Se-acid", "selanyl(carbonothioyl)", "C(=S)[Se]").complex().carbonEating(), new Structure(7, 1, 24, "carbodiselenoic acid", "selanyl(carbonoselenoyl)", "C(=[Se])[Se]").complex().carbonEating(), new Structure(7, 1, 25, "carboselenotelluroic Se-acid", "selanyl(carbonothioyl)", "C(=[Te])[Se]").complex().carbonEating(), new Structure(7, 1, 26, "carboditelluroic acid", "tellanyl(carbonotelluroyl)", "C(=[Te])[Te]").complex().carbonEating(), new Acid(1, 3, "carbohydrazonic acid", "C-hydroxycarbonohydrazonoyl", "C(=NN)[OH]").carbonEating(), new Structure(7, 1, 4, "carboximidic acid", "dihydroxycarbonimidoyl", "C(=NO)O").complex().suffixPrefix("N-hydroxy").carbonEating(), new Acid(1, 2, "carboximidic acid", "C-hydroxycarbonimidoyl", "C(=N)[OH]").carbonEating(), new Structure(7, 1, 11, "carboimidothioic acid", "thio(carbonoimidyl)", "C(=N)S").complex().carbonEating(), new Acid(4, 0, "sulfonoperoxoic acid", null, "S(=O)(=O)O[OH]"), new Acid(4, 1, "sulfiniperoxoic acid", null, "S(=O)O[OH]"), new Acid(4, 2, "selenonoperoxoic acid", null, "[Se](=O)(=O)O[OH]"), new Acid(4, 3, "seleninoperoxoic acid", null, "[Se](=O)O[OH]"), new Acid(4, 4, "telluronoperoxoic acid", null, "[Te](=O)(=O)O[OH]"), new Acid(4, 5, "tellurinoperoxoic acid", null, "[Te](=O)O[OH]"), new Acid(4, 90, "sulfamic acid", null, "S(=O)(=O)(N)[OH]"), new Acid(21, 8, "phosphoric acid", null, "P(=O)([OH])([OH])[OH]").notEster(), new Acid(21, 9, "phosphorous acid", null, "[Pv3]([OH])([OH])[OH]").notEster(), new Acid(21, 20, "arsoric acid", null, "[As]([OH])([OH])([OH])=O").notEster(), new Acid(21, 21, "arsorous acid", null, "[As]([OH])([OH])([OH])").notEster(), new Acid(21, 30, "stiboric acid", null, "[Sb]([OH])([OH])([OH])=O").notEster(), new Acid(21, 31, "stiborous acid", null, "[Sb]([OH])([OH])([OH])").notEster(), new Acid(21, 40, "silicic acid", null, "[Si]([OH])([OH])([OH])[OH]").notEster(), new Acid(21, 50, "boric acid", null, "[B]([OH])([OH])[OH]").notEster(), new Acid(21, 70, "sulfuric acid", null, "S(=O)(=O)([OH])[OH]").notEster(), new Acid(21, 71, "sulfurous acid", null, "[Sv4](=O)([OH])[OH]").notEster(), new Acid(21, 80, "selenic acid", null, "[Se](=O)(=O)([OH])[OH]").notEster(), new Acid(21, 81, "selenous acid", null, "[Se](=O)([OH])[OH]").notEster(), new Acid(21, 90, "telluric acid", null, "[Te](=O)(=O)([OH])[OH]").notEster(), new Acid(21, 91, "tellurous acid", null, "[Te](=O)([OH])[OH]").notEster(), new Acid(4, 0, "sulfonic acid", "sulfo", "S(=O)(=O)[OH]"), new Acid(4, 1, "sulfinic acid", "sulfino", "[Sv4](=O)[OH]"), new Acid(4, 2, "selenonic acid", "selenono", "[Se](=O)(=O)[OH]"), new Acid(4, 3, "seleninic acid", "selenino", "[Se](=O)[OH]"), new Acid(4, 4, "telluronic acid", "tellurono", "[Te](=O)(=O)[OH]"), new Acid(4, 5, "tellurinic acid", "tellurino", "[Te](=O)[OH]"), new Acid(22, 1, "nitric acid", null, "N(=O)(=O)[OH]"), new Acid(20, 1, "azonic acid", null, "N(=O)([OH])[OH]").alwaysParent(), new Acid(20, 2, "azinic acid", null, "N(=O)O").alwaysParent(), new Acid(20, 6, "phosphonic acid", "phosphono", "P(=O)([OH])[OH]").notEster().alwaysParent(), new Acid(20, 10, "phosphonous acid", null, "P([OH])[OH]").notEster().alwaysParent(), new Acid(20, 11, "phosphinic acid", null, "P(=O)[OH]").alwaysParent(), new Acid(20, 12, "phosphinous acid", null, "P[OH]").alwaysParent(), new Acid(20, 16, "arsonic acid", "arsono", "[Asv5](=O)([OH])[OH]").alwaysParent(), new Acid(20, 20, "arsonous acid", null, "[Asv3]([OH])[OH]").alwaysParent(), new Acid(20, 21, "arsinic acid", null, "[Asv5](=O)[OH]").alwaysParent(), new Acid(20, 22, "arsinous acid", null, "[Asv3][OH]").alwaysParent(), new Acid(20, 80, "stibonous acid", null, "[Sb]([OH])[OH]").alwaysParent(), new Acid(20, 81, "stibinic acid", null, "[Sb](=O)[OH]").alwaysParent(), new Acid(20, 82, "stibinous acid", null, "[Sb][OH]").alwaysParent(), new Acid(20, 90, "boronic acid", null, "B([OH])[OH]").alwaysParent(), new Acid(20, 91, "borinic acid", null, "B[OH]").alwaysParent(), new Acid(22, 2, "nitrous acid", null, "[Nv3](=O)[OH]"), new Acid(22, 3, "perfluoric acid", null, "F(=O)(=O)(=O)[OH]"), new Acid(22, 4, "fluoric acid", null, "F(=O)(=O)[OH]"), new Acid(22, 5, "fluorous acid", null, "F(=O)[OH]"), new Acid(22, 6, "hypofluorous acid", null, "F[OH]"), new Acid(22, 7, "perchloric acid", null, "[Cl](=O)(=O)(=O)[OH]"), new Acid(22, 8, "chloric acid", null, "[Cl](=O)(=O)[OH]"), new Acid(22, 9, "chlorous acid", null, "[Cl](=O)[OH]"), new Acid(22, 10, "hypochlorous acid", null, "[Cl][OH]"), new Acid(22, 11, "perbromic acid", null, "[Br](=O)(=O)(=O)[OH]"), new Acid(22, 12, "bromic acid", null, "[Br](=O)(=O)[OH]"), new Acid(22, 13, "bromous acid", null, "[Br](=O)[OH]"), new Acid(22, 14, "hypobromous acid", null, "[Br][OH]"), new Acid(22, 15, "periodic acid", null, "[I](=O)(=O)(=O)[OH]"), new Acid(22, 16, "iodic acid", null, "[I](=O)(=O)[OH]"), new Acid(22, 17, "iodous acid", null, "[I](=O)[OH]"), new Acid(22, 18, "hypoiodous acid", null, "[I][OH]"), new Structure("perfluoryl", "[F](=O)(=O)=O"), new Structure("fluoryl", "[F](=O)=O"), new Structure("fluorosyl", "[F]=O"), new Structure("perchloryl", "[Cl](=O)(=O)=O"), new Structure("chloryl", "[Cl](=O)=O"), new Structure("chlorosyl", "[Cl]=O"), new Structure("perbromyl", "[Br](=O)(=O)=O"), new Structure("bromyl", "[Br](=O)=O"), new Structure("bromosyl", "[Br]=O"), new Structure("periodyl", "[I](=O)(=O)=O"), new Structure("iodyl", "[I](=O)=O"), new Structure("iodosyl", "[I]=O"), new Structure("azido", "N=N#N"), new Structure("diazo", "[Nv5]#N").rootBond(2), new Structure(6, 0, 0, "diazonium", null, "[N+]#N"), new Structure("isocyanato", "N=C=O"), new Structure("isothiocyanato", "N=C=S"), new Structure("isoselenocyanato", "N=C=[Se]"), new Structure("isotellurocyanato", "N=C=[Te]"), new Structure(12, 0, 0, "carbohydrazide", "hydrazinecarbonyl", "C(=O)NN |$;;N;N';$|").complex().turned("hydrazido").carbonEating(), new Structure(12, 0, 1, "sulfonohydrazide", "hydrazinesulfonyl", "S(=O)(=O)NN |$;;;N;N';$|").complex(), new Structure(12, 0, 2, "sulfinohydrazide", "hydrazinesulfinyl", "S(=O)NN |$;;N;N';$|").complex(), new Structure(12, 0, 3, "selenonohydrazide", "hydrazineselenonyl", "[Se](=O)(=O)NN |$;;;N;N';$|").complex(), new Structure(12, 0, 4, "seleninohydrazide", "hydrazineseleninyl", "[Se](=O)NN |$;;N;N';$|").complex(), new Structure(12, 0, 5, "telluronohydrazide", "hydrazinetelluronyl", "[Te](=O)(=O)NN |$;;;N;N';$|").complex(), new Structure(12, 0, 6, "tellurinohydrazide", "hydrazinetellurinyl", "[Te](=O)NN |$;;N;N';$|").complex(), new Structure(11, 16, 0, "carboxamide", "carbamoyl", "C(=O)N").turned("amido").asTurnedRadical("amidyl").carbonEating(), new Structure(6, 16, 0, "carboxamidylium", null, "C(=O)[Nv2+]").carbonEating(), new Structure(6, 16, 1, "carboxamidium", null, "C(=O)[N+]").carbonEating(), new Structure(11, 16, 1, "carbothioamide", "carbamothioyl", "C(=S)N").turned("thioamido").carbonEating(), new Structure(11, 16, 2, "sulfonodithioamide", "", "S(=S)(=S)N").turned("sulfonodithioamido").carbonEating(), new Structure(11, 17, 10, "guanidine", "carbamimidamido", "NC(=N)[NH2] |$1;;2;3;$|").alwaysParent().rootBond(1), new Structure(11, 17, 10, "guanidine", "carbamimidamido", "NC(=N)N |$3;;2;1;$|").alwaysParent().rootBond(1), new Structure(11, 17, 0, "carboximidamide", "carbamimidoyl", "C(=N)N |$;N';N;$|").turned("imidamido").carbonEating(), new Structure(11, 17, 1, "sulfonoimidamide", "S-aminosulfonimidoyl", "S(=O)(=N)N").turned("sulfonoimidamido"), new Structure(11, 17, 2, "sulfonodiimidamide", "S-aminosulfonodiimidoyl", "S(=N)(=N)N").turned("sulfonodiimidamido"), new Structure(11, 17, 3, "sulfinimidamide", "S-aminosulfinimidoyl", "S(=N)N").turned("sulfinimidamido"), new Structure(11, 19, 1, "sulfonamide", "sulfamoyl", "S(=O)(=O)N").turned("sulfonamido"), new Structure(11, 19, 2, "sulfinamide", null, "S(=O)N"), new Structure(11, 19, 3, "selenonamide", null, "[Se](=O)(=O)N"), new Structure(11, 19, 4, "seleninamide", null, "[Se](=O)N"), new Structure(11, 19, 5, "telluronamide", null, "[Te](=O)(=O)N"), new Structure(11, 19, 6, "tellurinamide", null, "[Te](=O)N"), new Structure("sulfonyl", "S(=O)=O").acceptsSubstituents(), new Structure("sulfinyl", "S=O").acceptsSubstituents(), new Structure("selenonyl", "[Se](=O)=O").acceptsSubstituents(), new Structure("seleninyl", "[Se]=O").acceptsSubstituents(), new Aldehyde(0, 0, "carbaldehyde", "formyl", "C(=O)"), new Aldehyde(0, 1, "carbothialdehyde", "methanethioyl", "C(=S)").complex(), new Aldehyde(0, 2, "carboselenaldehyde", "methaneselenoyl", "C(=[Se])").complex(), new Aldehyde(0, 3, "carbotelluraldehyde", "methanetelluroyl", "C(=[Te])").complex(), new Structure(18, 0, 0, "peroxol", "hydroperoxy", "O[OH]").asRadical("dioxidanyl"), new Structure(18, 0, 1, "-OS-thioperoxol", "sulfanyloxy", "OS").complex(), new Structure(18, 0, 2, "-OSe-selenoperoxol", "selanyloxy", "O[Se]").complex(), new Structure(18, 0, 3, "-OTe-telluroperoxol", "tellanyloxy", "O[Te]").complex(), new Structure(18, 0, 4, "-SO-thioperoxol", "hydroxysulfanyl", "[Sv2]O").complex(), new Structure(18, 0, 5, "-SeO-selenoperoxol", "hydroxyselanyl", "[Se]O").complex(), new Structure(18, 0, 6, "-TeO-telluroperoxol", "hydroxytellanyl", "[Te]O").complex(), new Structure(18, 0, 7, "dithioperoxol", "disulfanyl", "SS"), new Structure(18, 0, 8, "-SSe-selenothioperoxol", "selanylsulfanyl", "S[Se]").complex(), new Structure(18, 0, 9, "-STe-tellurothioperoxol", "tellanylsulfanyl", "S[Te]").complex(), new Structure(18, 0, 10, "-SeS-selenothioperoxol", "sulfanylselanyl", "[Se]S").complex(), new Structure(18, 0, 11, "-TeS-tellurothioperoxol", "sulfanyltellanyl", "[Te]S").complex(), new Structure(18, 0, 12, "diselenoperoxol", "diselanyl", "[Se][Se]"), new Structure(18, 0, 13, "-SeTe-selenotelluroperoxol", "tellanylsulfanyl", "[Se][Te]").complex(), new Structure(18, 0, 14, "-TeSe-selenotelluroperoxol", "selanyltellanyl", "[Te][Se]").complex(), new Structure(18, 0, 15, "ditelluroperoxol", "ditellanyl", "[Te][Te]"), new Structure("nitro", "N(=O)=O"), new Structure(5, 0, 1, "nitrile oxide", "oxo-$l^{5}-azanylidyne", "[Nv5](#*)=O").complex().noNeedLocant().rootBond(3), new Structure(5, 0, 2, "imine oxide", "oxo-$l^{5}-azanylidene", "[Nv5](=*)=O").complex().noNeedLocant().rootBond(2), new Structure(5, 0, 3, "amine oxide", "oxo-$l^{5}-azanyl", "[Nv5]=O").complex().noNeedLocant(), new Structure("nitroso", "N=O"), new Structure("phospho", "P(=O)=O"), new Structure("phosphonoyl", "[Pv5;H]=O"), new Structure("phosphoryl", "[Pv5]=O"), new Structure("phosphoroso", "P=O"), new Structure("arso", "[As](=O)=O"), new Structure("arsoryl", "[As;v5]=O"), new Structure("arsoroso", "[As]=O"), new Structure("isocyano", "[N+]#[C-]"), new Structure(14, 0, 0, "carbonitrile", "cyano", "C#N").carbonEating(), new Structure(6, 0, 1, "carbonitrilium", "cyano", "C#[NH+]").carbonEating(), new StatefullStructure(21, 1, 1, "hydroxylamine", null, "NO |$N;O;$|"){
        int substitutions = 0;

        @Override
        boolean checkAllSubstitutions() {
            return true;
        }

        @Override
        boolean checkSubstitutedAtom(MolAtom matchedAtom, MolAtom queryAtom, Molecule target, int[] groupAtoms) {
            return ++this.substitutions < 2;
        }
    }.alwaysParent(), new Structure(16, 0, 8, "one", "oxo", "O=*").rootBond(2), new Structure(4, 2, 8, "olate", "oxido", "[O-]"){

        @Override
        int getCharge() {
            return -1;
        }
    }, new Structure(17, 0, 8, "ol", "hydroxy", "[OH]"), new Structure(17, 0, 9, "thiol", "sulfanyl", "[SH;v2]"), new Structure(17, 0, 10, "selenol", "selanyl", "[SeH;v2]"), new Structure(17, 0, 11, "tellurol", "tellanyl", "[TeH;v2]")};

    GroupDictionary() {
    }

    static class StatefullStructure
    extends Structure
    implements Cloneable {
        StatefullStructure(int suffix1, int suffix2, int suffix3, String suffixName, String prefixName, String query) {
            super(suffix1, suffix2, suffix3, suffixName, prefixName, query);
        }
    }

    static class Structure {
        String prefixName;
        String suffixName;
        String radicalName;
        String turnedRadicalName;
        String turnedPrefixName;
        int suffixJuniority = -1;
        boolean needLocant = true;
        boolean eatCarbon = false;
        boolean complex = false;
        String suffixPrefix;
        boolean acceptsSubstituents = false;
        boolean alwaysParent = false;
        Molecule query;
        private StaticMolecule sQuery;
        boolean ignoreCharge = false;
        boolean ignoreQueryProperties = false;
        int rootBond = 1;
        MolBond doubleBond;

        Structure(String name, String query) {
            this.prefixName = name;
            try {
                MolInputStream mis = new MolInputStream(new ByteArrayInputStream(query.getBytes()));
                MolImporter mi = new MolImporter(mis, "smarts");
                mi.setQueryMode(true);
                this.query = mi.read();
                MolAtom root = this.query.getAtom(0);
                if (root.getRadical() == 0 && root.getImplicitHcount() > 0) {
                    root.setRadical(1);
                    root.setImplicitHcount(root.getImplicitHcount() - 1);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.findDoubleBond();
        }

        Structure(int suffix1, int suffix2, int suffix3, String suffixName, String prefixName, String query) {
            this(prefixName, query);
            this.suffixJuniority = Structure.seniority(suffix1, suffix2, suffix3);
            this.suffixName = suffixName;
        }

        static int seniority(int seniorityClass, int p1, int p2) {
            return (seniorityClass << 24) + (p1 << 16) + (p2 << 8);
        }

        static int seniority(int s1, int s2, int s3, int s4) {
            return (s1 << 24) + (s2 << 16) + (s3 << 8) + s4;
        }

        void setSuffix1(int suffix1) {
            this.suffixJuniority = (suffix1 << 24) + (this.suffixJuniority & 0xFFFFFF);
        }

        int getSuffix1() {
            return this.suffixJuniority >>> 24;
        }

        int getSuffix2() {
            return this.suffixJuniority >>> 16 & 0xFF;
        }

        int getSuffix4() {
            return this.suffixJuniority & 0xFF;
        }

        void setSuffix3(int suffix3) {
            this.suffixJuniority = Structure.seniority(this.getSuffix1(), this.getSuffix2(), suffix3, this.getSuffix4());
        }

        void setSuffix4(int suffix4) {
            this.suffixJuniority |= suffix4;
        }

        StaticMolecule getQuery() {
            if (this.sQuery == null) {
                this.sQuery = new StaticMolecule(this.query);
            }
            return this.sQuery;
        }

        Structure noNeedLocant() {
            this.needLocant = false;
            return this;
        }

        Structure carbonEating() {
            this.eatCarbon = true;
            this.needLocant = false;
            return this;
        }

        Structure complex() {
            this.complex = true;
            return this;
        }

        Structure suffixPrefix(String suffixPrefix) {
            this.suffixPrefix = suffixPrefix;
            return this;
        }

        Structure acceptsSubstituents() {
            this.acceptsSubstituents = true;
            return this;
        }

        Structure alwaysParent() {
            this.alwaysParent = true;
            return this;
        }

        Structure turned(String turnedPrefixName) {
            this.turnedPrefixName = turnedPrefixName;
            return this;
        }

        public String toString() {
            if (this.suffixName != null) {
                return this.suffixName;
            }
            return this.prefixName;
        }

        Structure cloneIfNeeded(Molecule wholePart) {
            if (this instanceof Cloneable) {
                try {
                    Structure res = (Structure)this.clone();
                    res.setMolecule(wholePart);
                    return res;
                }
                catch (CloneNotSupportedException e) {
                    throw new RuntimeException(e);
                }
            }
            return this;
        }

        void setMolecule(Molecule wholePart) {
        }

        final boolean checkMatchedAtom(MolAtom matchedAtom, MolAtom queryAtom) {
            int matchedValence;
            int queryValence = queryAtom.getValenceProp();
            if (this.prefixName == "sulfinyl" && queryAtom == this.query.getAtom(0)) {
                queryValence = 4;
            }
            if (queryValence > 0 && (matchedValence = matchedAtom.getValence() + matchedAtom.getRadicalCount()) != queryValence) {
                return false;
            }
            return this.specificCheckMatchedAtom(matchedAtom, queryAtom);
        }

        boolean specificCheckMatchedAtom(MolAtom matchedAtom, MolAtom queryAtom) {
            int queryH = queryAtom.getQPropAsInt("H");
            return queryH <= 0 || Chem.getHCount(matchedAtom) >= queryH;
        }

        boolean checkSubstitutedAtom(MolAtom matchedAtom, MolAtom queryAtom, Molecule target, int[] groupAtoms) {
            if (queryAtom.getAliasstr() != null) {
                return true;
            }
            return matchedAtom.getAtno() == 7;
        }

        boolean checkRadical(MolAtom matched, MolAtom queryAtom) {
            if (this.prefixName == null) {
                return false;
            }
            return this.suffixName != "guanidine" || !"2".equals(queryAtom.getAliasstr());
        }

        String getPrefix() {
            return null;
        }

        boolean isAcceptable() {
            return true;
        }

        boolean needsLocants() {
            return true;
        }

        int getCharge() {
            return 0;
        }

        boolean canHaveSubstituents() {
            return true;
        }

        boolean checkAllSubstitutions() {
            return false;
        }

        Structure asRadical(String radicalName) {
            this.radicalName = radicalName;
            return this;
        }

        Structure asTurnedRadical(String radicalName) {
            this.turnedRadicalName = radicalName;
            return this;
        }

        Structure rootBond(int type) {
            this.rootBond = type;
            return this;
        }

        private void findDoubleBond() {
            int i = this.query.getBondCount();
            while (--i >= 0) {
                MolBond b = this.query.getBond(i);
                if (b.getType() != 2) continue;
                this.doubleBond = b;
            }
        }
    }
}

