/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameexport;

import chemaxon.marvin.io.formats.name.nameexport.GroupDictionary;
import chemaxon.marvin.io.formats.name.nameexport.IUPACNamer;
import chemaxon.marvin.io.formats.name.nameexport.Util;
import chemaxon.marvin.modules.SubstructureSearch;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;

public class GroupSearch {
    private Molecule m;
    private SubstructureSearch sss;
    int current = -1;
    private boolean fullMatchOnly;
    private static int searches = 0;
    private static int matches = 0;

    GroupSearch(Molecule m) {
        if (searches++ > 4000) {
            this.tooComplex();
        }
        this.m = m;
        this.sss = new SubstructureSearch();
        this.sss.setTarget(m);
        this.fullMatchOnly = this.isHomogeneous(m);
    }

    static void resetStats() {
        matches = 0;
        searches = 0;
    }

    static void printStats() {
        System.out.println("Searches: " + searches);
        System.out.println("Matches:  " + matches);
    }

    void tooComplex() {
        throw new IUPACNamer.UnsupportedError("The structure is too complex to be named");
    }

    boolean findNext() {
        if (matches++ > 10000) {
            this.tooComplex();
        }
        return this.findNextPossiblyOverlapping();
    }

    private boolean findNextPossiblyOverlapping() {
        if (this.current == -1) {
            this.setQuery(GroupDictionary.structures[++this.current]);
            if (this.findFirst()) {
                return true;
            }
        } else if (this.sss.findNext()) {
            return true;
        }
        do {
            if (++this.current == GroupDictionary.structures.length) {
                return false;
            }
            this.setQuery(GroupDictionary.structures[this.current]);
        } while (!this.findFirst());
        return true;
    }

    void setQuery(GroupDictionary.Structure query) {
        this.sss.setIgnoreCharge(query.ignoreCharge);
        this.sss.setIgnoreQueryProperties(query.ignoreQueryProperties);
        this.sss.setQuery(query.getQuery());
    }

    boolean findFirst() {
        if (this.fullMatchOnly && GroupDictionary.structures[this.current].query.getAtomCount() != this.m.getAtomCount()) {
            return false;
        }
        return this.sss.findFirst();
    }

    GroupDictionary.Structure getMatch() {
        return GroupDictionary.structures[this.current];
    }

    int[] getMatchedAtoms() {
        return this.sss.getResult();
    }

    int getMatchRoot() {
        if (this.getMatch().eatCarbon) {
            return this.getMatchStart();
        }
        int res = -1;
        int[] group = this.sss.getResult();
        int start = group[0];
        MolAtom a = this.m.getAtom(start);
        int i = a.getBondCount();
        while (--i >= 0) {
            MolAtom neighbour = a.getLigand(i);
            int n = this.m.indexOf(neighbour);
            int index = Util.indexOf(n, group);
            if (index == 1 && this.getMatch().query.getAtom(index).getAtno() == 131) {
                return n;
            }
            if (index != -1) continue;
            if (res == -1) {
                res = n;
                continue;
            }
            return -2;
        }
        return res;
    }

    int getMatchStart() {
        return this.sss.getResult()[0];
    }

    Molecule getQuery() {
        return GroupDictionary.structures[this.current].query;
    }

    boolean isHomogeneous(Molecule m) {
        int atno = m.getAtom(0).getAtno();
        int i = m.getAtomCount();
        while (--i >= 1) {
            if (m.getAtom(i).getAtno() == atno) continue;
            return false;
        }
        return true;
    }
}

