/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameexport;

import chemaxon.common.util.IntVector;
import chemaxon.marvin.io.formats.name.nameexport.BenzoHeterocycle;
import chemaxon.marvin.io.formats.name.nameexport.Chain;
import chemaxon.marvin.io.formats.name.nameexport.Chem;
import chemaxon.marvin.io.formats.name.nameexport.GeneralSpiroNamer;
import chemaxon.marvin.io.formats.name.nameexport.Options;
import chemaxon.marvin.io.formats.name.nameexport.SimplePart;
import chemaxon.marvin.io.formats.name.nameexport.Util;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.PeriodicSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;

public class HeteroAnalyser {
    SimplePart carbon;
    boolean completeName = false;
    private static final Comparator<HeteroAtom> locantComparator = new Comparator<HeteroAtom>(){

        @Override
        public int compare(HeteroAtom h1, HeteroAtom h2) {
            int loc2;
            int loc1 = Util.getNumber(h1.location);
            int diff = loc1 - (loc2 = Util.getNumber(h2.location));
            if (diff != 0) {
                return diff;
            }
            diff = h1.prime - h2.prime;
            if (diff != 0) {
                return diff;
            }
            return 0;
        }
    };
    private static final Comparator<HeteroAtom> seniorityComparator = new Comparator<HeteroAtom>(){

        @Override
        public int compare(HeteroAtom h1, HeteroAtom h2) {
            return Chem.seniority(h2.atno) - Chem.seniority(h1.atno);
        }
    };
    private static final Comparator<HeteroAtom> nonStandardBondingComparator = new Comparator<HeteroAtom>(){

        @Override
        public int compare(HeteroAtom h1, HeteroAtom h2) {
            if (h1.radical || h2.radical) {
                return 0;
            }
            return HeteroAnalyser.lambdaValence(h2.atom) - HeteroAnalyser.lambdaValence(h1.atom);
        }
    };

    HeteroAnalyser(SimplePart carbon) {
        this.carbon = carbon;
    }

    String print(int[] descriptor, int[] numbering) {
        HeteroAtom[] heteroAtoms = HeteroAnalyser.findSortedHeteroAtoms(this.carbon.originalMolecule, numbering, null);
        boolean isHetero = heteroAtoms.length > 0;
        StringBuffer res = new StringBuffer();
        if (this.carbon.ignoreHeteroAtoms() && !(this.carbon instanceof BenzoHeterocycle)) {
            if (this.hasLambda(heteroAtoms) || this.carbon.printHeteroLocations(heteroAtoms)) {
                this.printHeteroAtomLocations(heteroAtoms, false, res);
            }
            return res.toString();
        }
        if (this.homogeneousOrAlternating(descriptor, numbering, heteroAtoms, isHetero, res)) {
            this.completeName = true;
            return res.toString();
        }
        if (this.carbon instanceof BenzoHeterocycle) {
            HeteroAnalyser.nameBenzoHeteroAtoms(heteroAtoms, false, res);
        } else {
            HeteroAnalyser.nameHeteroAtoms(heteroAtoms, false, !this.carbon.needsLocants() && (!isHetero || this.carbon.modifiers.substituents == null), res);
        }
        return res.toString();
    }

    private boolean homogeneousOrAlternating(int[] descriptor, int[] numbering, HeteroAtom[] heteroAtoms, boolean isHetero, StringBuffer res) {
        int heteros = heteroAtoms.length;
        if (heteros <= 1 || heteros != this.carbon.getAtomCount() || this.carbon.ignoreHeteroAtoms()) {
            return false;
        }
        if (heteroAtoms[0].atno == heteroAtoms[heteroAtoms.length - 1].atno) {
            int atno = heteroAtoms[0].atno;
            HeteroAnalyser.addLambdas(heteroAtoms, numbering, null, res);
            res.append(this.carbon.nameDescriptor(descriptor, numbering, true, true));
            res.append(Chem.greek(heteros));
            String base = Chem.aSuffixForAtom(atno);
            if (base == null) {
                res.append(PeriodicSystem.getName(atno).toLowerCase());
            } else {
                res.append(base);
                res.append("ne");
            }
            return true;
        }
        int middle = 0;
        for (int i = 1; i < heteroAtoms.length; ++i) {
            if (heteroAtoms[i].atno == heteroAtoms[middle].atno) continue;
            if (middle == 0) {
                middle = i;
                continue;
            }
            return false;
        }
        int otherAtno = heteroAtoms[middle].atno;
        for (int a = 0; a < heteros; ++a) {
            MolAtom atom = heteroAtoms[a].atom;
            int i = atom.getBondCount();
            while (--i >= 0) {
                if (a == middle) {
                    otherAtno = heteroAtoms[0].atno;
                }
                if (atom.getLigand(i).getAtno() == otherAtno) continue;
                return false;
            }
        }
        if (Chem.standardValence(heteroAtoms[0].atno) >= 3 && Chem.standardValence(heteroAtoms[middle].atno) >= 3 && !(this.carbon instanceof Chain)) {
            res.append('1').append(PeriodicSystem.getSymbol(this.carbon.getAtom(Util.indexOf(1, numbering)).getAtno())).append('-');
        }
        res.append(this.carbon.nameDescriptor(descriptor, numbering, isHetero, true));
        res.append(Chem.greek(heteros - middle));
        res.append(Chem.aPrefixForAtom(heteroAtoms[middle].atno));
        Util.appendRemovingVowel(Chem.aPrefixForAtom(heteroAtoms[0].atno), res);
        res.append("ne");
        return true;
    }

    static boolean hasHeteroAtoms(MoleculeGraph m) {
        int i = m.getAtomCount();
        while (--i >= 0) {
            if (m.getAtom(i).getAtno() == 6) continue;
            return true;
        }
        return false;
    }

    static boolean nameHeteroAtoms(Molecule m, int[] numbering, int[] primes, boolean brackets, StringBuffer res) {
        HeteroAtom[] heteroAtoms = HeteroAnalyser.findSortedHeteroAtoms(m, numbering, primes);
        HeteroAnalyser.nameHeteroAtoms(heteroAtoms, brackets, false, res);
        return heteroAtoms.length > 0;
    }

    int[] heteroAtomLocations(int[] numbering, int[] primes) {
        HeteroAtom[] heteroAtoms = HeteroAnalyser.findSortedHeteroAtoms(this.carbon.originalMolecule, numbering, primes, primes == null);
        return this.heteroAtomLocations(heteroAtoms);
    }

    static int[][][] bestHeteroResults(Molecule m, int[][][] results) {
        return HeteroAnalyser.bestHeteroResults(m, null, results);
    }

    static int[][][] bestHeteroResults(Molecule m, MolAtom radical, int[][][] results) {
        ArrayList<int[][]> res = new ArrayList<int[][]>(results.length);
        int[][] best = results[0];
        res.add(best);
        HeteroAtom[] haBest = HeteroAnalyser.findHeteroAtoms(m, best[1], null, radical);
        for (int i = 1; i < results.length; ++i) {
            int[][] current = results[i];
            HeteroAtom[] ha = HeteroAnalyser.findHeteroAtoms(m, current[1], null, radical);
            int diff = HeteroAnalyser.compareHeteroAtoms(haBest, ha);
            if (diff < 0) continue;
            if (diff > 0) {
                res.clear();
                best = current;
                haBest = ha;
            }
            res.add(current);
        }
        return Util.intArrayArrayArray(res);
    }

    static int compareHeteroAtoms(HeteroAtom[] ha1, HeteroAtom[] ha2) {
        int res = Util.pointToPointComparison(ha1, ha2, locantComparator);
        if (res != 0) {
            return res;
        }
        res = Util.pointToPointComparison(ha1, ha2, seniorityComparator);
        if (res != 0) {
            return res;
        }
        res = Util.pointToPointComparison(ha1, ha2, nonStandardBondingComparator);
        return res;
    }

    static HeteroAtom[] findHeteroAtoms(Molecule carbon, int[] numbering, int[] primes) {
        return HeteroAnalyser.findHeteroAtoms(carbon, numbering, primes, null);
    }

    static HeteroAtom[] findHeteroAtoms(Molecule carbon, int[] numbering, int[] primes, MolAtom radical) {
        return HeteroAnalyser.findHeteroAtoms(carbon, numbering, primes, radical, true);
    }

    static HeteroAtom[] findSortedHeteroAtoms(Molecule carbon, int[] numbering, int[] primes) {
        return HeteroAnalyser.findSortedHeteroAtoms(carbon, numbering, primes, true);
    }

    static HeteroAtom[] findSortedHeteroAtoms(Molecule carbon, int[] numbering, int[] primes, boolean global) {
        HeteroAtom[] res = HeteroAnalyser.findHeteroAtoms(carbon, numbering, primes, null, global);
        Arrays.sort(res, seniorityComparator);
        return res;
    }

    static HeteroAtom[] findHeteroAtoms(Molecule carbon, int[] numbering, int[] primes, MolAtom radical, boolean global) {
        int len = carbon.getAtomCount();
        ArrayList<HeteroAtom> heteroAtoms = new ArrayList<HeteroAtom>(len);
        for (int i = 0; i < len; ++i) {
            MolAtom a = carbon.getAtom(i);
            if (a.getAtno() == 6 || a.getAtno() > 109) continue;
            int prime = primes == null ? 0 : primes[i];
            boolean retained = GeneralSpiroNamer.getBit(prime, 1);
            boolean spiro = GeneralSpiroNamer.getBit(prime, 2);
            if (global && retained && !spiro || !global && !retained) continue;
            prime = GeneralSpiroNamer.decode2(prime);
            heteroAtoms.add(new HeteroAtom(a, numbering[i], prime, retained, spiro, a == radical));
        }
        HeteroAtom[] res = heteroAtoms.toArray(new HeteroAtom[heteroAtoms.size()]);
        Arrays.sort(res, locantComparator);
        return res;
    }

    private static boolean nameHeteroAtom(HeteroAtom atom, boolean canOmit, StringBuffer res) {
        if (canOmit && atom.prime == 0 && !HeteroAnalyser.hasLambda(atom)) {
            return false;
        }
        res.append(Util.locant(atom.location));
        int prime = atom.prime;
        while (prime-- > 0) {
            res.append('\'');
        }
        int valence = HeteroAnalyser.lambdaValence(atom.atom);
        if (valence > 0) {
            HeteroAnalyser.printLambda(valence, res);
        }
        return true;
    }

    static void printLambda(int valence, StringBuffer res) {
        if (Options.unicode) {
            res.append('\u03bb').append(Util.unicodeSuperscriptNumber(valence));
        } else {
            res.append("$l^{").append(valence).append('}');
        }
    }

    static void nameHeteroAtoms(HeteroAtom[] atoms, boolean brackets, boolean canOmitLocant, StringBuffer res) {
        for (int i = 0; i < atoms.length; ++i) {
            if (atoms[i].retained && !HeteroAnalyser.hasLambda(atoms[i])) continue;
            if (res.length() > 0) {
                Util.appendDash(res);
            }
            if (brackets) {
                res.append('[');
            }
            boolean done = HeteroAnalyser.nameHeteroAtom(atoms[i], canOmitLocant && atoms.length == 1, res);
            int count = 1;
            while (!(i + 1 >= atoms.length || atoms[i + 1].atno != atoms[i].atno || Chem.hasNonStandardBondingNumber(atoms[i].atom) && Chem.hasNonStandardBondingNumber(atoms[i + 1].atom) && atoms[i + 1].atom.getValence() != atoms[i].atom.getValence())) {
                res.append(',');
                HeteroAnalyser.nameHeteroAtom(atoms[++i], false, res);
                ++count;
            }
            if (done) {
                res.append(brackets ? (char)']' : '-');
            }
            if (atoms[i].retained) continue;
            if (count > 1) {
                res.append(Chem.greek(count));
            }
            res.append(Chem.aPrefixForAtom(atoms[i].atno));
        }
    }

    private static void nameBenzoHeteroAtoms(HeteroAtom[] atoms, boolean brackets, StringBuffer res) {
        if (atoms.length == 0) {
            return;
        }
        if (brackets) {
            res.append('[');
        }
        for (int i = 0; i < atoms.length; ++i) {
            if (i > 0) {
                res.append(',');
            }
            HeteroAnalyser.nameHeteroAtom(atoms[i], false, res);
        }
        res.append(brackets ? (char)']' : '-');
    }

    int[] heteroAtomLocations(HeteroAtom[] atoms) {
        IntVector r = new IntVector();
        for (int i = 0; i < atoms.length; ++i) {
            int valence;
            HeteroAtom atom = atoms[i];
            r.add(!this.carbon.needsLocants() ? 0 : atom.location);
            if (atom.global || (valence = HeteroAnalyser.lambdaValence(atom.atom)) <= 0) continue;
            r.add(-valence);
        }
        return r.toArray();
    }

    void printHeteroAtomLocations(HeteroAtom[] atoms, boolean bracket, StringBuffer to) {
        HeteroAnalyser.printHeteroAtomLocations(this.heteroAtomLocations(atoms), bracket, to);
    }

    static void printHeteroAtomLocations(int[] locations, boolean bracket, StringBuffer to) {
        if (bracket) {
            to.append('[');
        }
        for (int i = 0; i < locations.length; ++i) {
            if (i > 0) {
                to.append(',');
            }
            if (locations[i] != 0) {
                to.append(Util.locant(locations[i]));
            }
            if (i + 1 >= locations.length || locations[i + 1] >= 0) continue;
            HeteroAnalyser.printLambda(-locations[++i], to);
        }
        to.append(bracket ? (char)']' : '-');
    }

    static void heteroNamePrefix(HeteroAtom[] atoms, boolean hantzschWidman, StringBuffer res) {
        for (int i = 0; i < atoms.length; ++i) {
            int count = 1;
            while (i + 1 < atoms.length && atoms[i + 1].atno == atoms[i].atno) {
                ++i;
                ++count;
            }
            if (count > 1) {
                res.append(Chem.greek(count));
            }
            String name = Chem.aPrefixForAtom(atoms[i].atno, hantzschWidman);
            Util.appendRemovingDoubleVowel(name, res);
        }
    }

    boolean hasLambda(HeteroAtom[] atoms) {
        int i = atoms.length;
        while (--i >= 0) {
            if (atoms[i].global || !HeteroAnalyser.hasLambda(atoms[i])) continue;
            return true;
        }
        return false;
    }

    private static boolean hasLambda(HeteroAtom atom) {
        return HeteroAnalyser.lambdaValence(atom.atom) > 0;
    }

    static int lambdaValence(MolAtom atom) {
        int atno = atom.getAtno();
        if (PeriodicSystem.isMetal(atno)) {
            return -1;
        }
        int valence = Chem.getRealValence(atom);
        int stdValence = Chem.standardValence(atno);
        if (stdValence < 0) {
            return -1;
        }
        if (valence != stdValence) {
            return valence;
        }
        return -1;
    }

    static void addLambdas(Molecule m, int[] numbering, int[] primes, StringBuffer res) {
        HeteroAtom[] atoms = HeteroAnalyser.findHeteroAtoms(m, numbering, primes, null, true);
        HeteroAnalyser.addLambdas(atoms, numbering, primes, res);
    }

    static void addLambdas(HeteroAtom[] atoms, int[] numbering, int[] primes, StringBuffer res) {
        int count = 0;
        for (int i = 0; i < atoms.length; ++i) {
            if (!HeteroAnalyser.hasLambda(atoms[i])) continue;
            if (count++ == 0) {
                if (res.length() > 0) {
                    Util.appendDash(res);
                }
            } else {
                res.append(',');
            }
            HeteroAnalyser.nameHeteroAtom(atoms[i], false, res);
        }
        if (count > 0) {
            res.append('-');
        }
    }

    private static void displaySolution(Molecule m, int[] descriptor, int[] numbering) {
        int mainRingLength = descriptor[0] + descriptor[1] + 2;
        int[] selected = new int[mainRingLength];
        int n = 0;
        for (int i = 0; i < numbering.length; ++i) {
            if (0 >= numbering[i] || numbering[i] > mainRingLength) continue;
            selected[n++] = i;
        }
        Util.displayNumbering(m, numbering);
    }

    static boolean hantzschWidmann(Molecule m) {
        int i = m.getAtomCount();
        while (--i >= 0) {
            int z = m.getAtom(i).getAtno();
            if (z == 6 || Chem.aPrefixForAtom(z, true, false) != null) continue;
            return false;
        }
        return true;
    }

    static class HeteroAtom {
        MolAtom atom;
        int atno;
        int location;
        int prime;
        boolean global;
        boolean retained;
        boolean radical;

        HeteroAtom(MolAtom atom, int location, int prime, boolean retained, boolean global, boolean radical) {
            this.atom = atom;
            this.atno = atom.getAtno();
            this.location = location;
            this.prime = prime;
            this.global = global;
            this.retained = retained;
            this.radical = radical;
        }

        public String toString() {
            return this.atom.getSymbol() + "@" + this.location;
        }
    }
}

