/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameexport;

import chemaxon.common.util.IntVector;
import chemaxon.common.util.LongVector;
import chemaxon.marvin.io.formats.name.nameexport.Acyclic;
import chemaxon.marvin.io.formats.name.nameexport.Canonicalizer;
import chemaxon.marvin.io.formats.name.nameexport.Chain;
import chemaxon.marvin.io.formats.name.nameexport.CharacteristicGroup;
import chemaxon.marvin.io.formats.name.nameexport.Chem;
import chemaxon.marvin.io.formats.name.nameexport.GeneralSpiroNamer;
import chemaxon.marvin.io.formats.name.nameexport.GroupMatch;
import chemaxon.marvin.io.formats.name.nameexport.HeteroAnalyser;
import chemaxon.marvin.io.formats.name.nameexport.IUPACNamer;
import chemaxon.marvin.io.formats.name.nameexport.Monocycle;
import chemaxon.marvin.io.formats.name.nameexport.NamingCentral;
import chemaxon.marvin.io.formats.name.nameexport.NumberingComparator;
import chemaxon.marvin.io.formats.name.nameexport.Options;
import chemaxon.marvin.io.formats.name.nameexport.Part;
import chemaxon.marvin.io.formats.name.nameexport.SaturationAnalyser;
import chemaxon.marvin.io.formats.name.nameexport.SimpleGroup;
import chemaxon.marvin.io.formats.name.nameexport.SubmoleculeBuilder;
import chemaxon.marvin.io.formats.name.nameexport.Substituent;
import chemaxon.marvin.io.formats.name.nameexport.Util;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.PeriodicSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

class Modifiers
extends NumberingComparator {
    Part part;
    private ArrayList saturatedAtomGroups = new ArrayList();
    private int[] saturatedAtoms = null;
    private IntVector hydro;
    private IntVector indicated;
    IntVector bonds2 = new IntVector();
    IntVector bonds3 = new IntVector();
    IntVector chiralAtoms = new IntVector();
    ArrayList substituents;
    private String retainedNameAndSuffix;
    private String fullRetainedName;
    ArrayList suffixes = new ArrayList();
    private List<Isotope> isotopes;
    private static final int EZ = -2;
    String toPrintBefore = null;
    boolean hasDetachedSubstituent = false;
    int endingLocant = -1;
    private String ending = null;
    private boolean omitSuffixLocant = false;
    ArrayList<CharacteristicGroup> suffixGroups;
    int endingCount = 0;
    int[] suffixLocants;
    String suffixPrefix;
    int suffixPrefixStart;
    boolean noBrackets = false;
    int rootBondStereo;
    boolean rootBondDescribedInParent;
    int indirectSubstituents = 0;

    Modifiers(Part part) {
        this.part = part;
    }

    Substituent substituent(int index) {
        return (Substituent)this.substituents.get(index);
    }

    void addSaturatedAtoms(int[] saturatedAtoms) {
        this.saturatedAtomGroups.add(saturatedAtoms);
    }

    void addHydro(int locant) {
        this.hydro.add(locant);
    }

    void addIndicatedHydrogen(int locant) {
        Util.insertSorted(locant, this.indicated);
    }

    void addBond(int type, int atom1, int atom2) {
        IntVector bonds;
        if (type == 2) {
            bonds = this.bonds2;
        } else if (type == 3) {
            bonds = this.bonds3;
        } else {
            if (type == 4) {
                if (NamingCentral.foreignCall) {
                    return;
                }
                throw new RuntimeException("The structure could not be dearomatized");
            }
            throw new RuntimeException("Unhandled bond type: " + type);
        }
        bonds.add(atom1);
        bonds.add(atom2);
    }

    void addChiralAtom(int chirality) {
        this.addChiralAtom(-899, chirality);
    }

    void addChiralAtom(int atom, int chirality) {
        if (chirality == 0) {
            return;
        }
        this.chiralAtoms.add(atom);
        this.chiralAtoms.add(chirality);
    }

    void addCumulativeSuffix(int atom, String suffix) {
        if (suffix == null) {
            return;
        }
        this.suffixes.add(new Suffix(atom, suffix));
    }

    void addIsotope(int atom, int isotope) {
        this.addIsotope(atom, this.part.getAtom(atom).getAtno(), isotope);
    }

    void addIsotope(int locant, int atno, int massno) {
        Isotope isotope = new Isotope();
        isotope.atno = atno;
        isotope.massno = massno;
        if (this.isotopes == null) {
            this.isotopes = new ArrayList<Isotope>();
            this.isotopes.add(isotope);
        } else {
            int index = Collections.binarySearch(this.isotopes, isotope);
            if (index >= 0) {
                isotope = this.isotopes.get(index);
            } else {
                index = -(index + 1);
                this.isotopes.add(index, isotope);
            }
        }
        isotope.locations.add(locant);
    }

    int[] getAllIstopeLocants() {
        IntVector res = new IntVector();
        for (Isotope i : this.isotopes) {
            res.addAll(i.locations);
        }
        return res.toArray();
    }

    int[] getAllIstopeLocants(int[] numbering, int[] primes) {
        IntVector res = new IntVector();
        for (Isotope i : this.isotopes) {
            int[] locants = Util.locants(numbering, primes, i.locations.toArray());
            Arrays.sort(locants);
            res.addAll(new IntVector(locants));
        }
        return res.toArray();
    }

    int numberOfBonds() {
        if (this.part.ignoreBonds()) {
            return 0;
        }
        return (this.bonds2.size() + this.bonds3.size()) / 2;
    }

    boolean hasNoBonds() {
        return this.numberOfBonds() == 0;
    }

    boolean isEmpty() {
        return this.saturatedAtomGroups.isEmpty() && this.hasNoBonds() && this.substituents == null && this.ending == null && this.retainedNameAndSuffix == null && this.suffixes.isEmpty() && this.chiralAtoms.isEmpty() && this.isotopes == null;
    }

    boolean noLocatedSubstituents() {
        if (this.substituents == null) {
            return true;
        }
        int i = this.substituents.size();
        while (--i >= 0) {
            if (this.substituent((int)i).root < 0) continue;
            return false;
        }
        return true;
    }

    boolean hasAlwaysLocatedSubstituents() {
        if (this.substituents == null) {
            return false;
        }
        int i = this.substituents.size();
        while (--i >= 0) {
            Substituent s = this.substituent(i);
            if (s.isDetached() || (s.root >= 0 || s.root == -899) && s.extraLocant == null) continue;
            return true;
        }
        return false;
    }

    boolean needsSubstituentLocants() {
        if (this.hasAlwaysLocatedSubstituents()) {
            return true;
        }
        return this.part.needsLocants();
    }

    public void findSuffixGroup(Molecule m, IntVector roots, ArrayList substituents) {
        int bestJuniority = Integer.MAX_VALUE;
        if (this.ending == null && this.part.canHaveSuffix()) {
            Part substituent;
            int i = substituents.size();
            while (--i >= 0) {
                int juniority;
                substituent = (Part)substituents.get(i);
                if (substituent == null || this.suffixes.size() > 0 && !substituent.hasCharge() || (juniority = substituent.suffixJuniority()) <= 0 || juniority > bestJuniority) continue;
                this.endingCount = juniority < bestJuniority ? 1 : ++this.endingCount;
                bestJuniority = juniority;
            }
            i = substituents.size();
            while (--i >= 0) {
                substituent = (Part)substituents.get(i);
                if (substituent == null || substituent.suffixJuniority() != bestJuniority) continue;
                CharacteristicGroup suffixGroup = (CharacteristicGroup)substituent;
                if (this.suffixGroups == null) {
                    this.suffixGroups = new ArrayList();
                }
                this.suffixGroups.add(suffixGroup);
                GroupMatch.setOwners(suffixGroup.atoms, this.part);
                if (!suffixGroup.eatCarbon) continue;
                if (this.endingCount <= 2) {
                    suffixGroup.eatCarbon = false;
                    continue;
                }
                if (suffixGroup.alternateRoot == null) continue;
                roots.set(i, Util.indexOf(suffixGroup.alternateRoot, ((Chain)this.part).originalChain));
            }
        }
        this.rewriteSystematicSubstituents(roots, substituents);
        this.rewriteSuffix();
    }

    void findSuffixGroup() {
        if (this.substituents == null) {
            return;
        }
        if (!this.part.canHaveSuffix()) {
            return;
        }
        int bestJuniority = Integer.MAX_VALUE;
        for (Substituent s : this.substituents) {
            int juniority;
            Part substituent = s.part;
            if (this.suffixes.size() > 0 && !substituent.hasCharge() || (juniority = substituent.suffixJuniority()) <= 0 || juniority > bestJuniority) continue;
            this.endingCount = juniority < bestJuniority ? 1 : ++this.endingCount;
            bestJuniority = juniority;
        }
        IntVector suffixLocants = null;
        int i = this.substituents.size();
        while (--i >= 0) {
            Substituent s = (Substituent)this.substituents.get(i);
            Part substituent = s.part;
            int juniority = substituent.suffixJuniority();
            if (juniority != bestJuniority) continue;
            this.substituents.remove(i);
            CharacteristicGroup suffixGroup = (CharacteristicGroup)substituent;
            if (this.suffixGroups == null) {
                this.suffixGroups = new ArrayList();
            }
            this.suffixGroups.add(suffixGroup);
            GroupMatch.setOwners(suffixGroup.atoms, this.part);
            this.addSuffixSubstituents(suffixGroup, s.root, suffixLocants == null ? 0 : suffixLocants.count(s.root));
            if (!s.hasRoot) continue;
            if (suffixLocants == null) {
                suffixLocants = new IntVector();
            }
            suffixLocants.add(s.root);
        }
        if (suffixLocants != null) {
            this.registerSuffix();
            this.suffixLocants = suffixLocants.toArray();
        }
    }

    private void addSuffixSubstituents(CharacteristicGroup g, int groupRoot, int groupRank) {
        this.addChiralAtom(Chem.getChirality(g.radical));
        if (g.ezBond != null) {
            this.addBond(2, -2, Canonicalizer.getStereo(g.ezBond.getAtom1(), g.ezBond.getAtom2()));
        }
        if (g.substituents == null) {
            return;
        }
        int s = g.substituents.length;
        while (--s >= 0) {
            int locant;
            Part p = g.substituents[s];
            if (p.isHydrogen()) continue;
            g.substituents[s] = null;
            String label = p.root.getExtraLabel();
            if (label == null && !this.hasUnlocatedSuffix()) {
                label = p.root.getSymbol();
            }
            String extraLocant = null;
            if (label == null) {
                locant = Part.heteroLocant(p.root);
            } else if (this.endingCount == 1) {
                locant = Util.groupLocant(label);
            } else {
                locant = groupRoot;
                extraLocant = label;
                if (label != " ") {
                    extraLocant = extraLocant + Util.primes(groupRank);
                }
            }
            this.addSubstituent(true, locant, extraLocant, p);
            ++this.indirectSubstituents;
        }
    }

    void rewriteSystematicSubstituents(IntVector roots, ArrayList substituents) {
        int i = substituents.size();
        while (--i >= 0) {
            CharacteristicGroup g;
            if (!(substituents.get(i) instanceof CharacteristicGroup) || this.isSuffix(g = (CharacteristicGroup)substituents.get(i)) || g.group == null || g.prefixName != null) continue;
            int a = g.atoms.length;
            while (--a >= 0) {
                g.atoms[a].clearExtraLabel();
            }
            if (g.alternateRoot == null) {
                Part systematic = new Acyclic(g.originalMolecule, null, g.root, g.radical, NamingCentral.topologyAnalyser).branch();
                substituents.set(i, systematic);
                continue;
            }
            int root = roots.remove(i);
            substituents.remove(i);
            int neighb = g.root.getBondCount();
            while (--neighb >= 0) {
                MolAtom start = g.root.getLigand(neighb);
                if (start == g.alternateRoot) continue;
                Part systematic = new Acyclic(g.originalMolecule, null, g.root, start, NamingCentral.topologyAnalyser).branch();
                roots.add(root);
                substituents.add(systematic);
            }
        }
    }

    boolean isSuffix(CharacteristicGroup g) {
        return this.suffixGroups != null && this.suffixGroupsJuniority() == g.suffixJuniority();
    }

    void addSubstituents(int[] roots, Part[] substituents) {
        int bestJuniority = Integer.MAX_VALUE;
        IntVector suffixLocants = null;
        if (this.suffixGroups != null) {
            bestJuniority = this.suffixGroupsJuniority();
            if (roots != null) {
                suffixLocants = new IntVector();
            }
        }
        int i = substituents.length;
        while (--i >= 0) {
            Part substituent = substituents[i];
            if (substituent == null) continue;
            if (substituent.suffixJuniority() == bestJuniority) {
                CharacteristicGroup g = (CharacteristicGroup)substituent;
                this.addSuffixSubstituents(g, roots == null ? -1 : roots[i], suffixLocants == null ? 0 : suffixLocants.count(roots[i]));
                if (suffixLocants == null) continue;
                suffixLocants.add(roots[i]);
                continue;
            }
            String extraLocant = substituent.root == null ? null : substituent.root.getExtraLabel();
            this.addSubstituent(true, roots == null ? -899 : roots[i], extraLocant, substituent);
        }
        if (this.suffixGroups != null) {
            this.registerSuffix();
            this.addSuffixPrefix();
        }
        if (suffixLocants != null && suffixLocants.size() > 0) {
            this.suffixLocants = suffixLocants.toArray();
        }
        this.part.resetPrefixName();
    }

    private boolean hasGeminal(Part[] substituents, int bestJuniority, int[] roots) {
        if (substituents.length < 2) {
            return false;
        }
        IntVector suffixLocants = new IntVector();
        int i = substituents.length;
        while (--i >= 0) {
            Part substituent = substituents[i];
            if (substituent == null || substituent.suffixJuniority() != bestJuniority) continue;
            if (suffixLocants.indexOf(roots[i]) != -1) {
                return true;
            }
            suffixLocants.add(roots[i]);
        }
        return false;
    }

    void addSubstituent(int root, Part substituent) {
        this.addSubstituent(true, root, null, substituent);
    }

    void addPrefix(final String prefix) {
        this.addSubstituent(false, 0, null, new Part(null){

            @Override
            String getName() {
                return prefix;
            }
        });
    }

    private void addSubstituent(boolean hasRoot, int root, String extraLocant, Part substituent) {
        int isotope;
        if (substituent.isHydrogen() && (isotope = substituent.getAtom(0).getMassno()) != 0) {
            this.addIsotope(root, 1, isotope);
            return;
        }
        substituent.setParent(this.part);
        if (root == -900) {
            extraLocant = " ";
        } else if (root == -899 && Util.groupLocant(extraLocant) != null) {
            root = Util.groupLocant(extraLocant);
        } else {
            hasRoot |= root < 0;
            hasRoot &= root != -899;
        }
        hasRoot &= root >= 0 || extraLocant != " ";
        if (this.substituents == null) {
            this.substituents = new ArrayList();
        }
        this.substituents.add(new Substituent(substituent, this, root, hasRoot, extraLocant));
        this.part.resetPrefixName();
    }

    List<String> getSubstituents() {
        if (this.substituents == null) {
            return Collections.emptyList();
        }
        this.rewriteSubstituents();
        if (this.substituents == null) {
            return Collections.emptyList();
        }
        Substituent.sort(this.substituents);
        ArrayList<String> substituentNames = new ArrayList<String>(this.substituents.size());
        for (int i = 0; i < this.substituents.size(); ++i) {
            substituentNames.add(this.substituent(i).getName());
        }
        return substituentNames;
    }

    private void rewriteSuffix() {
        if (this.suffixGroups == null) {
            return;
        }
        if (this.endingCount == 1 && this.part.isBenzene() && this.suffixGroup(0).isAmine()) {
            SimpleGroup amine = (SimpleGroup)this.suffixGroup(0);
            if (amine.getGroupCharge() == 0) {
                this.retainedNameAndSuffix = "aniline";
            } else if (amine.getGroupCharge() == 1) {
                this.retainedNameAndSuffix = "anilinium";
            } else if (amine.getGroupCharge() == -1) {
                this.retainedNameAndSuffix = "anilinide";
            }
        }
    }

    private void rewriteSubstituents() {
        String substituentName;
        if (this.suffixGroups == null && this.ending == null && this.part.isBenzene() && this.substituents != null && this.substituents.size() == 1 && (substituentName = ((Substituent)this.substituents.get(0)).getName()).equals("methoxy")) {
            this.fullRetainedName = "anisole";
        }
        this.rewriteChainSubstituents();
        this.removeIndirectSubstituents();
        this.findSubstituentsNamedAsSuffixes();
        if (this.substituents != null && this.substituents.size() == 0) {
            this.substituents = null;
        }
    }

    private void rewriteChainSubstituents() {
        if (!(this.part instanceof Chain)) {
            return;
        }
        if (this.suffixGroups == null || this.suffixLocants != null && this.suffixLocants.length > 1) {
            return;
        }
        Iterator it = this.substituents.iterator();
        while (it.hasNext()) {
            Substituent substituent = (Substituent)it.next();
            if (substituent.part.root != this.suffixGroup((int)0).root || substituent.getName() != "oxo") continue;
            it.remove();
            this.setEnding("oyl" + this.suffixGroup(0).getName());
        }
    }

    private void removeIndirectSubstituents() {
        Substituent substituent;
        int i = this.substituents.size();
        while (--i >= 0) {
            substituent = this.substituent(i);
            substituent.part.removeSubstituents(this.substituents);
        }
        i = this.substituents.size();
        while (--i >= 0) {
            substituent = this.substituent(i);
            if (!substituent.toRemove) continue;
            this.substituents.remove(i);
        }
    }

    private void findSubstituentsNamedAsSuffixes() {
        if (this.suffixGroups != null) {
            return;
        }
        if (this.ending == "yl" && this.part instanceof Chain && this.part.radical.getAtno() == 6) {
            int radical = this.part.originalMolecule.indexOf(this.part.radical);
            int i = this.substituents.size();
            while (--i >= 0) {
                Substituent s = this.substituent(i);
                if (s.root != radical) continue;
                String name = s.getName();
                String newEnding = null;
                if (name.equals("oxo")) {
                    newEnding = "oyl";
                } else if (name.equals("sulfanylidene")) {
                    newEnding = "thioyl";
                } else if (name.equals("imino")) {
                    newEnding = "imidoyl";
                } else if (name.equals("hydrazinylidene")) {
                    newEnding = "hydrazonoyl";
                } else if (name.equals("selanylidene")) {
                    newEnding = "selenoyl";
                } else if (name.equals("telluranylidene")) {
                    newEnding = "telluroyl";
                }
                if (newEnding == null) continue;
                this.substituents.remove(i);
                this.ending = newEnding;
                this.omitSuffixLocant = true;
            }
        }
    }

    static String preSuffix(String suffix) {
        if (!suffix.startsWith("(")) {
            return null;
        }
        int close = suffix.indexOf(41, 1);
        if (close == -1) {
            return null;
        }
        return suffix.substring(0, close + 1);
    }

    void registerSuffix() {
        String suffix = this.suffixGroup(0).getSuffixName();
        String preSuffix = Modifiers.preSuffix(suffix);
        String string = suffix = preSuffix == null ? suffix : suffix.substring(preSuffix.length());
        if (this.canRemoveCarboFromSuffix() && suffix.startsWith("carb")) {
            if ((suffix = suffix.intern()) == "carboxylic acid") {
                suffix = "oic acid";
            } else if (suffix == "carboxylic acidium") {
                suffix = "oic acidium";
            } else if (suffix == "carboxylate") {
                suffix = "oate";
            } else if (suffix == "carbaldehyde") {
                suffix = "al";
            } else if (suffix == "carbothialdehyde" || suffix == "carboselenaldehyde" || suffix == "carbotelluraldehyde") {
                suffix = suffix.substring(5, suffix.length() - 6);
            } else if (suffix == "carboximidic acid") {
                suffix = "imidic acid";
            } else if (suffix == "carbohydrazonic acid") {
                suffix = "hydrazonic acid";
            } else if (suffix == "carboperoxoic acid") {
                suffix = "peroxoic acid";
            } else if (suffix == "carbothioic S-acid") {
                suffix = "thioic S-acid";
            } else if (suffix == "carbothioic O-acid") {
                suffix = "thioic O-acid";
            } else if (suffix == "carboselenothioic S-acid") {
                suffix = "selenothioic S-acid";
            } else if (suffix == "carbodithioic acid") {
                suffix = "dithioic acid";
            } else if (suffix == "carboimidothioic acid") {
                suffix = "imidothioic acid";
            } else if (suffix == "carboxamide") {
                suffix = "amide";
            } else if (suffix == "carboxamidium") {
                suffix = "amidium";
            } else if (suffix == "carboxamidylium") {
                suffix = "amidylium";
            } else if (suffix == "carboximidamide") {
                suffix = "imidamide";
            } else if (suffix.startsWith("carbo") && (suffix.endsWith("acid") || suffix.endsWith("amide") || suffix.endsWith("hydrazide") || suffix.endsWith("oate") || suffix.startsWith("carbonitril"))) {
                suffix = suffix.substring(5);
            } else if (suffix.startsWith("carbonyl") && suffix.endsWith("ide")) {
                suffix = 'o' + suffix.substring(6);
            }
        }
        this.setEnding(-1, preSuffix == null ? suffix : preSuffix + suffix);
    }

    private boolean canRemoveCarboFromSuffix() {
        if (this.endingCount > 2 || !(this.part instanceof Chain)) {
            return false;
        }
        MolAtom[] chain = ((Chain)this.part).originalChain;
        int i = chain.length;
        while (--i >= 0) {
            if (chain[i].getAtno() != 6) continue;
            return true;
        }
        return false;
    }

    private void addSuffixPrefix() {
        String head;
        String suffixPrefix;
        String string = suffixPrefix = this.suffixGroup((int)0).group == null ? null : this.suffixGroup((int)0).group.suffixPrefix;
        if (suffixPrefix == null) {
            return;
        }
        if (this.endingCount == 1) {
            this.suffixPrefix = suffixPrefix;
            return;
        }
        if (suffixPrefix.startsWith("N-")) {
            head = "N";
            suffixPrefix = suffixPrefix.substring(2);
        } else {
            head = null;
        }
        StringBuffer res = new StringBuffer();
        if (head != null) {
            for (int i = 0; i < this.endingCount; ++i) {
                if (i > 0) {
                    res.append(',');
                }
                res.append(head).append(Util.primes(i));
            }
            res.append('-');
        }
        res.append(Chem.diMultiplier(this.endingCount)).append(suffixPrefix);
        this.suffixPrefix = res.toString();
    }

    void sortMultipleSubstituents(int[] locants) {
        List<String> substituents = this.getSubstituents();
        int i = 0;
        while (i < substituents.size()) {
            String name = substituents.get(0);
            int start = i;
            while (++i < substituents.size() && name.equals(substituents.get(i))) {
            }
            Arrays.sort(locants, start, i);
        }
    }

    @Override
    int compare(int[] numbering1, int[] numbering2) {
        return this.compare(numbering1, null, numbering2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int compare(int[] numbering1, int[] primes1, int[] numbering2, int[] primes2) {
        long[] positions2;
        int diff;
        if (this.saturatedAtoms == null) {
            this.saturatedAtoms = Util.flatten(this.saturatedAtomGroups);
        }
        int[] saturatedLocants1 = Util.locants(numbering1, primes1, this.saturatedAtoms);
        int[] saturatedLocants2 = Util.locants(numbering2, primes2, this.saturatedAtoms);
        if (Options.minimizeSaturatedAtomsFirst && (diff = this.compareIndicatedHydrogen(saturatedLocants1, saturatedLocants2)) != 0) {
            return diff;
        }
        diff = this.compareRadicalLocants(numbering1, primes1, numbering2, primes2);
        if (diff != 0) {
            return diff;
        }
        if (!this.suffixes.isEmpty()) {
            int[] locants2;
            int[] atoms = this.getSuffixAtomsInLocantPriorityOrder();
            int[] locants1 = this.getLocants(numbering1, primes1, atoms);
            diff = Util.setComparison(locants1, locants2 = this.getLocants(numbering2, primes2, atoms));
            if (diff != 0) {
                return diff;
            }
            diff = Util.pointToPointComparison(locants1, locants2);
            if (diff != 0) {
                return diff;
            }
        }
        if ((diff = this.compareSuffixLocants(numbering1, primes1, numbering2, primes2)) != 0) {
            return diff;
        }
        long[] positions1 = this.getPositions(numbering1, primes1);
        diff = (int)(-positions1[0] + (positions2 = this.getPositions(numbering2, primes2))[0]);
        if (diff != 0) {
            return diff;
        }
        diff = Util.setComparison(positions1, positions2);
        if (diff != 0) {
            return diff;
        }
        positions1 = this.getPositions2(numbering1, primes1);
        diff = Util.setComparison(positions1, positions2 = this.getPositions2(numbering2, primes2));
        if (diff != 0) {
            return diff;
        }
        if (Options.minimizeSaturatedAtomsFirst) {
            diff = Util.setComparison(saturatedLocants1, saturatedLocants2);
            if (diff != 0) {
                return diff;
            }
            if (primes1 != null && (diff = Util.setComparison(Util.apply(primes1, this.saturatedAtoms), Util.apply(primes2, this.saturatedAtoms))) != 0) {
                return diff;
            }
        }
        this.getSubstituents();
        if (this.substituents != null) {
            List extraLocants2;
            int[] s2;
            int[] substituents = Substituent.getSortedRoots(this.substituents);
            int[] s1 = Util.locants(numbering1, primes1, substituents);
            diff = Util.orderedComparison(s1, s2 = Util.locants(numbering2, primes2, substituents));
            if (diff != 0) {
                return diff;
            }
            this.sortMultipleSubstituents(s1);
            this.sortMultipleSubstituents(s2);
            diff = Util.pointToPointComparison(s1, s2);
            if (diff != 0) {
                return diff;
            }
            List extraLocants1 = this.sortExtraLocants(s1, numbering1);
            diff = Util.alphabeticalPointToPointComparison(extraLocants1, extraLocants2 = this.sortExtraLocants(s2, numbering2));
            if (diff != 0) {
                return diff;
            }
        }
        if (this.isotopes != null) {
            int[] isotopeLocants = this.getAllIstopeLocants();
            diff = Util.orderedComparison(Util.locants(numbering1, primes1, isotopeLocants), Util.locants(numbering2, primes2, isotopeLocants));
            if (diff != 0) {
                return diff;
            }
            Isotope.sortForLocants = true;
            try {
                Collections.sort(this.isotopes);
                diff = Util.pointToPointComparison(this.getAllIstopeLocants(numbering1, primes1), this.getAllIstopeLocants(numbering2, primes2));
                if (diff != 0) {
                    int s1 = diff;
                    return s1;
                }
            }
            finally {
                Isotope.sortForLocants = false;
                Collections.sort(this.isotopes);
            }
        }
        int[][] stereoDescriptors1 = this.getStereoDescriptors(numbering1, primes1);
        int[][] stereoDescriptors2 = this.getStereoDescriptors(numbering2, primes2);
        int[] locants1 = stereoDescriptors1[0];
        int[] locants2 = stereoDescriptors2[0];
        int[] descriptors1 = stereoDescriptors1[1];
        int[] descriptors2 = stereoDescriptors2[1];
        diff = Util.pointToPointComparison(locants1, locants2);
        if (diff != 0) {
            return diff;
        }
        diff = Util.pointToPointComparison(descriptors1, descriptors2);
        if (diff != 0) {
            return diff;
        }
        if (!Options.minimizeSaturatedAtomsFirst) {
            diff = this.compareIndicatedHydrogen(saturatedLocants1, saturatedLocants2);
            if (diff != 0) {
                return diff;
            }
            diff = Util.setComparison(saturatedLocants1, saturatedLocants2);
            if (diff != 0) {
                return diff;
            }
            if (primes1 != null && (diff = Util.setComparison(Util.apply(primes1, this.saturatedAtoms), Util.apply(primes2, this.saturatedAtoms))) != 0) {
                return diff;
            }
        }
        return 0;
    }

    private int[] getSuffixAtomsInLocantPriorityOrder() {
        IntVector res = new IntVector();
        int i = this.suffixes.size();
        while (--i >= 0) {
            Suffix s = (Suffix)this.suffixes.get(i);
            if (s.suffix == "ylium" || s.suffix == "uide") {
                res.add(0, s.atom);
                continue;
            }
            res.add(s.atom);
        }
        return res.toArray();
    }

    private int compareIndicatedHydrogen(int[] saturatedLocants1, int[] saturatedLocants2) {
        if (this.saturatedAtoms.length % 2 == 1) {
            Arrays.sort(saturatedLocants1);
            Arrays.sort(saturatedLocants2);
            return saturatedLocants1[0] - saturatedLocants2[0];
        }
        return 0;
    }

    private int compareRadicalLocants(int[] numbering1, int[] primes1, int[] numbering2, int[] primes2) {
        if (this.ending != null && this.endingLocant >= 0) {
            return Util.locant(this.endingLocant, numbering1, primes1) - Util.locant(this.endingLocant, numbering2, primes2);
        }
        return 0;
    }

    private int compareSuffixLocants(int[] numbering1, int[] primes1, int[] numbering2, int[] primes2) {
        if (this.suffixGroups != null && this.suffixLocants != null) {
            int[] l1 = Util.locants(numbering1, primes1, this.suffixLocants);
            int[] l2 = Util.locants(numbering2, primes2, this.suffixLocants);
            return Util.setComparison(l1, l2);
        }
        return 0;
    }

    List sortExtraLocants(int[] locants, int[] numbering) {
        ArrayList<String> res = new ArrayList<String>();
        for (int i = 0; i < locants.length; ++i) {
            int locant = locants[i];
            if (locant < 0) continue;
            locant = Util.getNumber(locant);
            int s = this.substituents.size();
            while (--s >= 0) {
                Substituent sub = this.substituent(s);
                if (sub.root < 0 || numbering[sub.root] != locant) continue;
                res.add(sub.extraLocant);
            }
        }
        return res;
    }

    long[] getPositions2(int[] numbering, int[] primes) {
        return this.getPositions(this.bonds2, numbering, primes, false);
    }

    long[] getPositions(int[] numbering, int[] primes) {
        return this.getAllPositions(this.bonds2, this.bonds3, numbering, primes);
    }

    void analyseSaturatedAtoms(int[] numbering, int[] primes) {
        this.hydro = new IntVector();
        this.indicated = new IntVector();
        if (this.saturatedAtomGroups.size() == 0) {
            return;
        }
        for (int[] saturatedAtoms : this.saturatedAtomGroups) {
            int[] locants = Util.locants(numbering, primes, saturatedAtoms);
            Arrays.sort(locants);
            if (this.part.noHydro() && !SaturationAnalyser.isSaturated(this.part.originalMolecule)) {
                for (int i = 0; i < locants.length; ++i) {
                    this.addIndicatedHydrogen(locants[i]);
                }
                break;
            }
            int start = saturatedAtoms.length % 2;
            if (locants.length > 1) {
                for (int i = start; i < locants.length; ++i) {
                    this.addHydro(locants[i]);
                }
            }
            if (start != 1) continue;
            this.addIndicatedHydrogen(locants[0]);
        }
    }

    boolean printPrefix(int[] numbering, int[] primes, StringBuffer res) {
        StringBuffer stereo;
        boolean printBefore;
        if (this.fullRetainedName != null) {
            res.append(this.fullRetainedName);
            return true;
        }
        if (this.suffixPrefix != null) {
            this.suffixPrefixStart = res.length();
            res.append(this.suffixPrefix);
        }
        StringBuffer mainPrefixes = new StringBuffer();
        String groupPrefix = null;
        if (this.suffixGroups != null) {
            groupPrefix = this.suffixGroup(0).getPrefix();
        } else if (this.part instanceof CharacteristicGroup) {
            groupPrefix = ((CharacteristicGroup)this.part).getPrefix();
        }
        if (groupPrefix != null) {
            mainPrefixes.append(groupPrefix);
        }
        if ((printBefore = this.printStereoDescriptors(numbering, primes, stereo = new StringBuffer())) && stereo.length() > 0) {
            this.toPrintBefore = stereo.toString();
        } else {
            mainPrefixes.append(stereo);
        }
        this.printSubstituents(numbering, primes, mainPrefixes.toString(), res);
        this.analyseSaturatedAtoms(numbering, primes);
        if (this.hydro.size() > 0) {
            Util.appendDash(res);
            int len = this.hydro.size();
            if (!SaturationAnalyser.isSaturated(this.part.originalMolecule)) {
                this.hydro.sort();
                int[] hydro = this.hydro.toArray();
                for (int i = 0; i < len; ++i) {
                    if (i > 0) {
                        res.append(',');
                    }
                    res.append(Util.locant(hydro[i]));
                }
                res.append('-');
            }
            res.append(Chem.diMultiplier(len)).append("hydro");
        }
        if (this.printIsotopes(numbering, primes, res)) {
            return true;
        }
        if (this.indicated.size() > 0) {
            Util.appendDash(res);
            int[] indicated = this.indicated.toArray();
            for (int i = 0; i < indicated.length; ++i) {
                if (i > 0) {
                    res.append(',');
                }
                res.append(Util.locant(indicated[i]));
                res.append('H');
            }
            res.append('-');
        }
        if (this.retainedNameAndSuffix == null) {
            return false;
        }
        res.append(this.retainedNameAndSuffix);
        return true;
    }

    boolean printIsotopes(int[] numbering, int[] primes, StringBuffer res) {
        if (this.isotopes == null) {
            return false;
        }
        res.append('(');
        boolean first = true;
        for (Isotope i : this.isotopes) {
            int[] locants;
            if (!first) {
                res.append(',');
            } else {
                first = false;
            }
            if (numbering != null && this.part.needsLocants(locants = Util.locants(numbering, primes, i.locations.toArray()), i.atno == 1)) {
                Arrays.sort(locants);
                Util.printLocants(locants, res);
                res.append('-');
            }
            res.append(i);
            if (i.locations.size() <= 1 && (i.atno != 1 || !this.hasSeveralH(i.locations.get(0))) && (!(this.part instanceof CharacteristicGroup) || !((CharacteristicGroup)this.part).hasSeveral(i.atno))) continue;
            res.append(Util.unicodeSubscriptNumber(i.locations.size()));
        }
        res.append(')');
        return this.part.isHydrogen();
    }

    private boolean hasSeveralH(int location) {
        if (location < 0 || this.part.originalMolecule == null) {
            return false;
        }
        MolAtom atAtom = SubmoleculeBuilder.originalAtom(this.part.getAtom(location));
        return Chem.getHCount(atAtom) > 1;
    }

    private int[][] getStereoDescriptors(int[] numbering, int[] primes) {
        IntVector locants = new IntVector();
        IntVector descriptors = new IntVector();
        boolean canOmitChiralLocants = !this.part.needsLocants();
        int i = 0;
        while (i < this.chiralAtoms.size()) {
            int atom = this.chiralAtoms.get(i++);
            int chirality = this.chiralAtoms.get(i++);
            int locant = canOmitChiralLocants ? 0 : this.getLocant(numbering, primes, atom, chirality);
            int rank = Util.insertSorted(locant, locants);
            descriptors.add(rank, Chem.chiralStereoConstant(chirality));
        }
        boolean canOmitBondLocants = this.part.ignoreBonds() || this.noBondLocant();
        long[] positions = this.getPositions(this.bonds2, numbering, primes, true);
        for (int i2 = 0; i2 < positions.length; ++i2) {
            long position = positions[i2];
            int locant1 = canOmitBondLocants ? 0 : (int)(position >> 33);
            int mark = (int)position & 3;
            if (mark == 0) continue;
            int stereo = mark == 2 ? 0 : 1;
            int rank = Util.insertSorted(locant1, locants);
            descriptors.add(rank, stereo);
        }
        return new int[][]{locants.toArray(), descriptors.toArray()};
    }

    boolean printStereoDescriptors(int[] numbering, int[] primes, StringBuffer to) {
        boolean res = true;
        int start = to.length();
        int[][] locantsAndDescriptors = this.getStereoDescriptors(numbering, primes);
        int[] locants = locantsAndDescriptors[0];
        int[] descriptors = locantsAndDescriptors[1];
        for (int i = 0; i < locants.length; ++i) {
            String desc;
            boolean relativeStereo;
            int locant;
            String l;
            if (i == 0) {
                to.append('(');
            }
            if ((l = Util.locant(locant = locants[i])) != "") {
                to.append(l);
                res = false;
            }
            if (relativeStereo = (desc = Chem.stereoDescriptorString(descriptors[i])).endsWith("*")) {
                if (NamingCentral.relativeStereoSwapRS == 0) {
                    int n = NamingCentral.relativeStereoSwapRS = desc == "R*" ? 1 : 2;
                }
                if (NamingCentral.relativeStereoSwapRS == 2) {
                    desc = desc == "R*" ? "S*" : "R*";
                }
            }
            if (relativeStereo && NamingCentral.isAllRelativeStereo()) {
                desc = desc.substring(0, 1);
            }
            to.append(desc);
            if (i == locants.length - 1) {
                to.append(")-");
                continue;
            }
            to.append(',');
        }
        return res;
    }

    void printSubstituents(int[] numbering, StringBuffer res) {
        this.printSubstituents(numbering, null, null, res);
    }

    void printSubstituents(int[] numbering, int[] primes, String mainPrefixes, StringBuffer res) {
        List<String> substituents = this.getSubstituents();
        if (!this.needsSubstituentLocants()) {
            numbering = null;
        }
        int i = 0;
        int firstNonDetached = 0;
        boolean useParenthesesAroundNonLocated = false;
        int Nprimes = -1;
        int lastHeteroLocant = 0;
        ListIterator<String> it = this.getSubstituents().listIterator();
        while (it.hasNext()) {
            int locant;
            int start = i;
            int repeat = 1;
            String name = it.next();
            IntVector locants = null;
            ArrayList<String> extraLocants = null;
            if (this.substituent((int)i).extraLocant != null) {
                extraLocants = new ArrayList<String>();
                extraLocants.add(this.substituent((int)i).extraLocant);
            }
            while (it.hasNext()) {
                int index;
                int locant2;
                String nextName = it.next();
                if (!nextName.equals(name) || this.substituent(start).isDetached() != this.substituent(i + 1).isDetached()) {
                    it.previous();
                    break;
                }
                ++i;
                ++repeat;
                if (!this.substituent((int)start).hasRoot) continue;
                if (locants == null && (locant2 = this.getLocant(numbering, primes, index = this.substituent((int)(i - 1)).root)) != 0) {
                    locants = new IntVector();
                    locants.add(locant2);
                }
                if ((locant2 = this.getLocant(numbering, primes, index = this.substituent((int)i).root)) == 0) continue;
                index = Util.insertSorted(locant2, locants);
                if (this.substituent((int)i).extraLocant == null) continue;
                if (extraLocants == null) {
                    extraLocants = new ArrayList();
                }
                Util.addNulls(extraLocants, index - 1);
                extraLocants.add(index, this.substituent((int)i).extraLocant);
            }
            boolean addParenthesis = false;
            boolean addSpace = false;
            int beforeSubstituents = res.length();
            if (locants == null) {
                int root = this.substituent((int)start).root;
                if (numbering == null && (root >= 0 || root == -899)) {
                    if (extraLocants != null && extraLocants.get(0) != null) {
                        for (int j = 0; j < repeat; ++j) {
                            String extraLocant = this.substituent((int)(start + j)).extraLocant;
                            if (extraLocant == null) continue;
                            if (extraLocant == " ") {
                                addSpace = true;
                                continue;
                            }
                            if (j > 0) {
                                res.append(',');
                            } else if (start > firstNonDetached) {
                                res.append('-');
                            }
                            res.append(extraLocant);
                        }
                        if (!addSpace) {
                            res.append('-');
                        }
                    } else if (start >= firstNonDetached) {
                        addParenthesis = useParenthesesAroundNonLocated;
                        useParenthesesAroundNonLocated = !useParenthesesAroundNonLocated;
                    }
                } else if (root < 0) {
                    String locant3 = Util.groupLocantString(root);
                    if (locant3 == null) {
                        if (root != lastHeteroLocant) {
                            lastHeteroLocant = root;
                            ++Nprimes;
                        }
                        locant3 = Part.heteroSymbol(root) + Util.primes(Nprimes);
                    }
                    if (locant3 == " ") {
                        addSpace = true;
                    } else if (locant3 != "") {
                        if (start > firstNonDetached) {
                            res.append('-');
                        }
                        res.append(locant3).append('-');
                    }
                } else if (numbering != null) {
                    if (i > firstNonDetached) {
                        res.append('-');
                    }
                    locant = this.getLocant(numbering, primes, root);
                    res.append(Util.locant(locant)).append('-');
                    if (extraLocants != null && extraLocants.get(0) != null) {
                        if (extraLocants.get(0) == " ") {
                            addSpace = true;
                        } else {
                            res.append((String)extraLocants.get(0)).append('-');
                        }
                    }
                }
            } else if (locants.size() != substituents.size() || this.part.needsLocants(locants.toArray(), true) || extraLocants != null) {
                if (start > firstNonDetached) {
                    res.append('-');
                }
                if (extraLocants != null) {
                    Util.addNulls(extraLocants, locants.size() - 1);
                }
                for (int l = 0; l < locants.size(); ++l) {
                    if (l > 0) {
                        res.append(',');
                    }
                    if ((locant = locants.get(l)) < 0) {
                        String label = Util.groupLocantString(locant);
                        if (label != null) {
                            res.append(label);
                            continue;
                        }
                        if (locant != lastHeteroLocant) {
                            lastHeteroLocant = locant;
                            ++Nprimes;
                        }
                        res.append(Part.heteroSymbol(locant)).append(Util.primes(Nprimes));
                        continue;
                    }
                    res.append(Util.locant(locant));
                    if (extraLocants == null || extraLocants.get(l) == null) continue;
                    if (extraLocants.get(l) == " ") {
                        addSpace = true;
                        continue;
                    }
                    res.append('-').append((String)extraLocants.get(l));
                }
                res.append('-');
            }
            if (mainPrefixes != null && !addSpace) {
                res.insert(beforeSubstituents, mainPrefixes);
                mainPrefixes = null;
            }
            if (repeat > 1) {
                if (this.hasParentheses(name)) {
                    res.append(Chem.complexMultiplier(repeat));
                    addParenthesis = false;
                } else if (name == "tert-butyl") {
                    res.append(Chem.diMultiplier(repeat)).append('-');
                } else if (this.needsParentheses(name)) {
                    res.append(Chem.complexMultiplier(repeat));
                    name = Util.parenthesize(name);
                    addParenthesis = false;
                } else {
                    res.append(Chem.diMultiplier(repeat));
                    addParenthesis = false;
                }
            } else if (addParenthesis && !this.hasParentheses(name)) {
                res.append('(');
            } else {
                addParenthesis = false;
            }
            res.append(name);
            if (addParenthesis) {
                res.append(')');
            } else if (addSpace) {
                this.hasDetachedSubstituent = true;
                res.append(' ');
                firstNonDetached = i + 1;
            }
            ++i;
        }
        if (mainPrefixes != null) {
            res.append(mainPrefixes);
        }
    }

    private int getLocant(int[] numbering, int[] primes, int index, int chirality) {
        if (chirality == 256 || chirality == 128) {
            block0: while (true) {
                MolAtom a = this.part.getAtom(index);
                for (MolAtom neighbour : a.getLigands()) {
                    int indexN;
                    if (a.getBondTo(neighbour).getType() != 2 || (indexN = this.part.indexOf(neighbour)) < 0 || this.getLocant(numbering, primes, indexN) >= this.getLocant(numbering, primes, index)) continue;
                    index = indexN;
                    continue block0;
                }
                break;
            }
        }
        return this.getLocant(numbering, primes, index);
    }

    private int getLocant(int[] numbering, int[] primes, int index) {
        if (index < 0) {
            return index;
        }
        if (numbering == null) {
            return 0;
        }
        int p = primes == null ? 0 : GeneralSpiroNamer.decode2(primes[index]);
        return Util.locant(numbering[index], p);
    }

    private int[] getLocants(int[] numbering, int[] primes, int[] indexes) {
        int[] res = new int[indexes.length];
        int i = res.length;
        while (--i >= 0) {
            res[i] = this.getLocant(numbering, primes, indexes[i]);
        }
        return res;
    }

    boolean hasParentheses(String substituent) {
        char start = substituent.charAt(0);
        return start == '(' || start == '[';
    }

    boolean needsParentheses(String substituent) {
        if (substituent.startsWith("dec")) {
            return true;
        }
        return substituent.indexOf(45) != -1;
    }

    long position(int atom1, int atom2, int[] numbering, int[] primes, long[] compound, int mark) {
        int locant2;
        int locant1;
        if (atom1 == -2) {
            return 0L;
        }
        if (numbering != null) {
            locant1 = this.getLocant(numbering, primes, atom1);
            locant2 = this.getLocant(numbering, primes, atom2);
        } else {
            locant2 = 0;
            locant1 = 0;
        }
        if (locant2 < locant1) {
            int tmp = locant2;
            locant2 = locant1;
            locant1 = tmp;
        }
        if (compound != null && !Modifiers.consecutive(locant1, locant2)) {
            compound[0] = compound[0] - 1L;
        }
        if (mark != 0) {
            mark = mark == 128 ? 2 : 3;
        }
        long res = (long)locant1 << 33 | ((long)locant2 & Integer.MAX_VALUE) << 2 | (long)mark;
        return res;
    }

    static int getBondStereo(MolBond b) {
        return Canonicalizer.getStereo(b.getAtom1(), b.getAtom2());
    }

    long[] getPositions(IntVector bonds, int[] numbering, int[] primes, boolean cistrans) {
        int len = bonds.size() / 2;
        LongVector positions = new LongVector();
        for (int i = 0; i < len; ++i) {
            int atom1 = bonds.get(i * 2);
            int atom2 = bonds.get(i * 2 + 1);
            if (atom1 == -2) {
                if (!cistrans) continue;
                positions.add(this.position(0, 0, null, null, null, atom2));
                continue;
            }
            Molecule m = this.part.originalMolecule;
            MolAtom a1 = m.getAtom(atom1);
            MolAtom a2 = m.getAtom(atom2);
            int mark = this.part.isShortRing() ? 0 : Canonicalizer.getStereo(a1, a2);
            if (cistrans && !Modifiers.cisOrTrans(mark)) continue;
            positions.add(this.position(atom1, atom2, numbering, primes, null, mark));
        }
        if (cistrans && !this.rootBondDescribedInParent && Modifiers.cisOrTrans(this.rootBondStereo)) {
            int radicalIndex = this.part.getRadicalIndex();
            positions.add(this.position(radicalIndex, radicalIndex, numbering, primes, null, this.rootBondStereo));
        }
        if (cistrans && this.substituents != null) {
            for (Substituent s : this.substituents) {
                int mark = s.part.getParentRootBondStereo();
                if (!Modifiers.cisOrTrans(mark)) continue;
                positions.add(this.position(s.root, s.root, numbering, primes, null, mark));
            }
        }
        if (cistrans && this.suffixGroups != null) {
            int i = this.suffixGroups.size();
            while (--i >= 0) {
                int mark = this.suffixGroup(i).getParentRootBondStereo();
                if (!Modifiers.cisOrTrans(mark)) continue;
                positions.add(this.position(this.suffixLocants[i], this.suffixLocants[i], numbering, primes, null, mark));
            }
        }
        long[] res = positions.toArray();
        Arrays.sort(res);
        return res;
    }

    static boolean cisOrTrans(int mark) {
        return mark == 128 || mark == 64;
    }

    long[] getAllPositions(IntVector bondsA, IntVector bondsB, int[] numbering, int[] primes) {
        int atom1;
        int atom2;
        long[] positions = new long[(bondsA.size() + bondsB.size()) / 2 + 1];
        int n = 1;
        int i = bondsA.size();
        while (i > 0) {
            atom2 = bondsA.get(--i);
            atom1 = bondsA.get(--i);
            positions[n++] = this.position(atom1, atom2, numbering, primes, positions, 0);
        }
        i = bondsB.size();
        while (i > 0) {
            atom2 = bondsB.get(--i);
            atom1 = bondsB.get(--i);
            positions[n++] = this.position(atom1, atom2, numbering, primes, positions, 0);
        }
        Arrays.sort(positions);
        return positions;
    }

    String[] orderBonds(IntVector bonds, int[] numbering, int[] primes) {
        long[] positions = this.getPositions(bonds, numbering, primes, false);
        int len = positions.length;
        String[] res = new String[len];
        for (int i = 0; i < len; ++i) {
            long position = positions[i];
            int locant1 = (int)(position >> 33);
            int locant2 = (int)(position >> 2 & Integer.MAX_VALUE);
            if (locant2 >= 0x40000000) {
                locant2 -= Integer.MIN_VALUE;
            }
            res[i] = this.bondString(locant1, locant2);
        }
        return res;
    }

    String bondString(int locant1, int locant2) {
        int n1 = Util.getNumber(locant1);
        int n2 = Util.getNumber(locant2);
        int prime1 = Util.getPrime(locant1);
        int prime2 = Util.getPrime(locant2);
        String rep1 = Integer.toString(n1);
        if (prime1 > 0) {
            rep1 = rep1 + Util.primes(prime1);
        }
        String rep2 = Integer.toString(n2);
        if (prime2 > 0) {
            rep2 = rep2 + Util.primes(prime2);
        }
        if (Modifiers.consecutive(locant1, locant2)) {
            return rep1;
        }
        return rep1 + "(" + rep2 + ")";
    }

    static boolean consecutive(int locant1, int locant2) {
        return Util.getNumber(locant2) == Util.getNumber(locant1) + 1 && Util.getPrime(locant1) == Util.getPrime(locant2);
    }

    private boolean noBondLocant() {
        int nBonds = this.numberOfBonds();
        if (nBonds == 0) {
            return false;
        }
        if (nBonds == 1 && this.suffixes.isEmpty() && this.part.originalMolecule.getBondCount() == 1) {
            return true;
        }
        return !this.part.needsLocants();
    }

    void printSuffix(int[] numbering, int[] primes, boolean ellide, boolean isHetero, StringBuffer res) {
        if (!this.part.needsLocants()) {
            numbering = null;
        }
        if (this.noBondLocant()) {
            String current = res.toString();
            res.append(this.bonds2.size() > 0 ? "ene" : "yne");
            this.printEnding(numbering, primes, false, isHetero, res);
            return;
        }
        if (!ellide && (this.bonds2.size() > 2 || this.bonds2.size() == 0 && this.bonds3.size() > 2)) {
            res.append('a');
        }
        int suffix = res.length();
        if (this.numberOfBonds() > 0) {
            this.printBonds(numbering, primes, res);
        }
        if (ellide && Util.startsWithVowel(res, suffix)) {
            res.deleteCharAt(suffix - 2);
        }
        this.printSuffixes(numbering, primes, res);
        this.printEnding(numbering, primes, true, isHetero, res);
    }

    private void printBonds(int[] numbering, int[] primes, StringBuffer res) {
        int i;
        String[] enes;
        int count;
        if (!this.bonds2.isEmpty() && (count = (enes = this.orderBonds(this.bonds2, numbering, primes)).length) > 0) {
            res.append('-');
            for (i = 0; i < count; ++i) {
                res.append(enes[i]);
                if (i + 1 >= count) continue;
                res.append(',');
            }
            res.append('-');
            res.append(Chem.diMultiplier(count));
            if (this.bonds3.size() == 0) {
                res.append("ene");
            } else {
                res.append("en");
            }
        }
        if ((count = this.bonds3.size() / 2) > 0) {
            res.append('-');
            String[] ynes = this.orderBonds(this.bonds3, numbering, primes);
            for (i = 0; i < count; ++i) {
                res.append(ynes[i]);
                if (i + 1 >= count) continue;
                res.append(',');
            }
            res.append('-');
            res.append(Chem.diMultiplier(count));
            res.append("yne");
        }
    }

    boolean needSuffixesLocants() {
        if (this.suffixes == null || this.suffixes.isEmpty()) {
            return false;
        }
        if (this.ending == null && this.suffixes.size() == 1 && this.part instanceof Chain && ((Chain)this.part).length() <= 2) {
            return false;
        }
        return this.part.needsLocants();
    }

    void printSuffixes(final int[] numbering, final int[] primes, StringBuffer res) {
        if (this.suffixes.isEmpty()) {
            return;
        }
        boolean needLocants = this.needSuffixesLocants();
        if (this.suffixes.size() > 1) {
            Collections.sort(this.suffixes, new Comparator(){

                public int compare(Object o1, Object o2) {
                    Suffix s1 = (Suffix)o1;
                    Suffix s2 = (Suffix)o2;
                    int diff = this.rank(s1.suffix) - this.rank(s2.suffix);
                    if (diff != 0) {
                        return diff;
                    }
                    if (numbering == null) {
                        return 0;
                    }
                    diff = primes == null ? numbering[s1.atom] - numbering[s2.atom] : Util.locant(numbering[s1.atom], primes[s1.atom]) - Util.locant(numbering[s2.atom], primes[s2.atom]);
                    return diff;
                }

                private int rank(String suffix) {
                    if (suffix == "ium") {
                        return 1;
                    }
                    if (suffix == "ylium") {
                        return 2;
                    }
                    if (suffix == "ide") {
                        return 3;
                    }
                    if (suffix == "uide") {
                        return 4;
                    }
                    throw new IUPACNamer.Failure("Unknown suffix: " + suffix);
                }
            });
        }
        ListIterator it = this.suffixes.listIterator();
        while (it.hasNext()) {
            Suffix s = (Suffix)it.next();
            String suffix = s.suffix;
            String locants = null;
            if (needLocants) {
                locants = Util.locant(this.getLocant(numbering, primes, s.atom));
            }
            int repeat = 1;
            while (it.hasNext()) {
                s = (Suffix)it.next();
                if (s.suffix != suffix) {
                    it.previous();
                    break;
                }
                ++repeat;
                if (!needLocants) continue;
                locants = locants + ',' + Util.locant(this.getLocant(numbering, primes, s.atom));
            }
            suffix = repeat > 1 && suffix == "ylium" ? Chem.complexMultiplier(repeat) + '(' + suffix + ')' : Chem.diMultiplier(repeat) + suffix;
            if (locants == null && this.canGiveAlkylName() && res.toString().endsWith("ane") && suffix.startsWith("yl")) {
                res.delete(res.length() - 2, res.length());
            }
            if (Util.isVowel(suffix.charAt(0))) {
                Util.removeTrailingVowel(res);
            }
            if (locants != null) {
                res.append('-').append(locants).append('-');
            }
            res.append(suffix);
        }
    }

    private boolean canGiveAlkylName() {
        if (!HeteroAnalyser.hasHeteroAtoms(this.part.originalMolecule)) {
            return true;
        }
        if (this.part.originalMolecule.getAtomCount() > 1) {
            return false;
        }
        int atno = this.part.originalMolecule.getAtom(0).getAtno();
        return atno == 14 || atno == 32 || atno == 50 || atno == 82;
    }

    void printEnding(int[] numbering, int[] primes, boolean printLocant, boolean isHetero, StringBuffer res) {
        if (this.ending == null) {
            return;
        }
        if (this.writeSpecialEndings(res)) {
            return;
        }
        String end = this.getMultipliedEnding();
        if (this.omitSuffixLocant(isHetero, numbering)) {
            Util.appendRemovingVowel(end, res);
            return;
        }
        if (!(this.part instanceof Chain) && !(this.part instanceof Monocycle) || isHetero || printLocant && (!this.saturatedAtomGroups.isEmpty() || !this.hasNoBonds()) || this.printLocantOne() || !this.locantOne(numbering)) {
            if (end != "" && Util.startsWithVowel(end) && Util.isVowel(res.charAt(res.length() - 1))) {
                res.deleteCharAt(res.length() - 1);
            }
            this.appendSuffixLocant(numbering, primes, res);
        } else if (this.hasNoBonds() && this.ending.startsWith("yl")) {
            res.delete(res.length() - 3, res.length());
        }
        Util.appendRemovingVowel(end, res);
    }

    private boolean printLocantOne() {
        if (!this.suffixes.isEmpty()) {
            return true;
        }
        if (this.part.complex() && this.ending == "" || this.ending.startsWith("yl")) {
            return false;
        }
        if (Options.strictLocants) {
            return true;
        }
        if (this.part instanceof Chain && ((Chain)this.part).chain.length <= 2) {
            return false;
        }
        return !this.part.isBenzene();
    }

    private boolean locantOne(int[] numbering) {
        if (this.suffixLocants == null) {
            return numbering == null || numbering[this.endingLocant] == 1;
        }
        if (numbering == null) {
            return false;
        }
        return this.suffixLocants.length == 1 && numbering[this.suffixLocants[0]] == 1;
    }

    private boolean writeSpecialEndings(StringBuffer res) {
        String base = res.toString();
        if (base.endsWith("benzene")) {
            if (this.ending.startsWith("yl") || this.ending.equals("ol") && (this.suffixLocants == null || this.suffixLocants.length == 1)) {
                res.delete(res.length() - 7, res.length());
                res.append("phen");
                Util.appendRemovingVowel(this.getMultipliedEnding(), res);
                return true;
            }
            if ((this.ending == "carboxylic acid" || this.ending == "carboxylate" || this.ending == "carboxamide" || this.ending == "carboxamidium" || this.ending.startsWith("carbonitril") || this.ending == "carbohydrazide" || this.ending == "carbaldehyde") && this.endingCount == 1) {
                res.delete(res.length() - 3, res.length());
                this.ending = this.ending == "carboxylic acid" ? "oic acid" : (this.ending == "carboxylate" ? "oate" : (this.ending == "carboxamide" ? "amide" : (this.ending == "carboxamidium" ? "amidium" : (this.ending.startsWith("carbonitril") ? "o" + this.ending.substring(5) : (this.ending == "carbaldehyde" ? "aldehyde" : "ohydrazide")))));
                Util.appendRemovingVowel(this.getMultipliedEnding(), res);
                return true;
            }
        } else if (base.endsWith("amine") && (this.ending == "yl" || this.ending == "ylidene")) {
            res.delete(res.length() - 5, res.length());
            res.append(this.ending == "yl" ? "amino" : "imino");
            return true;
        }
        if (base.endsWith("methane") && this.ending.startsWith("oyl")) {
            res.delete(res.length() - 7, res.length());
            MolAtom a = SubmoleculeBuilder.originalAtom(this.part.originalMolecule.getAtom(0));
            if (a.getImplicitHcount() + a.getExplicitHcount() == 0) {
                res.append("carbon");
            } else {
                res.append("form");
            }
            res.append(this.ending.substring(1));
            return true;
        }
        if (base.endsWith("ethane") && this.ending.startsWith("oyl")) {
            res.delete(res.length() - 6, res.length());
            res.append("acet").append(this.ending.substring(1));
            return true;
        }
        return false;
    }

    private void appendSuffixLocant(int[] numbering, int[] primes, StringBuffer res) {
        if (numbering == null) {
            return;
        }
        res.append('-');
        if (this.suffixGroups == null) {
            res.append(Util.locant(Util.locant(this.endingLocant, numbering, primes)));
        } else {
            int[] suffixLocants = Util.locants(numbering, primes, this.suffixLocants);
            Arrays.sort(suffixLocants);
            String suffixLocantString = this.suffixLocantString(suffixLocants);
            if (!(this.suffixPrefix == null || this.saturatedAtomGroups.isEmpty() && this.substituents == null)) {
                res.insert(this.suffixPrefixStart, suffixLocantString + '-');
            }
            res.append(suffixLocantString);
        }
        res.append('-');
    }

    private String getMultipliedEnding() {
        if (this.endingCount <= 1) {
            return this.ending;
        }
        int space = this.ending.lastIndexOf(32);
        if (this.ending.endsWith(" acid") && this.ending.startsWith("di")) {
            return Chem.complexMultiplier(this.endingCount) + '(' + this.ending.substring(0, space) + ") acid";
        }
        if (space != -1 && !this.ending.endsWith(" acid")) {
            StringBuffer res = new StringBuffer();
            String mult = Chem.diMultiplier(this.endingCount);
            res.append(mult).append(this.ending.substring(0, space));
            res.append(' ');
            res.append(mult).append(this.ending.substring(space + 1));
            return res.toString();
        }
        if (this.ending == "imidamide" || this.ending == "olate" || this.ending.endsWith("ium")) {
            return Chem.complexMultiplier(this.endingCount) + '(' + this.ending + ')';
        }
        String end = Chem.diMultiplier(this.endingCount);
        if (end.charAt(end.length() - 1) == 'a' && Util.isVowel(this.ending.charAt(0))) {
            end = end.substring(0, end.length() - 1);
        }
        end = end + this.ending;
        return end;
    }

    private String suffixLocantString(int[] suffixLocants) {
        if (suffixLocants.length == 1) {
            return Util.locant(suffixLocants[0]);
        }
        StringBuffer res = new StringBuffer();
        for (int i = 0; i < suffixLocants.length; ++i) {
            if (i > 0) {
                res.append(',');
            }
            res.append(Util.locant(suffixLocants[i]));
        }
        return res.toString();
    }

    private boolean hasUnlocatedSuffix() {
        return this.suffixGroups != null && this.suffixGroup((int)0).group != null && !this.suffixGroup((int)0).group.needLocant && this.endingCount <= 2 && this.part instanceof Chain;
    }

    private boolean omitSuffixLocant(boolean isHetero, int[] numbering) {
        if (this.omitSuffixLocant) {
            return true;
        }
        if (this.suffixGroups == null) {
            return false;
        }
        if (this.suffixLocants == null) {
            return true;
        }
        if (!this.hasUnlocatedSuffix()) {
            return false;
        }
        if (!isHetero && this.hasNoBonds()) {
            return true;
        }
        if (numbering != null) {
            int i = this.suffixLocants.length;
            while (--i >= 0) {
                if (numbering[this.suffixLocants[i]] != 1) continue;
                return true;
            }
        }
        return false;
    }

    CharacteristicGroup someSuffixGroup() {
        if (this.suffixGroups == null || this.suffixGroups.size() == 0) {
            return null;
        }
        return this.suffixGroup(0);
    }

    CharacteristicGroup suffixGroup(int i) {
        return this.suffixGroups.get(i);
    }

    int suffixGroupsJuniority() {
        return this.suffixGroup(0).suffixJuniority();
    }

    public void setEnding(int loc, String ending) {
        this.setEndingLocant(loc);
        this.setEnding(ending);
    }

    void setEndingLocant(int loc) {
        this.endingLocant = loc;
        this.part.resetPrefixName();
    }

    void setEnding(String ending) {
        this.ending = ending;
    }

    void noPrintedEnding() {
        this.ending = "";
    }

    String getEnding() {
        return this.ending;
    }

    void setRootBond(MolBond rootBond, boolean describedInParent) {
        this.rootBondStereo = Modifiers.getBondStereo(rootBond);
        this.rootBondDescribedInParent = describedInParent;
    }

    int getNumberOfSubstituents() {
        int res = 0;
        if (this.substituents != null) {
            res += this.substituents.size();
        }
        if (this.suffixGroups != null) {
            res += this.suffixLocants == null ? 1 : this.suffixLocants.length;
        } else if (this.ending != null && !this.ending.startsWith("yl")) {
            ++res;
        }
        res += this.suffixes.size();
        if (this.isotopes != null) {
            res += this.isotopes.size();
        }
        return res;
    }

    int getNumberOfLocants() {
        int res = 0;
        if (this.substituents != null) {
            res += this.substituents.size();
        }
        res -= this.indirectSubstituents;
        if (this.suffixGroups != null) {
            res += this.suffixLocants == null ? 1 : this.suffixLocants.length;
        } else if (this.ending != null) {
            ++res;
        }
        res += this.suffixes.size();
        res += this.bonds2.size() / 2;
        res += this.bonds3.size() / 2;
        if (this.isotopes != null) {
            res += this.isotopes.size();
        }
        return res;
    }

    String getFullName(String name) {
        if (this.toPrintBefore != null) {
            if (this.hasDetachedSubstituent) {
                name = "(" + name + ")";
            }
            name = this.toPrintBefore + name;
            this.toPrintBefore = null;
        }
        return name;
    }

    static class Isotope
    implements Comparable<Isotope> {
        int atno;
        int massno;
        IntVector locations = new IntVector();
        static boolean sortForLocants = false;

        Isotope() {
        }

        public String toString() {
            return Util.unicodeSuperscriptNumber(this.massno) + PeriodicSystem.getSymbol(this.atno);
        }

        @Override
        public int compareTo(Isotope that) {
            if (sortForLocants) {
                if (this.atno == that.atno) {
                    return that.massno - this.massno;
                }
                return that.atno - this.atno;
            }
            if (this.atno == that.atno) {
                return this.massno - that.massno;
            }
            return PeriodicSystem.getSymbol(this.atno).compareTo(PeriodicSystem.getSymbol(that.atno));
        }
    }

    class Suffix {
        int atom;
        String suffix;

        Suffix(int atom, String suffix) {
            this.atom = atom;
            this.suffix = suffix;
        }
    }
}

