/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameexport;

import chemaxon.marvin.io.formats.name.nameexport.AminoAcid;
import chemaxon.marvin.io.formats.name.nameexport.Canonicalizer;
import chemaxon.marvin.io.formats.name.nameexport.Chem;
import chemaxon.marvin.io.formats.name.nameexport.HeteroAnalyser;
import chemaxon.marvin.io.formats.name.nameexport.IUPACNamer;
import chemaxon.marvin.io.formats.name.nameexport.Modifiers;
import chemaxon.marvin.io.formats.name.nameexport.Part;
import chemaxon.marvin.io.formats.name.nameexport.SimplePart;
import chemaxon.marvin.io.formats.name.nameexport.SubmoleculeBuilder;
import chemaxon.marvin.io.formats.name.nameexport.Util;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.PeriodicSystem;

public class MonoNuclear
extends Part {
    MonoNuclear(Molecule m) {
        super(m);
    }

    private MolAtom atom() {
        return this.originalMolecule.getAtom(0);
    }

    @Override
    int getCharge() {
        return this.atom().getCharge();
    }

    @Override
    boolean isSalt() {
        return this.atom().getAtno() != 6;
    }

    @Override
    boolean isAminoAcid() {
        return AminoAcid.isAminoAcid(this.atom());
    }

    @Override
    String getName() {
        int group;
        MolAtom a = this.atom();
        int atno = a.getAtno();
        int radicalNum = Chem.radicalCount(a, true);
        if (AminoAcid.isAminoAcid(a)) {
            radicalNum = 1;
        }
        StringBuffer res = new StringBuffer();
        if (Chem.hasNonStandardBondingNumber(a)) {
            HeteroAnalyser.printLambda(Chem.getRealValence(a), res);
        }
        boolean systematic = false;
        if (res.length() > 0) {
            res.append('-');
            systematic = true;
        }
        if (SubmoleculeBuilder.globalMolecule != this.originalMolecule) {
            systematic = true;
        }
        if (a.getAtno() != 1) {
            Modifiers mods = new Modifiers(this);
            SimplePart.analyseAtoms(this.originalMolecule, mods);
            mods.printPrefix(null, null, res);
        }
        if ((group = PeriodicSystem.getColumn(atno)) >= 1 && group <= 12 && a.getImplicitHcount() > 0 && res.length() == 0 && a.getCharge() == 0) {
            return PeriodicSystem.getName(atno).toLowerCase() + " " + Chem.diMultiplier(a.getImplicitHcount()) + "hydride";
        }
        String name = MonoNuclear.mononuclearName(a, radicalNum, a.getCharge(), systematic, SubmoleculeBuilder.globalMolecule.getFragCount() > 1);
        if (res.length() == 0) {
            return name;
        }
        res.append(name);
        return res.toString();
    }

    static String mononuclearName(MolAtom a, int radicalNum, int charge, boolean systematic, boolean multiFragment) {
        String suffix;
        int atno = a.getAtno();
        int column = PeriodicSystem.getColumn(atno);
        if (atno == 1) {
            switch (a.getMassno()) {
                case 0: {
                    switch (charge) {
                        case -1: {
                            return "hydride";
                        }
                        case 0: {
                            return "hydrogen";
                        }
                        case 1: {
                            return multiFragment ? "hydrogen" : "hydron";
                        }
                    }
                    break;
                }
                case 1: {
                    switch (charge) {
                        case -1: {
                            return "protide";
                        }
                        case 0: {
                            return "protium";
                        }
                        case 1: {
                            return "proton";
                        }
                    }
                    break;
                }
                case 2: {
                    switch (charge) {
                        case -1: {
                            return "deuteride";
                        }
                        case 0: {
                            return "deuterium";
                        }
                        case 1: {
                            return "deuteron";
                        }
                    }
                    break;
                }
                case 3: {
                    switch (charge) {
                        case -1: {
                            return "tritide";
                        }
                        case 0: {
                            return "tritium";
                        }
                        case 1: {
                            return "triton";
                        }
                    }
                    break;
                }
                default: {
                    throw new IUPACNamer.Failure("Unknown hydrogen isotope: " + a.getMassno());
                }
            }
        }
        if (radicalNum == 0 && charge > 0) {
            if (charge == 1) {
                switch (atno) {
                    case 19: {
                        return "potassium";
                    }
                    case 7: {
                        if (!multiFragment) break;
                        return "ammonium";
                    }
                    case 11: {
                        return "sodium";
                    }
                }
            }
            if (charge == 2 && atno == 20) {
                return "calcium";
            }
        }
        boolean special = radicalNum != 0 || charge != 0;
        systematic |= special;
        String root = null;
        switch (atno) {
            case 6: {
                root = radicalNum > 0 && charge >= 0 && charge <= 1 ? "meth" : "methane";
                break;
            }
            case 7: {
                if (!systematic) {
                    return "ammonia";
                }
                root = special || a.getCharge() >= 2 ? "azane" : "amine";
                break;
            }
            case 8: {
                if (multiFragment && radicalNum == 0 && charge == 0) {
                    return "hydrate";
                }
                if (systematic) {
                    root = "oxidan";
                    break;
                }
                return "water";
            }
            case 9: {
                if (systematic) break;
                return "hydrogen fluoride";
            }
            case 16: {
                if (systematic) break;
                return "hydrogen sulfide";
            }
            case 17: {
                if (systematic) break;
                return "hydrogen chloride";
            }
            case 34: {
                if (systematic) {
                    root = "selan";
                    break;
                }
                return "hydrogen selenide";
            }
            case 35: {
                if (systematic) break;
                return "hydrogen bromide";
            }
            case 52: {
                if (systematic) {
                    root = "tellane";
                    break;
                }
                return "hydrogen telluride";
            }
            case 53: {
                if (systematic) break;
                return "hydrogen iodide";
            }
            case 14: 
            case 32: 
            case 50: 
            case 82: {
                if (radicalNum == 0 || charge != 0) break;
                root = Chem.aPrefixForAtom(atno);
                root = root.substring(0, root.length() - 1);
            }
        }
        if (root == null && column == 17 && (multiFragment || charge < 0) && (root = Chem.aPrefixForAtom(atno)) != null) {
            root = root.substring(0, root.length() - 1);
            if (charge == 0) {
                root = "hydro" + root;
                charge = -1;
                a.setCharge(-1);
            }
        }
        if (root == null && charge > 0 && (charge > 1 || column < 13 || column > 17)) {
            root = MolAtom.nameOf(atno).toLowerCase().intern();
            if (radicalNum == 1) {
                root = Chem.elementNameAsSubstituent(root);
            }
            root = root + "(" + charge + "+) ion";
            return root;
        }
        if (root == null) {
            root = MonoNuclear.baseName(a, null, radicalNum == 1, systematic, multiFragment);
        }
        if ((suffix = Chem.suffix(a, a, true, true)) == null) {
            return root;
        }
        StringBuffer res = new StringBuffer(root);
        Util.appendRemovingVowel(suffix, res);
        return res.toString();
    }

    static String baseName(MolAtom a, Modifiers modifiers, boolean substituent, boolean systematic, boolean multiFragment) {
        int atno = a.getAtno();
        switch (atno) {
            case 6: {
                return "methane";
            }
            case 7: {
                return a.getCharge() >= 2 ? "azane" : "amine";
            }
            case 8: {
                return "oxidane";
            }
            case 13: {
                return "alumane";
            }
            case 16: {
                return "sulfane";
            }
            case 34: {
                return "selane";
            }
            case 49: {
                return "indigane";
            }
            case 52: {
                return "tellane";
            }
            case 83: {
                return "bismuthane";
            }
            case 84: {
                return "polane";
            }
            case 135: {
                String aminoAcidName = AminoAcid.getAminoAcidName(a);
                if (aminoAcidName != null) {
                    return substituent ? AminoAcid.acylName(a) : aminoAcidName;
                }
                if (!Canonicalizer.isCoA(a)) break;
                return "-CoA";
            }
        }
        if (atno > 109) {
            throw IUPACNamer.UnsupportedError.unsupportedPseudoAtom(atno);
        }
        String root = null;
        int column = PeriodicSystem.getColumn(atno);
        if (column >= 13 && column <= 17 && (root = Chem.aPrefixForAtom(atno)) != null) {
            root = root + "ne";
        }
        if (root == null) {
            root = MolAtom.nameOf(atno).toLowerCase().intern();
            if (substituent) {
                root = Chem.elementNameAsSubstituent(root);
                modifiers.noPrintedEnding();
            }
        }
        return root;
    }
}

