/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameexport;

import chemaxon.common.util.IntVector;
import chemaxon.marvin.io.formats.name.nameexport.Chem;
import chemaxon.marvin.io.formats.name.nameexport.HeteroAnalyser;
import chemaxon.marvin.io.formats.name.nameexport.IUPACNamer;
import chemaxon.marvin.io.formats.name.nameexport.Modifiers;
import chemaxon.marvin.io.formats.name.nameexport.SaturationAnalyser;
import chemaxon.marvin.io.formats.name.nameexport.SimplePart;
import chemaxon.marvin.io.formats.name.nameexport.Substituent;
import chemaxon.marvin.io.formats.name.nameexport.Util;
import chemaxon.struc.Molecule;
import java.util.ArrayList;

public class Monocycle
extends SimplePart {
    Monocycle(Molecule m, int[] atomIndexMap) {
        super(m, atomIndexMap);
    }

    @Override
    int[][][] recognize() {
        return new int[][][]{new int[][]{null, null}};
    }

    @Override
    boolean printHeteroLocations(HeteroAnalyser.HeteroAtom[] heteroAtoms) {
        int heteros = heteroAtoms.length;
        int total = this.originalMolecule.getAtomCount();
        return heteros > 1 && (heteros != total || heteroAtoms[0].atno != heteroAtoms[heteros - 1].atno) && (heteros != 2 || total != 3);
    }

    @Override
    void namePrefix(int[] descriptor, int[] numbering, boolean bracket, boolean global, boolean printHeteros, StringBuffer to) {
        HeteroAnalyser ha = new HeteroAnalyser(this);
        HeteroAnalyser.HeteroAtom[] heteroAtoms = HeteroAnalyser.findSortedHeteroAtoms(this.originalMolecule, numbering, this.primes, global);
        if (heteroAtoms.length == 0) {
            return;
        }
        if (printHeteros && !this.ignoreHeteroAtoms()) {
            to.append(ha.print(descriptor, numbering));
            return;
        }
        if (!ha.hasLambda(heteroAtoms) && !this.printHeteroLocations(heteroAtoms)) {
            return;
        }
        ha.printHeteroAtomLocations(heteroAtoms, bracket, to);
    }

    @Override
    String nameDescriptor(int[] descriptor, int[] numbering, boolean saturatedBase, boolean omitSuffix) {
        return this.nameDescriptor(descriptor, numbering, saturatedBase, omitSuffix, false);
    }

    @Override
    String nameDescriptor(int[] descriptor, int[] numbering, boolean saturatedBase, boolean omitSuffix, boolean asFusedComponent) {
        if (omitSuffix) {
            return "cyclo";
        }
        int len = this.originalMolecule.getAtomCount();
        return Monocycle.getName(this.originalMolecule, numbering, saturatedBase, false, asFusedComponent, len);
    }

    static String getName(Molecule originalMolecule, int[] numbering, boolean saturatedBase, boolean benzo, boolean asFusedComponent, int len) {
        StringBuffer res = new StringBuffer();
        HeteroAnalyser.HeteroAtom[] heteroAtoms = HeteroAnalyser.findSortedHeteroAtoms(originalMolecule, numbering, null);
        boolean isHetero = heteroAtoms != null && heteroAtoms.length > 0;
        int saturation = SaturationAnalyser.saturation(originalMolecule);
        if (!isHetero || len > 10 || !HeteroAnalyser.hantzschWidmann(originalMolecule) || saturation == 3) {
            if (benzo && heteroAtoms != null) {
                HeteroAnalyser.heteroNamePrefix(heteroAtoms, true, res);
            }
            if (asFusedComponent && !isHetero) {
                res.append('[').append(len).append("]annulene");
            } else {
                res.append("cyclo").append(Chem.carbonChainName(len, benzo && saturation == 2 ? "ine" : "ane"));
            }
            return res.toString();
        }
        boolean saturated = saturatedBase && saturation == 1;
        HeteroAnalyser.heteroNamePrefix(heteroAtoms, true, res);
        if (saturated) {
            if (heteroAtoms.length == 1) {
                int atno = heteroAtoms[0].atno;
                switch (len) {
                    case 5: {
                        switch (atno) {
                            case 7: {
                                return "pyrrolidine";
                            }
                        }
                        break;
                    }
                    case 6: {
                        switch (atno) {
                            case 7: {
                                return "piperidine";
                            }
                        }
                    }
                }
            }
            Util.appendRemovingVowel(Chem.saturatedHantzschWidman(len, heteroAtoms), res);
        } else {
            if (heteroAtoms.length == 1) {
                int atno = heteroAtoms[0].atno;
                switch (len) {
                    case 5: {
                        switch (atno) {
                            case 8: {
                                return "furan";
                            }
                            case 7: {
                                return "pyrrole";
                            }
                            case 16: {
                                return "thiophene";
                            }
                            case 34: {
                                return "selenophene";
                            }
                            case 52: {
                                return "tellurophene";
                            }
                        }
                        break;
                    }
                    case 6: {
                        switch (atno) {
                            case 7: {
                                return "pyridine";
                            }
                            case 8: {
                                return "pyran";
                            }
                            case 16: 
                            case 34: 
                            case 52: {
                                Util.appendRemovingVowel("opyran", res);
                                return res.toString();
                            }
                        }
                    }
                }
            }
            Util.appendRemovingVowel(Chem.unsaturatedHantzschWidman(len, heteroAtoms), res);
        }
        return res.toString();
    }

    @Override
    boolean hasRetainedName() {
        return this.ignoreHeteroAtoms() && HeteroAnalyser.hasHeteroAtoms(this.originalMolecule);
    }

    @Override
    boolean ignoreHeteroAtoms() {
        return this.originalMolecule.getSSSR()[0].length <= 10 && HeteroAnalyser.hantzschWidmann(this.originalMolecule) && SaturationAnalyser.saturation(this.originalMolecule) != 3;
    }

    @Override
    boolean needsLocants() {
        if (this.hasRetainedName()) {
            return true;
        }
        int locants = this.modifiers.getNumberOfLocants();
        if (HeteroAnalyser.hasHeteroAtoms(this.originalMolecule)) {
            return locants != 0;
        }
        return locants > 1;
    }

    @Override
    int[][][] addMissingNumbering(int[][][] results, IntVector spiroAtoms, boolean prioritizeSpiro) {
        if (results.length > 1 || results[0][1] != null) {
            return results;
        }
        int[] descriptor = results[0][0];
        int len = this.originalMolecule.getAtomCount();
        if (prioritizeSpiro) {
            if (spiroAtoms.size() != 1) {
                throw new IUPACNamer.Failure("Not handled yet");
            }
            int start = spiroAtoms.get(0);
            int[] numberingLeft = Util.leftRingNumbering(start, len);
            int[] numberingRight = Util.rightRingNumbering(start, len);
            return new int[][][]{new int[][]{descriptor, numberingLeft}, new int[][]{descriptor, numberingRight}};
        }
        ArrayList<int[][]> numberings = new ArrayList<int[][]>();
        this.numberFromHeteroatoms(descriptor, numberings);
        if (numberings.size() == 0 && spiroAtoms != null) {
            for (int i = 0; i < spiroAtoms.size(); ++i) {
                int start = spiroAtoms.get(i);
                int[] numberingLeft = Util.leftRingNumbering(start, len);
                int[] numberingRight = Util.rightRingNumbering(start, len);
                numberings.add(new int[][]{descriptor, numberingLeft});
                numberings.add(new int[][]{descriptor, numberingRight});
            }
        }
        if (numberings.size() == 0) {
            return results;
        }
        return Util.intArrayArrayArray(numberings);
    }

    @Override
    int[][][] addMissingNumbering(int[][][] results, Modifiers modifiers) {
        if (results.length > 1 || results[0][1] != null) {
            return results;
        }
        int[] descriptor = results[0][0];
        ArrayList res = new ArrayList();
        if (modifiers.getEnding() != null && modifiers.endingLocant != -1) {
            this.addNumberingsFrom(modifiers.endingLocant, descriptor, res);
            return Util.intArrayArrayArray(res);
        }
        if (modifiers.suffixLocants != null) {
            this.addNumberingsFrom(modifiers.suffixLocants, descriptor, res);
        }
        if (!modifiers.suffixes.isEmpty()) {
            for (Modifiers.Suffix s : modifiers.suffixes) {
                this.addNumberingsFrom(s.atom, descriptor, res);
            }
        }
        if (res.size() != 0) {
            return Util.intArrayArrayArray(res);
        }
        this.addNumberingsFrom(modifiers.bonds2, descriptor, res);
        this.addNumberingsFrom(modifiers.bonds3, descriptor, res);
        if (res.size() != 0) {
            return Util.intArrayArrayArray(res);
        }
        this.addNumberingsFrom(Substituent.getDirectRoots(modifiers.substituents), descriptor, res);
        if (res.size() != 0) {
            return Util.intArrayArrayArray(res);
        }
        return results;
    }

    private void addNumberingsFrom(IntVector starts, int[] descriptor, ArrayList res) {
        this.addNumberingsFrom(starts.toArray(), descriptor, res);
    }

    private void addNumberingsFrom(int[] starts, int[] descriptor, ArrayList res) {
        if (starts == null) {
            return;
        }
        int i = starts.length;
        while (--i >= 0) {
            if (starts[i] == -1) continue;
            this.addNumberingsFrom(starts[i], descriptor, res);
        }
    }

    private void addNumberingsFrom(int start1, int[] descriptor, ArrayList res) {
        int len = this.originalMolecule.getAtomCount();
        int[] numberingLeft = Util.leftRingNumbering(start1, len);
        int[] numberingRight = Util.rightRingNumbering(start1, len);
        res.add(new int[][]{descriptor, numberingLeft});
        res.add(new int[][]{descriptor, numberingRight});
    }

    private void numberFromHeteroatoms(int[] descriptor, ArrayList numberings) {
        int len = this.originalMolecule.getAtomCount();
        int bestSeniority = -1;
        for (int start = 0; start < len; ++start) {
            int seniority;
            int atno = this.originalMolecule.getAtom(start).getAtno();
            if (atno == 6 || (seniority = Chem.seniority(atno)) < bestSeniority) continue;
            if (seniority > bestSeniority) {
                bestSeniority = seniority;
                numberings.clear();
            }
            int[] numberingLeft = Util.leftRingNumbering(start, len);
            int[] numberingRight = Util.rightRingNumbering(start, len);
            numberings.add(new int[][]{descriptor, numberingLeft});
            numberings.add(new int[][]{descriptor, numberingRight});
        }
    }

    @Override
    boolean cyclic() {
        return true;
    }

    @Override
    public boolean isShortRing() {
        return this.originalMolecule.getAtomCount() < 8;
    }
}

