/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameexport;

import chemaxon.naming.n2s.Standardize;
import chemaxon.naming.n2s.UtilLegacy;
import chemaxon.util.DotfileUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

class NameTranslator {
    static final Logger log = Logger.getLogger("chemaxon.marvin.io.formats.name.nameexport.NameTranslator");
    static String cachedInput;
    static String cachedOutput;
    private static String targetLanguage;

    NameTranslator() {
    }

    static synchronized String translate(String name) {
        NameTranslator.computeTargetLanguage();
        if (targetLanguage == null) {
            return name;
        }
        if (name.equals(cachedInput)) {
            return cachedOutput;
        }
        try {
            log.finer("Translating '" + name + "'...");
            String googleResponse = UtilLegacy.readURL("https://ajax.googleapis.com/ajax/services/language/translate?v=1.0&q=" + name + "&langpair=en%7C" + targetLanguage, "http://chemaxon.com");
            if (!googleResponse.endsWith("\"responseStatus\": 200}\n")) {
                log.finer("Translation failed: " + googleResponse);
                return name;
            }
            log.finest("Google response: " + googleResponse);
            String translatedName = googleResponse.replaceFirst("^.*translatedText\":\"([^\"]*)\".*$", "$1");
            translatedName = translatedName.trim();
            translatedName = translatedName.replace("\\u0026", "&");
            translatedName = Standardize.decodeHTML(translatedName);
            cachedInput = name;
            cachedOutput = translatedName;
            log.finer("Translated name: " + translatedName);
            return translatedName;
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Translation failed", e);
            return name;
        }
    }

    private static synchronized void computeTargetLanguage() {
        if (targetLanguage != "?") {
            return;
        }
        targetLanguage = null;
        log.finest("Searching for desired s2n language");
        try {
            String lang;
            File langFile = DotfileUtil.getDotFileWithEnsuredPath("naming/s2n-language.txt");
            if (!langFile.exists()) {
                if (log.isLoggable(Level.FINER)) {
                    log.finer("No s2n language file: " + langFile + ". No translation will be performed.");
                }
                return;
            }
            targetLanguage = lang = new BufferedReader(new FileReader(langFile)).readLine();
            log.fine("s2n language: " + targetLanguage);
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Getting s2n language failed", e);
        }
    }

    static {
        targetLanguage = "?";
    }
}

